/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview;

import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.util.StringUtils;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.ICommunicateBtwForm;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;

public class TemplateDataAreaSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String PAGESIGN_AREA = "area";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String area = (String)this.getFormCustomParam(PAGESIGN_AREA);
        if (StringUtils.isNotEmpty((String)area)) {
            this.getModel().setValue(PAGESIGN_AREA, (Object)area);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_confirm": {
                String area = (String)this.getModel().getValue(PAGESIGN_AREA);
                TemplateFloatUtil.setDataAreaBeforeCheck(area, this.getSpreadModel().getAreaManager().getPostionInfoSet());
                this.doHandleAreaSetting();
            }
        }
    }

    private void doHandleAreaSetting() {
        this.sendMsg2Parent();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String success = pageCache.get("areasetting");
        if (success != null && "true".equals(success)) {
            this.getView().close();
        }
    }

    private void sendMsg2Parent() {
        IFormView pv = this.getView().getParentView();
        String area = (String)this.getModel().getValue(PAGESIGN_AREA);
        pv.getFormShowParameter().setCustomParam(PAGESIGN_AREA, (Object)area);
        FormViewPluginProxy proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class);
        proxy.getPlugIns().forEach(e -> {
            if (ICommunicateBtwForm.class.isAssignableFrom(e.getClass())) {
                ((ICommunicateBtwForm)ICommunicateBtwForm.class.cast(e)).communicateMsg();
            }
        });
        this.getView().sendFormAction(pv);
    }
}

