/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Base64;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.util.GZIPUtils;

public class TemplateFormulaLogViewPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier {
    private static final String SPREADKEY = "template_spread";
    private SpreadManager spreadManager;

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handelTemplate();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), SPREADKEY, MapInitHelper.ofMap((Object)"isHide", (Object)true));
    }

    private void handelTemplate() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        SpreadManager sm = this.getSpreadModel();
        HashBasedTable resultCells = HashBasedTable.create();
        sm.getBook().getSheet(0).iteratorCells(arg_0 -> TemplateFormulaLogViewPlugin.lambda$handelTemplate$0((Table)resultCells, arg_0));
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(this.getJson().substring(6))));
        JSONObject obj = JSONObjectUtil.parseObjectOrder((String)ssjson);
        JSONObject sheets = (JSONObject)obj.get((Object)"sheets");
        for (Map.Entry entry : sheets.entrySet()) {
            Object datatable;
            Object data;
            Object value = entry.getValue();
            if (value == null || (data = ((JSONObject)value).get((Object)"data")) == null || (datatable = ((JSONObject)data).get((Object)"dataTable")) == null) continue;
            Map resultRowMap = resultCells.rowMap();
            for (Map.Entry resultRow : resultRowMap.entrySet()) {
                for (Map.Entry row : ((JSONObject)datatable).entrySet()) {
                    if (row == null || !((String)row.getKey()).equals(String.valueOf(resultRow.getKey()))) continue;
                    Map resultCVs = (Map)resultRowMap.get(resultRow.getKey());
                    for (Map.Entry resultCol : resultCVs.entrySet()) {
                        for (Map.Entry cell : ((JSONObject)row.getValue()).entrySet()) {
                            if (cell == null || !((String)cell.getKey()).equals(String.valueOf(resultCol.getKey())) || !(cell.getValue() instanceof JSONObject)) continue;
                            ((JSONObject)cell.getValue()).put("formula", null);
                            ((JSONObject)cell.getValue()).put("value", resultCVs.get(resultCol.getKey()));
                        }
                    }
                }
            }
        }
        String pJson = JSONObject.toJSONString((Object)obj);
        String s = new String(Base64.getEncoder().encode(GZIPUtils.compress((String)pJson)));
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), SPREADKEY, "base64" + s);
        invoker.lockAllToolbarItems(true, SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol);
        invoker.startToInvoke();
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), SPREADKEY, true);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), SPREADKEY);
        Sheet sheet = this.getEffectiveSheet();
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), SPREADKEY, Collections.singletonList(sheet.getSheetName()));
        Long periodId = (Long)this.getView().getFormShowParameter().getCustomParam("periodId");
        Long yearId = (Long)this.getView().getFormShowParameter().getCustomParam("yearId");
        Long scenarioId = (Long)this.getView().getFormShowParameter().getCustomParam("scenarioId");
        Long templateId = (Long)this.getView().getFormShowParameter().getCustomParam("templateId");
        DynamicObject orgTemplate = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId());
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") && (orgTemplate == null || StringUtils.isEmpty((String)orgTemplate.getString("data")))) {
            TempFormulaUtil.markErrorColor(this.getModelId(), this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY, templateId, this.getOrgMemId(), periodId, yearId, scenarioId);
        }
    }

    private String getJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam("json");
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spreadManager == null) {
            String cacheModel = this.getPageCache().get(this.KEY_SPREAD_MODEL);
            this.spreadManager = cacheModel == null ? JsonSerializerUtil.toSpreadManager((String)((String)this.getView().getFormShowParameter().getCustomParam("sm"))) : JsonSerializerUtil.toSpreadManager((String)cacheModel);
        }
        return this.spreadManager;
    }

    @Override
    public String toSerialSpreadModel(SpreadManager sm) {
        return this.toByteSerialized(sm);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        if (sm != null) {
            this.getPageCache().put(this.KEY_SPREAD_MODEL, JsonSerializerUtil.toJson((SpreadManager)sm));
        }
        this.spreadManager = sm;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_collectlog": {
                QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
                qFilter.and("template", "=", this.getView().getFormShowParameter().getCustomParam("templateId"));
                qFilter.and("org", "=", (Object)this.getOrgMemId());
                qFilter.and("period", "=", this.getView().getFormShowParameter().getCustomParam("periodId"));
                qFilter.and("fy", "=", this.getView().getFormShowParameter().getCustomParam("yearId"));
                qFilter.and("scenario", "=", this.getView().getFormShowParameter().getCustomParam("scenarioId"));
                Boolean isExist = QueryServiceHelper.exists((String)"bcm_datacollect", (QFilter[])qFilter.toArray());
                if (isExist.booleanValue()) {
                    Sheet sheet = this.getEffectiveSheet();
                    SpreadSelector selector = this.getSpreadSelector();
                    int selectRow = selector.getEndRow() - selector.getStartRow();
                    int selectCol = selector.getEndCol() - selector.getStartCol();
                    int rowNumber = selector.getStartRow();
                    int colNumber = selector.getStartCol();
                    Cell selectCell = sheet.getCell(rowNumber, colNumber);
                    if (rowNumber >= 0 && selectRow >= 0 && selectCol >= 0) {
                        if (selectCell.getFormula() != null) {
                            Object cellId = selectCell.getUserObject().get((Object)"cid");
                            qFilter.and("logtype", "=", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType());
                            qFilter.and("cellid", "=", cellId);
                            DynamicObjectCollection cellerrors = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"error,datafrom,cellid", (QFilter[])qFilter.toArray());
                            FormShowParameter parameter = new FormShowParameter();
                            parameter.setFormId("bcm_collectloginfo");
                            parameter.getOpenStyle().setShowType(ShowType.Modal);
                            parameter.setShowTitle(true);
                            parameter.setCustomParam("title", (Object)ExcelUtils.xy2Pos((int)selectCell.getCol(), (int)selectCell.getRow()));
                            parameter.setCustomParam("formula", (Object)selectCell.getFormula());
                            if (!cellerrors.isEmpty()) {
                                String formula = ((DynamicObject)cellerrors.get(0)).getString("datafrom");
                                if (formula.startsWith("=")) {
                                    formula = formula.substring(1);
                                }
                                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                                qf.and("template", "=", this.getView().getFormShowParameter().getCustomParam("templateId"));
                                qf.and("cell", "=", cellId);
                                qf.and(new QFilter("orgnumber", "=", (Object)"").or("orgnumber", "=", this.getView().getFormShowParameter().getCustomParam("orgNumber")));
                                DynamicObjectCollection cellFormulas = QueryServiceHelper.query((String)"bcm_cellformula", (String)"formula, cell", (QFilter[])qf.toArray());
                                if (!formula.equals(selectCell.getFormula()) && cellFormulas.size() > 1) {
                                    StringBuilder info = new StringBuilder();
                                    info.append(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u5df2\u4fee\u6539\uff0c\u9700\u91cd\u65b0\u53d6\u6570\u3002", (String)"TemplateFormulaLogViewPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                    info.append('\n');
                                    info.append(ResManager.loadKDString((String)"\u524d\u516c\u5f0f\u4e3a:%s", (String)"TemplateFormulaLogViewPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{((DynamicObject)cellerrors.get(0)).getString("datafrom")}));
                                    info.append('\n');
                                    info.append(ResManager.loadKDString((String)"\u53d6\u6570\u9519\u8bef\u65e5\u5fd7\u4e3a\uff1a%s\u3002", (String)"TemplateFormulaLogViewPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[]{((DynamicObject)cellerrors.get(0)).getString("error")}));
                                    parameter.setCustomParam("info", (Object)info.toString());
                                } else {
                                    parameter.setCustomParam("info", (Object)((DynamicObject)cellerrors.get(0)).getString("error"));
                                }
                            } else {
                                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                                qf.and("org", "=", (Object)this.getOrgMemId());
                                qf.and(new QFilter("template", "=", (Object)0).or("template", "=", this.getView().getFormShowParameter().getCustomParam("templateId")));
                                qf.and("datafrom", "=", (Object)" ");
                                qf.and("logtype", "=", (Object)"0");
                                DynamicObjectCollection cellErrors = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"error,collecttime", (QFilter[])qf.toArray());
                                if (!cellErrors.isEmpty()) {
                                    StringBuilder info = new StringBuilder();
                                    for (int i = 0; i < cellErrors.size(); ++i) {
                                        info.append(i + 1).append("\u3001").append(((DynamicObject)cellErrors.get(i)).getString("collecttime")).append(":").append(((DynamicObject)cellErrors.get(i)).getString("error"));
                                        info.append('\n');
                                    }
                                    parameter.setCustomParam("info", (Object)info.toString());
                                } else {
                                    parameter.setCustomParam("info", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u516c\u5f0f\u53d6\u6570\u6210\u529f\u3002", (String)"TemplateFormulaLogViewPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                }
                            }
                            this.getView().showForm(parameter);
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u65e0\u516c\u5f0f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TemplateFormulaLogViewPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u5355\u5143\u683c\u3002", (String)"TemplateFormulaLogViewPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u65e5\u5fd7\u4fe1\u606f\uff0c\u53ef\u4ee5\u516c\u5f0f\u53d6\u6570\u540e\u91cd\u8bd5\u3002", (String)"TemplateFormulaLogViewPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private long getOrgMemId() {
        return Long.parseLong((String)this.getFormCustomParam("orgId"));
    }

    private static /* synthetic */ void lambda$handelTemplate$0(Table resultCells, Cell cell) {
        if (cell.hasFormula()) {
            String formula = cell.getFormula();
            if (!formula.startsWith("=")) {
                formula = "=" + formula;
            }
            cell.setValue((Object)formula);
            resultCells.put((Object)cell.getRow(), (Object)cell.getCol(), (Object)formula);
        }
    }
}

