/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.template.OrgRptTemplateUpdateEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.formplugin.util.NewMyTemplateUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;

public class TemplateFormulaViewPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier {
    private static final String SPREADKEY = "template_spread";
    private SpreadManager spreadManager;

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> {
            Cell cell = (Cell)e.getSource();
            Object value = cell.getValue();
            String formula = null;
            if (value != null && (formula = value.toString().replaceAll("\\p{C}", "")).startsWith("'=")) {
                formula = formula.substring(1);
            }
            if (formula != null && !(value instanceof BigDecimal) && formula.startsWith("=")) {
                cell.setValue((Object)BigDecimal.ZERO);
                cell.setFormula(formula.substring(1));
                SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
                invoker.setBatch(true);
                invoker.setFormula(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol(), formula);
                invoker.startToInvoke();
            } else if (!(value instanceof BigDecimal)) {
                cell.setFormula(null);
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_FORMULA, e -> {
            Cell cell = (Cell)e.getSource();
            String formula = cell.getFormula();
            if (!StringUtils.isEmpty((String)formula)) {
                cell.setFormula(formula);
                SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
                invoker.setBatch(true);
                invoker.setFormula(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol(), "=" + formula);
                invoker.startToInvoke();
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.fromReport()) {
            this.handelReport();
        } else {
            this.handelTemplate();
        }
        this.checkItemAuthForHide(new String[]{"bar_save"});
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 0);
        if (!this.fromReport()) {
            Sheet sheet = this.getEffectiveSheet();
            SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), SPREADKEY, Collections.singletonList(sheet.getSheetName()));
        }
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate")) {
            DynamicObject orgTemplate;
            if ("bcm_multiviewtemplate".equalsIgnoreCase(this.getView().getParentView().getEntityId())) {
                Object templateId = this.getView().getFormShowParameter().getCustomParam("templateId");
                TempFormulaUtil.markColor(this.getModelId(), this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY, LongUtil.toLong((Object)templateId), " ");
            }
            if ("bcm_cslreportprocess".equalsIgnoreCase(this.getView().getParentView().getEntityId())) {
                String tmpid = (String)this.getView().getFormShowParameter().getCustomParam("tmpid");
                String orgNum = (String)this.getView().getFormShowParameter().getCustomParam("orgNum");
                TempFormulaUtil.markColor(this.getModelId(), this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY, LongUtil.toLong((Object)tmpid), orgNum);
            }
            if (this.getFormCustomParam("orgid") != null && ((orgTemplate = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId())) == null || StringUtils.isEmpty((String)orgTemplate.getString("data")))) {
                TempFormulaUtil.setStyle(this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY);
            }
        }
        if (this.getFormCustomParam("orgid") == null && !this.fromReport()) {
            TempFormulaUtil.setStyle(this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY);
        }
        for (PositionInfo posInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null) continue;
            RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
            ArrayList cells = new ArrayList();
            HashMap<String, Integer> cell = new HashMap<String, Integer>(4);
            cell.put(SpreadProperties.LockCellMethod.R.k(), rangeModel.getY_start());
            cell.put(SpreadProperties.LockCellMethod.C.k(), rangeModel.getX_start());
            cell.put(SpreadProperties.LockCellMethod.RC.k(), rangeModel.getRowSize());
            cell.put(SpreadProperties.LockCellMethod.CC.k(), rangeModel.getColSize());
            cells.add(cell);
            SpreadClientInvoker.invokeLockCellMethod(this.getClientViewProxy(), SPREADKEY, cells);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.fromReport()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), SPREADKEY, MapInitHelper.ofMap((Object)"isHide", (Object)true));
    }

    private void handelTemplate() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        this.getSpreadModel().getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula()) {
                String formula = cell.getFormula();
                if (!formula.startsWith("=")) {
                    formula = "=" + formula;
                }
                cell.setValue((Object)formula);
                invoker.setFormula(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol(), formula);
            }
        });
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), SPREADKEY, this.getJson());
        invoker.lockAllToolbarItems(true, SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol);
        invoker.startToInvoke();
    }

    private void handelReport() {
        this.handelTemplate();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        String tmpid = (String)this.getView().getFormShowParameter().getCustomParam("tmpid");
        List formulaDyo = AnalysisFormulaUtil.getFormulaDyo((SpreadManager)this.getSpreadModel(), (long)Long.parseLong(tmpid), (String)"", (boolean)false);
        Map<String, List<DynamicObject>> floatarea2formula = formulaDyo.stream().collect(Collectors.groupingBy(formula -> formula.getString("floatarea")));
        Sheet sheet = this.getSpreadModel().getBook().getSheet(0);
        ArrayList<DynamicObject> allFillFormulas = new ArrayList<DynamicObject>(16);
        for (Object positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                Pair<List<String>, List<List<String>>> dimsAndMems4Float = TemplateFormulaViewPlugin.collectFloatMems(sheet, basePointInfo);
                if (((List)dimsAndMems4Float.p2).isEmpty()) continue;
                List<DynamicObject> formulas = floatarea2formula.get(basePointInfo.getOriginalDynaRange());
                List<DynamicObject> fillformulas = TemplateFloatUtil.analysisFloat(formulas, (List)dimsAndMems4Float.p2, (List)dimsAndMems4Float.p1, this.getModelId());
                allFillFormulas.addAll(fillformulas);
            }
        }
        if (allFillFormulas == null || allFillFormulas.isEmpty()) {
            SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), SPREADKEY, true);
            invoker.startToInvoke();
            this.cacheSpreadModel();
            return;
        }
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject d : allFillFormulas) {
            table.put((Object)d.getString("dimkey"), (Object)d.getString("membkey"), (Object)d.getString("datafrom"));
        }
        StringBuilder dimKey = new StringBuilder();
        StringBuilder membKey = new StringBuilder();
        this.getSpreadModel().getBook().getSheet(0).iteratorCells(arg_0 -> TemplateFormulaViewPlugin.lambda$handelReport$5(membKey, dimKey, (Table)table, invoker, arg_0));
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), SPREADKEY, true);
        invoker.startToInvoke();
        this.cacheSpreadModel();
    }

    private static Pair<List<String>, List<List<String>>> collectFloatMems(Sheet sheet, BasePointInfo basePointInfo) {
        String[] floatRange = basePointInfo.getDynaRange().split(":");
        Point floatStart = ExcelUtils.pos2Point((String)floatRange[0]);
        Point floatEnd = ExcelUtils.pos2Point((String)floatRange[1]);
        boolean directHoriz = basePointInfo.isDirectHoriz();
        int startX = floatStart.x;
        int startY = floatStart.y;
        int endX = floatEnd.x;
        int endY = floatEnd.y;
        ArrayList dimMems4Float = new ArrayList(16);
        ArrayList<String> dims = new ArrayList<String>(10);
        int fixStart = directHoriz ? startY : startX;
        int fixEnd = directHoriz ? endY : endX;
        int startFloat = directHoriz ? startX : startY;
        int endFloat = directHoriz ? endX : endY;
        for (int i = startFloat; i <= endFloat; ++i) {
            ArrayList<String> mems = new ArrayList<String>(10);
            for (int j = fixStart; j <= fixEnd; ++j) {
                Cell cell = directHoriz ? sheet.getCell(j, i) : sheet.getCell(i, j);
                List memberFromUserObject = cell.getMemberFromUserObject();
                if (memberFromUserObject == null) continue;
                for (IDimMember iDimMember : memberFromUserObject) {
                    if (!dims.contains(iDimMember.getDimension().getNumber())) {
                        dims.add(iDimMember.getDimension().getNumber());
                    }
                    mems.add(iDimMember.getNumber());
                }
                dimMems4Float.add(mems);
            }
        }
        return new Pair(dims, dimMems4Float);
    }

    private String getJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam("json");
    }

    private boolean fromReport() {
        return this.getView().getFormShowParameter().getCustomParam("isreport") != null;
    }

    @Override
    public void spreadF7Click(int r, int c) {
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spreadManager == null) {
            String cacheModel = this.getPageCache().get(this.KEY_SPREAD_MODEL);
            this.spreadManager = cacheModel == null ? JsonSerializerUtil.toSpreadManager((String)((String)this.getView().getFormShowParameter().getCustomParam("sm"))) : JsonSerializerUtil.toSpreadManager((String)cacheModel);
        }
        return this.spreadManager;
    }

    @Override
    public String toSerialSpreadModel(SpreadManager sm) {
        return this.toByteSerialized(sm);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        if (sm != null) {
            this.getPageCache().put(this.KEY_SPREAD_MODEL, JsonSerializerUtil.toJson((SpreadManager)sm));
        }
        this.spreadManager = sm;
    }

    private void updateClientView(String key) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        this.getSpreadModel().getBook().getSheet(0).iteratorCells(cell -> {
            String formula = cell.getFormula();
            if (!StringUtils.isEmpty((String)formula)) {
                if ("value".equals(key)) {
                    invoker.setFormula(cell.getRow(), cell.getCol(), null);
                    invoker.updataValue(cell.getRow(), cell.getCol(), String.format("=%s", formula));
                } else {
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    invoker.setFormula(cell.getRow(), cell.getCol(), formula);
                }
            }
        });
        invoker.startToInvoke();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                long modelId = this.getModelId();
                Object yearId = this.getView().getFormShowParameter().getCustomParam("yearId");
                Object periodId = this.getView().getFormShowParameter().getCustomParam("periodId");
                Object sceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
                Object orgId = this.getView().getFormShowParameter().getCustomParam("reportOrgId");
                Object isfloat = this.getView().getFormShowParameter().getCustomParam("isfloat");
                if (Boolean.parseBoolean(isfloat.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u62a5\u8868\u6216\u8005\u62d3\u5c55\u7ef4\u62a5\u8868\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"AbstractMultiReportPlugin_249", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (MergeControlHelper.isQuoteLocked((Long)modelId, (Long)LongUtil.toLong((Object)sceneId), (Long)LongUtil.toLong((Object)yearId), (Long)LongUtil.toLong((Object)periodId), (Long)LongUtil.toLong((Object)orgId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5316\u60c5\u666f\u4e0b\uff0c\u672a\u6267\u884c\u7248\u672c\u5316\u7684\u7ec4\u7ec7\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"AbstractMultiReportPlugin_262", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8981\u4fdd\u5b58\u5f53\u524d\u8868\u6837\u6570\u636e\u5230\u6211\u7684\u6a21\u677f\uff0c\u4fdd\u5b58\u524d\u8bf7\u5148\u6267\u884c\u6574\u8868\u6e05\u9664\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"TemplateFormulaViewPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bar_save", (IFormPlugin)this));
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "bar_save": {
                DynamicObject orgTemplate;
                if (MessageBoxResult.Yes != e.getResult()) break;
                Object reportStatus = this.getView().getFormShowParameter().getCustomParam("reportStatus");
                if (reportStatus != null && !ReportStatusEnum.UNWEAVE.status().equals(reportStatus.toString())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7f16\u5236\u8bb0\u5f55\uff0c\u4fdd\u5b58\u524d\u8bf7\u5148\u6267\u884c\u6574\u8868\u6e05\u9664\u3002", (String)"TemplateFormulaViewPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("callback", "invokeAction");
                params.put("invokemethod", "actionSave");
                SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), SPREADKEY, params);
                if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") || this.getFormCustomParam("orgid") == null || (orgTemplate = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId())) != null && !StringUtils.isEmpty((String)orgTemplate.getString("data"))) break;
                TempFormulaUtil.setStyle(this.getSpreadModel(), this.getClientViewProxy(), SPREADKEY);
                break;
            }
        }
    }

    private long getOrgMemId() {
        return LongUtil.toLong((Object)this.getFormCustomParam("orgid"));
    }

    public void actionSave(String spreadJson) {
        if (this.getFormCustomParam("orgid") != null) {
            DynamicObject obj;
            TemplateModel template = this.getTemplateModel();
            spreadJson = this.addFormula(spreadJson);
            SpreadManager spreadModel = this.getSpreadModel();
            spreadModel.setFilter(null);
            String serial = this.toSerialSpreadModel(spreadModel);
            int version = template.getVersionNumber().intValue();
            QFilter versionfilter = new QFilter("version", ">", (Object)(version * 100)).and("version", "<", (Object)((version + 1) * 100));
            QFilter filter = new QFilter("template", "=", (Object)template.getId()).and("org", "=", (Object)this.getOrgMemId()).and("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
            DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_orgrpttemplate", (String)"spreadjson,data,modifier,modifytime,creator,createtime,isorgrpt,isupdate", (QFilter[])new QFilter[]{filter, versionfilter}, (String)"version desc");
            if (docs.length > 0) {
                obj = docs[0];
                CommonSqlMsgUtil.modifi((DynamicObject)obj);
                if (obj.get("creator") == null || obj.get("creator") == "0") {
                    CommonSqlMsgUtil.create((DynamicObject)obj);
                }
            } else {
                obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_orgrpttemplate");
                obj.set("model", (Object)this.getModelId());
                obj.set("template", (Object)template.getId());
                obj.set("org", (Object)this.getOrgMemId());
                obj.set("version", (Object)(version * 100 + 1));
                obj.set("status", (Object)1);
                obj.set("isupdate", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
                CommonSqlMsgUtil.create((DynamicObject)obj);
            }
            obj.set("isorgrpt", (Object)1);
            if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") && StringUtil.isEmptyString((String)obj.getString("data"))) {
                String orgNumber = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)this.getOrgMemId()).getNumber();
                SpreadManager sm = this.getSpreadModel();
                NewMyTemplateUtil.saveMyTemplateDyos(this.getModelId(), template.getId(), orgNumber, sm, true);
                TemplateServiceHelper.removeTemplateModelCacheByIds((Object)this.getModelId(), (Object[])new Object[]{template.getId()});
                this.cacheSpreadModel(sm);
            } else {
                obj.set("spreadjson", (Object)spreadJson);
                obj.set("data", (Object)serial);
            }
            CommonSqlMsgUtil.modifi((DynamicObject)obj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TemplateFormulaViewPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.updateClientView("value");
            this.getPageCache().put("change", "true");
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58\u516c\u5f0f", "TemplateFormulaViewPlugin_8", "fi-bcm-formplugin", "Save Formula"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s,\u4fdd\u5b58\u6210\u529f", "TemplateFormulaViewPlugin_9", "fi-bcm-formplugin", new String[]{MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)this.getOrgMemId()).getNumber(), template.getNumber(), template.getName()}));
        }
    }

    private String addFormula(String json) {
        DynamicObject orgTemplate = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId());
        String data = orgTemplate != null && !StringUtil.isEmptyString((String)orgTemplate.getString("data")) ? orgTemplate.getString("data") : this.getTemplateModel().getRptData();
        SpreadManager templateManager = JsonSerializerUtil.toSpreadManager((String)data);
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") && (orgTemplate == null || StringUtil.isEmptyString((String)orgTemplate.getString("data")))) {
            SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)templateManager, (long)this.getModelId(), (long)this.template.getId(), (long)this.getOrgMemId(), (boolean)false);
        }
        Sheet sheet = templateManager.getBook().getSheet(0);
        TemplateScanMemberService service = new TemplateScanMemberService(this.getSpreadModel(), this.getTemplateModel());
        Set<Point> points = service.getFloatFirst(this.getSpreadModel());
        ArrayList formulaPas = new ArrayList();
        this.getSpreadModel().getBook().getSheet(0).iteratorCells(cell -> {
            Point point = new Point(cell.getCol(), cell.getRow());
            if (cell.hasFormula()) {
                cell.setValue(null);
            }
            if (this.getTemplateModel().isSaveByDim() && points.contains(point) && cell.hasFormula() && !cell.getFormula().contains("@")) {
                cell.setChangeVal(false);
                cell.setValue(null);
                Cell cellTemplate = sheet.getCell(cell.getRow(), cell.getCol());
                String formulaStr = null;
                if (cellTemplate != null && cellTemplate.hasFormula()) {
                    formulaStr = cellTemplate.getFormula();
                    formulaStr = formulaStr.startsWith("=") ? formulaStr.replaceFirst("=", "") : formulaStr;
                }
                cell.setFormula(formulaStr);
            }
            if (cell.hasFormula()) {
                formulaPas.add(cell);
            }
        });
        this.cacheSpreadModel(this.getSpreadModel());
        if (formulaPas.size() > 0) {
            json = TempFormulaUtil.dealBase64Str(json);
            String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(json)));
            JSONObject obj = JSONObjectUtil.parseObjectOrder((String)ssjson);
            String sheetname = this.getSpreadModel().getBook().getSheet(0).getSheetName();
            JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)obj, (String)sheetname);
            for (Cell c : formulaPas) {
                JSONObject cell2 = (JSONObject)((JSONObject)dataTable.get((Object)(c.getRow() + ""))).get((Object)(c.getCol() + ""));
                cell2.put("value", null);
                cell2.put("formula", (Object)c.getFormula());
            }
            byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)obj.toJSONString()));
            String bbs = new String(bb);
            return "base64" + bbs;
        }
        return json;
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        if (!this.fromReport()) {
            return;
        }
        if (this.getEffectiveSheet() != null && row >= 0 && col >= 0) {
            Cell cell = this.getEffectiveSheet().getCell(row, col);
            String msg = this.checkCanAddFormula(row, col);
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            String formula = cell.getFormula();
            if (StringUtils.isEmpty((String)formula)) {
                this.showFormulaList(formula);
            } else {
                try {
                    formula = formula.replaceAll("\\p{C}", "");
                    Expression e = ExcelFormulaPaserHelper.parse((String)formula);
                    this.openFormulaEdit(e, formula);
                }
                catch (Exception ee) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"TemplateFormulaViewPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void showFormulaList(String formula) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_formulapicker");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("txtadvance", (Object)formula);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectFormula");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openFormulaEdit(Expression e, String formula) {
        if (e instanceof BinaryOperationExpr) {
            this.showFormulaList(formula);
        } else if (e instanceof FunctionExpr) {
            String selectedNodeNumber = ((FunctionExpr)e).getFuncionName().toLowerCase(Locale.ENGLISH);
            boolean exitformula = FormulaConfig.getInstance().getFormulaList().stream().anyMatch(f -> selectedNodeNumber.equals(((String)f.get("number")).toLowerCase(Locale.ENGLISH)));
            if (exitformula) {
                FormShowParameter parameter = new FormShowParameter();
                ShowFormulaUtil.selectGuidePage(ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber), parameter, this.getModelId());
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
                parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                if (formula != null) {
                    parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setFormula");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameter);
            } else {
                this.showFormulaList(formula);
            }
        } else {
            this.showFormulaList(formula);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            this.handleCallBackFormula(evt.getReturnData().toString());
        }
    }

    private void handleCallBackFormula(String returndata) {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        cell.setFormula(returndata);
        cell.setValue((Object)"");
        HashMap<String, Object> formula = new HashMap<String, Object>(16);
        formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
        formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
        formula.put(SpreadProperties.SetFormulaMethod.F.k(), returndata);
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), SPREADKEY, Lists.newArrayList((Object[])new Map[]{formula}));
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        invoker.setFormula(cell.getRow(), cell.getCol(), "");
        invoker.updataValue(cell.getRow(), cell.getCol(), "=" + returndata);
        invoker.startToInvoke();
        this.cacheSpreadModel();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("change") != null) {
            HashBasedTable formulas = HashBasedTable.create();
            this.getSpreadModel().getBook().getSheet(0).iteratorCells(arg_0 -> TemplateFormulaViewPlugin.lambda$beforeClosed$9((Table)formulas, arg_0));
            this.getView().returnDataToParent((Object)formulas);
        }
    }

    private static /* synthetic */ void lambda$beforeClosed$9(Table formulas, Cell c) {
        if (c.hasFormula()) {
            formulas.put((Object)c.getRow(), (Object)c.getCol(), (Object)c.getFormula());
        }
    }

    private static /* synthetic */ void lambda$handelReport$5(StringBuilder membKey, StringBuilder dimKey, Table table, SpreadEasyInvoker invoker, Cell cell) {
        if (cell.isMdDataDomain() && cell.getMemberFromUserObject() != null) {
            cell.getMemberFromUserObject().forEach(m -> {
                membKey.append(m.getNumber()).append('|');
                dimKey.append(m.getDimension().getNumber()).append('|');
            });
            if (table.contains((Object)dimKey.toString(), (Object)membKey.toString())) {
                String str = (String)table.get((Object)dimKey.toString(), (Object)membKey.toString());
                String formula = StringUtils.isEmpty((String)str) ? str : str.substring(1);
                cell.setFormula(formula);
                if (cell.getValue() == null) {
                    cell.setValue((Object)BigDecimal.ZERO);
                }
                invoker.setFormula(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol(), table.get((Object)dimKey.toString(), (Object)membKey.toString()));
            } else if (cell.getValue() != null && !cell.hasFormula()) {
                invoker.setFormula(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
            }
            dimKey.setLength(0);
            membKey.setLength(0);
        }
    }
}

