/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview.handle;

import java.util.Collections;
import java.util.Map;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.multiview.handle.IViewHandle;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public abstract class AbstractViewHandle
implements IViewHandle {
    protected AbstractTemplateBasePlugin plugin;
    protected String spreadKey;

    @Override
    public void handleView(AbstractTemplateBasePlugin plugin, String spreadKey) {
        this.plugin = plugin;
        this.spreadKey = spreadKey;
        this.doHandleView();
        this.handleButtonDisplayStrategy();
        this.hideWholeContextMenuItem(true);
    }

    protected void handleButtonDisplayStrategy() {
        this.setVisible(this.getAllHideCtrlKeys(), false);
        this.setVisible(this.getVisibleCtrlKeys(), true);
    }

    protected void lockSheet() {
        SpreadClientInvoker.invokeLockSheetMethod(this.plugin.getClientViewProxy(), this.spreadKey, Collections.singletonList(this.getEffectiveSheet().getSheetName()));
    }

    protected void controlWholeToolBarItems(boolean isLock) {
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.plugin.getClientViewProxy(), this.spreadKey, isLock);
    }

    protected void hideWholeContextMenuItem(boolean isHide) {
        SpreadClientInvoker.invokeHideContextMenuItems(this.plugin.getClientViewProxy(), this.spreadKey, MapInitHelper.ofMap((Object)"isHide", (Object)true));
    }

    private String[] getAllHideCtrlKeys() {
        return new String[]{"btn_setreportdata", "btn_baseinfo", "btn_weaveexplain", "btn_weaveinfo", "btn_dimsetting", "btn_formula_import", "btn_formula_export", "btn_areasetting", "btn_membsetting", "btn_floatsetting", "btn_seqsetting", "btn_circularsetting", "btn_clearcross", "btn_restorecross", "btn_component", "btn_modifycross", "btn_clearformula", "btn_restoreformula", "btn_modifyformula", "bar_formulaview", "btn_rptparam", "btn_extdatasetting", "btn_extdatacalsetting", "btn_extendareasetting"};
    }

    private void setVisible(String[] ctrlKeys, boolean v) {
        this.plugin.getView().setVisible(Boolean.valueOf(v), ctrlKeys);
    }

    protected void displayStyle() {
        String json = this.plugin.getTemplateModel().getSpreadJson() != null ? this.plugin.getTemplateModel().getSpreadJson() : this.plugin.getSpreadModel().getBook().toJSon();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.spreadKey, json);
    }

    public Map<String, Object> updateMemberMessage(Cell cell) {
        return SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), TemplateUtil.getMemberMessage(this.plugin.getModelId(), cell));
    }

    protected Sheet getEffectiveSheet() {
        return this.plugin.getSpreadModel().getBook().getSheet(0);
    }

    protected abstract String getViewTabKey();

    protected abstract void doHandleView();

    protected abstract String[] getVisibleCtrlKeys();
}

