/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview.handle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.handle.AbstractViewHandle;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections.CollectionUtils;

public class MemberViewHandle
extends AbstractViewHandle {
    @Override
    public void doHandleView() {
        this.displayStyle();
        this.controlWholeToolBarItems(true);
        this.drawDimMemAreaColor();
        this.displayMemberInfo();
        this.setF7TypeCellOnSpreadJS();
        this.lockSheet();
        this.unlockDimCell();
        this.lockFloatColOrRow();
        MarkSpecialCell.drawMarkPoint(this.plugin.getPageCache(), this.plugin.getView(), this.plugin.getSpreadModel(), this.spreadKey, false, true);
    }

    private void unlockDimCell() {
        SpreadManager sm = this.plugin.getSpreadModel();
        ArrayList cells = new ArrayList(16);
        sm.getAreaManager().forEach(area -> this.dealDataAreaCells((PositionInfo)area.getKey(), cells));
        if (!cells.isEmpty()) {
            SpreadClientInvoker.invokeUnLockCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, cells);
        }
    }

    private void dealDataAreaCells(PositionInfo ps, List<Map<String, Object>> cells) {
        RangeModel rangeModel = new RangeModel(ps.getAreaRange());
        cells.add(SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start(), rangeModel.getX_start(), 1, rangeModel.getX_end() - rangeModel.getX_start() + 1));
        int rowCount = rangeModel.getY_end() - rangeModel.getY_start() + 1;
        if (rowCount > 1) {
            cells.add(SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start() + 1, rangeModel.getX_start(), rowCount - 1, 1));
        }
    }

    private void drawDimMemAreaColor() {
        SpreadManager sm = this.plugin.getSpreadModel();
        ArrayList rangeList = new ArrayList();
        sm.getAreaManager().forEach(area -> {
            PositionInfo positionInfo = (PositionInfo)area.getKey();
            if (positionInfo.getExtendInfo() == null) {
                this.dealDataAreaCells(positionInfo, rangeList);
            }
        });
        if (!rangeList.isEmpty()) {
            HashMap<String, Cloneable> features = new HashMap<String, Cloneable>();
            HashMap<String, String> styleMap = new HashMap<String, String>();
            styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#66CDAA");
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(this.plugin.getClientViewProxy(), this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    private void displayMemberInfo() {
        SpreadManager sm = this.plugin.getSpreadModel();
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList cellValues = new ArrayList();
        ArrayList formulas = new ArrayList();
        Recorder hasFormula = new Recorder((Object)false);
        sm.getAreaManager().forEach(area -> {
            RangeModel rangeModel = new RangeModel(((PositionInfo)area.getKey()).getAreaRange());
            sheet.iteratorRangeCells(rangeModel, cell -> {
                if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) {
                    if (cell.getRow() == rangeModel.getY_start() || cell.getCol() == rangeModel.getX_start()) {
                        Map<String, Object> map = this.updateMemberMessage((Cell)cell);
                        if (!map.isEmpty()) {
                            cellValues.add(map);
                        }
                        hasFormula.setRecord((Object)true);
                    } else {
                        cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                    }
                } else if (cell.getVariant() != null && !cell.getVariant().isEmpty()) {
                    cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                }
                if (StringUtils.isNotEmpty((String)cell.getFormula())) {
                    formulas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                    hasFormula.setRecord((Object)true);
                }
            });
        });
        if (!formulas.isEmpty()) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.plugin.getClientViewProxy(), this.spreadKey, formulas);
        }
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.spreadKey, cellValues);
        }
        if (((Boolean)hasFormula.getRecord()).booleanValue()) {
            this.plugin.cacheSpreadModel();
        }
    }

    private void setF7TypeCellOnSpreadJS() {
        SpreadManager sm = this.plugin.getSpreadModel();
        ArrayList<Map<String, Object>> supportFuzQuery = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> noSupportFuzQuery = new ArrayList<Map<String, Object>>(16);
        sm.getAreaManager().forEach(area -> {
            AreaRangeEntry entry;
            if (((PositionInfo)area.getKey()).getExtendInfo() == null && (entry = this.getOverlapAreaRange(((PositionInfo)area.getKey()).getAreaRange())) != null) {
                RangeModel rangeModel = new RangeModel(((PositionInfo)area.getKey()).getAreaRange());
                noSupportFuzQuery.add(SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start(), rangeModel.getX_start(), 1, 1));
                if (rangeModel.getX_start() != rangeModel.getX_end()) {
                    this.addF7TypeCellRange(entry.getColDimEntries().size(), supportFuzQuery, noSupportFuzQuery, SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start(), rangeModel.getX_start() + 1, 1, rangeModel.getX_end() - (rangeModel.getX_start() + 1) + 1));
                }
                if (rangeModel.getY_start() != rangeModel.getY_end()) {
                    this.addF7TypeCellRange(entry.getRowDimEntries().size(), supportFuzQuery, noSupportFuzQuery, SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start() + 1, rangeModel.getX_start(), rangeModel.getY_end() - (rangeModel.getY_start() + 1) + 1, 1));
                }
            }
        });
        this.setF7TypeCell(supportFuzQuery, 0);
        this.setF7TypeCell(noSupportFuzQuery, 1);
    }

    private void addF7TypeCellRange(int dimSize, List<Map<String, Object>> supportFuzQuery, List<Map<String, Object>> noSupportFuzQuery, Map<String, Object> rangeMap) {
        if (dimSize == 1) {
            supportFuzQuery.add(rangeMap);
        } else {
            noSupportFuzQuery.add(rangeMap);
        }
    }

    private void setF7TypeCell(List<Map<String, Object>> cells, int selectType) {
        if (CollectionUtils.isNotEmpty(cells)) {
            HashMap<String, Object> features = new HashMap<String, Object>(16);
            features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), cells);
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), selectType);
            SpreadClientInvoker.invokeSetF7TypeCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, features);
        }
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.plugin.getTemplateModel().getAreaRangeEntries()) {
            if (!tarArea.equals(e.getAreaRange())) continue;
            return e;
        }
        return null;
    }

    @Override
    protected String getViewTabKey() {
        return "tab_memb";
    }

    @Override
    protected String[] getVisibleCtrlKeys() {
        if (this.plugin.getTemplateModel().getIsCircularDefine()) {
            return new String[]{"btn_dimsetting", "btn_areasetting", "btn_membsetting", "btn_floatsetting", "btn_circularsetting", "btn_seqsetting"};
        }
        ArrayList list = Lists.newArrayList((Object[])new String[]{"btn_dimsetting", "btn_areasetting", "btn_membsetting", "btn_floatsetting", "btn_seqsetting"});
        if (this.plugin.isCM()) {
            list.add("btn_extendareasetting");
            list.add("btn_extdatasetting");
            list.add("btn_extdatacalsetting");
        }
        return list.toArray(new String[0]);
    }

    private void lockFloatColOrRow() {
        for (PositionInfo ps : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            TemplateFloatUtil.setFloatAreaCellLock(this.plugin.getView(), this.spreadKey, ps, null);
        }
    }
}

