/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview.handle;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.formplugin.template.multiview.MultiViewTemplateProcess;
import kd.fi.bcm.formplugin.template.multiview.handle.IViewHandle;
import kd.fi.bcm.formplugin.template.multiview.handle.MembCrossViewHandle;
import kd.fi.bcm.formplugin.template.multiview.handle.MemberViewHandle;
import kd.fi.bcm.formplugin.template.multiview.handle.StyleViewHandle;

public class ViewSwitchers {
    public static final String TAB_CACHE_KEY = "tab_current_key";
    public static final String TAB_SYTLE_VIEW = "tab_style";
    public static final String TAB_MEMB_VIEW = "tab_memb";
    public static final String TAB_CROSS_VIEW = "tab_cross";
    public static final String TAB_FORMULA_VIEW = "tab_formula";

    public void switchView(String tabKey, MultiViewTemplateProcess plugin, String spreadKey, boolean isforceExec) {
        if (!isforceExec && tabKey.equals(this.getCurrentTabKey(plugin))) {
            return;
        }
        ViewFactory.getViewInstance(tabKey).handleView(plugin, spreadKey);
        plugin.getPageCache().put(TAB_CACHE_KEY, tabKey);
    }

    private String getCurrentTabKey(MultiViewTemplateProcess plugin) {
        return plugin.getPageCache().get(TAB_CACHE_KEY);
    }

    static class ViewFactory {
        private static final Map<String, Class<? extends IViewHandle>> views = new HashMap<String, Class<? extends IViewHandle>>();

        ViewFactory() {
        }

        static IViewHandle getViewInstance(String tabKey) {
            Class<? extends IViewHandle> clazz = views.get(tabKey);
            if (clazz != null) {
                try {
                    return clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u89c6\u56fe%s\u5bf9\u5e94\u652f\u6301\u7684\u5904\u7406\u65b9\u5f0f\u3002", (String)"ViewSwitchers_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tabKey));
        }

        static {
            views.put(ViewSwitchers.TAB_SYTLE_VIEW, StyleViewHandle.class);
            views.put(ViewSwitchers.TAB_MEMB_VIEW, MemberViewHandle.class);
            views.put(ViewSwitchers.TAB_CROSS_VIEW, MembCrossViewHandle.class);
        }
    }
}

