/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.SerialSpliter;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.PositionTypeEnum;
import kd.fi.bcm.common.enums.WeaveInfoEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class TemplateEntryFormulaCheck {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractTemplateBasePlugin.class);
    private TemplateModel tm;
    private SpreadManager sm;
    private Long modelid;
    private List<RangeModel> seqRangeModels = new ArrayList<RangeModel>(16);
    private List<RangeModel> extRangeModels = new ArrayList<RangeModel>(16);
    private List<RangeModel> floatRangeModels = new ArrayList<RangeModel>(16);
    private StringBuilder tips = new StringBuilder();

    public TemplateEntryFormulaCheck(TemplateModel tm, SpreadManager sm) {
        this.tm = tm;
        this.sm = sm;
        if (tm != null) {
            this.modelid = tm.getModelId();
        }
    }

    public SpreadManager getSm() {
        return this.sm;
    }

    public StringBuilder getTips() {
        return this.tips;
    }

    public Map<String, String> checkFormulaForImport(Map<String, String> formulas) {
        Map<String, String> map = this.filterNoIllegalFormula(formulas);
        this.collectRangeModels();
        if (!formulas.isEmpty()) {
            formulas.forEach((k, f) -> {
                Point point = ExcelUtils.pos2Point((String)k);
                Cell cell = this.getEffectiveSheet().getCell(point.y, point.x);
                boolean notEmpty = StringUtils.isNotEmpty((String)f);
                if (!notEmpty || notEmpty && StringUtils.isEmpty((String)this.collectTipsForSingleCell(cell, true, true))) {
                    cell.setValue((Object)0);
                    cell.setFormula(f);
                } else {
                    map.put((String)k, (String)f);
                }
            });
            if (!map.isEmpty()) {
                map.forEach((k, v) -> {
                    String cfr_ignored_0 = (String)formulas.remove(k);
                });
            }
        }
        return formulas;
    }

    private Map<String, String> filterNoIllegalFormula(Map<String, String> formulas) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        formulas.forEach((k, v) -> {
            if (StringUtils.isNotEmpty((String)v)) {
                String message = "";
                try {
                    if (TempFormulaUtil.isCycleRefrenceCal(v, k)) {
                        message = ResManager.loadKDString((String)"\u516c\u5f0f\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"TemplateEntryFormulaCheck_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    message = ResManager.loadKDString((String)"\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff0c\u65e0\u6cd5\u8bc6\u522b\u3002", (String)"TemplateEntryFormulaCheck_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)message)) {
                    this.tips.append(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u3010%1$s\u3011\u6a21\u677f\u7248\u672c\u3010%2$s\u3011\u5355\u5143\u683c\u3010%3$s\u3011\u65e0\u6cd5\u5bfc\u5165\u516c\u5f0f\u539f\u56e0\u3010%4$s\u3011\u3002%5$s", (String)"TemplateEntryFormulaCheck_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.tm.getNumber(), this.getTemplateVersionNumber(), k, message, "\n"));
                    map.put((String)k, (String)v);
                }
            }
        });
        if (!map.isEmpty()) {
            map.forEach((k, v) -> {
                String cfr_ignored_0 = (String)formulas.remove(k);
            });
        }
        return map;
    }

    public List<Map<String, Object>> correctFormulaForSave() {
        ArrayList<Map<String, Object>> fCellValues = new ArrayList<Map<String, Object>>(16);
        if (this.tm.isSaveByDim()) {
            this.collectRangeModels();
            this.getEffectiveSheet().iteratorCells(cell -> {
                if (cell.hasFormula() && StringUtils.isNotEmpty((String)this.collectTipsForSingleCell((Cell)cell, false, false))) {
                    cell.setFormula(null);
                    cell.setValue(null);
                    fCellValues.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                }
            });
        }
        return fCellValues;
    }

    private String collectTipsForSingleCell(Cell cell, boolean isAdd, boolean isImport) {
        String msg = this.singleCellFormulaCheck(cell, isAdd, isImport);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.tips.append(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u3010%1$s\u3011\u6a21\u677f\u7248\u672c\u3010%2$s\u3011\u5355\u5143\u683c\u3010%3$s\u3011\u65e0\u6cd5\u5bfc\u5165\u516c\u5f0f\u539f\u56e0\u3010%4$s\u3011\u3002%5$s", (String)"TemplateEntryFormulaCheck_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.tm.getNumber(), this.getTemplateVersionNumber(), ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), msg, "\n"));
        }
        return msg;
    }

    private String getTemplateVersionNumber() {
        return String.format("V%.1f", Float.valueOf(this.tm.getVersionNumber().floatValue()));
    }

    public boolean singleCellValueCheck(Cell cell) {
        if (!this.tm.isSaveByDim()) {
            return true;
        }
        PositionInfo ps = this.getPosForCell(cell, true);
        if (ps == null) {
            return true;
        }
        if (ps.getExtendInfo() != null) {
            return false;
        }
        return !this.isCompleteRowColDim(cell.getRow(), cell.getCol(), ps);
    }

    public String singleCellFormulaCheck(Cell cell, boolean isAdd, boolean isImport) {
        String formula = cell.getFormula();
        if (cell.isLock() && isImport) {
            return ResManager.loadKDString((String)"\u5355\u5143\u683c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u6dfb\u52a0\u516c\u5f0f\u3002", (String)"TemplateEntryFormulaCheck_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (formula != null && isAdd && (formula.startsWith(WeaveInfoEnum.UNIT.getFormlua()) || formula.startsWith(WeaveInfoEnum.DATE.getFormlua()) || formula.startsWith(WeaveInfoEnum.CURRENCY.getFormlua()))) {
            return ResManager.loadKDString((String)"\u6b64\u5355\u5143\u683c\u5df2\u5305\u542b\u7f16\u5236\u4fe1\u606f\uff0c\u4e0d\u53ef\u6dfb\u52a0\u516c\u5f0f\u3002", (String)"MultiViewTemplateProcess_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!this.tm.isSaveByDim()) {
            return null;
        }
        PositionInfo ps = this.getPosForCell(cell, false);
        if (ps == null) {
            return null;
        }
        String msg = this.checkRangModels(cell);
        if (StringUtils.isNotEmpty((String)msg)) {
            return msg;
        }
        if (ps.getExtendInfo() != null) {
            return null;
        }
        if (this.isCompleteRowColDim(cell.getRow(), cell.getCol(), ps)) {
            if (!this.floatRangeModels.isEmpty() && this.floatRangeModels.stream().anyMatch(rangeModel -> rangeModel.checkIsInArea(cell))) {
                return ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e2d\u6d6e\u52a8\u6570\u636e\u533a\u57df\u9996\u884c\u6216\u9996\u5217\u4e4b\u5916\u7684\u533a\u57df\u4e0d\u53ef\u586b\u5199\u516c\u5f0f\u3002", (String)"TemplateEntryFormulaCheck_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            msg = this.checkCanAddFormulaForView();
            if (StringUtils.isNotEmpty((String)msg)) {
                return msg;
            }
            msg = this.checkRowAndCol(cell.getRow(), cell.getCol(), ps);
            if (StringUtils.isNotEmpty((String)msg)) {
                return msg;
            }
        }
        return null;
    }

    public String checkRowAndCol(int row, int col, PositionInfo e) {
        String msg1;
        block2: {
            DynaMembScopeInfo membScopeInfo;
            IDimMember member;
            Pair<List<DimMember>, List<DynaMembScopeInfo>> pair = this.getCellDimMember(row, col, e, false);
            List memberFromUserObject = (List)pair.p1;
            List dynaMembScopeInfos = (List)pair.p2;
            msg1 = null;
            for (IDimMember member2 : memberFromUserObject) {
                msg1 = TempFormulaUtil.checkDimCombinationForFormula(member2.getDimension().getNumber(), member2.getNumber(), this.modelid);
                if (msg1 == null) continue;
                return msg1;
            }
            if (dynaMembScopeInfos.isEmpty()) break block2;
            Iterator iterator = dynaMembScopeInfos.iterator();
            while (iterator.hasNext() && (msg1 = TempFormulaUtil.checkDimCombinationForFormula((member = (membScopeInfo = (DynaMembScopeInfo)iterator.next()).getMember()).getDimension().getNumber(), member.getNumber(), this.modelid)) == null) {
            }
        }
        return msg1;
    }

    public boolean isCompleteRowColDim(int row, int col, PositionInfo e) {
        if (e.getExtendInfo() != null) {
            return true;
        }
        Pair<List<DimMember>, List<DynaMembScopeInfo>> cellDimMember = this.getCellDimMember(row, col, e, true);
        List<Tuple<String, String, String>> rowColDimList = this.findRowColDimList(ExcelUtils.xy2Pos((int)col, (int)row), true);
        return ((List)cellDimMember.p1).size() + ((List)cellDimMember.p2).size() == rowColDimList.size();
    }

    public List<Tuple<String, String, String>> findRowColDimList(String position, boolean isCross) {
        ArrayList<Tuple<String, String, String>> rowColDimMesList = new ArrayList<Tuple<String, String, String>>(16);
        try {
            for (AreaRangeEntry e : this.tm.getAreaRangeEntries()) {
                String spreadArea;
                PositionInfo spreadPositionInfo = this.sm.getAreaManager().findPositionInfo(e.getStartPosition(), e.getAreaRange());
                if (spreadPositionInfo == null || !ExcelUtils.isWithInScope((String)(spreadArea = spreadPositionInfo.getAreaRange()), (String)position)) continue;
                if (isCross) {
                    this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONROW);
                    this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONCOL);
                } else {
                    Point point = ExcelUtils.pos2Point((String)position);
                    int row = point.y;
                    int col = point.x;
                    Point startPonit = ExcelUtils.pos2Point((String)spreadPositionInfo.getStartPosition());
                    if (startPonit.x == col && startPonit.y == row) {
                        this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONROW);
                        this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONCOL);
                    } else if (col == startPonit.x) {
                        this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONROW);
                    } else if (row == startPonit.y) {
                        this.fillDimTupleList(e, rowColDimMesList, PositionTypeEnum.ONCOL);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = position == null ? "null" : position;
            log.error(msg + " : " + e);
        }
        return rowColDimMesList;
    }

    public void fillDimTupleList(AreaRangeEntry e, List<Tuple<String, String, String>> rowColDimMesList, PositionTypeEnum positionTypeEnum, boolean isUpdateCellDimMems) {
        Map map = MemberReader.getDimNumberMapNameById((long)this.modelid);
        if (PositionTypeEnum.ONCOL == positionTypeEnum) {
            e.getColDimEntries().forEach(colDimensionEntry -> {
                Dimension dimension = colDimensionEntry.getDimension();
                String dimNumber = dimension.getNumber();
                String name = map.get(dimNumber) != null ? (String)map.get(dimNumber) : dimension.getName();
                rowColDimMesList.add(Tuple.create((Object)dimension.getMemberEntityNumber(), (Object)dimNumber, (Object)(isUpdateCellDimMems ? positionTypeEnum.getName() : name)));
            });
        } else if (PositionTypeEnum.ONROW == positionTypeEnum) {
            e.getRowDimEntries().forEach(rowDimensionEntry -> {
                Dimension dimension = rowDimensionEntry.getDimension();
                String dimNumber = dimension.getNumber();
                String name = map.get(dimNumber) != null ? (String)map.get(dimNumber) : dimension.getName();
                rowColDimMesList.add(Tuple.create((Object)dimension.getMemberEntityNumber(), (Object)dimNumber, (Object)(isUpdateCellDimMems ? positionTypeEnum.getName() : name)));
            });
        }
    }

    public void fillDimTupleList(AreaRangeEntry e, List<Tuple<String, String, String>> rowColDimMesList, PositionTypeEnum positionTypeEnum) {
        this.fillDimTupleList(e, rowColDimMesList, positionTypeEnum, false);
    }

    public Pair<List<DimMember>, List<DynaMembScopeInfo>> getCellDimMember(int r, int c, PositionInfo e, boolean isComplete) {
        String[] split = e.getAreaRange().split(":");
        Point startPoint = ExcelUtils.pos2Point((String)split[0]);
        ArrayList dynaMembScopeInfos = new ArrayList(16);
        boolean isDirect = false;
        boolean isFloatArea = false;
        if (e.isFloatPosition()) {
            for (BasePointInfo baseInfo : e.getBasePoints()) {
                isDirect = baseInfo.isDirectHoriz();
                split = baseInfo.getDynaRange().split(":");
                Point startDyn = ExcelUtils.pos2Point((String)split[0]);
                Point endDyn = ExcelUtils.pos2Point((String)split[1]);
                if (isDirect) {
                    isFloatArea = c >= startDyn.x && c <= endDyn.x;
                } else {
                    boolean bl = isFloatArea = r >= startDyn.y && r <= endDyn.y;
                }
                if (!isFloatArea) continue;
                baseInfo.getBasePointInnerLineInfo().forEach(basePointInnerLineInfo -> {
                    if (isComplete) {
                        dynaMembScopeInfos.add(new DynaMembScopeInfo(null));
                    } else if (!basePointInnerLineInfo.isFloated()) {
                        dynaMembScopeInfos.add(basePointInnerLineInfo.getDynaMembScopes().get(0));
                    }
                });
                break;
            }
        }
        return Pair.onePair(this.getCellFixedDimMember(r, c, e, isFloatArea, isDirect, startPoint), dynaMembScopeInfos);
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    private List<DimMember> getCellFixedDimMember(int r, int c, PositionInfo e, boolean isFloatArea, boolean isDirect, Point startPoint) {
        ArrayList<DimMember> memberList = new ArrayList<DimMember>(16);
        Cell cell = this.getEffectiveSheet().getCell(r, c);
        AreaRangeEntry areaRange = this.getOverlapAreaRange(e.getAreaRange());
        if (areaRange == null) {
            return memberList;
        }
        HashSet<String> rowDim = new HashSet<String>(16);
        HashSet<String> colDim = new HashSet<String>(16);
        HashSet<String> emptySet = new HashSet<String>(16);
        areaRange.getRowDimEntries().forEach(rowDimensionEntry -> rowDim.add(rowDimensionEntry.getDimension().getNumber()));
        areaRange.getColDimEntries().forEach(colDimensionEntry -> colDim.add(colDimensionEntry.getDimension().getNumber()));
        if (isFloatArea) {
            if (isDirect) {
                Cell rowCell = this.getEffectiveSheet().getCell(r, startPoint.x);
                this.addDimMember(memberList, rowCell, rowDim, emptySet);
            } else {
                Cell colCell = this.getEffectiveSheet().getCell(startPoint.y, c);
                this.addDimMember(memberList, colCell, emptySet, colDim);
            }
        } else if (!((Boolean)cell.getUserObject("not_cross", (Object)false)).booleanValue() || ((Boolean)cell.getUserObject("edit_cross", (Object)false)).booleanValue()) {
            if (cell.getUserObject("cross_nums") != null && ((Boolean)cell.getUserObject("edit_cross", (Object)false)).booleanValue()) {
                memberList.addAll(this.getCrossDimMember(cell));
            } else if (c == startPoint.x && r == startPoint.y) {
                this.addDimMember(memberList, cell, rowDim, colDim);
            } else if (c == startPoint.x) {
                this.addDimMember(memberList, cell, rowDim, emptySet);
                Cell colCell = this.getEffectiveSheet().getCell(startPoint.y, startPoint.x);
                this.addDimMember(memberList, colCell, emptySet, colDim);
            } else if (r == startPoint.y) {
                this.addDimMember(memberList, cell, emptySet, colDim);
                Cell rowCell = this.getEffectiveSheet().getCell(startPoint.y, startPoint.x);
                this.addDimMember(memberList, rowCell, rowDim, emptySet);
            } else {
                Cell rowCell = this.getEffectiveSheet().getCell(r, startPoint.x);
                this.addDimMember(memberList, rowCell, rowDim, emptySet);
                Cell colCell = this.getEffectiveSheet().getCell(startPoint.y, c);
                this.addDimMember(memberList, colCell, emptySet, colDim);
            }
        }
        return memberList;
    }

    public List<DimMember> getCrossDimMember(Cell cell) {
        String serial;
        ArrayList<DimMember> dimMembers = new ArrayList<DimMember>();
        if (cell.getUserObject("cross_nums") != null && StringUtils.isNotEmpty((String)(serial = (String)cell.getUserObject("cross_nums", (Object)"")))) {
            String modelNumber = MemberReader.findModelNumberById((Object)this.modelid);
            SerialSpliter spliter = new SerialSpliter(serial);
            Map dimMaps = MemberReader.getDimNumberMapNameById((long)this.modelid);
            spliter.getPairs().forEach(pair -> {
                String dimNumber = (String)pair.p1;
                if (dimMaps.containsKey(dimNumber)) {
                    kd.fi.bcm.spread.model.Dimension dimension = new kd.fi.bcm.spread.model.Dimension((String)dimMaps.get(dimNumber), dimNumber, DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber));
                    String memNumber = (String)pair.p2;
                    String name = "";
                    if (SystemVarsEnum.CURRENT.getNumber().equals(memNumber)) {
                        name = SystemVarsEnum.CURRENT.getName();
                    } else {
                        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memNumber);
                        name = node.getName();
                    }
                    dimMembers.add(new DimMember(name, memNumber, "", (IDimension)dimension));
                }
            });
        }
        return dimMembers;
    }

    private void addDimMember(List<DimMember> memberList, Cell cell, Set<String> rowDim, Set<String> colDim) {
        List fromUserObject = (List)cell.getUserObject("KEY_DIM_FLAG");
        if (fromUserObject != null && !fromUserObject.isEmpty()) {
            fromUserObject.forEach(userObj -> {
                String dimNumber = userObj.getDimension().getNumber();
                boolean isExit = false;
                for (IDimMember member : memberList) {
                    if (!dimNumber.equals(member.getDimension().getNumber())) continue;
                    isExit = true;
                    break;
                }
                if (!isExit && (rowDim.contains(dimNumber) || colDim.contains(dimNumber))) {
                    memberList.add((DimMember)userObj);
                }
            });
        }
    }

    private String checkRangModels(Cell cell) {
        String msg = null;
        if (!this.extRangeModels.isEmpty() && this.extRangeModels.stream().anyMatch(rangeModel -> rangeModel.checkIsInArea(cell))) {
            return ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u4e0d\u53ef\u586b\u5199\u516c\u5f0f\u3002", (String)"MultiViewTemplateProcess_91", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!this.seqRangeModels.isEmpty() && this.seqRangeModels.stream().anyMatch(rangeModel -> rangeModel.checkIsInArea(cell))) {
            return ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e2d\u884c\u6b21\u8bbe\u7f6e\u533a\u57df\u4e0d\u53ef\u586b\u5199\u516c\u5f0f\u3002", (String)"MultiViewTemplateProcess_104", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public PositionInfo getPosForCell(Cell cell, boolean isCheckValue) {
        for (PositionInfo e : this.sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = e.getAreaRange();
            if (e.getExtendInfo() != null && !isCheckValue) {
                RangeModel rangeModel = new RangeModel(areaRange);
                rangeModel.setY_start(rangeModel.getY_start() - 1);
                areaRange = rangeModel.toString();
            }
            if (!ExcelUtils.isWithInScope((String)areaRange, (String)ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()))) continue;
            return e;
        }
        return null;
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.tm.getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    public String checkCanAddFormulaForView() {
        for (ViewPointDimensionEntry viewentry : this.tm.getViewPointDimensionEntries()) {
            String number = viewentry.getMember().getNumber();
            String msg = TempFormulaUtil.checkDimCombinationForFormula(viewentry.getDimension().getNumber(), number, this.modelid);
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            return msg;
        }
        return null;
    }

    public void collectRangeModels() {
        if (this.tm != null && this.sm != null) {
            this.sm.getAreaManager().getPostionInfoSet().forEach(ps -> {
                SequenceInfo sequenceInfo;
                if (ps.getExtendInfo() != null) {
                    this.extRangeModels.add(new RangeModel(ps.getAreaRange()));
                }
                if ((sequenceInfo = ps.getSequenceInfo()) != null) {
                    this.seqRangeModels.add(new RangeModel(sequenceInfo.getSeqArea()));
                }
                this.floatRangeModels.addAll(this.getRangeModelsFromFloat((PositionInfo)ps));
            });
        } else {
            this.extRangeModels = new ArrayList<RangeModel>(16);
            this.seqRangeModels = new ArrayList<RangeModel>(16);
            this.floatRangeModels = new ArrayList<RangeModel>(16);
        }
    }

    private List<RangeModel> getRangeModelsFromFloat(PositionInfo ps) {
        ArrayList<RangeModel> floatRangeModels = new ArrayList<RangeModel>(16);
        List basePoints = ps.getBasePoints();
        if (basePoints != null && !basePoints.isEmpty()) {
            String[] split = ps.getAreaRange().split(":");
            Point startPoint = ExcelUtils.pos2Point((String)split[0]);
            Point endPoint = ExcelUtils.pos2Point((String)split[1]);
            basePoints.forEach(basePointInfo -> {
                String[] floatSplit = basePointInfo.getDynaRange().split(":");
                Point fsPoint = ExcelUtils.pos2Point((String)floatSplit[0]);
                Point fePoint = ExcelUtils.pos2Point((String)floatSplit[1]);
                if (basePointInfo.isDirectHoriz() && fsPoint.x != fePoint.x) {
                    floatRangeModels.add(new RangeModel(fsPoint.x + 1, fePoint.x, startPoint.y, endPoint.y));
                } else if (!basePointInfo.isDirectHoriz() && fsPoint.y != fePoint.y) {
                    floatRangeModels.add(new RangeModel(startPoint.x, endPoint.x, fsPoint.y + 1, fePoint.y));
                }
            });
        }
        return floatRangeModels;
    }

    public List<Tuple<String, String, String>> getEnterRowOrColDims(final Cell cell) {
        ArrayList<Tuple<String, String, String>> dimTuples = new ArrayList<Tuple<String, String, String>>(16);
        final PositionInfo pos = this.getPosForCell(cell, true);
        if (pos == null || pos.getExtendInfo() != null) {
            return dimTuples;
        }
        Predicate<AreaRangeEntry> rangeEntryPredicate = new Predicate<AreaRangeEntry>(){

            @Override
            public boolean test(AreaRangeEntry areaRangeEntry) {
                return areaRangeEntry.getAreaRange().equals(pos.getAreaRange());
            }
        };
        Optional<AreaRangeEntry> optionalAreaRangeEntry = this.tm.getAreaRangeEntries().stream().filter(rangeEntryPredicate).findFirst();
        if (!optionalAreaRangeEntry.isPresent()) {
            return dimTuples;
        }
        AreaRangeEntry areaRangeEntry = optionalAreaRangeEntry.get();
        PositionTypeEnum positionTypeEnum = null;
        RangeModel rangeModel = new RangeModel(pos.getAreaRange());
        if (cell.getRow() == rangeModel.getY_start() && cell.getCol() == rangeModel.getX_start()) {
            positionTypeEnum = PositionTypeEnum.ONCROSS;
        } else if (cell.getRow() == rangeModel.getY_start()) {
            positionTypeEnum = PositionTypeEnum.ONCOL;
        } else if (cell.getCol() == rangeModel.getX_start()) {
            positionTypeEnum = PositionTypeEnum.ONROW;
        }
        if (positionTypeEnum == null) {
            return dimTuples;
        }
        if (pos.isFloatPosition() && positionTypeEnum == PositionTypeEnum.ONCROSS) {
            Predicate<BasePointInfo> predicate = new Predicate<BasePointInfo>(){

                @Override
                public boolean test(BasePointInfo basePointInfo) {
                    RangeModel floatRangeModel = new RangeModel(basePointInfo.getDynaRange());
                    return basePointInfo.isDirectHoriz() ? floatRangeModel.getX_start() == cell.getCol() : floatRangeModel.getY_start() == cell.getRow();
                }
            };
            Optional<BasePointInfo> optional = pos.getBasePoints().stream().filter(predicate).findFirst();
            if (optional.isPresent()) {
                PositionTypeEnum positionTypeEnum2 = positionTypeEnum = optional.get().isDirectHoriz() ? PositionTypeEnum.ONROW : PositionTypeEnum.ONCOL;
            }
        }
        if (positionTypeEnum == PositionTypeEnum.ONCROSS) {
            this.fillDimTupleList(areaRangeEntry, dimTuples, PositionTypeEnum.ONROW, true);
            this.fillDimTupleList(areaRangeEntry, dimTuples, PositionTypeEnum.ONCOL, true);
        } else {
            this.fillDimTupleList(areaRangeEntry, dimTuples, positionTypeEnum, true);
        }
        return dimTuples;
    }
}

