/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview.validators;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.rptformula.RptFormulaUtil;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateEntryFormulaCheck;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TemplateVerification {
    private static final String FORMULA = "formula";
    private static final String VALUE = "value";
    private static FormulaChecker formulaChecker;

    public static List<Map<String, Object>> showManagerAndSpreadJsonDiff(String spreadJson, SpreadManager sm, boolean isRptData) {
        formulaChecker = new FormulaChecker();
        ArrayList<Map<String, Object>> valueMapList = new ArrayList<Map<String, Object>>(10);
        JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)spreadJson));
        Sheet sheet = sm.getBook().getSheet(0);
        JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)object, (String)sheet.getSheetName());
        for (Map.Entry row : dataTable.entrySet()) {
            if (row == null) continue;
            for (Map.Entry cell : ((JSONObject)row.getValue()).entrySet()) {
                if (cell == null || !(cell.getValue() instanceof JSONObject)) continue;
                Cell cell1 = sheet.getCell(Integer.parseInt((String)row.getKey()), Integer.parseInt((String)cell.getKey()));
                String formulaObj = "";
                Object valueObj = null;
                if (((JSONObject)cell.getValue()).get((Object)FORMULA) != null) {
                    formulaObj = ((JSONObject)cell.getValue()).get((Object)FORMULA).toString();
                }
                if (((JSONObject)cell.getValue()).get((Object)VALUE) != null) {
                    valueObj = ((JSONObject)cell.getValue()).get((Object)VALUE);
                }
                String formula = cell1.getFormula();
                Object value = cell1.getValue();
                boolean isOnlyExcel = false;
                if (formula == null) {
                    formula = "";
                } else if (isRptData && !(isOnlyExcel = formulaChecker.checkIsOnlyExcel(formula)) && isRptData) {
                    formula = "";
                }
                if (!isRptData) {
                    isOnlyExcel = true;
                }
                if (formula.trim().equals(formulaObj.trim()) && !TemplateVerification.checkValueEqual(value, valueObj, isOnlyExcel)) continue;
                valueMapList.add(TemplateVerification.getOneData(cell1, formulaObj, formula, valueObj, value));
            }
        }
        return valueMapList;
    }

    private static boolean checkValueEqual(Object value1, Object value2, boolean isOnlyExcel) {
        if (value1 instanceof Number && value2 instanceof Number) {
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal = new BigDecimal(value1.toString());
            return bigDecimal.compareTo(bigDecimal2 = new BigDecimal(value2.toString())) != 0;
        }
        if (value1 == value2) {
            return false;
        }
        if (value1 != null) {
            if (value2 != null) {
                return !value1.toString().trim().equals(value2.toString().trim());
            }
        } else if (isOnlyExcel && value2.toString().equals("0")) {
            return false;
        }
        return true;
    }

    private static Map<String, Object> getOneData(Cell cell, Object formula1, Object formula2, Object vaule1, Object value2) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("location", ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()));
        map.put("frontformula", formula1);
        map.put("backformula", formula2);
        map.put("frontvalue", vaule1);
        map.put("backvalue", value2);
        return map;
    }

    private static Pair<Point, Point> getAreaRange(SpreadManager sm) {
        Point startPoint = null;
        Point endPoint = null;
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = ps.getAreaRange();
            String[] split = areaRange.split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        return Pair.onePair(startPoint, endPoint);
    }

    public static List<RangeModel> getHeaderRangeModel(Sheet sheet, RangeModel rangeModel) {
        ArrayList<RangeModel> rangeModels = new ArrayList<RangeModel>(16);
        if (rangeModel != null) {
            List dimNums = sheet.getRowHeader().getDimNums();
            rangeModels.add(new RangeModel(rangeModel.getX_start() - dimNums.size(), rangeModel.getX_start() - 1, rangeModel.getY_start() - 2, rangeModel.getY_end()));
            rangeModels.add(new RangeModel(rangeModel.getX_start(), rangeModel.getX_end(), rangeModel.getY_start() - 2, rangeModel.getY_start() - 1));
        }
        return rangeModels;
    }

    private static Set<String> getRowDimForWp(TemplateModel tm) {
        HashSet<String> rowDim = new HashSet<String>(16);
        tm.getAreaRangeEntries().forEach(areaRangeEntry -> areaRangeEntry.getRowDimEntries().forEach(rowDimensionEntry -> rowDim.add(rowDimensionEntry.getDimension().getNumber())));
        return rowDim;
    }

    public static Set<Integer> getCanSetFormulDataArea(TemplateModel tm, SpreadManager sm) {
        Pair<Point, Point> areaRange;
        HashSet<Integer> rows = new HashSet<Integer>(16);
        Set<String> rowDim = TemplateVerification.getRowDimForWp(tm);
        if (!rowDim.isEmpty() && (areaRange = TemplateVerification.getAreaRange(sm)) != null) {
            Point startPoint = (Point)areaRange.p1;
            Point endPoint = (Point)areaRange.p2;
            for (int j = startPoint.y; j <= endPoint.y; ++j) {
                boolean flag = false;
                for (int i = rowDim.size(); i > 0; --i) {
                    Cell cell;
                    if (flag || (cell = sm.getBook().getSheet(0).getCell(j, startPoint.x - i)).getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) continue;
                    rows.add(j);
                    flag = true;
                }
            }
        }
        return rows;
    }

    public static boolean syncAreaRangeByModel(SpreadManager sm, TemplateModel tm) {
        Iterator iterator = tm.getAreaRangeEntries().iterator();
        boolean isChange = false;
        while (iterator.hasNext()) {
            AreaRangeEntry e = (AreaRangeEntry)iterator.next();
            PositionInfo spreadPositionInfo = sm.getAreaManager().findPositionInfo(e.getStartPosition(), e.getAreaRange());
            if (spreadPositionInfo != null) continue;
            iterator.remove();
            isChange = true;
        }
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = positionInfo.getAreaRange();
            String start = positionInfo.getStartPosition();
            iterator = tm.getAreaRangeEntries().iterator();
            boolean flag = Boolean.TRUE;
            while (iterator.hasNext()) {
                AreaRangeEntry e = (AreaRangeEntry)iterator.next();
                if (!areaRange.equals(e.getAreaRange()) || !start.equals(e.getStartPosition())) continue;
                flag = Boolean.FALSE;
                break;
            }
            if (!flag) continue;
            AreaRangeEntry areaEntry = TemplateVerification.getAreaRangeEntryFloat(tm, areaRange, start);
            tm.getAreaRangeEntries().add(areaEntry);
            isChange = true;
        }
        return isChange;
    }

    private static AreaRangeEntry getAreaRangeEntryFloat(TemplateModel template, String areaRange, String startPosition) {
        AreaRangeEntry areaRangeEntry = new AreaRangeEntry(template);
        areaRangeEntry.setAreaRange(areaRange);
        areaRangeEntry.setStartPosition(startPosition);
        return areaRangeEntry;
    }

    public static boolean isSeqDataAreaRange(int r, int c, SpreadManager sm) {
        ArrayList seqAreas = new ArrayList(16);
        sm.getAreaManager().getPostionInfoSet().forEach(ps -> {
            if (ps.getSequenceInfo() != null) {
                seqAreas.add(ps.getSequenceInfo().getSeqArea());
            }
        });
        for (String seqArea : seqAreas) {
            RangeModel rangeModel = new RangeModel(seqArea);
            if (rangeModel.getX_start() > c || rangeModel.getX_end() < c || rangeModel.getY_start() > r || rangeModel.getY_end() < r) continue;
            return true;
        }
        return false;
    }

    public static Pair<String, String> beforeSaveTemplate(String json, SpreadManager sm, TemplateModel tm, boolean isFromWp, List<Map<String, Object>> delValues, List<Map<String, Object>> delFormulas) {
        String typeName;
        JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)json));
        TemplateVerification.modifySheetName(object, tm.getName(), isFromWp);
        JSONObject dataJsonObj = DataAndJsonTranslator.getDataTable((JSONObject)object, (String)tm.getName());
        if (!isFromWp) {
            TemplateUtil.setTemplateLockedCellStatus(dataJsonObj, sm);
        }
        ArrayList formulas = new ArrayList(16);
        ArrayList values = new ArrayList(16);
        Pair<List<Map<String, Object>>, List<Map<String, Object>>> pair = TemplateVerification.clearIllegalValueOrFormula(tm, sm, isFromWp, dataJsonObj, delFormulas);
        TemplateVerification.syncValueAndFormulaToSm(sm, TemplateVerification.collectValuesAndFormulas(dataJsonObj), true, true, false, isFromWp);
        if (pair != null) {
            values.addAll((Collection)pair.p1);
            formulas.addAll((Collection)pair.p2);
        }
        StringBuilder message = new StringBuilder();
        String string = typeName = isFromWp ? ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f", (String)"TemplateVerification_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868", (String)"TemplateVerification_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (!values.isEmpty()) {
            message.append(String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u4e2d\u6570\u636e\u533a\u57df\u4e0d\u53ef\u586b\u5199\u6570\u503c\uff01", (String)"TemplateVerification_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), typeName));
        }
        if (!formulas.isEmpty()) {
            message.append(isFromWp ? ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u4e2d\uff0c\u5b8c\u6574\u7ef4\u5ea6\u7684\u6570\u636e\u533a\u57df\u5185\u7684\u5355\u5143\u683c\u4e0d\u5141\u8bb8\u5f55\u5165\u516c\u5f0f\u3002", (String)"TemplateVerification_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u5185\u7684\u5355\u5143\u683c\u4e0d\u5141\u8bb8\u5f55\u5165\u516c\u5f0f\u3002", (String)"TemplateVerification_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        json = "base64" + new String(Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString())));
        delFormulas.addAll(formulas);
        delValues.addAll(values);
        return Pair.onePair((Object)json, (Object)message.toString());
    }

    private static Object syncValueAndFormulaToSm(SpreadManager sm, Table<String, String, Pair<Object, String>> table, boolean isUpdateValue, boolean isUpdateFormula, boolean isNeedTips, boolean isFromWp) {
        StringBuilder stringBuffer = new StringBuilder();
        AtomicBoolean flag = new AtomicBoolean(false);
        if (!table.isEmpty()) {
            formulaChecker = new FormulaChecker();
            ArrayList areas = new ArrayList(16);
            sm.getAreaManager().getPostionInfoSet().forEach(ps -> areas.add(ps.getAreaRange()));
            Sheet sheet = sm.getBook().getSheet(0);
            sheet.iteratorCells(cell -> {
                if (!isFromWp && isUpdateValue && (areas.isEmpty() || !SpreadAreaUtil.isInArea((String)ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), (List)areas))) {
                    if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) {
                        flag.set(true);
                    }
                    cell.clearMembersOfUserObject();
                    if (cell.getUserObject().containsKey((Object)"cross_nums")) {
                        cell.removeUserObject("cross_nums");
                    }
                    cell.setMdDataDomain(false);
                }
                Pair pair = (Pair)table.remove((Object)(cell.getRow() + ""), (Object)(cell.getCol() + ""));
                String formula = null;
                String cellFormula = cell.getFormula() == null ? "" : cell.getFormula().trim();
                boolean isChange = false;
                boolean isOnlyExcel = false;
                if (pair != null) {
                    if (isUpdateFormula) {
                        String string = formula = pair.p2 == null ? "" : ((String)pair.p2).trim();
                        if (!formula.equals(cellFormula)) {
                            if (cellFormula != "" && formula == "" && !RptFormulaUtil.rptformulas.stream().anyMatch(item -> cellFormula.toLowerCase(Locale.ENGLISH).startsWith((String)item))) {
                                return;
                            }
                            cell.setFormula(StringUtils.isNotEmpty((String)formula) ? formula : null);
                            isChange = true;
                        }
                    }
                    if (cell.hasFormula()) {
                        isOnlyExcel = formulaChecker.checkIsOnlyExcel(cell.getFormula());
                    }
                    if (isUpdateValue) {
                        Object value = pair.p1;
                        Object cellValue = cell.getValue();
                        if (TemplateVerification.checkValueEqual(cellValue, value, isOnlyExcel)) {
                            cell.setValue(value);
                            flag.set(true);
                        }
                    }
                } else {
                    isChange = cell.hasFormula();
                    if (cell.getValue() != null || isChange) {
                        flag.set(true);
                        cell.setValue(null);
                        cell.setFormula(null);
                    }
                }
                if (isNeedTips && isUpdateFormula && isChange) {
                    String str = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%s\u540e\u7aef\u516c\u5f0f\u7531%1$s\u6539\u4e3a%2$s", (String)"MultiViewTemplateProcess_77", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), StringUtils.isEmpty((String)cellFormula) ? "null" : cellFormula, StringUtils.isNotEmpty((String)formula) ? formula : "null");
                    stringBuffer.append(str).append(";");
                }
            });
            if (!table.isEmpty()) {
                table.rowMap().forEach((row, v) -> v.forEach((col, pair) -> {
                    if (pair != null) {
                        Cell cell = sheet.getCell(Integer.parseInt(row), Integer.parseInt(col));
                        if (isUpdateValue && pair.p1 != null && StringUtils.isNotEmpty((String)pair.p1.toString())) {
                            flag.set(true);
                            cell.setValue(pair.p1);
                        }
                        if (isUpdateFormula && pair.p2 != null && StringUtils.isNotEmpty((String)((String)pair.p2))) {
                            cell.setFormula(((String)pair.p2).trim());
                            if (isNeedTips) {
                                String str = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%s\u540e\u7aef\u516c\u5f0f\u7531%1$s\u6539\u4e3a%2$s", (String)"MultiViewTemplateProcess_77", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), "null", ((String)pair.p2).trim());
                                stringBuffer.append(str).append(";");
                            }
                        }
                    }
                }));
            }
        }
        if (isUpdateFormula && !isUpdateValue && isNeedTips) {
            return stringBuffer.toString();
        }
        if (isUpdateValue && !isUpdateFormula) {
            return flag.get();
        }
        return null;
    }

    private static void adjsutOriginal(SpreadManager sm, List<RangeModel> areas, List<RangeModel> extRangeModel, List<RangeModel> floatAreas) {
        sm.getAreaManager().getPostionInfoSet().forEach(e -> {
            SequenceInfo sequenceInfo;
            e.setOriginalAreaRange(e.getAreaRange());
            e.setOriginalStartPosition(e.getStartPosition());
            if (e.getBasePoints() != null && !e.getBasePoints().isEmpty()) {
                e.getBasePoints().forEach(basePointInfo -> {
                    basePointInfo.setOriginalDynaRange(basePointInfo.getDynaRange());
                    floatAreas.add(new RangeModel(basePointInfo.getDynaRange()));
                });
            }
            if ((sequenceInfo = e.getSequenceInfo()) != null) {
                sequenceInfo.setOriSeqArea(null);
                sequenceInfo.setDataArea(e.getAreaRange());
            }
            if (e.getExtendInfo() != null) {
                extRangeModel.add(new RangeModel(e.getAreaRange()));
            } else {
                areas.add(new RangeModel(e.getAreaRange()));
            }
        });
    }

    public static Pair<List<Map<String, Object>>, List<Map<String, Object>>> clearValueOfDataArea(TemplateModel tm, SpreadManager sm) {
        JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)tm.getSpreadJson()));
        return TemplateVerification.clearIllegalValueOrFormula(tm, sm, false, DataAndJsonTranslator.getDataTable((JSONObject)object, (String)tm.getName()), new ArrayList<Map<String, Object>>(16));
    }

    private static Pair<List<Map<String, Object>>, List<Map<String, Object>>> clearIllegalValueOrFormula(TemplateModel tm, SpreadManager sm, boolean isFromWp, JSONObject dataJsonObj, List<Map<String, Object>> delFormulas) {
        ArrayList values = new ArrayList(16);
        ArrayList formulas = new ArrayList(16);
        ArrayList<Map<String, Object>> changes = new ArrayList<Map<String, Object>>(16);
        ArrayList<RangeModel> areas = new ArrayList<RangeModel>(16);
        ArrayList<RangeModel> floatAreas = new ArrayList<RangeModel>(16);
        ArrayList<RangeModel> extRangeModel = new ArrayList<RangeModel>(16);
        TemplateVerification.adjsutOriginal(sm, areas, extRangeModel, floatAreas);
        Set<Object> rows = new HashSet(16);
        if (isFromWp) {
            rows = TemplateVerification.getCanSetFormulDataArea(tm, sm);
        }
        HashSet finalRows = rows;
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            boolean isClearVal = false;
            boolean isClearFormula = false;
            if (!floatAreas.isEmpty() && floatAreas.stream().anyMatch(e -> e.checkIsInArea(cell))) {
                isClearVal = true;
                isClearFormula = true;
            }
            if (!isFromWp && extRangeModel.stream().anyMatch(e -> e.checkIsInArea(cell))) {
                isClearVal = true;
                isClearFormula = true;
            }
            if (areas.stream().anyMatch(e -> e.checkIsInArea(cell))) {
                if (isFromWp) {
                    if (!finalRows.contains(cell.getRow())) {
                        isClearVal = true;
                        isClearFormula = true;
                    }
                } else {
                    PositionInfo e2 = sm.getInAreaPositionInfoByXY(cell.getRow(), cell.getCol());
                    if (e2 != null) {
                        isClearVal = !cell.hasFormula() && new TemplateEntryFormulaCheck(tm, sm).isCompleteRowColDim(cell.getRow(), cell.getCol(), e2);
                    }
                }
            }
            Map<String, Object> change = new HashMap<String, String>(16);
            if (isClearVal && cell.getValue() != null && StringUtils.isNotEmpty((String)cell.getValue().toString())) {
                values.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                change = SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null);
                cell.setValue(null);
            }
            if (isClearFormula && cell.hasFormula()) {
                formulas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                if (change.isEmpty()) {
                    change = SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null);
                }
                change.put(FORMULA, cell.getFormula());
                cell.setFormula(null);
            }
            if (!change.isEmpty()) {
                changes.add(change);
            }
        });
        changes.addAll(delFormulas);
        TemplateVerification.updateValueAndFormulaToJson(changes, dataJsonObj);
        return Pair.onePair(values, formulas);
    }

    private static void updateValueAndFormulaToJson(List<Map<String, Object>> changes, JSONObject dataJsonObj) {
        if (!changes.isEmpty()) {
            changes.forEach(e -> {
                int row = (Integer)e.get(SpreadProperties.UpdataValueMethod.R.k());
                int col = (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k());
                if (dataJsonObj.get((Object)(row + "")) == null) {
                    return;
                }
                JSONObject rowCells = (JSONObject)dataJsonObj.get((Object)(row + ""));
                if (rowCells.get((Object)(col + "")) == null) {
                    return;
                }
                JSONObject cell = (JSONObject)rowCells.get((Object)(col + ""));
                if (cell != null) {
                    cell.remove((Object)VALUE);
                    if (e.get(FORMULA) != null) {
                        cell.remove((Object)FORMULA);
                    }
                }
            });
        }
    }

    private static void modifySheetName(JSONObject object, String sheetName, boolean isFromWp) {
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        for (Map.Entry entry : sheets.entrySet()) {
            String k = (String)entry.getKey();
            if (!isFromWp && sheetName.length() > 31) {
                sheetName = sheetName.substring(0, 31);
            }
            if (!sheetName.equals(k)) {
                sheets.put(sheetName, ObjectUtils.clone(entry.getValue()));
                sheets.remove((Object)k);
            }
            JSONObject name = (JSONObject)sheets.get((Object)sheetName);
            name.put("name", (Object)sheetName);
        }
    }

    public static String syncFormulaToSm(Object obj, SpreadManager sm, String tName) {
        Table<String, String, Pair<Object, String>> table = HashBasedTable.create();
        String tips = null;
        if (obj != null) {
            JSONObject dataJsonObj = TemplateVerification.getJsonObjByObj(obj, tName);
            table = TemplateVerification.collectValuesAndFormulas(dataJsonObj);
        }
        if (!table.isEmpty()) {
            tips = TemplateVerification.syncValueAndFormulaToSm(sm, table, false, true, true, false).toString();
        }
        return tips;
    }

    public static boolean syncValueToSm(Object obj, SpreadManager sm, TemplateModel tm) {
        Object val;
        Table<String, String, Pair<Object, String>> table = HashBasedTable.create();
        if (obj != null) {
            JSONObject dataJsonObj = TemplateVerification.getJsonObjByObj(obj, tm.getName());
            table = TemplateVerification.collectValuesAndFormulas(dataJsonObj);
        }
        if ((val = TemplateVerification.syncValueAndFormulaToSm(sm, table, true, false, false, false)) instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    private static JSONObject getJsonObjByObj(Object obj, String sheetName) {
        JSONObject dataJsonObj = new JSONObject();
        if (obj instanceof String) {
            dataJsonObj = DataAndJsonTranslator.getDataTable((JSONObject)JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)((String)obj))), (String)sheetName);
        } else if (obj instanceof JSONObject) {
            dataJsonObj = (JSONObject)obj;
        }
        return dataJsonObj;
    }

    private static Table<String, String, Pair<Object, String>> collectValuesAndFormulas(JSONObject dataJsonObj) {
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry row : dataJsonObj.entrySet()) {
            if (row == null) continue;
            for (Map.Entry cell : ((JSONObject)row.getValue()).entrySet()) {
                if (cell == null || !(cell.getValue() instanceof JSONObject)) continue;
                Object value = null;
                String formula = null;
                Object formulaObj = ((JSONObject)cell.getValue()).get((Object)FORMULA);
                Object valueObj = ((JSONObject)cell.getValue()).get((Object)VALUE);
                if (valueObj != null) {
                    value = valueObj;
                }
                if (formulaObj != null) {
                    formula = formulaObj.toString();
                }
                if (value == null && formula == null) continue;
                table.put(row.getKey(), cell.getKey(), (Object)Pair.onePair((Object)value, (Object)formula));
            }
        }
        return table;
    }
}

