/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class SaveTemplateUtil {
    private static final String read = "read";
    private static final String categoryReadOnly = "categoryReadOnly";

    public static void openTemplateProcessPage(TemplateModel template, String formId, IFormView view, IFormPlugin plugin) {
        IFormView mainPageView = view.getMainView();
        String pageId = view.getPageId() + template.getId();
        IFormView parentView = view.getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            boolean isNewPage;
            FormShowParameter formShowParameter = new FormShowParameter();
            boolean bl = isNewPage = !template.isOldTemplate();
            if (!isNewPage) {
                SaveTemplateUtil.showOldTemplateTips(template.getModelId(), view);
                return;
            }
            formShowParameter.setFormId("bcm_multiviewtemplate");
            if (StringUtils.isNotEmpty((String)formId)) {
                formShowParameter.setFormId(formId);
            }
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)view.getPageCache().get("KEY_MODEL_ID"));
            formShowParameter.setCustomParam("listPageID", (Object)view.getPageId());
            BigDecimal versionNumber = (BigDecimal)template.get("versionnumber");
            String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u6a21\u677f-%1$s %2$s", (String)"TemplateListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getName(), version));
            formShowParameter.setCustomParam("template_model", (Object)ObjectSerialUtil.toByteSerialized((Object)template));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setCustomParam("List_entry", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("rank", (Object)view.getPageCache().get("rank"));
            CloseCallBack closeCallBack = new CloseCallBack(plugin, "processClosedCallBack");
            formShowParameter.setCloseCallBack(closeCallBack);
            String res = view.getPageCache().get("templateonlyreader") != null ? "true" : null;
            formShowParameter.setCustomParam(read, (Object)res);
            if (parentView == null) {
                view.showForm(formShowParameter);
                return;
            }
            formShowParameter.setParentPageId(parentView.getPageId());
            formShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            view.sendFormAction(childFormView);
        }
    }

    public static void showOldTemplateTips(Long modelId, IFormView view) {
        QFilter qfm = new QFilter("model", "=", (Object)modelId);
        QFilter qfo = new QFilter("isOldTemplate", "=", (Object)"1");
        DynamicObject[] oldTemplate = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"id,number,name", (QFilter[])new QFilter[]{qfm, qfo});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject obj : oldTemplate) {
            sb.append(obj.getString("number"));
            sb.append(" ");
            sb.append(obj.getString("name"));
            sb.append("\uff0c");
        }
        sb.deleteCharAt(sb.lastIndexOf("\uff0c"));
        view.showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u62a5\u8868\u6a21\u677f\u7531\u4e8e\u4f7f\u7528\u7684\u521b\u5efa\u65b9\u5f0f\u7cfb\u7edf\u5df2\u4e0d\u518d\u652f\u6301\u7ef4\u62a4\uff0c\u56e0\u6b64\u8bf7\u5728\u201c\u62a5\u8868\u6a21\u677f\u201d\u83dc\u5355\u4e2d\u65b0\u589e\u76f8\u5e94\u62a5\u8868\u6a21\u677f\uff0c\u6b64\u64cd\u4f5c\u4e0d\u4f1a\u5f71\u54cd\u4e1a\u52a1\u6570\u636e\u3002", (String)"SaveTemplateUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u65b0\u589e\u64cd\u4f5c\u8bf4\u660e\u8bf7\u89c1\uff1ahttps://club.kdcloud.com/article/233903797708565248\u3002", (String)"SaveTemplateUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"\u9700\u8981\u91cd\u65b0\u642d\u5efa\u7684\u62a5\u8868\u6a21\u677f\u5982\u4e0b\uff1a%s\u3002", (String)"SaveTemplateUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
    }
}

