/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;

public class SpreadDataModelUtil {
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(\\.[0-9]{1,})?)\\)?$";

    public static Object dealValue(Object val) {
        if (val instanceof String && val != null && SpreadDataModelUtil.isNotSupportExcelFormat(val.toString()) && !StringUtils.isNumeric((String)val.toString())) {
            String vdata = SpreadDataModelUtil.removeAmountSign(val.toString().trim()).trim();
            boolean isNegative = vdata.startsWith("(");
            String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
            if (!validateData.startsWith("-") && isNegative) {
                validateData = "-" + validateData;
            }
            val = new BigDecimal(validateData);
        }
        return val;
    }

    protected static boolean isNotSupportExcelFormat(String data) {
        return StringUtils.isNotEmpty((String)data) && Pattern.matches(AMOUNT_PATTERN, data.trim());
    }

    private static String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,S\\\\$,\u00a3,\u00a5]", "");
    }
}

