/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class StatusReportExportService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, StatusReportExportService.class);
    private static int MAX_ROW = 10000;
    private Map<String, IDNumberTreeNode> orgNodes = new HashMap<String, IDNumberTreeNode>(16);
    private Map<String, IDNumberTreeNode> currencyNodes = new HashMap<String, IDNumberTreeNode>(16);
    private Map<Long, IDNumberTreeNode> periodNodes = new LinkedHashMap<Long, IDNumberTreeNode>(16);
    private Map<Long, IDNumberTreeNode> yearNodes = new LinkedHashMap<Long, IDNumberTreeNode>(16);
    private long modelId;
    private long currentFyId;
    private long CurrentPeriodId;
    private long scenarioId;
    private String scenarioNum;
    private Map<String, List<String>> templateToOrgMap = new LinkedHashMap<String, List<String>>(16);
    private Map<String, Set<Long>> numberToIdMap = new HashMap<String, Set<Long>>(16);

    private void initCommonParams(Map<String, Long> map) {
        this.modelId = map.get("model");
        this.currentFyId = map.get("year");
        this.CurrentPeriodId = map.get("period");
        this.scenarioId = map.get("scenario");
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.modelId, (String)"bcm_scenemembertree", (Long)this.scenarioId);
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            this.scenarioNum = node.getNumber();
        }
    }

    public String exportStatusReport(DynamicObject[] dyos, Map<String, Long> map) throws Exception {
        this.initCommonParams(map);
        List<Long> orgIds = new ArrayList<Long>(dyos.length);
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        for (DynamicObject p : dyos) {
            long orgId;
            String orgNum = p.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportlistentity", (String)"entity.number", (DynamicObject)p));
            String templateNum = p.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportlistentity", (String)"template.number", (DynamicObject)p));
            if (Objects.isNull(this.templateToOrgMap.get(templateNum))) {
                this.templateToOrgMap.put(templateNum, new ArrayList(16));
            }
            if (!this.templateToOrgMap.get(templateNum).contains(orgNum)) {
                this.templateToOrgMap.get(templateNum).add(orgNum);
            }
            if (orgIds.contains(orgId = p.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportlistentity", (String)"entity.id", (DynamicObject)p)))) continue;
            orgIds.add(orgId);
        }
        orgIds = this.prepareOrgData(orgIds);
        LinkedHashMap<String, List<Pair<Long, String>>> numberToTempIdsMap = new LinkedHashMap<String, List<Pair<Long, String>>>(16);
        List<Long> templateIds = this.prepareTemplateData(this.templateToOrgMap.keySet(), numberToTempIdsMap);
        this.initEffectFyMembers(MemberReader.findModelNumberById((Object)this.modelId), true);
        return this.exportData(this.getReportCords(orgIds, templateIds, this.getBeforePeriodIds(), numberToTempIdsMap));
    }

    private List<Map<StatusReportHeadEnum, String>> getReportCords(List<Long> orgIds, List<Long> templateIds, List<Long> beforePeriodId, Map<String, List<Pair<Long, String>>> numberToTempIdsMap) {
        QFilter modelQf = new QFilter("model", "=", (Object)this.modelId);
        QFilter qFilter = new QFilter("scene", "=", (Object)this.scenarioId);
        qFilter.and("entity", "in", orgIds);
        qFilter.and("template", "in", templateIds);
        qFilter.and("period", "in", this.periodNodes.keySet());
        qFilter.and("fyear", "in", this.yearNodes.keySet());
        HashSet currencySet = new HashSet(16);
        this.currencyNodes.values().forEach(e -> currencySet.add(e.getId()));
        qFilter.and("currency", "in", currencySet);
        qFilter.and("reporttype", "!=", (Object)ReportType.CSTE.index);
        ArrayList<Map<StatusReportHeadEnum, String>> results = new ArrayList<Map<StatusReportHeadEnum, String>>(16);
        DynamicObjectCollection reportCords = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,fyear,period,template.number,entity,entity.number,reportstatus,currency", (QFilter[])new QFilter[]{modelQf, qFilter}, null);
        Map<String, List<DynamicObject>> map = this.filterReportCords(reportCords, beforePeriodId);
        Map template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)this.modelId, templateIds.stream().collect(Collectors.toSet()), orgIds.stream().collect(Collectors.toSet()));
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        this.templateToOrgMap.forEach((arg_0, arg_1) -> this.lambda$getReportCords$5(template2OrgMapOfDispense, beforePeriodId, map, results, numberToTempIdsMap, (Table)form2key2DTProps, arg_0, arg_1));
        return results;
    }

    private boolean isDistribute(String orgNum, String templateNum, Map<Long, Set<Long>> template2OrgMapOfDispense) {
        if (Objects.isNull(this.orgNodes.get(orgNum)) || Objects.isNull(this.numberToIdMap.get(templateNum))) {
            return false;
        }
        long orgId = this.orgNodes.get(orgNum).getId();
        for (Long id : this.numberToIdMap.get(templateNum)) {
            Set<Long> orgs = template2OrgMapOfDispense.get(id);
            if (!CollectionUtils.isNotEmpty(orgs) || !orgs.contains(orgId)) continue;
            return true;
        }
        return false;
    }

    private String getTemplateName(String templateNum, Map<String, List<Pair<Long, String>>> numberToTempIdsMap) {
        String name = "";
        List<Pair<Long, String>> list = numberToTempIdsMap.get(templateNum);
        if (CollectionUtils.isNotEmpty(list)) {
            name = (String)list.get((int)0).p2;
        }
        return name;
    }

    private String exportData(List<Map<StatusReportHeadEnum, String>> results) throws Exception {
        SXSSFCell cell;
        SXSSFWorkbook wb = new SXSSFWorkbook(MAX_ROW);
        String sheetName = ResManager.loadKDString((String)"\u72b6\u6001\u62a5\u544a", (String)"ReportListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setDefaultRowHeight((short)512);
        List<String> headList = this.getHeadList();
        block4: for (int i = 0; i < headList.size(); ++i) {
            StatusReportHeadEnum statusEnumByIndex = StatusReportHeadEnum.getStatusEnumByIndex(i);
            switch (statusEnumByIndex) {
                case ORGNAME: 
                case REPORTNAME: {
                    sheet.setColumnWidth(i, 10000);
                    continue block4;
                }
                case YEAR: 
                case PERIOD: 
                case SCENENAME: 
                case CURRENCY: 
                case STATUS: {
                    sheet.setColumnWidth(i, 4000);
                    continue block4;
                }
                default: {
                    sheet.setColumnWidth(i, 8000);
                }
            }
        }
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = wb.createFont();
        titleFont.setBold(true);
        titleFont.setFontHeightInPoints((short)17);
        titleFont.setFontName(ResManager.loadKDString((String)"\u9ed1\u4f53", (String)"StatusReportExportService_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        cellStyle.setFont(titleFont);
        CellStyle headCellStyle = wb.createCellStyle();
        headCellStyle.setAlignment(HorizontalAlignment.CENTER);
        headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font headFont = wb.createFont();
        headFont.setBold(true);
        headFont.setFontHeightInPoints((short)11);
        headFont.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"StatusReportExportService_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headCellStyle.setFont(headFont);
        CellStyle dataCellStyle = wb.createCellStyle();
        dataCellStyle.setAlignment(HorizontalAlignment.CENTER);
        dataCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font dataFont = wb.createFont();
        dataFont.setBold(false);
        dataFont.setFontHeightInPoints((short)11);
        dataFont.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"StatusReportExportService_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        dataCellStyle.setFont(dataFont);
        SXSSFRow titleRow = sheet.createRow(0);
        SXSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellStyle(cellStyle);
        titleCell.setCellValue(sheetName);
        titleCell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headList.size() - 1));
        SXSSFRow headRow = sheet.createRow(1);
        for (int i = 0; i < headList.size(); ++i) {
            cell = headRow.createCell(i);
            cell.setCellValue(headList.get(i));
            cell.setCellStyle(headCellStyle);
        }
        for (int i = 0; i < results.size(); ++i) {
            SXSSFRow row = sheet.createRow(i + 2);
            Map<StatusReportHeadEnum, String> map = results.get(i);
            if (!Objects.nonNull(map)) continue;
            for (int j = 0; j < headList.size(); ++j) {
                cell = row.createCell(j);
                cell.setCellValue(map.get((Object)StatusReportHeadEnum.getStatusEnumByIndex(j)));
                cell.setCellStyle(dataCellStyle);
            }
        }
        LocalDate now = LocalDate.now();
        String fileName = String.format(ResManager.loadKDString((String)"%1$s_%2$s_\u62a5\u8868\u72b6\u6001\u62a5\u544a_%3$s", (String)"StatusReportExportService_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MemberReader.findModelSNumberById((Object)this.modelId), MemberReader.findMemberById((long)this.modelId, (String)"bcm_scenemembertree", (Long)this.scenarioId).getNumber(), String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()));
        return this.upLoadFileTemp(fileName, wb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String upLoadFileTemp(String fileName, SXSSFWorkbook wb) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)out);
            String string = this.downloadFile(out, fileName, ".xlsx");
            return string;
        }
        catch (Exception e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            return "";
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (wb != null) {
                try {
                    try {
                        wb.dispose();
                        wb.close();
                        wb = null;
                    }
                    catch (Exception e) {
                        log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                        wb = null;
                    }
                }
                catch (Throwable throwable) {
                    wb = null;
                    throw throwable;
                }
            }
        }
    }

    public String downloadFile(ByteArrayOutputStream oo, String fileName, String suffix) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String zipUrl = cache.saveAsUrl(fileName + suffix, oo.toByteArray(), 5000);
        return zipUrl;
    }

    private List<String> getHeadList() {
        ArrayList<String> headList = new ArrayList<String>(16);
        headList.add(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"StatusReportExportService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"StatusReportExportService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"StatusReportExportService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"StatusReportExportService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u60c5\u666f", (String)"StatusReportExportService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u8d22\u5e74", (String)"StatusReportExportService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u671f\u95f4", (String)"StatusReportExportService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StatusReportExportService_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u72b6\u6001", (String)"StatusReportExportService_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return headList;
    }

    private Map<StatusReportHeadEnum, String> getSingleRow(String reportNum, String reportName, String orgNum, String orgName, String sceneName, String year, String period, String currency, String status) {
        LinkedHashMap<StatusReportHeadEnum, String> row = new LinkedHashMap<StatusReportHeadEnum, String>(16);
        row.put(StatusReportHeadEnum.REPORTNUM, reportNum);
        row.put(StatusReportHeadEnum.REPORTNAME, reportName);
        row.put(StatusReportHeadEnum.ORGNUM, orgNum);
        row.put(StatusReportHeadEnum.ORGNAME, orgName);
        row.put(StatusReportHeadEnum.SCENENAME, sceneName);
        row.put(StatusReportHeadEnum.YEAR, year);
        row.put(StatusReportHeadEnum.PERIOD, period);
        row.put(StatusReportHeadEnum.CURRENCY, currency);
        row.put(StatusReportHeadEnum.STATUS, status);
        return row;
    }

    private Map<String, List<DynamicObject>> filterReportCords(DynamicObjectCollection reportCords, List<Long> beforePeriodId) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
        if (CollectionUtils.isNotEmpty((Collection)reportCords)) {
            HashBasedTable form2key2DTProps = HashBasedTable.create();
            reportCords.forEach(arg_0 -> this.lambda$filterReportCords$6((Table)form2key2DTProps, beforePeriodId, map, arg_0));
        }
        return map;
    }

    private List<Long> prepareTemplateData(Set<String> templateNums, Map<String, List<Pair<Long, String>>> numberToTempIdsMap) {
        QFilter modelQf = new QFilter("model", "=", (Object)this.modelId);
        QFilter tempQf = new QFilter("number", "in", templateNums);
        tempQf.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        tempQf.and("usage", "=", (Object)TemplateModel.UsageEnum.WEAVE.getStatuValue());
        ArrayList<Long> templateIds = new ArrayList<Long>(templateNums.size());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,sequence", (QFilter[])new QFilter[]{modelQf, tempQf}, (String)"sequence,number,versionnumber desc");
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            dynamicObjects.forEach(arg_0 -> this.lambda$prepareTemplateData$7((Table)form2key2DTProps, templateIds, numberToTempIdsMap, arg_0));
        }
        return templateIds;
    }

    private List<Long> getBeforePeriodIds() {
        DynamicObjectCollection sceneperiod;
        ArrayList<Long> beforePeriodId = new ArrayList<Long>(16);
        QFilter modelQf = new QFilter("model", "=", (Object)this.modelId);
        QFilter scenarioQf = new QFilter("id", "=", (Object)this.scenarioId);
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_periodmembertree", (Long)this.CurrentPeriodId);
        String number = treeNode.getNumber();
        List<Object> dyos = new ArrayList<IDNumberTreeNode>(16);
        dyos.add(treeNode);
        beforePeriodId.add(treeNode.getId());
        DynamicObject e = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{modelQf, scenarioQf});
        if (Objects.nonNull(e) && CollectionUtils.isNotEmpty((Collection)(sceneperiod = e.getDynamicObjectCollection("sceneperiod")))) {
            for (DynamicObject p2 : sceneperiod) {
                long id = p2.getDynamicObject("fbasedataid").getLong("id");
                IDNumberTreeNode node2 = MemberReader.findMemberById((long)this.modelId, (String)DimEntityNumEnum.PERIOD.getEntityNum(), (Long)id);
                if (node2 == IDNumberTreeNode.NotFoundTreeNode || !node2.isLeaf() || node2.isShare()) continue;
                if (!number.equals(node2.getNumber()) && number.compareTo(node2.getNumber()) > 0) {
                    beforePeriodId.add(id);
                }
                dyos.add(node2);
            }
            dyos = dyos.stream().sorted(this.comparing(node -> node.getNumber())).collect(Collectors.toList());
            dyos.forEach(p -> this.periodNodes.put(p.getId(), (IDNumberTreeNode)p));
        }
        return beforePeriodId;
    }

    private Comparator<IDNumberTreeNode> comparing(final Function<IDNumberTreeNode, String> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new Comparator<IDNumberTreeNode>(){

            @Override
            public int compare(IDNumberTreeNode c1, IDNumberTreeNode c2) {
                return ((String)keyExtractor.apply(c2)).compareTo((String)keyExtractor.apply(c1));
            }
        };
    }

    private void initEffectFyMembers(String modelNum, boolean isBefore) {
        IDNumberTreeNode currentTreeNode = MemberReader.findMemberById((String)modelNum, (String)DimEntityNumEnum.YEAR.getEntityNum(), (Long)this.currentFyId);
        String number = currentTreeNode.getNumber();
        List<Object> dyos = new ArrayList<IDNumberTreeNode>(16);
        dyos.add(currentTreeNode);
        for (IDNumberTreeNode p : MemberReader.getAllNodeByDimNum((String)DimEntityNumEnum.YEAR.getNumber(), (String)modelNum)) {
            boolean isLessThan;
            if (!p.isLeaf() || p.isShare()) continue;
            String fyNum = p.getNumber();
            if (!number.startsWith("FY") || !fyNum.startsWith("FY") || fyNum.equals(number)) continue;
            boolean bl = isLessThan = number.compareTo(fyNum) > 0;
            if ((!isBefore || !isLessThan) && (isBefore || isLessThan)) continue;
            dyos.add(p);
        }
        if (dyos.size() != 1) {
            dyos = dyos.stream().sorted(this.comparing(e -> e.getNumber())).collect(Collectors.toList());
        }
        dyos.forEach(e -> this.yearNodes.put(e.getId(), (IDNumberTreeNode)e));
    }

    private List<Long> prepareOrgData(List<Long> orgIds) {
        ArrayList<Long> baseIds = new ArrayList<Long>(16);
        long copyFromId = 0L;
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        for (Long id : orgIds) {
            IDNumberTreeNode currencyNode;
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.modelId, (String)"bcm_entitymembertree", (Long)id);
            String currencyNum = node.getCurrency();
            if (node.isShare()) {
                copyFromId = node.getCopyfromId();
                if (copyFromId != 0L) {
                    if (!baseIds.contains(copyFromId)) {
                        baseIds.add(copyFromId);
                    }
                    IDNumberTreeNode baseNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_entitymembertree", (Long)copyFromId);
                    this.orgNodes.put(baseNode.getNumber(), baseNode);
                    currencyNum = baseNode.getCurrency();
                }
            } else {
                this.orgNodes.put(node.getNumber(), node);
                if (!baseIds.contains(id)) {
                    baseIds.add(id);
                }
            }
            if ((currencyNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.CURRENCY.getNumber(), (String)currencyNum)) == IDNumberTreeNode.NotFoundTreeNode) continue;
            this.currencyNodes.put(node.getNumber(), currencyNode);
        }
        return baseIds;
    }

    private /* synthetic */ void lambda$prepareTemplateData$7(Table form2key2DTProps, List templateIds, Map numberToTempIdsMap, DynamicObject row) {
        Long id = row.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"id", (DynamicObject)row));
        templateIds.add(id);
        String number = row.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"number", (DynamicObject)row));
        if (Objects.isNull(this.numberToIdMap.get(number))) {
            this.numberToIdMap.put(number, new HashSet(16));
        }
        this.numberToIdMap.get(number).add(id);
        if (Objects.isNull(numberToTempIdsMap.get(number))) {
            numberToTempIdsMap.put(number, Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)id, (Object)row.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"name", (DynamicObject)row)))}));
        }
    }

    private /* synthetic */ void lambda$filterReportCords$6(Table form2key2DTProps, List beforePeriodId, Map map, DynamicObject o) {
        long period = o.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"period", (DynamicObject)o));
        long fyear = o.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"fyear", (DynamicObject)o));
        long currency = o.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"currency", (DynamicObject)o));
        String orgNum = o.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"entity.number", (DynamicObject)o));
        IDNumberTreeNode currencyNode = this.currencyNodes.get(orgNum);
        if (currencyNode == IDNumberTreeNode.NotFoundTreeNode) {
            return;
        }
        if (fyear == this.currentFyId && !beforePeriodId.contains(period) || currency != currencyNode.getId()) {
            return;
        }
        String templateNum = o.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"template.number", (DynamicObject)o));
        if (Objects.isNull(this.templateToOrgMap.get(templateNum)) || !this.templateToOrgMap.get(templateNum).contains(orgNum)) {
            return;
        }
        String key = String.join((CharSequence)"|", orgNum, fyear + "", period + "", templateNum);
        if (Objects.isNull(map.get(key))) {
            map.put(key, new ArrayList(16));
        }
        ((List)map.get(key)).add(o);
    }

    private /* synthetic */ void lambda$getReportCords$5(Map template2OrgMapOfDispense, List beforePeriodId, Map map, List results, Map numberToTempIdsMap, Table form2key2DTProps, String k, List v) {
        v.forEach(orgNum -> {
            boolean isExitDis = this.isDistribute((String)orgNum, k, template2OrgMapOfDispense);
            IDNumberTreeNode currencyNode = this.currencyNodes.get(orgNum);
            this.yearNodes.forEach((yearId, yearNode) -> this.periodNodes.forEach((periodId, periodNode) -> {
                if (this.currentFyId == yearId && !beforePeriodId.contains(periodId)) {
                    return;
                }
                String key = String.join((CharSequence)"|", orgNum, yearId + "", periodId + "", k);
                if (Objects.nonNull(map.get(key))) {
                    ((List)map.get(key)).forEach(o -> results.add(this.getSingleRow(k, this.getTemplateName(k, numberToTempIdsMap), (String)orgNum, this.orgNodes.get(orgNum).getName(), this.scenarioNum, yearNode.getName(), periodNode.getName(), currencyNode.getName(), ReportStatusEnum.getStatusEnumBy((String)o.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_reportentity", (String)"reportstatus", (DynamicObject)o))).text())));
                } else if (isExitDis) {
                    results.add(this.getSingleRow(k, this.getTemplateName(k, numberToTempIdsMap), (String)orgNum, this.orgNodes.get(orgNum).getName(), this.scenarioNum, yearNode.getName(), periodNode.getName(), currencyNode.getName(), ReportStatusEnum.UNWEAVE.text()));
                }
            }));
        });
    }

    static enum StatusReportHeadEnum {
        REPORTNUM(0),
        REPORTNAME(1),
        ORGNUM(2),
        ORGNAME(3),
        SCENENAME(4),
        YEAR(5),
        PERIOD(6),
        CURRENCY(7),
        STATUS(8);

        private int index;

        private StatusReportHeadEnum(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static StatusReportHeadEnum getStatusEnumByIndex(int index) {
            for (StatusReportHeadEnum reportHeadEnum : StatusReportHeadEnum.values()) {
                if (reportHeadEnum.getIndex() != index) continue;
                return reportHeadEnum;
            }
            throw new KDBizException("error StatusReportHeadEnum index: " + index);
        }
    }
}

