/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.util.POIUtil;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class TemplateExportPlugin {
    public static String TC_SIGN = "TemplateCode";
    public static String TN_SIGN = "TemplateName";
    public static String V_SIGN = "Version";
    public static String F_SIGN = "Formulas";
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, TemplateExportPlugin.class);
    TempFileCache cache;
    private String fileName;
    private long modelId;
    Map<Object, Short> stylesByWB = new HashMap<Object, Short>(16);

    public String export(String formId, Object[] pkids, String filename, boolean isExportFormula) throws IOException {
        String jsonString;
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)formId).getDynamicObjectType();
        if (isExportFormula) {
            jsonString = this.getFormulasJson(pkids, type);
        } else {
            TemplateModel[] tempalteModels = this.loadTemplatesById(pkids, type);
            jsonString = ObjectSerialUtil.toByteSerialized((Object)tempalteModels);
        }
        String fileName = this.getFileName(filename, isExportFormula);
        return this.createJsonFile(jsonString, fileName);
    }

    public String exportFormulas(TemplateModel template, String filename, SpreadManager orgDataSm) throws Exception {
        Map<String, Object> singleTemplateFormuls = this.getSingleTemplateFormuls(template, orgDataSm);
        String fileName = this.getFileName(filename, true);
        return this.createJsonFile(this.paseYaml(Collections.singletonList(singleTemplateFormuls)), fileName);
    }

    private Map<String, Object> getSingleTemplateFormuls(TemplateModel template, SpreadManager orgDataSm) {
        LinkedHashMap<String, Object> formulas = new LinkedHashMap<String, Object>(16);
        formulas.put(TC_SIGN, template.getNumber());
        formulas.put(TN_SIGN, template.getName());
        BigDecimal versionNumber = template.getVersionNumber();
        String version = "V1.0";
        if (versionNumber != null) {
            version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
        }
        formulas.put(V_SIGN, version);
        formulas.put(F_SIGN, this.getFormulasMap(orgDataSm != null ? orgDataSm : JsonSerializerUtil.toSpreadManager((String)template.getData())));
        return formulas;
    }

    private String getFormulasJson(Object[] templateIds, DynamicObjectType type) {
        ArrayList formualJson = new ArrayList(16);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)type.getName(), (String)"id,number,name,versionnumber,data", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray());
        for (DynamicObject template : templates) {
            String data = template.getString("data");
            if (!StringUtils.isNotEmpty((String)data)) continue;
            LinkedHashMap<String, Object> formulas = new LinkedHashMap<String, Object>(16);
            formulas.put(TC_SIGN, template.getString("number"));
            formulas.put(TN_SIGN, template.getString("name"));
            BigDecimal versionNumber = (BigDecimal)template.get("versionnumber");
            String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
            formulas.put(V_SIGN, version);
            formulas.put(F_SIGN, this.getFormulasMap(JsonSerializerUtil.toSpreadManager((String)data)));
            formualJson.add(formulas);
        }
        return this.paseYaml(formualJson);
    }

    private String paseYaml(Object obj) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        Yaml yaml = new Yaml(options);
        return yaml.dump(obj);
    }

    private Map<String, String> getFormulasMap(SpreadManager sm) {
        LinkedHashMap<String, String> formulaMap = new LinkedHashMap<String, String>(16);
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            String formula = cell.getFormula();
            if (StringUtils.isNotEmpty((String)formula)) {
                formulaMap.put(ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), formula);
            }
        });
        return formulaMap;
    }

    private TemplateModel[] loadTemplatesById(Object[] templateIds, DynamicObjectType type) {
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])templateIds, (DynamicObjectType)type);
        TemplateModel[] tempalteModels = new TemplateModel[templateIds.length];
        for (int i = 0; i < templates.length; ++i) {
            TemplateModel template = new TemplateModel();
            template.loadDynaObj2Model(templates[i]);
            tempalteModels[i] = template;
        }
        return tempalteModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createJsonFile(String jsonString, String fileName) throws IOException {
        try (ByteArrayInputStream inStream = null;){
            inStream = new ByteArrayInputStream(jsonString.getBytes(Charset.forName("UTF-8")));
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
    }

    private String getFileName(String filename, boolean isExportFormula) {
        String fileName = filename;
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()) + (isExportFormula ? ".yaml" : ".json");
        return fileName;
    }

    public String export(DynamicObject dyna) throws IOException {
        String fileName = dyna.getString("template.number") + "_" + dyna.getString("template.name") + "_" + dyna.getString("template.versionnumber");
        String jsonString = dyna.getString("reportdetails");
        ByteArrayInputStream inStream = new ByteArrayInputStream(jsonString.getBytes());
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return tempFileCache.saveAsUrl(fileName + ".txt", (InputStream)inStream, 100);
    }

    public String exportFailLog(String errorDetail, String fileName) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(errorDetail.getBytes());
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return tempFileCache.saveAsUrl(fileName + ".log", (InputStream)inStream, 100);
    }

    public String getTimeStamp() {
        LocalDate now = LocalDate.now();
        return String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth());
    }

    public String exportMemCombin(List<DynamicObject> dynamicObjects) throws Exception {
        log.startWatch();
        log.info(ResManager.loadKDString((String)"\u6210\u5458\u7ec4\u5408\u5bfc\u51fa\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4--->", (String)"TemplateExportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        this.fileName = this.getFileName();
        SXSSFWorkbook allSheetBook = new SXSSFWorkbook(10000);
        XSSFWorkbook xssfWorkbook = null;
        String url = "";
        this.modelId = dynamicObjects.get(0).getLong("model");
        try {
            for (DynamicObject obj : dynamicObjects) {
                String ssjson = JsonSerializerUtil.uncompress((String)obj.getString("rptspreadjson"));
                ByteArrayOutputStream spreadJsonOut = null;
                int freeRow = 0;
                int freecol = 0;
                JSONArray columns = new JSONArray();
                try {
                    try {
                        JSONObject jsonMap = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
                        boolean isChange = false;
                        JSONObject sheetObj = DataAndJsonTranslator.getSheetInfo((JSONObject)jsonMap);
                        if (sheetObj.containsKey((Object)"rowFilter")) {
                            isChange = true;
                            sheetObj.remove((Object)"rowFilter");
                        }
                        if (sheetObj != null) {
                            columns = sheetObj.getJSONArray("columns");
                        }
                        try {
                            Workbook gcbook = SpreadUtils.getWorkbook((String)(isChange ? jsonMap.toString() : ssjson));
                            freeRow = gcbook.getActiveSheet().getFreezeRow();
                            freecol = gcbook.getActiveSheet().getFreezeColumn();
                            spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                        }
                        catch (IllegalArgumentException e) {
                            DataAndJsonTranslator.getSheetInfo((JSONObject)jsonMap).remove((Object)"printInfo");
                            Workbook gcbook = SpreadUtils.getWorkbook((String)jsonMap.toString());
                            freeRow = gcbook.getActiveSheet().getFreezeRow();
                            freecol = gcbook.getActiveSheet().getFreezeColumn();
                            spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warn(obj.getString("number") + ":" + obj.getString("name") + ":Style conversion is not supported" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                    }
                    if (spreadJsonOut == null) continue;
                    String sheetName = this.getSheetName(obj.getString("number"), obj.getBigDecimal("versionnumber"));
                    String pdfURL = this.cache.saveAsUrl(sheetName + "." + XSSFWorkbookType.XLSX.getExtension(), spreadJsonOut.toByteArray(), 1000);
                    xssfWorkbook = new XSSFWorkbook(this.cache.getInputStream(pdfURL));
                    xssfWorkbook.setForceFormulaRecalculation(false);
                    XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
                    if (columns != null && !columns.isEmpty()) {
                        for (int i = 0; i < columns.size(); ++i) {
                            if (columns.getJSONObject(i) == null || columns.getJSONObject(i).get((Object)"size") == null) continue;
                            int size = Double.valueOf(columns.getJSONObject(i).get((Object)"size").toString()).intValue();
                            sheet.autoSizeColumn(i);
                            sheet.setColumnWidth(i, size * 35);
                        }
                    }
                    sheet.createFreezePane(freecol, freeRow);
                    SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)obj.getString("rptdata"));
                    int maxColumnCount = sm.getBook().getSheet(0).getMaxColumnCount();
                    for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                        if (sheet.getRow(i) != null) continue;
                        XSSFRow row = sheet.createRow(i);
                        for (int c = 0; c < maxColumnCount; ++c) {
                            row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                        }
                    }
                    this.setCrossMemberInfos(xssfWorkbook, this.getCrossMemberInfos(this.modelId, sm));
                    this.writeJson(xssfWorkbook, allSheetBook, this.getSheetInfo(sm, sheetName));
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    try {
                        if (spreadJsonOut != null) {
                            spreadJsonOut.close();
                        }
                        if (xssfWorkbook == null) continue;
                        xssfWorkbook.close();
                    }
                    catch (IOException e) {
                        log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                    }
                }
            }
            url = this.upLoadFileTemp(this.fileName, allSheetBook);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (allSheetBook != null) {
                    allSheetBook.close();
                    allSheetBook.dispose();
                }
            }
            catch (IOException e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        log.infoEnd(ResManager.loadKDString((String)"\u6210\u5458\u7ec4\u5408\u5bfc\u51fa\u7ed3\u675f\uff0c\u6267\u884c\u8017\u65f6--->", (String)"TemplateExportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return url;
    }

    private SheetInfo getSheetInfo(SpreadManager sm, String sheetName) {
        SheetInfo sheetInfo = new SheetInfo(0, sheetName, this.fileName);
        sheetInfo.setMaxRow(sm.getBook().getSheet(0).getMaxRowCount());
        sheetInfo.setMaxCol(sm.getBook().getSheet(0).getMaxColumnCount());
        return sheetInfo;
    }

    private String upLoadFileTemp(String fileName, SXSSFWorkbook wb) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String zipUrl = "";
        try {
            wb.write((OutputStream)out);
            String key = fileName + "." + XSSFWorkbookType.XLSX.getExtension();
            zipUrl = this.cache.saveAsUrl(key, out.toByteArray(), 5000);
        }
        catch (Exception e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (wb != null) {
                    wb.dispose();
                    wb.close();
                }
            }
            catch (IOException e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        return zipUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJson(XSSFWorkbook workbook, SXSSFWorkbook allSheetBook, SheetInfo sheetInfo) {
        XSSFSheet sheet = workbook.getSheetAt(0);
        XSSFSheet newSheet = allSheetBook.getXSSFWorkbook().createSheet(sheetInfo.getSheetName());
        newSheet.setForceFormulaRecalculation(false);
        POIUtil.copySheet(allSheetBook.getXSSFWorkbook(), sheet, newSheet, sheetInfo, this.stylesByWB);
        if (workbook != null) {
            try {
                workbook.close();
            }
            catch (IOException e) {
                log.warn(String.format(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25%s", (String)"TemplateExportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
            }
            finally {
                workbook = null;
            }
        }
    }

    private void setCrossMemberInfos(XSSFWorkbook workbook, List<Map<String, Object>> values) {
        XSSFSheet sheet = workbook.getSheetAt(0);
        if (sheet == null || CollectionUtils.isEmpty(values)) {
            return;
        }
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        if (CollectionUtils.isNotEmpty(values)) {
            for (Map<String, Object> value : values) {
                Object v;
                int r = (Integer)value.get("r");
                int c = (Integer)value.get("c");
                XSSFRow row = sheet.getRow(r);
                if (row == null) {
                    row = sheet.createRow(r);
                }
                XSSFCell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                if (value.containsKey(SpreadProperties.SetFormulaMethod.F.k())) {
                    cell.removeFormula();
                }
                cell.setCellValue((v = value.get("v")) != null ? v.toString() : null);
                XSSFCellStyle style = cell.getCellStyle();
                if (style != null) {
                    style.setAlignment(HorizontalAlignment.LEFT);
                    continue;
                }
                cell.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private List<Map<String, Object>> getCrossMemberInfos(long modelId, SpreadManager sm) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(16);
        HashSet rangeModels = new HashSet(16);
        sm.getAreaManager().forEach(e -> rangeModels.add(new RangeModel(((PositionInfo)e.getKey()).getAreaRange())));
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            Map<Object, Object> valMap = new HashMap();
            Object val = null;
            boolean isNeedClear = false;
            if (rangeModels.stream().anyMatch(e -> e.checkIsInArea(cell))) {
                if (cell.isMdDataDomain()) {
                    if (((Boolean)cell.getUserObject("not_cross", (Object)false)).booleanValue()) {
                        val = cell.getUserObject("cross_name", (Object)ResManager.loadKDString((String)"\u7ec4\u5408\u540d\u79f0\u672a\u627e\u5230\u3002", (String)"TemplateExportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    } else {
                        String message = TemplateUtil.getMemberMessage(modelId, cell);
                        if (message != null) {
                            val = message;
                        }
                    }
                    isNeedClear = true;
                } else if (cell.getVariant() != null && !cell.getVariant().isEmpty()) {
                    isNeedClear = true;
                }
            }
            if (isNeedClear) {
                valMap = SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), val);
            }
            if (cell.hasFormula()) {
                if (valMap.isEmpty()) {
                    valMap = SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), val);
                }
                valMap.put(SpreadProperties.SetFormulaMethod.F.k(), "");
            }
            if (!valMap.isEmpty()) {
                values.add(valMap);
            }
        });
        return values;
    }

    private String getSheetName(String name, BigDecimal versionNumber) {
        name = NewReportMultiExportService.createSafeSheetName(name, '_');
        String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
        return String.format("%s %s", name, version);
    }

    private String getFileName() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.fileName)) {
            return this.fileName;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        return String.format(ResManager.loadKDString((String)"\u62a5\u8868\u6210\u5458\u7ec4\u5408_%s", (String)"TemplateExportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), timeStamp);
    }
}

