/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;

public class TemplateExtDataAreaUtil {
    public static boolean isAddPosForMemView(PositionInfo ps, SpreadManager sm) {
        if (sm.getAreaManager().getPostionInfoSet().isEmpty()) {
            return true;
        }
        PositionInfo oldPs = sm.getAreaManager().searchStorePositionInfo(ps);
        if (oldPs == null) {
            return true;
        }
        if (oldPs != null && oldPs.getExtendInfo() == null) {
            return true;
        }
        return ps.getExtendInfo() != null && TemplateExtDataAreaUtil.isChangeForColSeq(oldPs.getExtendInfo().getCols(true), ps.getExtendInfo().getCols(true));
    }

    public static boolean isChangeForColSeq(List<String> cols, List<String> selectFields) {
        if (cols.size() != selectFields.size()) {
            return true;
        }
        for (int i = 0; i < cols.size(); ++i) {
            if (cols.get(i).equals(selectFields.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean adjustExtendColChange(SpreadManager sm, boolean isChange) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (sm != null && !sm.getAreaManager().getPostionInfoSet().isEmpty()) {
            sm.getAreaManager().getPostionInfoSet().forEach(ps -> {
                ExtendInfo extendInfo = ps.getExtendInfo();
                if (extendInfo != null) {
                    extendInfo.setColChange(isChange);
                    flag.set(true);
                }
            });
        }
        return flag.get();
    }

    public static boolean updateOldExtPos(Set<PositionInfo> positionInfoSet, SpreadManager sm) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (!positionInfoSet.isEmpty()) {
            sm.getAreaManager().getPostionInfoSet().forEach(ps -> {
                if (ps.getExtendInfo() != null && positionInfoSet.stream().anyMatch(e -> e.equals(ps))) {
                    ps.getExtendInfo().setColChange(true);
                    flag.set(true);
                }
            });
        }
        return flag.get();
    }

    public static Tuple<List<Map<String, Object>>, List<Map<String, Object>>, List<Map<String, Object>>> markExtDataAreaCells(Set<PositionInfo> positionInfos, SpreadManager newspread, boolean mark, long modelId, boolean isFromTemplate) {
        ArrayList cellValues = new ArrayList(16);
        ArrayList formulas = new ArrayList(16);
        ArrayList markRedPoints = new ArrayList(16);
        if (!positionInfos.isEmpty()) {
            Map<String, Map<String, String>> extModelMap = TemplateExtDataAreaUtil.getExtModelMap(positionInfos, modelId);
            positionInfos.forEach(ps -> {
                if (ps.getExtendInfo() != null) {
                    Tuple<List<Map<String, Object>>, List<Map<String, Object>>, List<Map<String, Object>>> listTuple = TemplateExtDataAreaUtil.markSingleExtDataAreaCells(ps, newspread, mark, extModelMap, isFromTemplate, modelId);
                    formulas.addAll((Collection)listTuple.p1);
                    cellValues.addAll((Collection)listTuple.p2);
                    markRedPoints.addAll((Collection)listTuple.p3);
                }
            });
        }
        return Tuple.create(formulas, cellValues, markRedPoints);
    }

    private static Tuple<List<Map<String, Object>>, List<Map<String, Object>>, List<Map<String, Object>>> markSingleExtDataAreaCells(PositionInfo ps, SpreadManager newspread, boolean mark, Map<String, Map<String, String>> extModelMap, boolean isFromTemplate, long modelId) {
        ArrayList cellValues = new ArrayList(16);
        ArrayList formulas = new ArrayList(16);
        ArrayList<Map<String, Object>> markRedPoints = new ArrayList<Map<String, Object>>(16);
        ExtendInfo extendInfo = ps.getExtendInfo();
        if (extendInfo != null) {
            Sheet sheet = newspread.getBook().getSheet(0);
            String areaRange = ps.getAreaRange();
            RangeModel rangeModel = new RangeModel(areaRange);
            List cols = extendInfo.getCols(true);
            RangeModel extHeadModel = new RangeModel(rangeModel.getX_start(), rangeModel.getX_end(), rangeModel.getY_start() - 1, rangeModel.getY_start() - 1);
            if (isFromTemplate && extHeadModel.getY_start() >= 0 && extendInfo.isColChange()) {
                if (mark) {
                    Map<String, String> map = TemplateExtDataAreaUtil.getExtModelForNumber(extendInfo.getExtModelNumber(), extModelMap);
                    map.put(DimTypesEnum.ENTITY.getNumber(), TemplateUtil.getDimName((Long)modelId, (String)DimTypesEnum.ENTITY.getNumber()));
                    AtomicInteger index = new AtomicInteger(0);
                    sheet.iteratorRangeCells(extHeadModel, true, cell -> {
                        String key = (String)cols.get(index.get());
                        index.getAndIncrement();
                        String value = (String)map.get(key);
                        cell.setValue((Object)value);
                        cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), value));
                        if (cell.hasFormula()) {
                            cell.setFormula(null);
                            formulas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                        }
                        cell.setUserObject("ext_col", (Object)key);
                    });
                    sheet.iteratorRangeCells(rangeModel, true, cell -> {
                        if (cell.getValue() != null) {
                            cell.setValue(null);
                            cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                        }
                        if (cell.hasFormula()) {
                            cell.setFormula(null);
                            formulas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                        }
                    });
                } else {
                    sheet.iteratorRangeCells(extHeadModel, true, cell -> {
                        cell.removeUserObject("ext_col");
                        cell.setValue(null);
                        cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                        if (cell.hasFormula()) {
                            cell.setFormula(null);
                            formulas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), null));
                        }
                    });
                }
            }
            markRedPoints.addAll(TemplateExtDataAreaUtil.getRedMarkPointParms(rangeModel, mark));
        }
        return Tuple.create(formulas, cellValues, markRedPoints);
    }

    private static Map<String, Map<String, String>> getExtModelMap(Set<PositionInfo> positionInfoSet, Long modelId) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        HashSet extModelNumbers = new HashSet();
        positionInfoSet.forEach(ps -> {
            ExtendInfo extendInfo = ps.getExtendInfo();
            if (extendInfo != null) {
                extModelNumbers.add(extendInfo.getExtModelNumber());
            }
        });
        if (!extModelNumbers.isEmpty()) {
            QFilter qFilter = new QFilter("number", "in", extModelNumbers);
            qFilter.and("model", "=", (Object)modelId);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])qFilter.toArray());
            if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                dynamicObjects.forEach(dyo -> {
                    HashMap fieldMap = new HashMap(16);
                    ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(Long.valueOf(dyo.getLong("id")));
                    List dimFieldEntryList = extendsModel.getDimFieldEntry();
                    dimFieldEntryList.forEach(dimFieldEntry -> fieldMap.put(dimFieldEntry.getDimension().getNumber(), dimFieldEntry.getDimension().getName()));
                    List extFieldEntrys = extendsModel.getExtFieldEntry();
                    extFieldEntrys.forEach(extFieldEntry -> fieldMap.put(extFieldEntry.getExtField().getNumber(), extFieldEntry.getExtField().getName()));
                    map.put(dyo.getString("number"), fieldMap);
                });
            }
        }
        return map;
    }

    private static Map<String, String> getExtModelForNumber(String extModelNumber, Map<String, Map<String, String>> extModelMap) {
        Map<String, String> map = new HashMap<String, String>(16);
        if (extModelMap.get(extModelNumber) != null) {
            map = extModelMap.get(extModelNumber);
        }
        return map;
    }

    public static List<Map<String, Object>> getRedMarkPointParms(RangeModel rangeModel, boolean mark) {
        ArrayList<Map<String, Object>> markRedPoints = new ArrayList<Map<String, Object>>(16);
        markRedPoints.add(TemplateExtDataAreaUtil.packedCellMap(rangeModel.getY_start(), rangeModel.getX_start(), mark, 0));
        markRedPoints.add(TemplateExtDataAreaUtil.packedCellMap(rangeModel.getY_end(), rangeModel.getX_end(), mark, 2));
        return markRedPoints;
    }

    public static Map<String, Object> packedCellMap(int r, int c, boolean isNeedMark, int index) {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put("r", r);
        features.put("c", c);
        features.put("st", isNeedMark);
        features.put("pos", Lists.newArrayList((Object[])new Integer[]{index}));
        return features;
    }

    public static Map<String, Object> packedCellMap4AllPoint(int r, int c, boolean isNeedMark) {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put("r", r);
        features.put("c", c);
        features.put("st", isNeedMark);
        features.put("pos", Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3}));
        return features;
    }
}

