/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateUsageEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.spread.datacollect.FormulaCheckModel;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class TemplateExtendModelRefUtil {
    private static final String KEY_MODEL = "model";
    private static final String KEY_EXTMODEL = "extmodel";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_USAGE = "usage";
    private static final String KEY_ISONLYREAD = "isonlyread";
    private static final String KEY_STATUS = "status";
    private static final List<String> extTemplateNeedDim = Arrays.asList("Scenario", "Year", "Period", "Entity", "Currency", "Process", "AuditTrail");

    public static List<Long> batchCheckBeforeSave(List<TemplateModel> templateModelList, OperationResult operationResult, Long modelId) {
        Map<String, Set<String>> allExtModelRef = TemplateExtendModelRefUtil.getALLExtModelRef(modelId, true);
        ArrayList<Long> failList = new ArrayList<Long>(16);
        for (TemplateModel template : templateModelList) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u7684\u62a5\u8868\u6a21\u677f\u65e0\u6cd5\u542f\u7528\u3002", (String)"TemplateListPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getNumber());
            try {
                TemplateExtendModelRefUtil.singleCheckBeforeSave(template, null, errorMessage, allExtModelRef, operationResult);
            }
            catch (KDBizException e) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(e.getMessage());
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
                failList.add(template.getId());
            }
        }
        return failList;
    }

    public static void singleCheckBeforeSave(TemplateModel template, SpreadManager sm, String errorMessage, Map<String, Set<String>> allExtModelRef, OperationResult operationResult) {
        if (template.isSaveByDim()) {
            Set postionInfoSet;
            boolean isFromEnable;
            Long modelId = template.getModelId();
            boolean isFromSave = sm != null;
            boolean bl = isFromEnable = operationResult != null;
            if (sm == null) {
                sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
            }
            if (!(postionInfoSet = sm.getAreaManager().getPostionInfoSet()).isEmpty()) {
                HashMap<String, List<ExtendInfo>> extendInfoMap = new HashMap<String, List<ExtendInfo>>(16);
                Set<Object> exceptSet = new HashSet(16);
                if (postionInfoSet.stream().anyMatch(ps -> ps.getExtendInfo() != null)) {
                    String mesg;
                    Map<String, Long> allExtendDataModel = TemplateExtendModelRefUtil.getAllExtendDataModel(modelId);
                    Map<String, Long> intrExtDataModelRef = TemplateExtendModelRefUtil.getIntrExtDataModelRef(modelId);
                    TemplateExtendModelRefUtil.isExtTemplateCheckDimension(template, errorMessage);
                    Map<Long, ExtendsModel> extendsModelMap = TemplateExtendModelRefUtil.batchGetExtendsModels(allExtendDataModel.values().stream().collect(Collectors.toSet()));
                    if (isFromSave) {
                        Map<String, Long> extModelRef;
                        HashSet<String> numberList = new HashSet<String>(16);
                        numberList.add(template.getNumber());
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template.getId())});
                        if (dynamicObject != null) {
                            numberList.add(dynamicObject.getString("number"));
                        }
                        if (!(extModelRef = TemplateExtendModelRefUtil.getExtModelRef(modelId, numberList)).isEmpty()) {
                            exceptSet = extModelRef.keySet();
                        }
                    } else if (isFromEnable) {
                        exceptSet = TemplateExtendModelRefUtil.getExceptExtendDataModel(allExtModelRef, template.getNumber());
                    }
                    boolean isOnlyReadOrQueryTm = TemplateExtendModelRefUtil.isOnlyReadOrQueryTm(template);
                    boolean isCheckExt = !isOnlyReadOrQueryTm && (isFromEnable || isFromSave && TemplateModel.TplStatus.ENABLE == template.getStatus());
                    HashSet<String> extModelNumbers = new HashSet<String>(16);
                    for (PositionInfo ps2 : postionInfoSet) {
                        ExtendInfo extendInfo = ps2.getExtendInfo();
                        if (extendInfo == null) continue;
                        String number = extendInfo.getExtModelNumber();
                        if (!allExtendDataModel.containsKey(number)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b%1$s\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c%2$s\u3002", (String)"TemplateExtendModelRefUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, errorMessage));
                        }
                        if (isCheckExt) {
                            if (exceptSet.contains(number)) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df%1$s\u5df2\u7ecf\u88ab\u5176\u4ed6\u6a21\u677f\u5f15\u7528\uff0c%2$s\u3002", (String)"TemplateExtendModelRefUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, errorMessage));
                            }
                            if (intrExtDataModelRef.containsKey(number)) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u6a21\u578b%1$s\u5df2\u7ecf\u88ab\u5176\u4ed6\u4ea4\u6613\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\u4e86\uff0c%2$s", (String)"TemplateExtendModelRefUtil_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, errorMessage));
                            }
                        }
                        extModelNumbers.add(number);
                        extendInfoMap.computeIfAbsent(number, k -> new ArrayList()).add(extendInfo);
                        TemplateExtendModelRefUtil.checkColField(extendInfo, errorMessage, !isOnlyReadOrQueryTm, extendsModelMap.get(allExtendDataModel.get(number)));
                    }
                    if (isFromEnable && !extModelNumbers.isEmpty()) {
                        allExtModelRef.put(template.getNumber(), extModelNumbers);
                    }
                    if (!isOnlyReadOrQueryTm && StringUtils.isNotEmpty((String)(mesg = TemplateExtendModelRefUtil.isAllowRepeatExtDataModel(extendInfoMap, errorMessage)))) {
                        throw new KDBizException(mesg);
                    }
                }
            }
        }
    }

    public static void checkRepeatExtDataModel(SpreadManager sm, PositionInfo ps, List<String> cols, String extNum) {
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        if (postionInfoSet.isEmpty()) {
            return;
        }
        for (PositionInfo posInfo : postionInfoSet) {
            ExtendInfo extendInfo = posInfo.getExtendInfo();
            if (extendInfo == null || ps != null && ps.getAreaRange().equals(posInfo.getAreaRange()) || !extendInfo.getExtModelNumber().equals(extNum)) continue;
            List selCols = extendInfo.getCols(true);
            if (selCols.size() == cols.size() && selCols.containsAll(cols)) break;
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u62d3\u5c55\u6570\u636e\u6a21\u578b\u8bbe\u7f6e\u591a\u4e2a\u62d3\u5c55\u6570\u636e\u533a\u57df\u65f6\uff0c\u8981\u6c42\u5fc5\u987b\u5305\u542b\u76f8\u540c\u7684\u5b57\u6bb5\u3002", (String)"TemplateExtendModelRefUtil_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private static String isAllowRepeatExtDataModel(Map<String, List<ExtendInfo>> extendInfoMap, String errorMessage) {
        if (extendInfoMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, List<ExtendInfo>> e : extendInfoMap.entrySet()) {
            List<ExtendInfo> extendInfos = e.getValue();
            if (extendInfos.size() <= 1) continue;
            ExtendInfo extendInfo = extendInfos.get(0);
            List cols = extendInfo.getCols(true);
            for (ExtendInfo k : extendInfos) {
                if (k == extendInfo || k.getCols(true).size() == cols.size() && k.getCols(true).containsAll(cols)) continue;
                if (StringUtils.isNotEmpty((String)errorMessage)) {
                    return String.format(ResManager.loadKDString((String)"\u540c\u4e00\u62d3\u5c55\u6570\u636e\u6a21\u578b\u8bbe\u7f6e\u591a\u4e2a\u62d3\u5c55\u6570\u636e\u533a\u57df\u65f6\uff0c\u8981\u6c42\u5fc5\u987b\u5305\u542b\u76f8\u540c\u7684\u5b57\u6bb5\uff0c%s", (String)"TemplateExtendModelRefUtil_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), errorMessage);
                }
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b%s\u88ab\u5f53\u524d\u6a21\u677f\u7684\u591a\u4e2a\u533a\u57df\u4f7f\u7528\u65f6\uff0c\u8981\u6c42\u5fc5\u987b\u5305\u542b\u76f8\u540c\u7684\u5b57\u6bb5\u3002", (String)"TemplateExtendModelRefUtil_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extendInfo.getExtModelNumber());
            }
        }
        return null;
    }

    public static Set<String> getExceptExtendDataModel(Map<String, Set<String>> allExtModelRef, String number) {
        HashSet<String> exceptSet = new HashSet<String>(16);
        if (!allExtModelRef.isEmpty()) {
            allExtModelRef.values().forEach(sets -> exceptSet.addAll((Collection<String>)sets));
            Set<String> set = allExtModelRef.get(number);
            if (set != null) {
                exceptSet.removeAll(set);
            }
        }
        return exceptSet;
    }

    public static void checkBeforeSave(SpreadManager sm, TemplateModel template, String errorMessage) {
        TemplateExtendModelRefUtil.singleCheckBeforeSave(template, sm, errorMessage, new HashMap<String, Set<String>>(), null);
    }

    private static void checkColField(ExtendInfo extendInfo, String errorMessage, boolean isForWeave, ExtendsModel extendsModel) {
        HashSet dimNumberSet = new HashSet(16);
        HashSet extColFieldNumbers = new HashSet(16);
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashMap<String, DynaEntityObject> obj = new HashMap<String, DynaEntityObject>(16);
        if (extendInfo != null) {
            List<String> notExitCol;
            extendsModel.getExtFieldEntry().forEach(extFieldEntry -> {
                extColFieldNumbers.add(extFieldEntry.getExtField().getNumber());
                map.put(extFieldEntry.getExtField().getNumber(), extFieldEntry.getExtField().getName());
                obj.put(extFieldEntry.getExtField().getNumber(), (DynaEntityObject)extFieldEntry);
            });
            extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> {
                dimNumberSet.add(dimFieldEntry.getDimension().getNumber());
                map.put(dimFieldEntry.getDimension().getNumber(), dimFieldEntry.getDimension().getName());
                obj.put(dimFieldEntry.getDimension().getNumber(), (DynaEntityObject)dimFieldEntry);
            });
            List<Object> mustInputColField = new ArrayList(16);
            if (isForWeave) {
                mustInputColField = TemplateExtendModelRefUtil.getMustInputColField(extendsModel);
            }
            List cols = extendInfo.getCols(false);
            List floatDimNums = extendInfo.getFloatDimNums();
            List<String> notExitDimNumber = floatDimNums.stream().filter(floatNumber -> !dimNumberSet.contains(floatNumber)).collect(Collectors.toList());
            if (!notExitDimNumber.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u591a\u7ef4\u5b57\u6bb5\u201c%1$s\u201d\u5728\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201c%2$s\u201d\u4e2d\u4e0d\u5b58\u5728\uff0c%3$s\u3002", (String)"TemplateExtendModelRefUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, notExitDimNumber), extendInfo.getExtModelNumber(), errorMessage));
            }
            if (!mustInputColField.isEmpty() && !(mustInputColField = mustInputColField.stream().filter(col -> !extendInfo.getCols(false).contains(col)).collect(Collectors.toList())).isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u552f\u4e00\u6216\u5fc5\u5f55\u6027\u5b57\u6bb5\u201c%1$s\u201d\u7f3a\u5931\uff1a%2$s\u3002", (String)"TemplateExtendModelRefUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, mustInputColField), errorMessage));
            }
            if (!(cols = cols.stream().filter(colNumber -> !floatDimNums.contains(colNumber)).collect(Collectors.toList())).isEmpty() && !(notExitCol = cols.stream().filter(colNumber -> !extColFieldNumbers.contains(colNumber)).collect(Collectors.toList())).isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u591a\u7ef4\u5b57\u6bb5\u201c%1$s\u201d\u5728\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201c%2$s\u201d\u4e2d\u4e0d\u5b58\u5728\uff0c%3$s\u3002", (String)"TemplateExtendModelRefUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, notExitCol), extendInfo.getExtModelNumber(), errorMessage));
            }
            TemplateExtendModelRefUtil.checkMinCols(obj, extendInfo.getCols(true));
        }
    }

    public static String showNumberAndNameFromMap(Map<String, String> map, List<String> cols) {
        StringBuilder sb = new StringBuilder();
        if (!cols.isEmpty()) {
            sb.append("\u3010");
            cols.forEach(e -> {
                sb.append((String)e);
                if (map.get(e) != null) {
                    sb.append('|');
                    sb.append((String)map.get(e));
                }
                sb.append('\uff0c');
            });
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\u3011");
        }
        return sb.toString();
    }

    public static Map<String, Long> getAllExtendDataModel(Long modelId) {
        return (Map)ThreadCache.get((Object)("getAllExtendDataModel" + modelId), () -> {
            QFilter modelQFilter = new QFilter(KEY_MODEL, "=", (Object)modelId);
            HashMap map = new HashMap(16);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])modelQFilter.toArray());
            if (!dynamicObjects.isEmpty()) {
                dynamicObjects.forEach(dyo -> map.put(dyo.getString("number"), dyo.getLong("id")));
            }
            return map;
        });
    }

    public static void isExtTemplateCheckDimension(TemplateModel template, String errorMessage) {
        ArrayList dimIds = new ArrayList();
        template.getPageDimensionEntries().forEach(p -> {
            if (extTemplateNeedDim.contains(p.getDimension().getNumber())) {
                dimIds.add(p.getDimension().getId());
            }
        });
        if (dimIds.isEmpty() || dimIds.size() != extTemplateNeedDim.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bbe\u7f6e\u62d3\u5c55\u7ef4\u6570\u636e\u533a\u57df\u65f6\uff0c\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3001\u7ec4\u7ec7\u3001\u5e01\u79cd\u3001\u8fc7\u7a0b\u548c\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u5ea6\u5fc5\u987b\u8981\u5728\u9875\u9762\u7ef4\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u7ef4\u540e\u91cd\u8bd5\u3002", (String)"TemplateExtendModelRefUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), errorMessage));
        }
    }

    public static boolean isSingleExtTemplate(SpreadManager sm, TemplateModel templateModel) {
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        return !postionInfoSet.isEmpty() && postionInfoSet.stream().anyMatch(ps -> ps.getExtendInfo() != null) && templateModel.getAreaRangeEntries().stream().anyMatch(areaRangeEntry -> areaRangeEntry.getRowDimEntries().isEmpty() && areaRangeEntry.getColDimEntries().isEmpty());
    }

    public static void batchSaveExtModelRefTemplate(List<TemplateModel> newtemplateModels) {
        long modelId = newtemplateModels.get(0).getModelId();
        Map<String, Long> allExtendDataModel = TemplateExtendModelRefUtil.getAllExtendDataModel(modelId);
        ArrayList saveDyoList = new ArrayList(16);
        newtemplateModels.forEach(templateModel -> {
            SpreadManager sm;
            Set postionInfoSet;
            if (templateModel.isSaveByDim() && !(postionInfoSet = (sm = JsonSerializerUtil.toSpreadManager((String)templateModel.getData())).getAreaManager().getPostionInfoSet()).isEmpty()) {
                postionInfoSet.forEach(ps -> {
                    ExtendInfo extendInfo = ps.getExtendInfo();
                    if (extendInfo != null) {
                        DynamicObject dyo = ORM.create().newDynamicObject("bcm_extmodelref");
                        dyo.set(KEY_MODEL, (Object)modelId);
                        dyo.set(KEY_EXTMODEL, allExtendDataModel.get(extendInfo.getExtModelNumber()));
                        dyo.set(KEY_TEMPLATE, (Object)templateModel.getId());
                        saveDyoList.add(dyo);
                    }
                });
            }
        });
        if (!saveDyoList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDyoList.toArray(new DynamicObject[0]));
        }
    }

    public static void saveExtModelRefTemplate(SpreadManager sm, TemplateModel templateModel) {
        long modelId = templateModel.getModelId();
        long templateId = templateModel.getId();
        TemplateExtendModelRefUtil.checkBeforeSave(sm, templateModel, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58", (String)"TemplateExtendModelRefUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        TemplateExtendModelRefUtil.clearExtModelRefTemplate(templateId, modelId);
        TemplateExtendModelRefUtil.saveExtModelRefTemplate(modelId, templateId, sm);
    }

    public static void saveExtModelRefTemplate(long modelId, long templateId, SpreadManager sm) {
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        if (postionInfoSet.isEmpty()) {
            return;
        }
        ArrayList dyoList = new ArrayList(16);
        Map<String, Long> map = TemplateExtendModelRefUtil.getAllExtendDataModel(modelId);
        postionInfoSet.forEach(ps -> {
            ExtendInfo extendInfo = ps.getExtendInfo();
            if (extendInfo != null) {
                DynamicObject dyo = ORM.create().newDynamicObject("bcm_extmodelref");
                dyo.set(KEY_MODEL, (Object)modelId);
                dyo.set(KEY_EXTMODEL, map.get(extendInfo.getExtModelNumber()));
                dyo.set(KEY_TEMPLATE, (Object)templateId);
                dyoList.add(dyo);
            }
        });
        if (!dyoList.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)dyoList.get(0)).getDataEntityType(), (Object[])dyoList.toArray());
        }
    }

    public static void clearExtModelRefTemplate(Long templateId, Long modelId) {
        QFilter modelQFilter = new QFilter(KEY_MODEL, "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"bcm_extmodelref", (QFilter[])new QFilter[]{new QFilter(KEY_TEMPLATE, "=", (Object)templateId), modelQFilter});
    }

    public static Map<String, Long> getExtModelRef(Long modelId, Object number) {
        QFilter modelQFilter = new QFilter(KEY_MODEL, "=", (Object)modelId);
        QFilter qFilter = new QFilter(KEY_USAGE, "=", (Object)"1");
        qFilter.and(KEY_STATUS, "=", (Object)"1");
        qFilter.and(KEY_ISONLYREAD, "=", (Object)"0");
        if (number instanceof Set) {
            qFilter.and("number", "not in", number);
        } else {
            qFilter.and("number", "!=", number);
        }
        List list = QueryServiceHelper.queryPrimaryKeys((String)"TemplateExtendModelRefUtil", (String)"bcm_templateentity", (QFilter[])new QFilter[]{modelQFilter, qFilter}, (String)"", (int)-1);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        if (list.isEmpty()) {
            return map;
        }
        QFilter templQFilter = new QFilter(KEY_TEMPLATE, "in", (Object)list);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,extmodel.id,extmodel.number", (QFilter[])new QFilter[]{modelQFilter.and(templQFilter)});
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dyo -> map.put(dyo.getString("extmodel.number"), dyo.getLong("extmodel.id")));
        }
        return map;
    }

    public static Map<String, Long> getIntrExtDataModelRef(Long modelId) {
        return (Map)ThreadCache.get((Object)("getIntrExtDataModelRef_" + modelId), () -> {
            Set catalogIds = TemplateCatalogEnum.getInnerTemplateCatalogIds((long)modelId);
            QFilter modelQFilter = new QFilter(KEY_MODEL, "=", (Object)modelId);
            QFilter qfBuilder = new QFilter("templatecatalog", "in", (Object)catalogIds);
            DynamicObjectCollection templateList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,mergenode", (QFilter[])new QFilter[]{modelQFilter, qfBuilder});
            HashMap map = new HashMap(16);
            if (CollectionUtils.isEmpty((Collection)templateList)) {
                return map;
            }
            HashSet ids = new HashSet(16);
            templateList.forEach(t -> {
                if (t.getLong("mergenode") != 0L) {
                    ids.add(t.getLong("mergenode"));
                }
            });
            if (CollectionUtils.isEmpty(ids)) {
                return map;
            }
            QFilter idQfilter = new QFilter("id", "in", ids);
            idQfilter.and("extendsgroup.grouptype", "=", (Object)ExtendDimGroupType.TRANSACTION.getIndex());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])new QFilter[]{modelQFilter, idQfilter});
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                dynamicObjects.forEach(dyo -> map.put(dyo.getString("number"), dyo.getLong("id")));
            }
            return map;
        });
    }

    public static Map<String, Set<String>> getALLExtModelRef(Long modelId, boolean isValidTemplate) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        QFilter modelQFilter = new QFilter(KEY_MODEL, "=", (Object)modelId);
        QFilter qFilter = null;
        if (isValidTemplate) {
            qFilter = new QFilter("template.usage", "=", (Object)"1");
            qFilter.and("template.status", "=", (Object)"1");
            qFilter.and("template.isonlyread", "=", (Object)"0");
        } else {
            qFilter = new QFilter("1", "=", (Object)1);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,template.number,extmodel.id,extmodel.number", (QFilter[])new QFilter[]{modelQFilter, qFilter});
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dyo -> {
                String templateNumebr = dyo.getString("template.number");
                map.computeIfAbsent(templateNumebr, k -> new HashSet(16)).add(dyo.getString("extmodel.number"));
            });
        }
        return map;
    }

    public static List<String> getMustInputColField(ExtendsModel extendsModel) {
        ArrayList<String> mustInputFields = new ArrayList<String>(16);
        if (extendsModel != null) {
            extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> {
                if (dimFieldEntry.getIsNecessary() || dimFieldEntry.getUniqueCheck()) {
                    mustInputFields.add(dimFieldEntry.getDimension().getNumber());
                }
            });
            extendsModel.getExtFieldEntry().forEach(extFieldEntry -> {
                if (extFieldEntry.getIsNecessary() || extFieldEntry.getUniqueCheck()) {
                    mustInputFields.add(extFieldEntry.getExtField().getNumber());
                }
            });
        }
        return mustInputFields;
    }

    public static List<String> getUniqueField(ExtendsModel extendsModel) {
        ArrayList<String> uniqueFields = new ArrayList<String>(16);
        if (extendsModel != null) {
            extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> {
                if (dimFieldEntry.getUniqueCheck()) {
                    uniqueFields.add(dimFieldEntry.getDimension().getNumber());
                }
            });
            extendsModel.getExtFieldEntry().forEach(extFieldEntry -> {
                if (extFieldEntry.getUniqueCheck()) {
                    uniqueFields.add(extFieldEntry.getExtField().getNumber());
                }
            });
        }
        return uniqueFields;
    }

    public static void checkExtCalSetting(ExtendInfo extendInfo, ExtendsModel extendsModel) {
        List calculateInfos = extendInfo.getCalculateInfos();
        HashMap<String, DynaEntityObject> map = new HashMap<String, DynaEntityObject>(16);
        extendsModel.getExtFieldEntry().forEach(extFieldEntry -> map.put(extFieldEntry.getExtField().getNumber(), (DynaEntityObject)extFieldEntry));
        extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> map.put(dimFieldEntry.getDimension().getNumber(), (DynaEntityObject)dimFieldEntry));
        List cols = extendInfo.getColsWithoutUnflooatMember();
        List<String> noDataCols = TemplateExtendModelRefUtil.getCurDataCols(map, cols, false);
        List<String> enumDataCols = TemplateExtendModelRefUtil.getEnumDataCols(map, cols);
        ArrayList removeCal = new ArrayList(16);
        calculateInfos.forEach(calculateInfo -> {
            if (noDataCols.contains(calculateInfo.getCalcol()) || new FormulaCheckModel().isHaveColsField(calculateInfo.getFormula(), noDataCols) || enumDataCols.contains(calculateInfo.getCalcol())) {
                removeCal.add(calculateInfo);
            }
        });
        if (!removeCal.isEmpty()) {
            calculateInfos.removeAll(removeCal);
            extendInfo.setCalculateInfos(calculateInfos);
        }
    }

    public static void checkTopSettingBeforeSave(ExtendInfo extendInfo, ExtendsModel extendsModel, boolean isForWeave) {
        AtomicBoolean isCheckTopField = new AtomicBoolean(false);
        if (isForWeave) {
            isCheckTopField.set(true);
        } else {
            HashMap<String, DynaEntityObject> map = new HashMap<String, DynaEntityObject>(16);
            extendsModel.getExtFieldEntry().forEach(extFieldEntry -> {
                if (extFieldEntry.getExtField().getNumber().equals(extendInfo.getTopField()) && (!extFieldEntry.getExtField().getMapped().contains("numext") || DataTypeEnum.ENUMTP.index.equals(extFieldEntry.getExtField().getDataType()))) {
                    isCheckTopField.set(true);
                }
                map.put(extFieldEntry.getExtField().getNumber(), (DynaEntityObject)extFieldEntry);
            });
            if (!isCheckTopField.get()) {
                extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> map.put(dimFieldEntry.getDimension().getNumber(), (DynaEntityObject)dimFieldEntry));
                List<String> mustInputColField = TemplateExtendModelRefUtil.getMustInputColField(extendsModel);
                Map customColName = extendInfo.getCustomColName();
                if (!customColName.isEmpty()) {
                    List cols = extendInfo.getColsWithoutUnflooatMember();
                    boolean flag = false;
                    if (!mustInputColField.isEmpty()) {
                        mustInputColField.removeAll(customColName.keySet());
                        if (!mustInputColField.isEmpty() && cols.stream().anyMatch(col -> mustInputColField.contains(col))) {
                            flag = true;
                        }
                    }
                    if (!flag) {
                        List<String> noDataCols = TemplateExtendModelRefUtil.getCurDataCols(map, cols, false);
                        boolean bl = flag = !noDataCols.isEmpty() && !noDataCols.containsAll(customColName.keySet());
                    }
                    if (flag) {
                        extendInfo.setCustomColName(new HashMap(16));
                    }
                }
            }
        }
        if (isCheckTopField.get()) {
            extendInfo.clearTopSetting();
        }
    }

    public static void checkOtherShowSetting(Map<String, DynaEntityObject> objectMap, List<String> cols, Map<String, String> cusMap) {
        if (cusMap.isEmpty()) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(16);
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (!cols.isEmpty()) {
            cols.forEach(e -> {
                DynaEntityObject dynaEntityObject = (DynaEntityObject)objectMap.get(e);
                if (dynaEntityObject instanceof ExtFieldEntry) {
                    ExtFieldEntry extFieldEntry = (ExtFieldEntry)dynaEntityObject;
                    map.put(extFieldEntry.getExtField().getNumber(), extFieldEntry.getExtField().getName());
                    if (extFieldEntry.getExtField().getMapped().contains("numext")) {
                        return;
                    }
                    if ((extFieldEntry.getIsNecessary() || extFieldEntry.getUniqueCheck()) && cusMap.get(e) == null) {
                        list.add(extFieldEntry.getExtField().getNumber());
                    }
                } else if (dynaEntityObject instanceof DimFieldEntry) {
                    DimFieldEntry dimFieldEntry = (DimFieldEntry)dynaEntityObject;
                    map.put(dimFieldEntry.getDimension().getNumber(), dimFieldEntry.getDimension().getName());
                    if ((dimFieldEntry.getIsNecessary() || dimFieldEntry.getUniqueCheck()) && cusMap.get(e) == null) {
                        list.add(dimFieldEntry.getDimension().getNumber());
                    }
                }
            });
        }
        if (!list.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5fc5\u5f55\u5b57\u6bb5\u6216\u552f\u4e00\u6027\u6821\u9a8c\u5b57\u6bb5%s\u9700\u8981\u5728Top\u8bbe\u7f6e-\u5176\u4ed6\u5408\u8ba1\u663e\u793a\u8bbe\u7f6e\u4e2d\u8865\u5145\u5b57\u6bb5\u663e\u793a\u5185\u5bb9\u3002", (String)"TemplateExtendModelRefUtil_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, list)));
        }
    }

    public static void checkMinCols(Map<String, DynaEntityObject> objectMap, List<String> cols) {
    }

    public static List<String> getRealDataCols(Map<String, DynaEntityObject> objectMap, List<String> cols, boolean isData, boolean isIncludeEnum) {
        if (!cols.isEmpty() && !objectMap.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(cols.size());
            objectMap.forEach((k, v) -> {
                if (cols.contains(k)) {
                    boolean isEnum = v instanceof ExtFieldEntry && DataTypeEnum.ENUMTP.index.equals(((ExtFieldEntry)v).getExtField().getDataType());
                    boolean isDataField = v instanceof ExtFieldEntry && ((ExtFieldEntry)v).getExtField().getMapped().contains("numext");
                    boolean flag = false;
                    if (!isIncludeEnum && isEnum) {
                        flag = true;
                    } else if (isData && (!isDataField || isEnum)) {
                        flag = true;
                    } else if (!isData && isDataField) {
                        flag = true;
                    }
                    if (!flag) {
                        list.add((String)k);
                    }
                }
            });
            return list;
        }
        return cols;
    }

    public static List<String> getEnumDataCols(Map<String, DynaEntityObject> objectMap, List<String> cols) {
        ArrayList<String> list = new ArrayList<String>(cols.size());
        if (!cols.isEmpty() && !objectMap.isEmpty()) {
            objectMap.forEach((k, v) -> {
                if (cols.contains(k)) {
                    boolean isDataField;
                    boolean isEnum = v instanceof ExtFieldEntry && DataTypeEnum.ENUMTP.index.equals(((ExtFieldEntry)v).getExtField().getDataType());
                    boolean bl = isDataField = v instanceof ExtFieldEntry && ((ExtFieldEntry)v).getExtField().getMapped().contains("numext");
                    if (isEnum && isDataField) {
                        list.add((String)k);
                    }
                }
            });
        }
        return list;
    }

    public static List<String> getCurDataCols(Map<String, DynaEntityObject> objectMap, List<String> cols, boolean isData) {
        return TemplateExtendModelRefUtil.getRealDataCols(objectMap, cols, isData, false);
    }

    public static Map<Long, ExtendsModel> batchGetExtendsModels(Set<Long> extIds) {
        return (Map)ThreadCache.get((Object)("batchGetExtendsModels" + extIds.toString()), () -> {
            HashMap extendsModelMap = new HashMap(16);
            if (!extIds.isEmpty()) {
                QFilter idFilter = new QFilter("id", "in", (Object)extIds);
                QFilter qFilter = new QFilter("extmodelid", "in", (Object)extIds);
                Map extendModelMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_extendsmodel", (QFilter[])idFilter.toArray());
                Map<Long, List<DynamicObject>> extModelFieldMap = TemplateExtendModelRefUtil.groupExtDyoByExtId(BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{qFilter}, (String)"sequence,extfield.number"));
                Map<Long, List<DynamicObject>> extModelDimMap = TemplateExtendModelRefUtil.groupExtDyoByExtId(BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{qFilter}, (String)"sequence"));
                extendModelMap.forEach((k, v) -> {
                    Long id = LongUtil.toLong((Object)k);
                    ExtendsModel extendsModel = new ExtendsModel();
                    extendsModel.initData(v, (List)extModelFieldMap.get(id), extModelDimMap.computeIfAbsent(id, key -> new ArrayList(16)));
                    extendsModelMap.put(id, extendsModel);
                });
            }
            return extendsModelMap;
        });
    }

    private static Map<Long, List<DynamicObject>> groupExtDyoByExtId(DynamicObject[] dynamicObjects) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        if (dynamicObjects.length != 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long extmodelid = dynamicObject.getLong("extmodelid");
                map.computeIfAbsent(extmodelid, k -> new ArrayList(16)).add(dynamicObject);
            }
        }
        return map;
    }

    public static boolean isOnlyReadOrQueryTm(TemplateModel tm) {
        return TemplateUsageEnum.FORQUERY.getValue().equals(tm.getUsage()) || tm.getIsOnlyRead();
    }

    public static String showExtDataModelValidMessage(SpreadManager sm, Long modelId, TemplateModel tm) {
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        StringBuilder message = new StringBuilder();
        if (!postionInfoSet.isEmpty()) {
            HashSet<String> extModelNumbers = new HashSet<String>(16);
            Map<String, Set<String>> allExtModelRef = TemplateExtendModelRefUtil.getALLExtModelRef(modelId, true);
            Map<Object, Object> intrExtDataModelRef = new HashMap(16);
            Set<Object> exceptSet = new HashSet(16);
            if (TemplateModel.TplStatus.ENABLE == tm.getStatus()) {
                String oldNumber = tm.getNumber();
                if (QueryServiceHelper.exists((String)"bcm_templateentity", (Object)tm.getId())) {
                    oldNumber = ModelDataProvider.getTemplateModel(tm.getId()).getNumber();
                }
                exceptSet = TemplateExtendModelRefUtil.getExceptExtendDataModel(allExtModelRef, oldNumber);
                intrExtDataModelRef = TemplateExtendModelRefUtil.getIntrExtDataModelRef(modelId);
            }
            HashSet<String> curRept = new HashSet<String>(16);
            HashSet<String> refRept = new HashSet<String>(16);
            HashSet<String> intrRef = new HashSet<String>(16);
            HashMap<String, List<ExtendInfo>> extendInfoMap = new HashMap<String, List<ExtendInfo>>(16);
            for (PositionInfo ps : postionInfoSet) {
                ExtendInfo extendInfo = ps.getExtendInfo();
                if (extendInfo == null) continue;
                String number = extendInfo.getExtModelNumber();
                if (!extModelNumbers.add(number)) {
                    curRept.add(number);
                }
                if (exceptSet.contains(number)) {
                    refRept.add(number);
                }
                extendInfoMap.computeIfAbsent(number, k -> new ArrayList(16)).add(extendInfo);
                if (!intrExtDataModelRef.containsKey(number)) continue;
                intrRef.add(number);
            }
            if (!curRept.isEmpty() || !refRept.isEmpty() || CollectionUtils.isNotEmpty(intrRef)) {
                boolean flag = false;
                String ms1 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c", (String)"MultiViewTemplateProcess_118", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String ms2 = "";
                String ms3 = "";
                String ms4 = "";
                String ms5 = "";
                String ms6 = "";
                String ms7 = "";
                if (!curRept.isEmpty()) {
                    ms2 = TemplateExtendModelRefUtil.isAllowRepeatExtDataModel(extendInfoMap, null);
                    if (StringUtils.isNotEmpty((String)ms2)) {
                        ms3 = "\uff0c";
                        flag = true;
                    } else {
                        ms2 = "";
                    }
                }
                if (!refRept.isEmpty()) {
                    ms4 = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201c%s\u201d\u5df2\u88ab\u5176\u4ed6\u201c\u7f16\u5236\u7c7b\u3001\u975e\u53ea\u8bfb\u201d\u7684\u6a21\u677f\u4f7f\u7528", (String)"TemplateExtendModelRefUtil_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), refRept);
                    ms5 = "\uff0c";
                    flag = true;
                }
                if (CollectionUtils.isNotEmpty(intrRef)) {
                    ms6 = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b%s\u5df2\u7ecf\u88ab\u5176\u4ed6\u4ea4\u6613\u5e95\u7a3f\u6a21\u677f\u4f7f\u7528", (String)"TemplateExtendModelRefUtil_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), intrRef);
                    ms7 = "\uff0c";
                    flag = true;
                }
                if (flag) {
                    message = new StringBuilder(String.format("%s%s%s%s%s%s%s", ms1, ms2, ms3, ms4, ms5, ms6, ms7));
                    message.deleteCharAt(message.lastIndexOf("\uff0c"));
                    message.append("\u3002");
                }
            }
        }
        return message.toString();
    }

    public static String showNotSetMustInputColFieldMessage(boolean isSave, SpreadManager sm, Long modelId) {
        HashMap<String, String> map;
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        Map<String, List<String>> notSetMustInputColField = TemplateExtendModelRefUtil.getNotSetMustInputColField(postionInfoSet, modelId, map = new HashMap<String, String>(16));
        if (!notSetMustInputColField.isEmpty()) {
            StringBuilder message = new StringBuilder(isSave ? ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c", (String)"MultiViewTemplateProcess_105", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c", (String)"MultiViewTemplateProcess_118", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            notSetMustInputColField.forEach((k, v) -> message.append(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b%1s\u4e2d\u8bbe\u7f6e\u7684\u552f\u4e00\u6027\u6821\u9a8c\u5b57\u6bb5\u6216\u5fc5\u5f55\u5b57\u6bb5%2s\u4e0d\u5728\u5217\u5b57\u6bb5\u4e2d\u3002", (String)"MultiViewTemplateProcess_106", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k, TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, v))));
            message.deleteCharAt(message.lastIndexOf("\uff0c"));
            message.append("\u3002");
            return message.toString();
        }
        return null;
    }

    public static Map<String, List<String>> getNotSetMustInputColField(Set<PositionInfo> postionInfoSet, Long modelId, Map<String, String> map) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        Map<String, Long> dataModelMap = TemplateExtendModelRefUtil.getExtDataModelMap(postionInfoSet, modelId);
        HashSet<Long> extIds = new HashSet<Long>(16);
        if (!dataModelMap.isEmpty()) {
            postionInfoSet.forEach(ps -> {
                ExtendInfo extendInfo = ps.getExtendInfo();
                if (extendInfo != null && dataModelMap.get(extendInfo.getExtModelNumber()) != null) {
                    extIds.add((Long)dataModelMap.get(extendInfo.getExtModelNumber()));
                }
            });
            Map<Long, ExtendsModel> extendsModelMap = TemplateExtendModelRefUtil.batchGetExtendsModels(extIds);
            for (PositionInfo positionInfo : postionInfoSet) {
                ExtendInfo extendInfo = positionInfo.getExtendInfo();
                if (extendInfo == null || dataModelMap.get(extendInfo.getExtModelNumber()) == null) continue;
                String extModelNumber = extendInfo.getExtModelNumber();
                ExtendsModel extendsModel = extendsModelMap.get(dataModelMap.get(extModelNumber));
                ArrayList mustInputFields = new ArrayList(16);
                extendsModel.getDimFieldEntry().forEach(dimFieldEntry -> {
                    if (dimFieldEntry.getIsNecessary() || dimFieldEntry.getUniqueCheck()) {
                        mustInputFields.add(dimFieldEntry.getDimension().getNumber());
                    }
                    map.put(dimFieldEntry.getDimension().getNumber(), dimFieldEntry.getDimension().getName());
                });
                extendsModel.getExtFieldEntry().forEach(extFieldEntry -> {
                    if (extFieldEntry.getIsNecessary() || extFieldEntry.getUniqueCheck()) {
                        mustInputFields.add(extFieldEntry.getExtField().getNumber());
                    }
                    map.put(extFieldEntry.getExtField().getNumber(), extFieldEntry.getExtField().getName());
                });
                if (!mustInputFields.isEmpty()) {
                    mustInputFields.removeAll(extendInfo.getCols(false));
                }
                if (mustInputFields.isEmpty()) continue;
                result.put(extModelNumber, mustInputFields);
            }
        }
        return result;
    }

    public static void deleteTopSetting(SpreadManager sm, TemplateModel tm) {
        if (tm.isSaveByDim() && !TemplateExtendModelRefUtil.isOnlyReadOrQueryTm(tm)) {
            sm.getAreaManager().getPostionInfoSet().forEach(ps -> {
                ExtendInfo extendInfo = ps.getExtendInfo();
                if (extendInfo != null && extendInfo.hasTopSetting()) {
                    extendInfo.clearTopSetting();
                }
            });
        }
    }

    public static Map<String, Long> getExtDataModelMap(Set<PositionInfo> postionInfoSet, Long modelId) {
        Map<String, Long> map = new HashMap<String, Long>(16);
        if (!postionInfoSet.isEmpty() && postionInfoSet.stream().anyMatch(ps -> ps.getExtendInfo() != null)) {
            List extModelNumbers = postionInfoSet.stream().filter(ps -> ps.getExtendInfo() != null).map(ps -> ps.getExtendInfo().getExtModelNumber()).collect(Collectors.toList());
            QFilter qFilter = new QFilter("number", "in", extModelNumbers);
            qFilter.and(KEY_MODEL, "=", (Object)modelId);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])qFilter.toArray());
            if (!dynamicObjects.isEmpty()) {
                map = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getLong("id")));
            }
        }
        return map;
    }

    public static Map<Tuple<String, String, String>, Set<String>> getTemplateRefExtendModelCols(ExtendsModel extendsModel) {
        HashMap<Tuple<String, String, String>, Set<String>> map = new HashMap<Tuple<String, String, String>, Set<String>>(16);
        if (extendsModel != null) {
            QFilter qFilter = new QFilter(KEY_EXTMODEL, "=", (Object)extendsModel.getId());
            QFilter modelQf = new QFilter(KEY_MODEL, "=", (Object)extendsModel.getModelId());
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_extmodelref", (String)KEY_TEMPLATE, (QFilter[])new QFilter[]{modelQf, qFilter});
            if (CollectionUtils.isNotEmpty((Collection)objects)) {
                String extendsModelNumber = extendsModel.getNumber();
                ArrayList ids = new ArrayList(objects.size());
                objects.forEach(e -> ids.add(e.getLong(KEY_TEMPLATE)));
                modelQf.and("id", "in", ids);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,versionnumber,data,issavebydim", (QFilter[])new QFilter[]{modelQf});
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    dynamicObjects.forEach(e -> {
                        if (e.getBoolean("issavebydim")) {
                            HashSet cols = new HashSet(16);
                            if (StringUtils.isNotEmpty((String)e.getString("data"))) {
                                JsonSerializerUtil.toSpreadManager((String)e.getString("data")).getAreaManager().getPostionInfoSet().forEach(p -> {
                                    if (p.getExtendInfo() != null && extendsModelNumber.equals(p.getExtendInfo().getExtModelNumber())) {
                                        cols.addAll(p.getExtendInfo().getCols(false));
                                    }
                                });
                            }
                            if (!cols.isEmpty()) {
                                map.put(Tuple.create((Object)e.getString("number"), (Object)e.getString("name"), (Object)String.format("V%.1f", Float.valueOf(e.getBigDecimal("versionnumber").floatValue()))), cols);
                            }
                        }
                    });
                }
            }
        }
        return map;
    }

    public static void updateEnumMemRange(ExtendInfo extendInfo, ExtendsModel extendsModel) {
        Map enumValueRangeMap = extendInfo.getEnumValueRangeMap();
        if (MapUtils.isNotEmpty((Map)enumValueRangeMap)) {
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            extendsModel.getExtFieldEntry().stream().map(ExtFieldEntry::getExtField).forEach(e -> {
                if (DataTypeEnum.ENUMTP.index.equals(e.getDataType()) && CollectionUtils.isNotEmpty((Collection)((Collection)enumValueRangeMap.get(e.getNumber())))) {
                    map.put(e.getNumber(), e.getEnumItemId());
                }
            });
            TemplateExtendModelRefUtil.updateEnumMemRange(extendsModel.getModelId(), enumValueRangeMap, map, true);
            extendInfo.setEnumValueRangeMap(enumValueRangeMap);
        }
    }

    public static void updateEnumMemRange(long modelId, Map<String, List<Pair<Long, String>>> enumValueRangeMap, Map<String, Long> map, boolean isImport) {
        if (enumValueRangeMap.isEmpty()) {
            return;
        }
        if (map != null && !map.isEmpty()) {
            QFilter modelQf = new QFilter(KEY_MODEL, "=", (Object)modelId);
            if (isImport) {
                HashSet enumvalues = new HashSet(16);
                enumValueRangeMap.forEach((k, v) -> v.forEach(p -> enumvalues.add(p.p2)));
                modelQf.and("enumvalue", "in", enumvalues);
            } else {
                modelQf.and("enumitemid", "in", map.values());
            }
            Map<Long, List<DynamicObject>> idMap = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id, enumvalue, name, enumitemid,datatype,dseq", (QFilter[])new QFilter[]{modelQf}, (String)"dseq").stream().collect(Collectors.groupingBy(d -> d.getLong("enumitemid")));
            HashSet<String> numbers = new HashSet<String>(enumValueRangeMap.keySet());
            numbers.forEach(s -> {
                Map<Object, DynamicObject> idToDyoMap;
                List oldValues;
                List objects;
                ArrayList values = new ArrayList(16);
                Long enumId = (Long)map.get(s);
                if (enumId != 0L && CollectionUtils.isNotEmpty((Collection)(objects = (List)idMap.get(enumId))) && CollectionUtils.isNotEmpty((Collection)(oldValues = (List)enumValueRangeMap.get(s))) && MapUtils.isNotEmpty(idToDyoMap = TemplateExtendModelRefUtil.groupDynamicObject(objects, isImport))) {
                    oldValues.forEach(p -> {
                        DynamicObject object = (DynamicObject)idToDyoMap.get(isImport ? p.p2 : p.p1);
                        if (object != null) {
                            values.add(Pair.onePair((Object)object.getLong("id"), (Object)object.getString("enumvalue")));
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(values)) {
                    enumValueRangeMap.put((String)s, values);
                } else {
                    enumValueRangeMap.remove(s);
                }
            });
        } else {
            enumValueRangeMap.clear();
        }
    }

    private static Map<Object, DynamicObject> groupDynamicObject(List<DynamicObject> objects, boolean isImport) {
        HashMap<Object, DynamicObject> valueDyoMap;
        if (isImport) {
            valueDyoMap = new HashMap(16);
            objects.forEach(e -> valueDyoMap.put(e.getString("enumvalue"), (DynamicObject)e));
        } else {
            valueDyoMap = objects.stream().collect(Collectors.toMap(k1 -> k1.getLong("id"), k2 -> k2));
        }
        return valueDyoMap;
    }
}

