/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateCatalog;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.enums.template.DisEffectWayEnum;
import kd.fi.bcm.common.enums.template.ImportTemplateTypeEnum;
import kd.fi.bcm.common.enums.template.OrgRptTemplateUpdateEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateEntryFormulaCheck;
import kd.fi.bcm.formplugin.template.util.TemplateExportPlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.NewMyTemplateUtil;
import kd.fi.bcm.formplugin.util.TemplateDimSettingUtil;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class TemplateImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(TemplateImportPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String BTNOK_UPDATE = "btnok_update";
    private static final String BTNOK_OVERIDE = "btnok_overide";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String BTNDOWNLOAD = "btndownload";
    private static final String IMPORTFORMULAS_FCP = "importFormulas";
    private static final String TEMPLATEID_FCP = "templateId";
    private static final String CACHEKEY_FILE_TYPE = "file_type";
    private static final String CACHEKEY_FILE_URL = "file_url";
    private static final String CACHEKEY_NOT_IMPORT_FORMULA_MESSAGE = "not_import_formula_message";
    private static final String CACHEKEY_UPDATE_FORMULA = "update_formula";
    private static final String JSON_FILETYPE = "json";
    private static final String YAML_FILETYPE = "yaml";
    private static final String CALLBACK_SHOW_ERROR_DETAIL = "show_error_detail";
    private static final String CONFIRM_CLICKTHIS = "clickthis";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK, BTNOK_UPDATE, BTNOK_OVERIDE, BTNDOWNLOAD);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        boolean flag = this.getFormCustomParam(IMPORTFORMULAS_FCP, false);
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{BTNOK_UPDATE, BTNOK_OVERIDE});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{BTNOK});
    }

    private void checkFileType() {
        boolean flag = this.getFormCustomParam(IMPORTFORMULAS_FCP, false);
        String type = this.getPageCache().get(CACHEKEY_FILE_TYPE);
        if (type != null && (JSON_FILETYPE.equals(type) && flag || YAML_FILETYPE.equals(type) && !flag)) {
            this.writeErrorLog(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (kd.bos.util.StringUtils.isNotEmpty((String)key) && key.startsWith(BTNOK)) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get(CACHEKEY_FILE_URL);
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"TemplateImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.checkFileType();
                String[] reqParams = new URL(file_url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                InputStream inputStream = content.getInputStream();
                String jsonString = this.getStringFromInputStream(inputStream);
                switch (key) {
                    case "btnok": {
                        this.handleInputStream(jsonString);
                        this.getView().close();
                        break;
                    }
                    case "btnok_update": {
                        this.importFormulas(true, jsonString);
                        break;
                    }
                    case "btnok_overide": {
                        this.importFormulas(false, jsonString);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.importFailed"), new Object[]{e.getMessage()});
            }
        }
    }

    private long getTemplateId() {
        return this.getFormCustomParam(TEMPLATEID_FCP, 0L);
    }

    private long getMyTemplateOrgId() {
        return this.getFormCustomParam("orgId", 0L);
    }

    private String getMyprefixTips() {
        return this.getMyTemplateOrgId() != 0L ? ResManager.loadKDString((String)"\u6211\u7684", (String)"MyTemplateProcessPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868", (String)"TemplateVerification_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void importFormulas(boolean isUpdate, String str) {
        Map<String, DynamicObject> prepareData;
        List<Map<String, Object>> list = new ArrayList(16);
        try {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
            Yaml yaml = new Yaml(options);
            list = (List)yaml.load(str);
        }
        catch (Exception e) {
            this.writeErrorLog(true);
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
        }
        ArrayList dynamicObjectList = new ArrayList(16);
        ArrayList<String> errorStrs = new ArrayList<String>(16);
        ArrayList<String> successStrs = new ArrayList<String>(16);
        ArrayList ids = new ArrayList(16);
        if (!list.isEmpty() && !(prepareData = this.checkAndPrepareData(list)).isEmpty()) {
            list.forEach(map -> {
                String versionNumber;
                String number = this.getValueForKey((Map<String, Object>)map, TemplateExportPlugin.TC_SIGN);
                DynamicObject dynamicObject = (DynamicObject)prepareData.get(this.genKey(number, versionNumber = this.getValueForKey((Map<String, Object>)map, TemplateExportPlugin.V_SIGN)));
                if (dynamicObject != null) {
                    String message;
                    Map<String, String> formulas = new HashMap(16);
                    if (map.get(TemplateExportPlugin.F_SIGN) != null) {
                        formulas = (Map)map.get(TemplateExportPlugin.F_SIGN);
                    }
                    ImportTemplateTypeEnum importTemplateTypeEnum = null;
                    if (!isUpdate || !formulas.isEmpty()) {
                        long id = dynamicObject.getLong("id");
                        SpreadManager sm = null;
                        String json = dynamicObject.getString("spreadjson");
                        DynamicObject orgRptDyo = null;
                        if (this.getMyTemplateOrgId() != 0L) {
                            orgRptDyo = this.getOrgRptDyo();
                            if (orgRptDyo != null && kd.bos.util.StringUtils.isNotEmpty((String)orgRptDyo.getString("data"))) {
                                sm = JsonSerializerUtil.toSpreadManager((String)orgRptDyo.getString("data"));
                                json = orgRptDyo.getString("spreadjson");
                                importTemplateTypeEnum = ImportTemplateTypeEnum.OLD;
                            } else if (this.isNewMyTemplate()) {
                                sm = this.getNewMyTemplateCellFormulas(dynamicObject);
                                importTemplateTypeEnum = ImportTemplateTypeEnum.NEW;
                            } else {
                                sm = JsonSerializerUtil.toSpreadManager((String)dynamicObject.getString("rptdata"));
                                importTemplateTypeEnum = ImportTemplateTypeEnum.NO;
                            }
                        } else {
                            sm = JsonSerializerUtil.toSpreadManager((String)dynamicObject.getString("data"));
                            importTemplateTypeEnum = ImportTemplateTypeEnum.COMMON;
                        }
                        sm = this.updateSpreadManager(sm, formulas, isUpdate, false, id);
                        if (ImportTemplateTypeEnum.COMMON == importTemplateTypeEnum) {
                            dynamicObject.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)sm));
                            dynamicObject.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)this.updateSpreadManager(JsonSerializerUtil.toSpreadManager((String)dynamicObject.getString("rptdata")), formulas, isUpdate, true, id)));
                        } else if ((ImportTemplateTypeEnum.NO == importTemplateTypeEnum || ImportTemplateTypeEnum.OLD == importTemplateTypeEnum) && orgRptDyo != null) {
                            orgRptDyo.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)sm));
                        }
                        if (!formulas.isEmpty()) {
                            if (ImportTemplateTypeEnum.NEW == importTemplateTypeEnum) {
                                this.saveNewMyTemplate(sm);
                                dynamicObjectList.add(orgRptDyo);
                            } else {
                                JSONObject spreadjson = this.updateJson(sm, json, formulas);
                                if (ImportTemplateTypeEnum.COMMON == importTemplateTypeEnum) {
                                    dynamicObject.set("spreadjson", (Object)this.jsonToString(spreadjson));
                                    dynamicObject.set("rptspreadjson", (Object)TempFormulaUtil.removeAccFormula(sm, spreadjson));
                                    dynamicObjectList.add(dynamicObject);
                                } else if (orgRptDyo != null) {
                                    orgRptDyo.set("spreadjson", (Object)this.jsonToString(spreadjson));
                                    dynamicObjectList.add(orgRptDyo);
                                }
                            }
                            ids.add(id);
                        }
                    }
                    if (!formulas.isEmpty()) {
                        successStrs.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a\u201c%1s\u201d\uff0c\u7248\u672c\uff1a\u201c%2s\u201d\u7684\u62a5\u8868\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, versionNumber, this.getMyprefixTips()));
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)(message = this.getPageCache().get(CACHEKEY_NOT_IMPORT_FORMULA_MESSAGE)))) {
                        errorStrs.add(message);
                    }
                    this.getPageCache().remove(CACHEKEY_NOT_IMPORT_FORMULA_MESSAGE);
                } else if (this.getTemplateId() == 0L) {
                    errorStrs.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7248\u672c\u4e3a\u3010%2$s\u3011\u7684%3$s\u6a21\u677f\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, versionNumber, this.getMyprefixTips()));
                }
            });
        }
        if (!dynamicObjectList.isEmpty()) {
            dynamicObjectList.forEach(dyo -> CommonSqlMsgUtil.modifi((DynamicObject)dyo));
            if (this.getMyTemplateOrgId() != 0L) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
            } else {
                SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
            }
            TemplateServiceHelper.removeTemplateModelCacheByIds((Object)this.getModelId(), (Object[])ids.toArray());
        }
        if (!successStrs.isEmpty()) {
            this.getPageCache().put(CACHEKEY_UPDATE_FORMULA, "true");
        }
        this.showResult(errorStrs, successStrs);
    }

    private SpreadManager getNewMyTemplateCellFormulas(DynamicObject tem) {
        long modelId = this.getFormCustomParam("modelid", 0L);
        SpreadManager dataSm = JsonSerializerUtil.toSpreadManager((String)tem.getString("data"));
        if (NewMyTemplateUtil.repairCellIdForSm(dataSm)) {
            SpreadManager rptDataSm = JsonSerializerUtil.toSpreadManager((String)tem.getString("rptdata"));
            NewMyTemplateUtil.repairCellIdForSm(rptDataSm);
            tem.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)rptDataSm));
            tem.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)dataSm));
            BusinessDataWriter.update((IDataEntityType)tem.getDataEntityType(), (Object[])new Object[]{tem});
        }
        SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)dataSm, (long)modelId, (long)this.getTemplateId(), (long)this.getMyTemplateOrgId(), (boolean)false);
        return dataSm;
    }

    private boolean isNewMyTemplate() {
        return ConfigServiceHelper.getBoolParam((Long)this.getFormCustomParam("modelid", 0L), (String)"isSupportNewMytemplate");
    }

    private void showResult(List<String> errorStrs, List<String> successStrs) {
        StringBuilder message = new StringBuilder();
        String msg = "";
        boolean isFromEditTemplate = this.getTemplateId() != 0L;
        String str = isFromEditTemplate ? ResManager.loadKDString((String)"\u5f53\u524d", (String)"TemplateImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : "";
        boolean flag = true;
        if (errorStrs.isEmpty() && successStrs.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u4f46\u65e0\u5185\u5bb9\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u4e2d\u7684\u6a21\u677f\u7f16\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"TemplateImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (errorStrs.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), str);
            flag = false;
        } else if (successStrs.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"%1$s\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\uff0c%2$s\u4e0b\u8f7d\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u65e5\u5fd7\u3002", (String)"TemplateImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), str, "#{0}");
            errorStrs.forEach(error -> {
                message.append((String)error);
                message.append("\n");
            });
        } else {
            msg = String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u90e8\u5206\u6210\u529f\uff0c%2$s\u4e0b\u8f7d\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u65e5\u5fd7\u3002", (String)"TemplateImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), str, "#{0}");
            errorStrs.forEach(error -> {
                message.append((String)error);
                message.append("\n");
            });
        }
        ArrayList<MessageBoxLink> msgLinkList = new ArrayList<MessageBoxLink>();
        MessageBoxLink msgLink = new MessageBoxLink();
        msgLink.setText(ResManager.loadKDString((String)"\u70b9\u51fb\u6b64\u5904", (String)"TemplateImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        msgLink.setValue(CONFIRM_CLICKTHIS);
        msgLinkList.add(msgLink);
        this.getView().showConfirm(msg, msgLinkList, MessageBoxOptions.OK, ConfirmTypes.Wait, new ConfirmCallBackListener(CALLBACK_SHOW_ERROR_DETAIL, (IFormPlugin)this));
        if (flag) {
            this.getPageCache().put(CALLBACK_SHOW_ERROR_DETAIL, message.toString());
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6a21\u677f\u516c\u5f0f\u5bfc\u5165", "TemplateImportPlugin_27", "fi-bcm-formplugin", "Formula Import"), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        } else {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6a21\u677f\u516c\u5f0f\u5bfc\u5165", "TemplateImportPlugin_27", "fi-bcm-formplugin", "Formula Import"), OPDescMultiLangEnumBridge.genUnTransBridge((String)msg));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (CALLBACK_SHOW_ERROR_DETAIL.equals(callBackId) && MessageBoxResult.CUSTOM == e.getResult() && CONFIRM_CLICKTHIS.equals(e.getCustomVaule()) && this.getPageCache().get(CALLBACK_SHOW_ERROR_DETAIL) != null) {
            String message = this.getPageCache().get(CALLBACK_SHOW_ERROR_DETAIL);
            try {
                TemplateExportPlugin exportor = new TemplateExportPlugin();
                String url = exportor.exportFailLog(message, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u9519\u8bef\u65e5\u5fd7_%s", (String)"TemplateImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), exportor.getTimeStamp()));
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    this.downloadFile(url, "bcm_templatelist", "4715a0df000000ac");
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"TemplateImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().remove(CALLBACK_SHOW_ERROR_DETAIL);
        }
        if (this.getPageCache().get(CACHEKEY_UPDATE_FORMULA) != null) {
            this.returnDataToParent(true);
            this.getPageCache().remove(CACHEKEY_UPDATE_FORMULA);
        }
        this.getView().close();
    }

    private DynamicObject getOrgRptDyo() {
        int version = ModelDataProvider.getTemplateModel(this.getTemplateId()).getVersionNumber().intValue();
        long modelId = (Long)this.getFormCustomParam("modelid");
        QFilter versionfilter = new QFilter("version", ">", (Object)(version * 100)).and("version", "<", (Object)((version + 1) * 100));
        QFilter filter = new QFilter("template", "=", (Object)this.getTemplateId()).and("org", "=", (Object)this.getMyTemplateOrgId()).and("model", "=", (Object)modelId).and("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bcm_orgrpttemplate", (String)"spreadjson,data,modifier,modifytime,creator,createtime,isorgrpt, isupdate", (QFilter[])new QFilter[]{filter, versionfilter});
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_orgrpttemplate");
            obj.set("model", (Object)modelId);
            obj.set("template", (Object)this.getTemplateId());
            obj.set("org", (Object)this.getMyTemplateOrgId());
            obj.set("status", (Object)1);
            obj.set("version", (Object)(version * 100 + 1));
            obj.set("isupdate", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
            CommonSqlMsgUtil.create((DynamicObject)obj);
        } else if (obj.get("creator") == null || obj.get("creator") == "0") {
            CommonSqlMsgUtil.create((DynamicObject)obj);
        }
        obj.set("isorgrpt", (Object)1);
        return obj;
    }

    private void saveNewMyTemplate(SpreadManager sm) {
        long modelId = (Long)this.getFormCustomParam("modelid");
        String orgNumber = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)this.getMyTemplateOrgId()).getNumber();
        NewMyTemplateUtil.saveMyTemplateDyos(modelId, this.getTemplateId(), orgNumber, sm, true);
    }

    private SpreadManager updateSpreadManager(SpreadManager sm, Map<String, String> formulas, boolean isUpdate, boolean isRpt, long templateId) {
        HashMap delFormulas = new HashMap(16);
        if (!isUpdate && !isRpt) {
            sm.getBook().getSheet(0).iteratorCells(cell -> {
                if (cell.hasFormula() && !cell.isLock()) {
                    cell.setFormula(null);
                    String key = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
                    if (formulas.get(key) == null) {
                        delFormulas.put(key, null);
                    }
                }
            });
        }
        if (!isRpt) {
            TemplateEntryFormulaCheck formulaCheck = new TemplateEntryFormulaCheck(ModelDataProvider.getTemplateModel(templateId), sm);
            formulaCheck.checkFormulaForImport(formulas);
            sm = formulaCheck.getSm();
            this.getPageCache().put(CACHEKEY_NOT_IMPORT_FORMULA_MESSAGE, formulaCheck.getTips().toString());
        } else if (!formulas.isEmpty()) {
            for (Map.Entry<String, String> entry : formulas.entrySet()) {
                Point point = ExcelUtils.pos2Point((String)entry.getKey());
                Cell cell2 = sm.getBook().getSheet(0).getCell(point.y, point.x);
                cell2.setValue((Object)0);
                cell2.setFormula(entry.getValue());
            }
        }
        if (!delFormulas.isEmpty()) {
            formulas.putAll(delFormulas);
        }
        return sm;
    }

    private JSONObject updateJson(SpreadManager sm, String json, Map<String, String> formulas) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)json) && !formulas.isEmpty()) {
            JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)json));
            JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)object, (String)sm.getBook().getSheet(0).getSheetName());
            formulas.forEach((k, f) -> {
                JSONObject cell;
                Point point = ExcelUtils.pos2Point((String)k);
                JSONObject rowObject = (JSONObject)dataTable.get((Object)(point.y + ""));
                if (rowObject == null) {
                    rowObject = new JSONObject();
                    dataTable.put(point.y + "", (Object)rowObject);
                }
                if ((cell = (JSONObject)rowObject.get((Object)(point.x + ""))) == null) {
                    cell = new JSONObject();
                    rowObject.put(point.x + "", (Object)cell);
                }
                cell.remove((Object)"value");
                if (kd.bos.util.StringUtils.isNotEmpty((String)f)) {
                    cell.put("formula", f);
                } else {
                    cell.remove((Object)"formula");
                }
            });
            return object;
        }
        return new JSONObject();
    }

    private String jsonToString(JSONObject object) {
        return "base64" + new String(Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString())));
    }

    private String genKey(String number, String versionNumber) {
        BigDecimal version = this.getTemplateVersion(versionNumber);
        return number + "|_|" + String.format("V%.1f", Float.valueOf(version.floatValue()));
    }

    private void writeErrorLog(boolean isImportFormula) {
        Long modelId = (Long)this.getFormCustomParam("modelid");
        OperationLogUtil.writeOperationLog((String)OpItemEnum.IMPORT.getName(), (String)(isImportFormula ? ResManager.loadKDString((String)"\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : OpItemEnum.IMPORT.getName() + ResultStatusEnum.FAIL.getName()), (Long)modelId, (String)"bcm_templateimport");
    }

    private String getValueForKey(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Map<String, DynamicObject> checkAndPrepareData(List<Map<String, Object>> list) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        Long modelId = (Long)this.getFormCustomParam("modelid");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        QFilter templateFilter = null;
        for (Map<String, Object> map : list) {
            String number = this.getValueForKey(map, TemplateExportPlugin.TC_SIGN);
            String versionNumber = this.getValueForKey(map, TemplateExportPlugin.V_SIGN);
            if (kd.bos.util.StringUtils.isEmpty((String)number) || kd.bos.util.StringUtils.isEmpty((String)versionNumber) || Pattern.matches("([0-9]+)", versionNumber)) {
                this.writeErrorLog(true);
                throw new KDBizException(ResManager.loadKDString((String)"yaml\u6587\u4ef6\u4e2d\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\u6216\u6a21\u677f\u7248\u672c\u4e0d\u5408\u6cd5\uff0c\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (!(map.get(TemplateExportPlugin.F_SIGN) instanceof Map)) {
                this.writeErrorLog(true);
                throw new KDBizException(ResManager.loadKDString((String)"yaml\u6587\u4ef6\u4e2d\u516c\u5f0f\u8bbe\u7f6e\u4e0d\u5408\u6cd5\uff0c\u6a21\u677f\u516c\u5f0f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter("number", "=", (Object)number);
            BigDecimal version = this.getTemplateVersion(versionNumber);
            qf.and("versionnumber", "=", (Object)version.intValue());
            if (templateFilter == null) {
                templateFilter = qf;
            } else {
                templateFilter.or(qf);
            }
            result.put(this.genKey(number, versionNumber), null);
        }
        if (templateFilter != null) {
            DynamicObject[] dynamicObjects;
            long templateId = this.getTemplateId();
            if (templateId != 0L) {
                templateFilter = new QFilter("id", "=", (Object)templateId);
            }
            if ((dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"id,number,versionnumber,data,rptdata,spreadjson,rptspreadjson,modifier,modifytime", (QFilter[])filter.and(templateFilter).toArray())).length != 0) {
                Arrays.stream(dynamicObjects).forEach(dyo -> result.put(dyo.getString("number") + "|_|" + String.format("V%.1f", Float.valueOf(((BigDecimal)dyo.get("versionnumber")).floatValue())), (DynamicObject)dyo));
            }
        }
        return result;
    }

    private BigDecimal getTemplateVersion(String versionNumber) {
        Pattern pattern = Pattern.compile("([0-9]+)");
        Matcher matcher = pattern.matcher(versionNumber);
        int version = 0;
        while (matcher.find() && (version = Integer.parseInt(matcher.group())) == 0) {
        }
        return new BigDecimal(version);
    }

    private String getStringFromInputStream(InputStream inputStream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"TemplateImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return writer.toString();
    }

    private boolean isNotSetRcDimForExtTemplate(TemplateModel templateModel) {
        if (templateModel.isSaveByDim()) {
            List areaRangeEntries = templateModel.getAreaRangeEntries();
            if (!areaRangeEntries.isEmpty()) {
                SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)templateModel.getData());
                Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
                if (!postionInfoSet.isEmpty() && postionInfoSet.stream().anyMatch(ps -> ps.getExtendInfo() != null)) {
                    return areaRangeEntries.stream().allMatch(areaRangeEntry -> areaRangeEntry.getRowDimEntries().isEmpty() && areaRangeEntry.getColDimEntries().isEmpty());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void handleInputStream(String str) {
        TemplateModel[] templateModels;
        try {
            templateModels = (TemplateModel[])ObjectSerialUtil.deSerializedBytes((String)str);
        }
        catch (Exception e) {
            this.writeErrorLog(false);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5", (String)"TemplateImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long modelId = (Long)this.getFormCustomParam("modelid");
        List<Object> passedTemplates = new ArrayList<TemplateModel>();
        HashMap<String, String> nopassedTemplates = new HashMap<String, String>();
        HashMap<String, String> nopassedLog = new HashMap<String, String>();
        for (TemplateModel tmplModel : templateModels) {
            if (tmplModel.isSaveByDim() && this.checkDimensionAndMemberNumber(tmplModel, nopassedTemplates, nopassedLog)) {
                try {
                    tmplModel.setModelId(modelId.longValue());
                    TemplateExtendModelRefUtil.singleCheckBeforeSave(tmplModel, null, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u62a5\u8868\u6a21\u677f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmplModel.getNumber()), new HashMap<String, Set<String>>(), null);
                    passedTemplates.add(tmplModel);
                }
                catch (Exception e) {
                    nopassedTemplates.put(tmplModel.getNumber(), e.getMessage());
                    nopassedLog.put(tmplModel.getNumber(), tmplModel.getName());
                }
            }
            if (tmplModel.isSaveByDim()) continue;
            passedTemplates.add(tmplModel);
        }
        if (!passedTemplates.isEmpty()) {
            Comparator<TemplateModel> numberComparator = Comparator.comparing(t -> t.getNumber());
            Comparator<TemplateModel> versionComparator = Comparator.comparing(t -> t.getVersionNumber());
            passedTemplates = passedTemplates.stream().sorted(numberComparator.thenComparing(versionComparator)).collect(Collectors.toList());
        }
        HashSet<String> adjustEffectivedateTmpl = new HashSet<String>();
        HashMap<String, Map<String, Map<String, List<IDimMember>>>> notExitMember = new HashMap<String, Map<String, Map<String, List<IDimMember>>>>(16);
        HashSet<String> unCheckEntityNums = new HashSet<String>(16);
        HashSet<String> orgDimProps = new HashSet<String>(16);
        if (passedTemplates.size() > 0) {
            Map<String, Map<String, Object>> tmplNeedFields = this.getNeedExchangeFields(modelId, passedTemplates.toArray(new TemplateModel[0]));
            ArrayList<TemplateModel> newtemplateModels = new ArrayList<TemplateModel>(10);
            HashMap<String, BigDecimal> templateMaxVersion = new HashMap<String, BigDecimal>(16);
            HashMap<String, Long> newGroupId = new HashMap<String, Long>();
            Map<String, DynamicObject> propertymap = this.getSysProperty(modelId);
            Map<String, DynamicObject> propertyValueDynamicObj = this.getPropertyValueDynamicObj(modelId);
            for (TemplateModel templateModel : passedTemplates) {
                newtemplateModels.add(this.replaceTemplateModel(templateModel, tmplNeedFields, templateMaxVersion, adjustEffectivedateTmpl, propertymap, propertyValueDynamicObj, newGroupId, notExitMember));
            }
            HashMap<Long, String> permclassMap = new HashMap<Long, String>(16);
            List<DynamicObject> list = this.dealUnCheckEntity(modelId, newtemplateModels, unCheckEntityNums, orgDimProps, permclassMap);
            try (TXHandle tx = TX.required((String)"template_import_save");){
                try {
                    if (!list.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                        this.setImportTemplatesDistribution(newtemplateModels, tmplNeedFields);
                        TemplateExtendModelRefUtil.batchSaveExtModelRefTemplate(newtemplateModels);
                        this.savePermClassData(modelId, permclassMap);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    log.error("--templateImportSave--:\n" + ThrowableHelper.toString((Throwable)e));
                    throw e;
                }
            }
        }
        this.writeImportLog(nopassedLog, passedTemplates, modelId);
        String needChangeMessage = "";
        if (!adjustEffectivedateTmpl.isEmpty()) {
            needChangeMessage = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6a21\u677f\u9700\u8981\u7ef4\u62a4\u5bfc\u5165\u751f\u6210\u7684\u65b0\u7248\u672c\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u70b9\u51fb\u7248\u672c\u5316\u6309\u94ae\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"TemplateImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", adjustEffectivedateTmpl.toArray(new String[0])));
        }
        if (!notExitMember.isEmpty()) {
            needChangeMessage = needChangeMessage + TemplateFloatUtil.getTipsForNotExitMember(notExitMember, true);
        }
        boolean entityNotExit = CollectionUtils.isNotEmpty(unCheckEntityNums);
        boolean orgDimProNotExit = CollectionUtils.isNotEmpty(orgDimProps);
        if (entityNotExit || orgDimProNotExit) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)needChangeMessage)) {
                needChangeMessage = needChangeMessage + "\n";
            }
            if (entityNotExit) {
                needChangeMessage = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u4e0d\u5b58\u5728\uff0c", (String)"TemplateImportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), needChangeMessage, unCheckEntityNums);
            }
            if (orgDimProNotExit) {
                needChangeMessage = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7ef4\u5ea6\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c%2$s\u4e0d\u5b58\u5728\uff0c", (String)"TemplateImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), needChangeMessage, orgDimProps);
            }
            needChangeMessage = String.format(ResManager.loadKDString((String)"%s\u62a5\u8868\u4e0e\u603b\u8d26\u8d26\u7c3f\u7684\u72b6\u6001\u6821\u9a8c-\u4f8b\u5916\u7ec4\u7ec7\u8bbe\u7f6e\u8df3\u8fc7\u4ee5\u4e0a\u6210\u5458\u3002", (String)"TemplateImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), needChangeMessage);
        }
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u5982\u4e0b:", (String)"TemplateImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        message.append("\n");
        for (Map.Entry entry : nopassedTemplates.entrySet()) {
            String key = (String)entry.getKey();
            message.append(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f", (String)"TemplateImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(key).append(':').append((String)entry.getValue()).append("\n");
        }
        if (nopassedTemplates.size() == 0 && passedTemplates.size() > 0) {
            if (kd.bos.util.StringUtils.isEmpty((String)needChangeMessage)) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), needChangeMessage, null);
        } else if (nopassedTemplates.size() > 0 && passedTemplates.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6210\u529f\u4e2a\u6570\uff1a%1$s \u5931\u8d25\u4e2a\u6570\uff1a%2$s %3$s%4$s %5$s%6$s", (String)"TemplateImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), passedTemplates.size(), nopassedTemplates.size(), "\n", needChangeMessage, "\n", message), null);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message.toString(), null);
        }
    }

    private List<DynamicObject> dealUnCheckEntity(long modelId, List<TemplateModel> newtemplateModels, Set<String> unCheckEntityNums, Set<String> orgDimProps, Map<Long, String> permclassMap) {
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)PresetConstant.ENTITY_DIM);
        DimPropList dimPropList = DimPropList.getDimPropList((long)dimensionId);
        ArrayList<DynamicObject> successTemplates = new ArrayList<DynamicObject>(16);
        newtemplateModels.forEach(model -> {
            String unCheckEntity = model.getUnCheckEntity();
            if (kd.bos.util.StringUtils.isNotEmpty((String)unCheckEntity)) {
                List result = TemplateUtil.getLegalSelectOrgs((long)modelId, (DimPropList)dimPropList, (String)unCheckEntity, (Set)unCheckEntityNums, (Set)orgDimProps);
                if (CollectionUtils.isNotEmpty((Collection)result)) {
                    model.setUnCheckEntity(JSON.toJSONString((Object)result));
                } else {
                    model.setUnCheckEntity("");
                }
            }
            DynamicObject t = model.genDynamicObject();
            successTemplates.add(t);
            if (model.getPermClass() instanceof DynamicObject) {
                permclassMap.put(t.getLong("id"), ((DynamicObject)model.getPermClass()).getString("number"));
            }
        });
        return successTemplates;
    }

    private void savePermClassData(Long modelId, Map<Long, String> permclassMap) {
        if (permclassMap.isEmpty()) {
            return;
        }
        Map<String, Long> permClassData = this.collectPermClassData(modelId);
        if (permClassData.isEmpty()) {
            return;
        }
        ArrayList dyos = new ArrayList(16);
        permclassMap.forEach((k, v) -> {
            if (permClassData.get(v) != null) {
                DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                entity.set("entityname", (Object)"bcm_templateentity");
                entity.set("model", (Object)modelId);
                entity.set("entityid", k);
                entity.set("permclass", permClassData.get(v));
                dyos.add(entity);
            }
        });
        SaveServiceHelper.save((DynamicObject[])dyos.toArray(new DynamicObject[0]));
    }

    private Map<String, Long> collectPermClassData(Long modelId) {
        HashMap<String, Long> permclassDyos = new HashMap<String, Long>(16);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_permissionclass", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            objects.forEach(e -> permclassDyos.put(e.getString("number"), e.getLong("id")));
        }
        return permclassDyos;
    }

    private void writeImportLog(Map<String, String> nopassedLog, List<TemplateModel> passedTemplates, Long modelId) {
        StringBuilder failLog = new StringBuilder();
        if (nopassedLog != null && nopassedLog.size() > 0) {
            Set<Map.Entry<String, String>> entries = nopassedLog.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                failLog.append(entry.getKey());
                failLog.append(" ");
                failLog.append(entry.getValue());
                failLog.append(" ");
            }
            failLog.append(", ");
            failLog.append(OpItemEnum.IMPORT.getName());
            failLog.append(ResultStatusEnum.FAIL.getName());
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.IMPORT.getName(), (String)failLog.toString(), (Long)modelId);
        }
        StringBuilder succLog = new StringBuilder();
        if (passedTemplates != null && passedTemplates.size() > 0) {
            for (TemplateModel templatemodel : passedTemplates) {
                succLog.append(templatemodel.getNumber());
                succLog.append(" ");
                succLog.append(templatemodel.getName());
                succLog.append(" ");
            }
            succLog.append(", ");
            succLog.append(OpItemEnum.IMPORT.getName());
            succLog.append(ResultStatusEnum.SUCCESS.getName());
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.IMPORT.getName(), (String)succLog.toString(), (Long)modelId);
        }
    }

    private void setImportTemplatesDistribution(List<TemplateModel> newtemplateModels, Map<String, Map<String, Object>> tmplNeedFields) {
        ArrayList<DynamicObject> toSaveList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> toSaveList1 = new ArrayList<DynamicObject>();
        Long modelId = (Long)this.getFormCustomParam("modelid");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        boolean flag = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM016");
        for (TemplateModel newtemplate : newtemplateModels) {
            Map<String, Object> map1 = tmplNeedFields.get(newtemplate.getNumber());
            if (map1 != null && map1.get("isExit") != null) {
                DynamicObject[] dyns;
                QFBuilder qf = new QFBuilder("model", "=", (Object)newtemplate.getModelId());
                qf.add("template.number", "=", (Object)newtemplate.getNumber());
                qf.add("template.id", "=", map1.get("id"));
                for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"bcm_distributionentity", (String)"id, model, entity, template, memrangdecombo, definedproperty, definedpropertyvalue, textname,effectway", (QFilter[])qf.toArray())) {
                    DynamicObject newDy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyn, (boolean)true, (boolean)true);
                    long id = GlobalIdUtil.genGlobalLongId();
                    newDy.set("id", (Object)id);
                    newDy.set("template", newtemplate.get("id"));
                    newDy.set("template_id", newtemplate.get("id"));
                    toSaveList.add(newDy);
                }
                continue;
            }
            if (!flag || newtemplate.isSaveByDim()) continue;
            IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)"Entity");
            DynamicObject dd = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionentity");
            dd.set("model", (Object)modelId);
            dd.set("template", (Object)newtemplate.getId());
            dd.set("entity", (Object)numberTreeNode.getId());
            dd.set("memrangdecombo", (Object)RangeEnum.VALUE_40.getValue());
            dd.set("effectway", (Object)DisEffectWayEnum.APPLY.getIndex());
            dd.set("textname", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"MultiViewTemplateProcess_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            toSaveList1.add(dd);
        }
        SaveServiceHelper.save((DynamicObject[])toSaveList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])toSaveList1.toArray(new DynamicObject[0]));
    }

    private List<String> collectDimAndMemForFilterDim(TemplateModel template, Map<String, Set<String>> dimensionAndMembers, Map<String, Set<String>> propertys, Map<String, Set<String>> propertyvalue) {
        ArrayList<String> filterDims = new ArrayList<String>(16);
        template.getFilterDimensionEntries().forEach(filterDimensionEntry -> {
            String dimNumber = filterDimensionEntry.getDimension().getNumber();
            HashSet propertyset = new HashSet(16);
            HashSet dimMembers = new HashSet(16);
            HashSet propertyvalueset = new HashSet(16);
            filterDims.add(dimNumber);
            filterDimensionEntry.getMembers().forEach(filterDimMember -> {
                if (filterDimMember.isCustom()) {
                    MembProperty membProperty = filterDimMember.getMembProperty();
                    CustomProperty customProperty = membProperty.getCustomProperty();
                    propertyset.add(customProperty.getNumber());
                    propertyvalueset.add(membProperty.getNumber());
                } else {
                    dimMembers.add(filterDimMember.getNumber());
                }
            });
            if (!dimMembers.isEmpty()) {
                dimensionAndMembers.put(dimNumber, dimMembers);
            } else if (!propertyset.isEmpty() && !propertyvalueset.isEmpty()) {
                propertys.put(dimNumber, propertyset);
                propertyvalue.put(dimNumber, propertyvalueset);
            }
        });
        return filterDims;
    }

    private void collectDimAndMemForPageAndView(TemplateModel template, Map<String, Set<String>> dimensionAndMembers, Map<String, Set<String>> propertys, Map<String, Set<String>> propertyvalue) {
        template.getViewPointDimensionEntries().forEach(v -> {
            HashSet<String> dimMembers = new HashSet<String>(16);
            dimMembers.add(v.getMember().getNumber());
            String dimNum = v.getDimension().getNumber();
            dimensionAndMembers.put(dimNum, dimMembers);
        });
        template.getPageDimensionEntries().forEach(p -> {
            HashSet dimMembers = new HashSet(16);
            p.getMembers().forEach(member -> dimMembers.add(member.getNumber()));
            String dimNum = p.getDimension().getNumber();
            dimensionAndMembers.put(dimNum, dimMembers);
        });
        template.getPagePropEntries().forEach(p -> {
            HashSet propertyset = new HashSet(16);
            String dimNum = p.getDimension().getNumber();
            dimensionAndMembers.put(dimNum, new HashSet(16));
            p.getCustomProperties().forEach(custom -> propertyset.add(custom.getNumber()));
            propertys.put(dimNum, propertyset);
            HashSet propertyvalueset = new HashSet(16);
            p.getAllMembProperties().forEach(membproperty -> propertyvalueset.add(membproperty.getNumber()));
            propertyvalue.put(dimNum, propertyvalueset);
        });
    }

    private void collectDimAndMemForRowCol(MembSettingBaseDetail msbd, Map<String, Set<String>> dimensionAndMembers, List<String> filterDims) {
        String dimNum = msbd.getDimension().getNumber();
        Set<String> dimMembers = dimensionAndMembers.get(dimNum) != null ? dimensionAndMembers.get(dimNum) : new HashSet<String>(16);
        if (msbd.getMembers() != null) {
            msbd.getMembers().forEach(member -> {
                String memNum = member.getNumber();
                if (!filterDims.contains(dimNum) || !SystemVarsEnum.CURRENT.getNumber().equals(memNum)) {
                    dimMembers.add(memNum);
                }
            });
        }
        dimensionAndMembers.put(dimNum, dimMembers);
    }

    private boolean checkDimensionAndMemberNumber(TemplateModel template, Map<String, String> nopassedTemplates, Map<String, String> nopassedLog) {
        Set value;
        String k;
        boolean isNeedCheckDims;
        HashMap<String, Set<String>> dimensionAndMembers = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> propertys = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> propertyvalue = new HashMap<String, Set<String>>(16);
        ArrayList moreExitDims = new ArrayList(16);
        long modelId = (Long)this.getFormCustomParam("modelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Map shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        HashSet notExitDims = new HashSet(shortNumber2NumberMap.values());
        this.collectDimAndMemForPageAndView(template, dimensionAndMembers, propertys, propertyvalue);
        List<String> filterDims = this.collectDimAndMemForFilterDim(template, dimensionAndMembers, propertys, propertyvalue);
        template.getAreaRangeEntries().forEach(area -> {
            area.getColDimEntries().forEach(c -> this.collectDimAndMemForRowCol((MembSettingBaseDetail)c, dimensionAndMembers, filterDims));
            area.getRowDimEntries().forEach(c -> this.collectDimAndMemForRowCol((MembSettingBaseDetail)c, dimensionAndMembers, filterDims));
        });
        boolean notSetRcDimForExtTemplate = this.isNotSetRcDimForExtTemplate(template);
        StringBuilder nopassedMessage = new StringBuilder();
        Set dimensions = dimensionAndMembers.keySet();
        dimensions.forEach(dim -> {
            if (!notExitDims.remove(dim)) {
                moreExitDims.add(dim);
            }
        });
        boolean bl = isNeedCheckDims = template.isSaveByDim() && !notSetRcDimForExtTemplate;
        if (!notExitDims.isEmpty() && isNeedCheckDims) {
            nopassedMessage.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u7f3a\u5c11\u7ef4\u5ea6\uff1a%s\u3002", (String)"TemplateImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Object)notExitDims).toString()));
        }
        if (!moreExitDims.isEmpty() && isNeedCheckDims) {
            nopassedMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff1a%s\u3002", (String)"TemplateImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Object)moreExitDims).toString()));
        }
        for (Map.Entry entry : dimensionAndMembers.entrySet()) {
            String k2 = (String)entry.getKey();
            Set value2 = (Set)entry.getValue();
            if (moreExitDims.contains(k2)) continue;
            value2.removeIf(v -> {
                IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)k2, (String)v);
                return memberByNumber != IDNumberTreeNode.NotFoundTreeNode;
            });
            if (!CollectionUtils.isNotEmpty((Collection)value2)) continue;
            nopassedMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458\u201c%2$s\u201d\u3002", (String)"TemplateImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k2, value2));
        }
        if (!propertys.isEmpty()) {
            boolean hasProp = false;
            for (Map.Entry entry : propertys.entrySet()) {
                Set<String> dimensionProp;
                k = (String)entry.getKey();
                value = (Set)entry.getValue();
                if (moreExitDims.contains(k) || !CollectionUtils.isNotEmpty(dimensionProp = this.cacheDimensionCustomProperty(modelNum, k))) continue;
                hasProp = true;
                if (dimensionProp.containsAll(value)) continue;
                nopassedMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u201c%2$s\u201d\u3002", (String)"TemplateImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k, CollectionUtils.subtract((Collection)value, dimensionProp)));
            }
            if (!hasProp) {
                nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"TemplateImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!propertyvalue.isEmpty()) {
            boolean hasProp = false;
            for (Map.Entry entry : propertyvalue.entrySet()) {
                k = (String)entry.getKey();
                value = (Set)entry.getValue();
                List<String> members = this.cacheDimensionCustomPropertyMember(modelNum, k);
                if (!CollectionUtils.isNotEmpty(members)) continue;
                hasProp = true;
                if (members.containsAll(value)) continue;
                nopassedMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u201c%2$s\u201d\u3002", (String)"TemplateImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k, CollectionUtils.subtract((Collection)value, members)));
            }
            if (!hasProp) {
                nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u3002", (String)"TemplateImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (nopassedMessage.length() > 0) {
            int index = nopassedMessage.lastIndexOf("\uff1b");
            if (index > -1) {
                nopassedMessage.deleteCharAt(index);
                nopassedMessage.append("\u3002");
            }
            nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
            nopassedLog.put(template.getNumber(), template.getName());
            return false;
        }
        return true;
    }

    private TemplateModel replaceTemplateModel(TemplateModel templateModel, Map<String, Map<String, Object>> tmplNeedFields, Map<String, BigDecimal> maxversion, Set<String> adjustEffectivedateTmpl, Map<String, DynamicObject> propertymap, Map<String, DynamicObject> propertyValueDynamicObj, Map<String, Long> newGroupId, Map<String, Map<String, Map<String, List<IDimMember>>>> notExitMember) {
        TemplateModel newTemplateModel = new TemplateModel();
        String number = templateModel.getNumber();
        Map<String, Object> currentlist = tmplNeedFields.get(number);
        boolean nohistryTemplate = currentlist == null;
        newTemplateModel.setId(GlobalIdUtil.genGlobalLongId());
        newTemplateModel.setModelId(((Long)this.getFormCustomParam("modelid")).longValue());
        newTemplateModel.setNumber(templateModel.getNumber());
        newTemplateModel.setName(templateModel.getName());
        newTemplateModel.setSpreadJson(templateModel.getSpreadJson());
        boolean isForWeave = !TemplateExtendModelRefUtil.isOnlyReadOrQueryTm(templateModel);
        newTemplateModel.setData(this.getData(templateModel.getData(), notExitMember, templateModel.getNumber(), isForWeave));
        newTemplateModel.setRptData(this.getData(templateModel.getRptData(), null, templateModel.getNumber(), isForWeave));
        newTemplateModel.setRptSpreadJson(templateModel.getRptSpreadJson());
        newTemplateModel.setCreateOrgId(this.getOrgId());
        newTemplateModel.setUsage(templateModel.getUsage());
        newTemplateModel.setDataUnit(templateModel.getDataUnit());
        newTemplateModel.setIsOnlyRead(templateModel.getIsOnlyRead());
        newTemplateModel.setTemplateType(templateModel.getTemplateType().intValue());
        newTemplateModel.setVarBase(templateModel.getVarBase());
        newTemplateModel.setVarJson(templateModel.getVarJson());
        newTemplateModel.setIsOldTemplate(templateModel.isOldTemplate());
        newTemplateModel.setIsFinTemplate(templateModel.isFinTemplate());
        newTemplateModel.setCreateTime(TimeServiceHelper.now());
        newTemplateModel.setCreatorId(this.getUserId());
        newTemplateModel.setModifierId(this.getUserId());
        newTemplateModel.setModifyTime(TimeServiceHelper.now());
        newTemplateModel.setVersionStatus(templateModel.getVersionStatus());
        newTemplateModel.setDescription(templateModel.getDescription());
        newTemplateModel.setSaveByDim(templateModel.isSaveByDim());
        newTemplateModel.setTemplateCatalog(nohistryTemplate ? this.getTmplCatalog(Long.valueOf((String)this.getFormCustomParam("templatecatalog"))) : this.getTmplCatalog((Long)currentlist.get("templatecatalog")));
        newTemplateModel.setEffectiveDate(nohistryTemplate ? EntityVersioningUtil.getModelBeginDate((Object)((Long)this.getFormCustomParam("modelid"))) : null);
        if (!nohistryTemplate) {
            newTemplateModel.setSequence(((Integer)currentlist.get("sequence")).intValue());
            adjustEffectivedateTmpl.add(templateModel.getNumber());
        } else {
            newTemplateModel.setSequence(templateModel.getSequence() == null ? 0 : templateModel.getSequence());
        }
        BigDecimal max = maxversion.get(templateModel.getNumber());
        BigDecimal versionnumber = nohistryTemplate ? new BigDecimal(1) : (max == null ? ((BigDecimal)currentlist.get("versionnumber")).add(new BigDecimal(1)) : max.add(new BigDecimal(1)));
        maxversion.put(templateModel.getNumber(), versionnumber);
        newTemplateModel.setVersionNumber(versionnumber);
        if (newGroupId.get(templateModel.getNumber()) == null) {
            newGroupId.put(templateModel.getNumber(), nohistryTemplate ? Long.valueOf(GlobalIdUtil.genGlobalLongId()) : (Long)currentlist.get("group"));
        }
        newTemplateModel.setGroup(newGroupId.get(templateModel.getNumber()).longValue());
        newTemplateModel.setStatus("0");
        newTemplateModel.setVersionDescription(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u751f\u6210\u3002%s", (String)"TemplateImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), templateModel.get("versiondescription") == null ? "" : templateModel.get("versiondescription")));
        newTemplateModel.setExpiringDate(null);
        if (currentlist == null) {
            currentlist = new HashMap<String, Object>(16);
            currentlist.put("versionnumber", newTemplateModel.getVersionNumber());
            currentlist.put("templatecatalog", newTemplateModel.getTemplateCatalog().getId());
            currentlist.put("group", newTemplateModel.getGroup());
            currentlist.put("sequence", newTemplateModel.getSequence());
            tmplNeedFields.put(number, currentlist);
        } else {
            currentlist.put("versionnumber", newTemplateModel.getVersionNumber());
        }
        this.intPageAndViewDimension(templateModel, newTemplateModel, propertymap, propertyValueDynamicObj);
        this.initRowColDimension(templateModel, newTemplateModel);
        newTemplateModel.setPermClass(templateModel.getPermClass());
        newTemplateModel.setAllowaddic(templateModel.isAllowaddic());
        newTemplateModel.setAutoCalculate(templateModel.isAutoCalculate());
        newTemplateModel.setAccountreclass(templateModel.getAccountreclass());
        boolean isCheckStatus = templateModel.getIsCheckStatus();
        if (isCheckStatus) {
            newTemplateModel.setIsCheckStatus(isCheckStatus);
            newTemplateModel.setUnCheckEntity(templateModel.getUnCheckEntity());
        } else {
            newTemplateModel.setIsCheckStatus(false);
        }
        return newTemplateModel;
    }

    private void initRowColDimension(TemplateModel templateModel, TemplateModel newTemplateModel) {
        long modelId = (Long)this.getFormCustomParam("modelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        List areaRangeEntryList = templateModel.getAreaRangeEntries();
        for (AreaRangeEntry area : areaRangeEntryList) {
            DynamicObject entryrow;
            AreaRangeEntry newAreaRangeEntry = new AreaRangeEntry(newTemplateModel);
            newAreaRangeEntry.setAreaRange(area.getAreaRange());
            newAreaRangeEntry.setStartPosition(area.getStartPosition());
            newAreaRangeEntry.setSeq(area.getSeq());
            List colDimensionEntryList = area.getColDimEntries();
            DynamicObjectCollection colsEntry = new DynamicObjectCollection();
            for (ColDimensionEntry colEntry : colDimensionEntryList) {
                List members = colEntry.getMembers();
                AtomicInteger incrementer = new AtomicInteger(1);
                DynamicObject col = colEntry.genDynamicObject();
                DynamicObject dimDy = this.cacheDimDy(modelId, colEntry.getDimension().getNumber());
                if (members.size() == 0) {
                    DynamicObject entryrow2 = new DynamicObject(col.getDynamicObjectType());
                    entryrow2.set("colmembid", (Object)"");
                    entryrow2.set("coldimension", (Object)dimDy);
                    entryrow2.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow2.set("colgroup", col.get("colgroup"));
                    entryrow2.set("header", col.get("header"));
                    entryrow2.set("colindex", col.get("colindex"));
                    entryrow2.set("displaychild", col.get("displaychild"));
                    colsEntry.add((Object)entryrow2);
                    continue;
                }
                if (dimDy == null) continue;
                for (Member member : members) {
                    entryrow = new DynamicObject(col.getDynamicObjectType());
                    entryrow.set("coldimension", (Object)dimDy);
                    entryrow.set("colmembid", (Object)this.cacheDimensionMemberNode(modelNum, dimDy.getString("number"), member.getNumber()).getId());
                    entryrow.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow.set("colgroup", col.get("colgroup"));
                    entryrow.set("header", col.get("header"));
                    entryrow.set("colindex", col.get("colindex"));
                    entryrow.set("displaychild", col.get("displaychild"));
                    colsEntry.add((Object)entryrow);
                }
            }
            newAreaRangeEntry.getColDimEntries().addAll(new ColDimensionEntry(newAreaRangeEntry).loadDynaObject(colsEntry, () -> newAreaRangeEntry));
            List rowDimensionEntryList = area.getRowDimEntries();
            DynamicObjectCollection rowsEntry = new DynamicObjectCollection();
            for (RowDimensionEntry rowEntry : rowDimensionEntryList) {
                List members = rowEntry.getMembers();
                AtomicInteger incrementer = new AtomicInteger(1);
                DynamicObject row = rowEntry.genDynamicObject();
                DynamicObject rowDimDy = this.cacheDimDy(modelId, rowEntry.getDimension().getNumber());
                if (members.size() == 0) {
                    entryrow = new DynamicObject(row.getDynamicObjectType());
                    entryrow.set("rowmembid", (Object)"");
                    entryrow.set("rowdimension", (Object)rowDimDy);
                    entryrow.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow.set("rowmembscope", row.get("rowmembscope"));
                    rowsEntry.add((Object)entryrow);
                    continue;
                }
                if (rowDimDy == null) continue;
                for (Member member : members) {
                    DynamicObject entryrow3 = new DynamicObject(row.getDynamicObjectType());
                    entryrow3.set("rowdimension", (Object)rowDimDy);
                    entryrow3.set("rowmembid", (Object)this.cacheDimensionMemberNode(modelNum, rowDimDy.getString("number"), member.getNumber()).getId());
                    entryrow3.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow3.set("rowmembscope", member.get("scope"));
                    rowsEntry.add((Object)entryrow3);
                }
            }
            newAreaRangeEntry.getRowDimEntries().addAll(new RowDimensionEntry(newAreaRangeEntry).loadDynaObject(rowsEntry, () -> newAreaRangeEntry));
            newTemplateModel.getAreaRangeEntries().add(newAreaRangeEntry);
        }
    }

    private IDNumberTreeNode cacheDimensionMemberNode(String modelNum, String dimNum, String memberNum) {
        return (IDNumberTreeNode)ThreadCache.get((Object)String.format("%s|%s|%s", modelNum, dimNum, memberNum), () -> MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberNum));
    }

    private DynamicObject cacheDimDy(long modelId, String dimNum) {
        return (DynamicObject)ThreadCache.get((Object)String.format("%s|%s", modelId, dimNum), () -> {
            Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            if (dimId == null) {
                return null;
            }
            return MemberReader.getDimensionDynById((long)dimId);
        });
    }

    private Set<String> cacheDimensionCustomProperty(String modelNum, String dimNum) {
        return (Set)ThreadCache.get((Object)String.format("%s|%s|%s", "Custom", modelNum, dimNum), () -> MemberReader.getDimensionProp((String)modelNum, (String)dimNum));
    }

    private List<String> cacheDimensionCustomPropertyMember(String modelNum, String dimNum) {
        return (List)((Map)ThreadCache.get((Object)String.format("%s|%s|%s", "CustomMember", modelNum, dimNum), () -> {
            Collection values = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (String)modelNum).values();
            Map dimNum2PropertyMember = values.stream().collect(HashMap::new, (map, node) -> map.computeIfAbsent(node.getDimNumber(), key -> new ArrayList()).add(node.getNumber()), (map1, map2) -> map1.forEach((k, v) -> {
                if (map2.containsKey(k)) {
                    v.addAll((Collection)map2.get(k));
                }
            }));
            return dimNum2PropertyMember;
        })).get(dimNum);
    }

    private void intPageAndViewDimension(TemplateModel templateModel, TemplateModel newTemplateModel, Map<String, DynamicObject> propertymap, Map<String, DynamicObject> propertyValueDynamicObj) {
        Long modelId = (Long)this.getFormCustomParam("modelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (templateModel.isSaveByDim()) {
            List filterDimensionEntries;
            List viewpointMembEntryList = templateModel.getViewPointDimensionEntries();
            DynamicObjectCollection viewPointDimensionEntry = new DynamicObjectCollection();
            for (ViewPointDimensionEntry entry : viewpointMembEntryList) {
                DynamicObject dyn = entry.genDynamicObject();
                DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                DynamicObject dimDy = this.cacheDimDy(modelId, entry.getDimension().getNumber());
                if (dimDy == null) continue;
                entryRow.set("viewmembid", (Object)this.cacheDimensionMemberNode(modelNum, dimDy.getString("number"), entry.getMember().getNumber()).getId());
                entryRow.set("viewdimension", (Object)dimDy);
                entryRow.set("seq", dyn.get("seq"));
                viewPointDimensionEntry.add((Object)entryRow);
            }
            newTemplateModel.getViewPointDimensionEntries().addAll(new ViewPointDimensionEntry(newTemplateModel).loadDynaObject(viewPointDimensionEntry, () -> newTemplateModel));
            List pageMembEntryList = templateModel.getPageDimensionEntries();
            DynamicObjectCollection pageMembEntry = new DynamicObjectCollection();
            for (PageDimensionEntry entry : pageMembEntryList) {
                List members = entry.getMembers();
                DynamicObject dyn = entry.genDynamicObject();
                DynamicObject dimDy = this.cacheDimDy(modelId, entry.getDimension().getNumber());
                if (members.size() > 0) {
                    if (dimDy == null) continue;
                    Iterator iterator = members.iterator();
                    while (iterator.hasNext()) {
                        Member member = (Member)iterator.next();
                        DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                        entryRow.set("pagedimension", (Object)dimDy);
                        entryRow.set("pagemembid", (Object)this.cacheDimensionMemberNode(modelNum, dimDy.getString("number"), member.getNumber()).getId());
                        entryRow.set("seq", dyn.get("seq"));
                        entryRow.set("membbound", member.get("scope"));
                        pageMembEntry.add((Object)entryRow);
                    }
                    continue;
                }
                DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                if (dimDy == null) continue;
                entryRow.set("pagedimension", (Object)dimDy);
                entryRow.set("pagemembid", (Object)"");
                entryRow.set("seq", dyn.get("seq"));
                entryRow.set("membbound", dyn.get("membbound"));
                pageMembEntry.add((Object)entryRow);
            }
            newTemplateModel.getPageDimensionEntries().addAll(new PageDimensionEntry(newTemplateModel).loadDynaObject(pageMembEntry, () -> newTemplateModel));
            List pageDimPropEntryList = templateModel.getPagePropEntries();
            DynamicObjectCollection pageProEntry = new DynamicObjectCollection();
            for (PageDimPropEntry entry : pageDimPropEntryList) {
                DynamicObject dyn = entry.genDynamicObject();
                AtomicInteger incrementer = new AtomicInteger(1);
                String dimNum = entry.getDimension().getNumber();
                DynamicObject dimDy = this.cacheDimDy(modelId, dimNum);
                List membproperties = entry.getAllMembProperties();
                if (membproperties.size() <= 0) continue;
                for (MembProperty membproperty : membproperties) {
                    if (dimDy == null) continue;
                    DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                    entryRow.set("pagepropdim", (Object)dimDy);
                    entryRow.set("property", (Object)propertymap.get(this.getDefinePropertyKey(membproperty.getCustomProperty().getNumber(), dimNum)));
                    entryRow.set("seq", (Object)incrementer.getAndIncrement());
                    entryRow.set("membprop", (Object)propertyValueDynamicObj.get(this.getDefinePropertyKey(membproperty.getNumber(), dimNum)));
                    entryRow.set("propbound", (Object)membproperty.getScope());
                    pageProEntry.add((Object)entryRow);
                }
            }
            if (!pageProEntry.isEmpty()) {
                newTemplateModel.getPagePropEntries().addAll(new PageDimPropEntry(newTemplateModel).loadDynaObject(pageProEntry, () -> newTemplateModel));
            }
            if (!(filterDimensionEntries = templateModel.getFilterDimensionEntries()).isEmpty()) {
                DynamicObjectCollection filterDimEntry = new DynamicObjectCollection();
                filterDimensionEntries.forEach(filterDimensionEntry -> {
                    String dimNumber = filterDimensionEntry.getDimension().getNumber();
                    DynamicObject dyn = filterDimensionEntry.genDynamicObject();
                    List filterDimMemberList = filterDimensionEntry.getMembers();
                    filterDimMemberList.forEach(filterDimMember -> {
                        DynamicObject dimDy = this.cacheDimDy(modelId, dimNumber);
                        if (dimDy != null) {
                            DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                            entryRow.set("filterdimension", (Object)dimDy);
                            entryRow.set("seq", dyn.get("seq"));
                            if (filterDimMember.isCustom()) {
                                MembProperty membProperty = filterDimMember.getMembProperty();
                                if (membProperty != null) {
                                    DynamicObject dyo = (DynamicObject)propertyValueDynamicObj.get(this.getDefinePropertyKey(membProperty.getNumber(), dimNumber));
                                    String definePropertyKey = this.getDefinePropertyKey(membProperty.getCustomProperty().getNumber(), dimNumber);
                                    if (Objects.nonNull(dyo) && propertymap.get(definePropertyKey) != null) {
                                        entryRow.set("filtermembid", (Object)dyo.getLong("id"));
                                        entryRow.set("filtermembound", (Object)membProperty.getScope());
                                        entryRow.set("filtermemproperty", propertymap.get(definePropertyKey));
                                    }
                                }
                            } else {
                                IDNumberTreeNode dimensionMemberNode = this.cacheDimensionMemberNode(modelNum, dimNumber, filterDimMember.getNumber());
                                if (dimensionMemberNode != IDNumberTreeNode.NotFoundTreeNode) {
                                    entryRow.set("filtermembid", (Object)dimensionMemberNode.getId());
                                    entryRow.set("filtermembound", (Object)filterDimMember.getScope());
                                    entryRow.set("filtermemproperty", null);
                                }
                            }
                            filterDimEntry.add((Object)entryRow);
                        }
                    });
                });
                if (!filterDimEntry.isEmpty()) {
                    newTemplateModel.setTemplateFilterDimensionEntry(new FilterDimensionEntry(newTemplateModel).loadDynaObject(filterDimEntry, () -> newTemplateModel));
                }
            }
        } else {
            TemplateDimSettingUtil.fillBack2TemplateModelForImport(newTemplateModel, ModelUtil.queryApp(this.getView()), this.getBizAppId());
        }
    }

    private String getData(String data, Map<String, Map<String, Map<String, List<IDimMember>>>> notExitMember, String templateNumber, boolean isForWeave) {
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)data);
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            List basepoints = e.getBasePoints();
            for (BasePointInfo basepoint : basepoints) {
                String floatRange = basepoint.getDynaRange();
                List lines = basepoint.getBasePointInnerLineInfo();
                lines.forEach(line -> {
                    IDimMember memberAddOf;
                    if (!line.getDynaMembScopes().isEmpty()) {
                        line.setDynaMembScopes(this.tranIdForDynaMembScopes(line.getDynaMembScopes(), notExitMember, templateNumber, line.isFloated() ? "floatmemtext" : "unfloatmem", floatRange));
                    }
                    if ((memberAddOf = line.getMemberAddOf(false)) != null) {
                        line.setMemberAddOf(this.tranIdForIDimMember(memberAddOf, notExitMember, templateNumber, floatRange, "newmembas", false));
                    }
                });
            }
            if (e.getExtendInfo() == null) continue;
            this.checkExtendInfo(e.getExtendInfo(), isForWeave);
            this.tranIdForFloatDimInfos(e.getExtendInfo().getFloatdims(), notExitMember, templateNumber, e.getAreaRange());
        }
        return JsonSerializerUtil.toJson((SpreadManager)sm);
    }

    private List<DynaMembScopeInfo> tranIdForDynaMembScopes(List<DynaMembScopeInfo> dynaMembScopes, Map<String, Map<String, Map<String, List<IDimMember>>>> notExitMember, String templateNumber, String sign, String extRange) {
        ArrayList<DynaMembScopeInfo> newscopes = new ArrayList<DynaMembScopeInfo>(dynaMembScopes.size());
        dynaMembScopes.forEach(e -> {
            IDimMember member = this.tranIdForIDimMember(e.getMember(), notExitMember, templateNumber, extRange, sign, e.isCustom());
            if (member != null) {
                newscopes.add(new DynaMembScopeInfo(member, e.getRangeId(), e.isCustom()));
            }
        });
        return newscopes;
    }

    private IDimMember tranIdForIDimMember(IDimMember member, Map<String, Map<String, Map<String, List<IDimMember>>>> notExitMember, String templateNumber, String areaRange, String sign, boolean isCustom) {
        String dimNum = member.getDimension().getNumber();
        String memNum = member.getNumber();
        Long modelId = (Long)this.getFormCustomParam("modelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        boolean flag = false;
        IDimMember fMember = null;
        if (this.map != null) {
            fMember = this.getSimpleIDimMember(member);
            if (isCustom) {
                String[] split = memNum.split(":");
                if (split.length == 2) {
                    memNum = split[1];
                    IDNumberTreeNode customPropertyValueNode = TemplateUtil.getCustomPropertyValueByNumber((String)dimNum, (String)memNum, (String)modelNum);
                    if (customPropertyValueNode != IDNumberTreeNode.NotFoundTreeNode) {
                        fMember.setId(customPropertyValueNode.getId().longValue());
                        flag = true;
                    }
                } else if (SystemVarsEnum.PR_NONE.getNumber().equals(memNum)) {
                    fMember.setId(LongUtil.toLong((Object)SystemVarsEnum.PR_NONE.getId()).longValue());
                    flag = true;
                }
            } else if (SystemVarsEnum.CURRENT.getNumber().equals(memNum)) {
                fMember.setId(LongUtil.toLong((Object)SystemVarsEnum.CURRENT.getId()).longValue());
                flag = true;
            } else {
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memNum);
                if (node != IDNumberTreeNode.NotFoundTreeNode) {
                    fMember.setId(node.getId().longValue());
                    flag = true;
                } else {
                    TemplateFloatUtil.collectNotExitMemForFLoat(areaRange, member, sign, notExitMember, templateNumber);
                }
            }
        }
        return flag ? fMember : null;
    }

    private IDimMember getSimpleIDimMember(IDimMember member) {
        String dimNum = member.getDimension().getNumber();
        DynamicObject dimensionDyn = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)((Long)this.getFormCustomParam("modelid")), (String)dimNum));
        Dimension dimension = new Dimension(dimensionDyn.getString("name"), dimNum, dimensionDyn.getString("membermodel"));
        return new DimMember(member.getName(), member.getNumber(), null, (IDimension)dimension);
    }

    private void tranIdForFloatDimInfos(List<FloatDimInfo> floatDimInfos, Map<String, Map<String, Map<String, List<IDimMember>>>> notExitMember, String templateNumber, String extRange) {
        if (!floatDimInfos.isEmpty()) {
            floatDimInfos.forEach(floatDimInfo -> {
                if (floatDimInfo.isFixMember()) {
                    floatDimInfo.setMember(this.tranIdForIDimMember(floatDimInfo.getMember(), notExitMember, templateNumber, "unfloatmem", extRange, false));
                } else if (!floatDimInfo.getDynaMembScopes().isEmpty()) {
                    floatDimInfo.setDynaMembScopes(this.tranIdForDynaMembScopes(floatDimInfo.getDynaMembScopes(), notExitMember, templateNumber, "floatmemtext", extRange));
                }
            });
        }
    }

    private void checkExtendInfo(ExtendInfo extendInfo, boolean isForWeave) {
        Long modelId = (Long)this.getFormCustomParam("modelid");
        Map<String, Long> allExtendDataModel = TemplateExtendModelRefUtil.getAllExtendDataModel(modelId);
        Map<Long, ExtendsModel> extendsModelMap = TemplateExtendModelRefUtil.batchGetExtendsModels(allExtendDataModel.values().stream().collect(Collectors.toSet()));
        ExtendsModel extendsModel = extendsModelMap.get(allExtendDataModel.get(extendInfo.getExtModelNumber()));
        if (extendInfo.hasTopSetting()) {
            TemplateExtendModelRefUtil.checkTopSettingBeforeSave(extendInfo, extendsModel, isForWeave);
        }
        if (!extendInfo.getCalculateInfos().isEmpty()) {
            TemplateExtendModelRefUtil.checkExtCalSetting(extendInfo, extendsModel);
        }
        TemplateExtendModelRefUtil.updateEnumMemRange(extendInfo, extendsModel);
    }

    private Map<String, DynamicObject> getSysProperty(Long modelid) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id, number, name, dimension.number", (QFilter[])qfs);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        dcs.forEach(p -> map.put(this.getDefinePropertyKey(p.getString("number"), p.getString("dimension.number")), (DynamicObject)p));
        return map;
    }

    private String getDefinePropertyKey(String proNum, String dimNum) {
        return proNum + '!' + dimNum;
    }

    private Map<String, DynamicObject> getPropertyValueDynamicObj(Long modelid) {
        HashMap<String, DynamicObject> propertyValues = new HashMap<String, DynamicObject>();
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id, number, name, dimension.number", (QFilter[])qfs);
        dcs.forEach(dyn -> propertyValues.put(this.getDefinePropertyKey(dyn.getString("number"), dyn.getString("dimension.number")), (DynamicObject)dyn));
        return propertyValues;
    }

    private TemplateCatalog getTmplCatalog(Long templatecatalogid) {
        TemplateCatalog catalog = new TemplateCatalog();
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)templatecatalogid, (String)"bcm_templatecatalog");
        catalog.setId(dyna.getLong("id"));
        catalog.setName(dyna.getString("name"));
        return catalog;
    }

    private Map<String, Map<String, Object>> getNeedExchangeFields(long modelid, TemplateModel[] templateModels) {
        String[] templatesNumber = new String[templateModels.length];
        for (int i = 0; i < templateModels.length; ++i) {
            templatesNumber[i] = templateModels[i].getNumber();
        }
        QFilter qfnumber = new QFilter("number", "in", (Object)templatesNumber);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        QFilter templatetype = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection numberCol = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number, versionnumber, group, templatecatalog,sequence", (QFilter[])new QFilter[]{qfnumber, modelFilter, templatetype});
        HashMap<String, Map<String, Object>> needExchangeFields = new HashMap<String, Map<String, Object>>();
        numberCol.forEach(e -> {
            int sequence;
            int n = sequence = e.get("sequence") == null ? 0 : e.getInt("sequence");
            if (needExchangeFields.get(e.getString("number")) == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("versionnumber", e.get("versionnumber"));
                map.put("group", e.get("group"));
                map.put("templatecatalog", e.get("templatecatalog"));
                map.put("id", e.get("id"));
                map.put("isExit", "true");
                map.put("sequence", sequence);
                needExchangeFields.put(e.getString("number"), map);
            } else {
                if (e.getBigDecimal("versionnumber").compareTo((BigDecimal)((Map)needExchangeFields.get(e.getString("number"))).get("versionnumber")) > 0) {
                    ((Map)needExchangeFields.get(e.getString("number"))).put("versionnumber", e.get("versionnumber"));
                    ((Map)needExchangeFields.get(e.getString("number"))).put("id", e.get("id"));
                }
                if (sequence < (Integer)((Map)needExchangeFields.get(e.getString("number"))).get("sequence")) {
                    ((Map)needExchangeFields.get(e.getString("number"))).put("sequence", sequence);
                }
            }
        });
        return needExchangeFields;
    }

    public void afterUpload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put(CACHEKEY_FILE_URL, (String)((Map)url).get("url"));
            this.getPageCache().put(CACHEKEY_FILE_TYPE, (String)((Map)url).get("type"));
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().remove(CACHEKEY_FILE_URL);
        this.getPageCache().remove(CACHEKEY_FILE_TYPE);
    }
}

