/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SerialSpliter;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.formplugin.batch.BatchQueryHelper;
import kd.fi.bcm.formplugin.batch.IQuery;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.IDimMember;

public class TemplateScanMemberService {
    private SpreadManager sm;
    private TemplateModel template;
    private boolean fromCreateModel = false;

    public TemplateScanMemberService(SpreadManager sm, TemplateModel template) {
        this.sm = sm;
        this.template = template;
    }

    public boolean isFromCreateModel() {
        return this.fromCreateModel;
    }

    public void setFromCreateModel(boolean fromCreateModel) {
        this.fromCreateModel = fromCreateModel;
    }

    private boolean isFromWp() {
        return this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType();
    }

    public void scan() {
        this.sm.getAreaManager().getPostionInfoSet().forEach(e -> {
            int[] dataxy = ExcelUtils.pos2XY((String)e.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)e.getAreaRange().split(":")[1]);
            int srow = this.template.isOldTemplate() ? dataxy[1] - 1 : dataxy[1];
            int scol = this.template.isOldTemplate() ? dataxy[0] - 1 : dataxy[0];
            int erow = endxy[1];
            int ecol = endxy[0];
            AreaRangeEntry ar = this.getOverlapAreaRange(e.getStartPosition() + ":" + e.getStartPosition());
            if (ar == null) {
                return;
            }
            List<List<String>> members = this.scanDimMemberInfo(srow, scol, erow, ecol, true, ar);
            if (this.isFromCreateModel()) {
                this.handleQuery(members, ar, true);
                members = this.scanDimMemberInfo(srow, scol, erow, ecol, false, ar);
                this.handleQuery(members, ar, false);
            } else {
                this.fillMemberToAreaRangeEntry(members, ar, true);
                members = this.scanDimMemberInfo(srow, scol, erow, ecol, false, ar);
                this.fillMemberToAreaRangeEntry(members, ar, false);
            }
        });
    }

    private void fillMemberToAreaRangeEntry(List<List<String>> members, AreaRangeEntry ar, boolean isRowDim) {
        if (!members.isEmpty()) {
            String modelNum = MemberReader.findModelNumberById((Object)this.template.getModelId());
            BatchQueryHelper<String, String, List> query = new BatchQueryHelper<String, String, List>();
            String[] dimNums = new String[isRowDim ? ar.getRowDimEntries().size() : (this.isFromWp() ? ar.getColDimEntriesExt().size() : ar.getColDimEntries().size())];
            int index = 0;
            for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : (this.isFromWp() ? ar.getColDimEntriesExt() : ar.getColDimEntries())) {
                dimNums[index++] = cd.getDimension().getNumber();
            }
            members.forEach(l -> {
                if (l.size() == dimNums.length) {
                    int idx = 0;
                    for (String n : dimNums) {
                        query.addQueryItem(n, (String)l.get(idx++));
                    }
                }
            });
            final String finalModelNum = modelNum;
            query.doQuery(new IQuery<String, String, List<IDNumberTreeNode>>(){

                @Override
                public List<IDNumberTreeNode> query(String k, Set<String> v) {
                    ArrayList<IDNumberTreeNode> singleDimMem = new ArrayList<IDNumberTreeNode>(16);
                    v.forEach(num -> singleDimMem.add(MemberReader.findMemberByNumber((String)finalModelNum, (String)k, (String)num)));
                    return singleDimMem;
                }
            }, (coll, k) -> {
                for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : (this.isFromWp() ? ar.getColDimEntriesExt() : ar.getColDimEntries())) {
                    if (!cd.getDimension().getNumber().equals(k)) continue;
                    cd.getMembers().clear();
                    coll.forEach(m -> cd.getMembers().add(ObjectConvertUtils.toMember(m)));
                }
            });
        } else if (!this.isFromWp()) {
            for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : (this.isFromWp() ? ar.getColDimEntriesExt() : ar.getColDimEntries())) {
                if (cd.getMembers() == null) continue;
                cd.getMembers().clear();
            }
        }
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.template.getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    private List<List<String>> scanDimMemberInfo(int srow, int scol, int erow, int ecol, boolean isScanRow, AreaRangeEntry ar) {
        ArrayList<List<String>> items = new ArrayList<List<String>>();
        int from = isScanRow ? srow : scol;
        int end = isScanRow ? erow : ecol;
        List membDetail = isScanRow ? ar.getRowDimEntries() : ar.getColDimEntries();
        for (int c = from; c <= end; ++c) {
            List members = this.getEffectiveSheet().getCell(isScanRow ? c : srow, isScanRow ? scol : c).getMemberFromUserObject();
            if (members == null || members.isEmpty()) continue;
            ArrayList<String> item = new ArrayList<String>(members.size());
            for (IDimMember m : members) {
                boolean isInclude = membDetail.stream().anyMatch(p -> m.getDimension().getNumber().equals(p.getDimension().getNumber()));
                if (!isInclude) continue;
                String number = m.getNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(m.getDimension().getNumber()) && StringUtils.isNotEmpty((String)m.getPar_SonNum())) {
                    number = m.getPar_SonNum();
                }
                item.add(number);
            }
            if (item.isEmpty()) continue;
            items.add(item);
        }
        if (!this.template.isOldTemplate()) {
            this.getEffectiveSheet().iteratorRangeCells(srow, erow, scol, ecol, cell -> {
                String serial;
                if (cell.isMdDataDomain() && ((Boolean)cell.getUserObject("not_cross", (Object)false)).booleanValue() && StringUtils.isNotEmpty((String)(serial = (String)cell.getUserObject("cross_nums", (Object)"")))) {
                    SerialSpliter spliter = new SerialSpliter(serial);
                    ArrayList item2 = new ArrayList(membDetail.size());
                    spliter.getPairs().forEach(p -> {
                        boolean isInclude = membDetail.stream().anyMatch(d -> ((String)p.p1).equals(d.getDimension().getNumber()));
                        if (isInclude) {
                            item2.add(p.p2);
                        }
                    });
                    if (!item2.isEmpty()) {
                        items.add(item2);
                    }
                }
            });
        }
        return items;
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    private void handleQuery(List<List<String>> members, AreaRangeEntry ar, boolean isRowDim) {
        BatchQueryHelper<String, String, DynamicObject[]> query = new BatchQueryHelper<String, String, DynamicObject[]>();
        if (!members.isEmpty()) {
            String[] entityNums = new String[isRowDim ? ar.getRowDimEntries().size() : ar.getColDimEntries().size()];
            int index = 0;
            for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : ar.getColDimEntries()) {
                entityNums[index++] = cd.getDimension().getMemberEntityNumber();
            }
            members.forEach(l -> {
                if (l.size() == entityNums.length) {
                    int idx = 0;
                    for (String n : entityNums) {
                        query.addQueryItem(n, (String)l.get(idx++));
                    }
                }
            });
            query.doQuery(new IQuery<String, String, DynamicObject[]>(){

                @Override
                public DynamicObject[] query(String k, Set<String> v) {
                    QFilter filtNum = new QFilter("number", "in", v);
                    QFilter filtshare = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                    QFilter filtModel = new QFilter("model", "=", (Object)TemplateScanMemberService.this.template.getModelId());
                    return BusinessDataServiceHelper.load((String)k, (String)"id,name,number,member,dimension.id,dimension.number,dimension.membermodel,dimension.dseq", (QFilter[])new QFilter[]{filtNum.and(filtModel).and(filtshare)}, null);
                }
            }, (coll, k) -> {
                for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : ar.getColDimEntries()) {
                    if (!cd.getDimension().getMemberEntityNumber().equals(k)) continue;
                    cd.getMembers().clear();
                    for (DynamicObject m : coll) {
                        if (!m.getString("dimension.number").equals(cd.getDimension().getNumber())) continue;
                        cd.getMembers().add(ObjectConvertUtils.toMember(m));
                    }
                }
            });
        } else if (!this.isFromWp()) {
            for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : ar.getColDimEntries()) {
                if (cd.getMembers() == null) continue;
                cd.getMembers().clear();
            }
        }
    }

    public Set<Point> getFloatFirst(SpreadManager spreadCopy) {
        String cacheKey = "getFloatFirst" + this.template.getId();
        return (Set)ThreadCache.get((Object)cacheKey, () -> {
            Set infos = spreadCopy.getAreaManager().getPostionInfoSet();
            if (infos.isEmpty()) {
                return new HashSet();
            }
            HashSet firstfloatCells = Sets.newHashSet();
            for (PositionInfo info : infos) {
                String[] parea = info.getAreaRange().split(":");
                int[] pstartXY = ExcelUtils.pos2XY((String)parea[0]);
                int[] pendXY = ExcelUtils.pos2XY((String)parea[1]);
                for (BasePointInfo baseInfo : info.getBasePoints()) {
                    String memNum;
                    String dimNum;
                    boolean isClear;
                    int i;
                    Map rcMems = baseInfo.getFixMemberPosition();
                    String[] area = baseInfo.getDynaRange().split(":");
                    int[] startXY = ExcelUtils.pos2XY((String)area[0]);
                    if (baseInfo.getDirect() == 1) {
                        for (i = pstartXY[1]; i <= pendXY[1]; ++i) {
                            isClear = false;
                            if (rcMems.size() == 0) {
                                isClear = true;
                            }
                            if (rcMems.get(i - pstartXY[1]) != null) {
                                for (IDimMember iDimMember : (List)rcMems.get(i - pstartXY[1])) {
                                    dimNum = iDimMember.getDimension().getNumber();
                                    if (!this.isNotCanSetFormula(dimNum, memNum = iDimMember.getNumber())) continue;
                                    isClear = true;
                                    break;
                                }
                            }
                            if (isClear) continue;
                            firstfloatCells.add(new Point(startXY[0], i));
                        }
                        continue;
                    }
                    for (i = pstartXY[0]; i <= pendXY[0]; ++i) {
                        isClear = false;
                        if (rcMems.size() == 0) {
                            isClear = true;
                        }
                        if (rcMems.get(i - pstartXY[0]) != null) {
                            for (IDimMember iDimMember : (List)rcMems.get(i - pstartXY[0])) {
                                dimNum = iDimMember.getDimension().getNumber();
                                if (!this.isNotCanSetFormula(dimNum, memNum = iDimMember.getNumber())) continue;
                                isClear = true;
                                break;
                            }
                        }
                        if (isClear) continue;
                        firstfloatCells.add(new Point(i, startXY[1]));
                    }
                }
            }
            return firstfloatCells;
        });
    }

    private boolean isNotCanSetFormula(String dimNum, String memNum) {
        return StringUtils.isNotEmpty((String)TempFormulaUtil.checkDimCombinationForFormula(dimNum, memNum, this.template.getModelId()));
    }
}

