/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;

public class TemplateSeqUtil {
    public static int getInitvalueByFromArea(SequenceInfo fromarea) {
        int start;
        String seqArea = fromarea.getSeqArea();
        RangeModel seqRange = new RangeModel(seqArea);
        int direct = fromarea.getDirect();
        int end = 0;
        if (direct == 1) {
            start = seqRange.getX_start();
            end = seqRange.getX_end();
        } else {
            start = seqRange.getY_start();
            end = seqRange.getY_end();
        }
        if (fromarea.getFromarea() == null) {
            int initvalue = fromarea.getInitvalue();
            int number = initvalue + end - start + 1;
            return number;
        }
        int initvalue = TemplateSeqUtil.getInitvalueByFromArea(fromarea.getFromarea());
        int number = initvalue + end - start + 1;
        return number;
    }

    public static int getDirect(String seqArea, String dataArea) {
        RangeModel seqRangeModel = new RangeModel(seqArea);
        RangeModel dataAreaModel = new RangeModel(dataArea);
        if (seqRangeModel.getX_end() < dataAreaModel.getX_start() || seqRangeModel.getX_start() > dataAreaModel.getX_end()) {
            return 2;
        }
        if (seqRangeModel.getY_end() < dataAreaModel.getY_start() || seqRangeModel.getY_start() > dataAreaModel.getY_end()) {
            return 1;
        }
        return 0;
    }

    public static String generateCellValueForSequence(SequenceInfo sequenceInfo, int value) {
        if (sequenceInfo.isFixValue()) {
            return sequenceInfo.getFixValue();
        }
        String prefix = sequenceInfo.getPrefix();
        String suffix = sequenceInfo.getSuffix();
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmptyString((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(value);
        if (!StringUtil.isEmptyString((String)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static void markSeqAreaCells(Set<PositionInfo> positionInfos, SpreadManager sm, boolean mark, SpreadEasyInvoker invoker) {
        if (!positionInfos.isEmpty()) {
            Sheet sheet = sm.getBook().getSheet(0);
            for (PositionInfo ps : positionInfos) {
                SequenceInfo sequenceInfo = ps.getSequenceInfo();
                if (sequenceInfo == null) continue;
                RangeModel rangeModel = new RangeModel(sequenceInfo.getSeqArea());
                if (mark) {
                    if (sequenceInfo.isFixValue()) {
                        invoker.updataValue(rangeModel.getY_start(), rangeModel.getX_start(), sequenceInfo.getFixValue());
                        continue;
                    }
                    SequenceInfo fromarea = sequenceInfo.getFromarea();
                    AtomicInteger initvalue = new AtomicInteger(sequenceInfo.getInitvalue());
                    if (fromarea != null) {
                        initvalue.set(TemplateSeqUtil.getInitvalueByFromArea(fromarea));
                    }
                    AtomicInteger finalInitvalue = initvalue;
                    sheet.iteratorRangeCells(rangeModel, true, cell -> {
                        if (cell.hasFormula()) {
                            cell.setFormula(null);
                            invoker.setFormula(cell.getRow(), cell.getCol(), null);
                        }
                        String value = TemplateSeqUtil.generateCellValueForSequence(sequenceInfo, finalInitvalue.get());
                        cell.setValue((Object)value);
                        invoker.updataValue(cell.getRow(), cell.getCol(), value);
                        finalInitvalue.getAndIncrement();
                    });
                    continue;
                }
                sheet.iteratorRangeCells(rangeModel, true, cell -> {
                    cell.setValue(null);
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                });
            }
        }
    }

    public static void clearSeqArea(Set<PositionInfo> positionInfos, SpreadManager sm, SpreadEasyInvoker invoker) {
        TemplateSeqUtil.markSeqAreaCells(positionInfos, sm, false, invoker);
    }

    private static Set<PositionInfo> getSeqPostInfo(SpreadManager lastSm) {
        Set postionInfoSet = lastSm.getAreaManager().getPostionInfoSet();
        Set<Object> positionInfos = new HashSet<PositionInfo>(16);
        if (postionInfoSet != null && !postionInfoSet.isEmpty()) {
            positionInfos = postionInfoSet.stream().filter(ps -> ps.getSequenceInfo() != null).collect(Collectors.toSet());
        }
        return positionInfos;
    }

    private static Pair<Set<PositionInfo>, Set<PositionInfo>> mergeSeqPosInfos(SpreadManager lastSm, SpreadManager sm) {
        Set<PositionInfo> oldSeqPosInfos = TemplateSeqUtil.getSeqPostInfo(lastSm);
        Set<PositionInfo> seqPostInfo = TemplateSeqUtil.getSeqPostInfo(sm);
        return Pair.onePair(oldSeqPosInfos, seqPostInfo);
    }

    public static void setSeqArea(Set<PositionInfo> seqPostInfo, SpreadManager sm, SpreadEasyInvoker invoker) {
        TemplateSeqUtil.markSeqAreaCells(seqPostInfo, sm, true, invoker);
    }

    public static void updateSeqArea(SpreadManager lastSm, SpreadManager sm, SpreadEasyInvoker invoker) {
        invoker.setBatch(true);
        Pair<Set<PositionInfo>, Set<PositionInfo>> mergeSeqPosInfos = TemplateSeqUtil.mergeSeqPosInfos(lastSm, sm);
        Set oldSeqPosInfos = (Set)mergeSeqPosInfos.p1;
        Set seqPostInfo = (Set)mergeSeqPosInfos.p2;
        TemplateSeqUtil.clearSeqArea(oldSeqPosInfos, sm, invoker);
        TemplateSeqUtil.setSeqArea(seqPostInfo, sm, invoker);
        invoker.startToInvoke();
    }

    public static void adjustSeqArea(SpreadManager newSm, List<SequenceInfo> removeSequenceInfo) {
        Set newPositionFos;
        if (newSm.getAreaManager().getPostionInfoSet().stream().anyMatch(ps -> ps.getSequenceInfo() != null) && !(newPositionFos = newSm.getAreaManager().getPostionInfoSet()).isEmpty()) {
            newPositionFos.forEach(ps -> {
                SequenceInfo sequenceInfo = ps.getSequenceInfo();
                if (sequenceInfo != null && sequenceInfo.getFromarea() != null && removeSequenceInfo.contains(sequenceInfo.getFromarea())) {
                    sequenceInfo.setFromarea(null);
                }
            });
        }
    }

    public static void updateSequenceInfoByPs(SpreadManager sm, PositionInfo oldInfo, PositionInfo ps, IFormView view, String spreadkey) {
        if (ps != null && oldInfo.getSequenceInfo() != null && oldInfo != null) {
            RangeModel rangeModel = new RangeModel(ps.getAreaRange());
            final SequenceInfo sequenceInfo = oldInfo.getSequenceInfo();
            Predicate<PositionInfo> predicate = new Predicate<PositionInfo>(){

                @Override
                public boolean test(PositionInfo positionInfo) {
                    SequenceInfo sequenceInfo1 = positionInfo.getSequenceInfo();
                    return sequenceInfo1 != null && sequenceInfo1.getFromarea() != null && sequenceInfo1.getFromarea().equals(sequenceInfo);
                }
            };
            boolean isNeedAdjust = TemplateSeqUtil.adjustSequenceInfo(oldInfo, ps);
            if (sequenceInfo.getDirect() == 1 || isNeedAdjust) {
                Set<Object> positionInfoSet = sm.getAreaManager().getPostionInfoSet().stream().filter(predicate).collect(Collectors.toSet());
                positionInfoSet.add(oldInfo);
                MarkSpecialCell.markSeqAreaCells(positionInfoSet, false, view, spreadkey, sm);
                positionInfoSet.clear();
                String seqArea = sequenceInfo.getSeqArea();
                RangeModel seqRangeModel = new RangeModel(seqArea);
                if (isNeedAdjust) {
                    seqRangeModel.setX_start(rangeModel.getX_end() + 1);
                    seqRangeModel.setX_end(rangeModel.getX_end() + 1);
                } else {
                    seqRangeModel.setX_end(rangeModel.getX_end());
                }
                sequenceInfo.setSeqArea(seqRangeModel.getAreaRangeStr());
                positionInfoSet = sm.getAreaManager().getPostionInfoSet().stream().filter(predicate).collect(Collectors.toSet());
                positionInfoSet.add(oldInfo);
                MarkSpecialCell.markSeqAreaCells(positionInfoSet, true, view, spreadkey, sm);
            }
            sequenceInfo.setDataArea(ps.getAreaRange());
        }
    }

    public static void updateSequenceInfo(SpreadManager sm) {
        HashMap<String, SequenceInfo> seqMap = new HashMap<String, SequenceInfo>(16);
        sm.getAreaManager().getPostionInfoSet().forEach(ps -> seqMap.put(ps.getAreaRange(), ps.getSequenceInfo()));
        for (Map.Entry entry : seqMap.entrySet()) {
            ArrayList<String> areList = new ArrayList<String>(16);
            areList.add((String)entry.getKey());
            TemplateSeqUtil.updateSingleSeq(seqMap, (SequenceInfo)entry.getValue(), areList);
        }
        seqMap.forEach((k, v) -> {
            ArrayList<String> areaList = new ArrayList<String>(16);
            areaList.add((String)k);
            TemplateSeqUtil.checkCycleRefrence(v, areaList, true);
        });
    }

    private static void checkCycleRefrence(SequenceInfo sequenceInfo, List<String> areaList, boolean flag) {
        if (!flag && sequenceInfo != null) {
            areaList.add(sequenceInfo.getDataArea());
        }
        if (sequenceInfo != null && sequenceInfo.getFromarea() != null) {
            SequenceInfo sequenceInfoFromarea = sequenceInfo.getFromarea();
            if (areaList.contains(sequenceInfoFromarea.getDataArea())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6570\u636e\u533a\u57df\u4e2d%s\u7684\u884c\u6b21\u8bbe\u7f6e\u4e2d\u5ef6\u7eed\u81ea\u8303\u56f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u7684\u60c5\u51b5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u884c\u6b21\u8bbe\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"MultiViewTemplateProcess_82", (String)"fi-bcm-formplugin", (Object[])new Object[0]), areaList));
            }
            TemplateSeqUtil.checkCycleRefrence(sequenceInfoFromarea, areaList, false);
        }
    }

    private static void updateSingleSeq(Map<String, SequenceInfo> seqMap, SequenceInfo sequenceInfo, List<String> areList) {
        if (sequenceInfo != null && sequenceInfo.getFromarea() != null) {
            SequenceInfo infoFromarea = sequenceInfo.getFromarea();
            String dataArea = infoFromarea.getDataArea();
            if (areList.contains(dataArea)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6570\u636e\u533a\u57df\u4e2d%s\u7684\u884c\u6b21\u8bbe\u7f6e\u4e2d\u5ef6\u7eed\u81ea\u8303\u56f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u7684\u60c5\u51b5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u884c\u6b21\u8bbe\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"MultiViewTemplateProcess_82", (String)"fi-bcm-formplugin", (Object[])new Object[0]), areList));
            }
            sequenceInfo.setFromarea(seqMap.get(dataArea));
            areList.add(dataArea);
            if (infoFromarea.getFromarea() != null) {
                TemplateSeqUtil.updateSingleSeq(seqMap, infoFromarea.getFromarea(), areList);
            }
        }
    }

    public static void filterCycleRefrence(List<SequenceInfo> data, String currentArea) {
        if (!data.isEmpty()) {
            ArrayList<SequenceInfo> sequenceInfos = new ArrayList<SequenceInfo>(16);
            ArrayList<String> areas = new ArrayList<String>(16);
            areas.add(currentArea);
            for (SequenceInfo info : data) {
                if (!TemplateSeqUtil.hasBeenRefrence(areas, info)) continue;
                sequenceInfos.add(info);
                areas.add(info.getDataArea());
            }
            data.removeAll(sequenceInfos);
        }
    }

    private static boolean hasBeenRefrence(List<String> areas, SequenceInfo sequenceInfo) {
        if (areas.contains(sequenceInfo.getDataArea())) {
            return true;
        }
        SequenceInfo fromarea = sequenceInfo.getFromarea();
        if (fromarea != null) {
            return TemplateSeqUtil.hasBeenRefrence(areas, fromarea);
        }
        return areas.contains(sequenceInfo.getDataArea());
    }

    public static boolean adjustSequenceInfo(PositionInfo oldInfo, PositionInfo ps) {
        if (ps != null && oldInfo != null && oldInfo.getSequenceInfo() != null) {
            RangeModel rangeModel = new RangeModel(ps.getAreaRange());
            SequenceInfo sequenceInfo = oldInfo.getSequenceInfo();
            RangeModel seqRangeModel = new RangeModel(sequenceInfo.getSeqArea());
            return seqRangeModel.checkIsInArea(rangeModel);
        }
        return false;
    }
}

