/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.version;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.TemplateStartPeriodUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsDimMemService;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class TplVersionEditPlugin
extends AbstractBaseFormPlugin {
    private static final String btn_ok = "btn_ok";
    private static final String btn_createandopen = "btn_createandopen";
    private static final String STARTPERIOD = "startperiod";
    private static final String CURRENT_MODEL = "currentmodel";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String style = (String)formShowParameter.getCustomParam("style");
        if ("new".equals(style)) {
            Long group = (Long)formShowParameter.getCustomParam("group");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, versionnumber, group, effectivedate, expiringdate", (QFilter[])QFilter.of((String)"group = ?", (Object[])new Object[]{group}).toArray(), (String)"versionnumber desc", (int)1);
            if (!query.isEmpty()) {
                DynamicObject template = (DynamicObject)query.get(0);
                IDataModel dataModel = this.getModel();
                dataModel.setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(template.getLong("versionnumber") + 1L)));
                Date effectiveDate = template.getDate("expiringdate");
                if (effectiveDate == null) {
                    effectiveDate = new Date();
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(effectiveDate.getTime() + 86400000L);
                    effectiveDate = cal.getTime();
                }
                dataModel.setValue("effectivedate", (Object)effectiveDate);
                view.setVisible(Boolean.valueOf(false), new String[]{btn_ok});
            }
        } else {
            Long pkId = (Long)formShowParameter.getCustomParam("pkId");
            DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id, versionnumber, group, effectivedate, expiringdate, versiondescription", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{pkId}).toArray());
            if (query != null) {
                IDataModel dataModel = this.getModel();
                dataModel.setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(query.getLong("versionnumber"))));
                Date effectiveDate = query.getDate("effectivedate");
                dataModel.setValue("effectivedate", (Object)effectiveDate);
                Date expiringdate = query.getDate("expiringdate");
                dataModel.setValue("expiringdate", (Object)expiringdate);
                String versiondescription = query.getString("versiondescription");
                dataModel.setValue("versiondescription", (Object)versiondescription);
                view.setVisible(Boolean.valueOf(false), new String[]{btn_createandopen});
                long periodId = TemplateStartPeriodUtil.getTempStartPeriod((long)pkId);
                if (periodId != 0L) {
                    dataModel.setValue(STARTPERIOD, (Object)periodId);
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_ok": {
                if (!this.validateRetionality()) break;
                this.saveTemplateInfo();
                break;
            }
            case "btn_createandopen": {
                if (!this.validateRetionality()) break;
                this.copyAndReturnData();
            }
        }
    }

    private void copyAndReturnData() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long group = (Long)formShowParameter.getCustomParam("group");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,cycletable, versionnumber, group, model", (QFilter[])QFilter.of((String)"group = ?", (Object[])new Object[]{group}).toArray(), (String)"versionnumber desc", (int)1);
        if (!query.isEmpty()) {
            IDataModel dataModel = this.getModel();
            String versionNumber = (String)dataModel.getValue("versionnum");
            Double versionNum = Double.valueOf(versionNumber.substring(1));
            if (!QueryServiceHelper.exists((String)"bcm_templateentity", (QFilter[])QFilter.of((String)"group = ? and versionnumber = ?", (Object[])new Object[]{group, versionNum}).toArray())) {
                DynamicObject template = (DynamicObject)query.get(0);
                template = BusinessDataServiceHelper.loadSingle((Object)template.getLong("id"), (String)"bcm_templateentity");
                CloneUtils cloneUtil = new CloneUtils(true, true);
                ArrayListMultimap multiMap = ArrayListMultimap.create();
                DynamicObject genGlobalLongId = this.copyBaseInfo(dataModel, versionNum, template, cloneUtil, (Multimap<String, DynamicObject>)multiMap);
                long modelId = template.getDynamicObject("model").getLong("id");
                long templateId = template.getLong("id");
                QFilter filter1 = new QFilter("model", "=", (Object)modelId);
                QFilter filter2 = new QFilter("template", "=", (Object)templateId);
                QFilter[] filters = new QFilter[]{filter1, filter2};
                this.copyEntityRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_userdefcvtformula");
                this.copyEntityRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_distributionentity");
                this.copyEntityRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_beginperioddims");
                this.copyEntityRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_extmodelref");
                this.copyEntityRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_tempdiscycletable");
                this.copyDataSetRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters, "bcm_reportdata_custseting");
                this.saveData((Multimap<String, DynamicObject>)multiMap);
                this.copyPermClass(modelId, templateId, genGlobalLongId.getLong("id"));
                this.saveStartPeriod(genGlobalLongId.getLong("id"));
                view.returnDataToParent((Object)genGlobalLongId.getLong("id"));
                view.close();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u88ab\u521b\u5efa\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TplVersionEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void copyPermClass(long modelId, long templateId, long newTemplateId) {
        QFilter permClassFilter = new QFilter("model", "=", (Object)modelId);
        permClassFilter = permClassFilter.and("entityname", "=", (Object)"bcm_templateentity");
        permClassFilter.and("entityid", "=", (Object)templateId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass", (QFilter[])permClassFilter.toArray());
        if (dynamicObject != null) {
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)"bcm_templateentity");
            entity.set("model", (Object)modelId);
            entity.set("entityid", (Object)newTemplateId);
            entity.set("permclass", dynamicObject.get("permclass"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        }
    }

    public void saveData(Multimap<String, DynamicObject> multiMap) {
        this.executeWithTX(handle -> multiMap.asMap().forEach((k, v) -> SaveServiceHelper.save((DynamicObject[])v.toArray(new DynamicObject[0]))));
    }

    private void copyEntityRecord(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, QFilter[] filters, String entitySign) {
        DynamicObject[] load;
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)entitySign, (String)"id", (QFilter[])filters);
        if (!tempCollection.isEmpty() && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entitySign))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("template", (Object)genGlobalLongId);
                multiMap.put((Object)entitySign, (Object)temp);
            });
        }
    }

    private void copyDataSetRecord(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, QFilter[] filters, String entitySign) {
        DynamicObject[] load;
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)entitySign, (String)"id", (QFilter[])filters);
        if (!tempCollection.isEmpty() && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entitySign))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("template", (Object)genGlobalLongId);
                multiMap.put((Object)entitySign, (Object)temp);
            });
        }
    }

    public DynamicObject copyBaseInfo(IDataModel dataModel, Double versionNum, DynamicObject template, CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap) {
        DynamicObject newTemplate = (DynamicObject)cloneUtil.clone((IDataEntityBase)template);
        Date effectiveDate = (Date)dataModel.getValue("effectivedate");
        newTemplate.set("effectivedate", (Object)effectiveDate);
        newTemplate.set("expiringdate", dataModel.getValue("expiringdate"));
        newTemplate.set("versiondescription", dataModel.getValue("versiondescription"));
        newTemplate.set("versionnumber", (Object)versionNum);
        newTemplate.set("status", (Object)"0");
        LocalDateTime localDateTime = LocalDateTime.now();
        Date now = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        RequestContext requestContext = RequestContext.get();
        newTemplate.set("creator", (Object)requestContext.getUserId());
        newTemplate.set("createtime", (Object)now);
        newTemplate.set("modifier", (Object)requestContext.getUserId());
        newTemplate.set("modifytime", (Object)now);
        long genGlobalLongId = GlobalIdUtil.genGlobalLongId();
        newTemplate.set("id", (Object)genGlobalLongId);
        if (template.getLong("cycletable.id") != 0L) {
            newTemplate.set("cycletable", (Object)template.getLong("cycletable.id"));
        }
        multiMap.put((Object)"bcm_templateentity", (Object)newTemplate);
        if (template.getDate("expiringdate") == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(effectiveDate.getTime() - 86400000L);
            effectiveDate = cal.getTime();
            template.set("expiringdate", (Object)effectiveDate);
            multiMap.put((Object)"bcm_templateentity", (Object)template);
        }
        return newTemplate;
    }

    private void executeWithTX(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                consumer.accept(txHandle);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
        }
    }

    private void saveTemplateInfo() {
        ArrayList waitSave;
        String selectStr = "id,cycletable,model.id,number,name, versionnumber, group, effectivedate, expiringdate, versiondescription,modifier,modifytime";
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long pkId = (Long)formShowParameter.getCustomParam("pkId");
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"bcm_templateentity", (String)selectStr, (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{pkId}).toArray());
        if (template != null) {
            IDataModel dataModel = this.getModel();
            Date effectiveDate = (Date)dataModel.getValue("effectivedate");
            template.set("effectivedate", (Object)effectiveDate);
            template.set("expiringdate", dataModel.getValue("expiringdate"));
            template.set("versiondescription", dataModel.getValue("versiondescription"));
            CommonSqlMsgUtil.modifi((DynamicObject)template);
            Pair<DynamicObject, DynamicObject> versionPair = this.getVersionPair(template.getLong("group"), template.getLong("id"));
            DynamicObject frontVersion = (DynamicObject)versionPair.p1;
            waitSave = Lists.newArrayListWithCapacity((int)2);
            waitSave.add(template);
            if (frontVersion != null && frontVersion.getDate("expiringdate") == null) {
                frontVersion = BusinessDataServiceHelper.loadSingle((Object)frontVersion.getLong("id"), (String)"bcm_templateentity", (String)selectStr);
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(effectiveDate.getTime() - 86400000L);
                effectiveDate = cal.getTime();
                frontVersion.set("expiringdate", (Object)effectiveDate);
                CommonSqlMsgUtil.modifi((DynamicObject)frontVersion);
                waitSave.add(frontVersion);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"TplVersionEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.update((DynamicObject[])waitSave.toArray(new DynamicObject[0]));
        this.saveStartPeriod(pkId);
        BigDecimal versionNumber = (BigDecimal)template.get("versionnumber");
        String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
        OperationLogUtil.writeOperationLog((IFormView)this.getView().getParentView(), (String)ResManager.loadKDString((String)"\u4fee\u6539\u7248\u672c\u4fe1\u606f", (String)"TplVersionEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,\u7248\u672c\u4fe1\u606f\u4fee\u6539\u6210\u529f", (String)"TplVersionEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getString("number"), template.getString("name"), version), (Long)ConvertUtil.convertObjToLong((Object)template.get("model.id")));
        view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"TplVersionEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        view.close();
    }

    private void saveStartPeriod(long templateId) {
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("template", "=", (Object)templateId);
        DeleteServiceHelper.delete((String)"bcm_temp_startperiod", (QFilter[])qFilter.toArray());
        if (this.getModel().getValue(STARTPERIOD) instanceof DynamicObject) {
            DynamicObject periodDyo = (DynamicObject)this.getModel().getValue(STARTPERIOD);
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_temp_startperiod");
            entity.set("model", (Object)modelId);
            entity.set("template", (Object)templateId);
            entity.set(STARTPERIOD, (Object)periodDyo.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        }
    }

    private boolean checkReportRecordForStartPeriod(DynamicObject recordDyo, long tempStartPeriod, Date date, Date recordDate, boolean isDefault) {
        if (tempStartPeriod != 0L && recordDyo != null) {
            LocalDateTime localDate = TemplateStartPeriodUtil.dateToLocalDateTime((Date)date);
            LocalDateTime localRecordDate = TemplateStartPeriodUtil.dateToLocalDateTime((Date)recordDate);
            if (localDate.getYear() == localRecordDate.getYear() && localRecordDate.getMonthValue() == localDate.getMonthValue()) {
                long modelId = this.getModelId();
                Map idDyoMap = (Map)ThreadCache.get((Object)String.join((CharSequence)"_", "checkReportRecordForStartPeriod", "" + modelId), () -> TemplateStartPeriodUtil.getPeriodForMRpt((long)modelId).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v)));
                DynamicObject periodDyo = (DynamicObject)idDyoMap.get(tempStartPeriod);
                DynamicObject recordPeriodDyo = (DynamicObject)idDyoMap.get(recordDyo.getLong("period.id"));
                if (periodDyo != null && recordPeriodDyo != null) {
                    boolean flag;
                    boolean bl = flag = periodDyo.getInt("dseq") <= recordPeriodDyo.getInt("dseq");
                    if (localRecordDate.getMonthValue() == 12) {
                        boolean is13Mrpt = "M_M13".equals(periodDyo.getString("number"));
                        boolean isR13Mrpt = "M_M13".equals(recordPeriodDyo.getString("number"));
                        if (is13Mrpt) {
                            flag = isR13Mrpt;
                        } else if (isR13Mrpt) {
                            flag = true;
                        }
                    }
                    return flag;
                }
            }
        }
        return isDefault;
    }

    private boolean checkReportRecordForStartPeriod(DynamicObject recordDyo, Date date, Date recordDate, boolean isAfter) {
        Object sPeriod = this.getModel().getValue(STARTPERIOD);
        if (recordDate != null && sPeriod instanceof DynamicObject && recordDyo != null) {
            return this.checkReportRecordForStartPeriod(recordDyo, ((DynamicObject)sPeriod).getLong("id"), date, recordDate, isAfter);
        }
        return isAfter;
    }

    private boolean validateRetionality() {
        Long pkId;
        DynamicObjectCollection reports;
        Date recordExpDate;
        String expDate;
        DynamicObject lastReport;
        List<DynamicObject> sortReports;
        QFilter filter2;
        QFilter filter1;
        QFilter[] filters;
        DynamicObjectCollection dynamicObjectCollection;
        IDataModel model = this.getModel();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date effectiveDate = (Date)model.getValue("effectivedate");
        if (effectiveDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.validateStartPeriod()) {
            return false;
        }
        Date expiringDate = (Date)model.getValue("expiringdate");
        if (expiringDate != null && format.format(expiringDate).compareTo(format.format(effectiveDate)) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject frontVersion = null;
        DynamicObject behindVersion = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String style = (String)formShowParameter.getCustomParam("style");
        if ("new".equals(style)) {
            Long group = (Long)formShowParameter.getCustomParam("group");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, model,versionnumber, group, effectivedate, expiringdate", (QFilter[])QFilter.of((String)"group = ?", (Object[])new Object[]{group}).toArray(), (String)"versionnumber desc", (int)1);
            if (!query.isEmpty()) {
                DynamicObject template;
                frontVersion = template = (DynamicObject)query.get(0);
            }
        } else {
            Long pkId2 = (Long)formShowParameter.getCustomParam("pkId");
            DynamicObject tempGroup = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id, group", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{pkId2}).toArray());
            if (tempGroup != null) {
                Pair<DynamicObject, DynamicObject> versionPair = this.getVersionPair(tempGroup.getLong("group"), pkId2);
                frontVersion = (DynamicObject)versionPair.p1;
                behindVersion = (DynamicObject)versionPair.p2;
            }
        }
        if (behindVersion != null && expiringDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u4e00\u7248\u672c\uff0c\u5931\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TplVersionEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date frontDate = null;
        Date behindDate = null;
        if (frontVersion != null && (frontDate = frontVersion.getDate("expiringdate")) == null) {
            frontDate = frontVersion.getDate("effectivedate");
        }
        if (behindVersion != null) {
            behindDate = behindVersion.getDate("effectivedate");
        }
        if (frontDate != null && format.format(effectiveDate).compareTo(format.format(frontDate)) <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u7248\u672c\u7684\u751f\u6548/\u5931\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (behindDate != null && expiringDate != null && format.format(expiringDate).compareTo(format.format(behindDate)) >= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u540e\u4e00\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (frontVersion != null && (dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,fyear.number,fyear.name,period.id,period.number,period.expdate,period.expmonth,period.expday", (QFilter[])(filters = new QFilter[]{filter1 = new QFilter("model", "in", (Object)frontVersion.getLong("model")), filter2 = new QFilter("template.id", "in", (Object)frontVersion.getLong("id"))}), (String)"fyear.number desc")) != null && !dynamicObjectCollection.isEmpty()) {
            LocalDateTime effectiveTime;
            sortReports = this.getSortReports(dynamicObjectCollection);
            lastReport = sortReports.get(0);
            expDate = TplVersionEditPlugin.getReportDate(lastReport);
            recordExpDate = null;
            try {
                recordExpDate = DateTimeUtils.parseStrDate((String)expDate);
            }
            catch (ParseException e) {
                recordExpDate = null;
            }
            if (recordExpDate != null && format.format(effectiveDate).compareTo(format.format(recordExpDate)) <= 0 && this.checkReportRecordForStartPeriod(lastReport, effectiveDate, recordExpDate, true)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u7248\u672c\u5b58\u5728\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\u7684\u6700\u665a\u8d22\u5e74\u671f\u95f4\u3002", (String)"TplVersionEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (recordExpDate != null && format.format(effectiveDate).compareTo(format.format(recordExpDate)) <= 0 && (effectiveTime = TemplateStartPeriodUtil.dateToLocalDateTime((Date)effectiveDate)).getDayOfMonth() == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u4e3a\u8c03\u6574\u671f\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\u8c03\u6574\u671f\u6240\u5728\u81ea\u7136\u6708\u7684\u7b2c\u4e00\u5929\u4f5c\u4e3a\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!"new".equals(style) && (reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,fyear.number,fyear.name,period.id,period.number,period.expdate,period.expmonth,period.expday", (QFilter[])(filters = new QFilter[]{filter2 = new QFilter("template.id", "in", (Object)(pkId = (Long)formShowParameter.getCustomParam("pkId")))}), (String)"fyear.number desc")) != null && !reports.isEmpty()) {
            sortReports = this.getSortReports(reports);
            lastReport = sortReports.get(0);
            expDate = TplVersionEditPlugin.getReportDate(lastReport);
            recordExpDate = null;
            try {
                recordExpDate = DateTimeUtils.parseStrDate((String)expDate);
            }
            catch (ParseException e) {
                recordExpDate = null;
            }
            if (expiringDate != null && recordExpDate != null && format.format(expiringDate).compareTo(format.format(recordExpDate)) < 0) {
                boolean flag = true;
                String periodNum = lastReport.getString("period.number");
                Collection periods = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.PERIOD.getNumber(), (String)MemberReader.findModelNumberById((Object)this.getModelId()));
                boolean hasAdjPeriod = periods.stream().anyMatch(p -> periodNum.equals(p.getProperty("relatednumber")) || periodNum.equals(p.getNumber()) && (Boolean)p.getProperty("isadjust") != false);
                LocalDateTime expiringDateTime = TemplateStartPeriodUtil.dateToLocalDateTime((Date)expiringDate);
                LocalDateTime reportDateTime = TemplateStartPeriodUtil.dateToLocalDateTime((Date)recordExpDate);
                if (hasAdjPeriod) {
                    boolean bl = flag = reportDateTime.getYear() != expiringDateTime.getYear() || reportDateTime.getMonth() != expiringDateTime.getMonth();
                }
                if (flag && behindVersion != null && expiringDate != null && behindDate != null) {
                    LocalDateTime behindDateTime = TemplateStartPeriodUtil.dateToLocalDateTime((Date)behindDate);
                    if (expiringDateTime.getYear() == behindDateTime.getYear() && expiringDateTime.getMonthValue() == behindDateTime.getMonthValue()) {
                        flag = this.checkReportRecordForStartPeriod(lastReport, TemplateStartPeriodUtil.getTempStartPeriod((long)behindVersion.getLong("id")), behindDate, recordExpDate, true);
                    }
                }
                if (flag) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u7248\u672c\u5b58\u5728\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\u7684\u6700\u665a\u8d22\u5e74\u671f\u95f4:%s\u3002\u5f53\u5b58\u5728\u8c03\u6574\u671f\u65f6\uff0c\u5931\u6548\u65e5\u671f\u624d\u53ef\u5728\u6700\u665a\u65e5\u671f\u6240\u5728\u81ea\u7136\u6708\u6700\u540e\u4e00\u5929\u4e4b\u524d\u3002", (String)"TplVersionEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), expDate);
                    this.getView().showErrorNotification(msg);
                    return false;
                }
            }
            int lastIndex = sortReports.size() - 1;
            DynamicObject firstReport = sortReports.get(lastIndex);
            String reportDate = TplVersionEditPlugin.getReportDate(firstReport);
            Date recordEffDate = null;
            try {
                recordEffDate = DateTimeUtils.parseStrDate((String)reportDate);
            }
            catch (ParseException e) {
                recordExpDate = null;
            }
            if (recordEffDate != null && effectiveDate != null && format.format(effectiveDate).compareTo(format.format(recordEffDate)) >= 0 && !this.checkReportRecordForStartPeriod(firstReport, effectiveDate, recordEffDate, false)) {
                String msg = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5f53\u524d\u7248\u672c\u5b58\u5728\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\u7684\u6700\u65e9\u8d22\u5e74\u671f\u95f4\u6700\u540e\u4e00\u5929\uff1a%s ", (String)"TplVersionEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), reportDate);
                this.getView().showErrorNotification(msg);
                return false;
            }
        }
        return true;
    }

    private List<DynamicObject> getSortReports(DynamicObjectCollection reports) {
        long modelId = this.getModelId();
        Map<String, Integer> periodSort = AnalyticsDimMemService.getMemberSort(modelId, DimTypesEnum.PERIOD.getNumber(), null);
        Map<String, Integer> yearSort = AnalyticsDimMemService.getMemberSort(modelId, DimTypesEnum.YEAR.getNumber(), null);
        List<DynamicObject> sortReports = reports.stream().sorted(TplVersionEditPlugin.yearComparator(yearSort).thenComparing(report -> (Integer)periodSort.get(((DynamicObject)report).getString("period.number")), Comparator.nullsLast(Integer::compareTo)).reversed()).collect(Collectors.toList());
        return sortReports;
    }

    private static String getReportDate(DynamicObject firstReport) {
        String year = firstReport.getString("fyear.number");
        int expmonth = firstReport.getInt("period.expmonth");
        int expday = firstReport.getInt("period.expday");
        int yearInt = Integer.parseInt(year.substring(2, 6));
        expday = expmonth == 2 && expday == 29 && !PeriodUtils.isLeapYear((int)yearInt) ? 28 : expday;
        return yearInt + "-" + expmonth + "-" + expday;
    }

    private static Comparator<Object> yearComparator(Map<String, Integer> yearSort) {
        return Comparator.comparing(report -> (Integer)yearSort.get(((DynamicObject)report).getString("fyear.number")), Comparator.nullsLast(Integer::compareTo));
    }

    private Pair<DynamicObject, DynamicObject> getVersionPair(long groupId, Long pkId) {
        Pair result = Pair.onePair(null, null);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, model,versionnumber, group, effectivedate, expiringdate", (QFilter[])QFilter.of((String)"group = ?", (Object[])new Object[]{groupId}).toArray(), (String)"versionnumber desc");
        int index = 0;
        if (!query.isEmpty()) {
            for (int i = 0; i < query.size(); ++i) {
                DynamicObject temp = (DynamicObject)query.get(i);
                if (temp.getLong("id") != pkId.longValue()) continue;
                index = i;
                break;
            }
        }
        if (index - 1 >= 0) {
            result = Pair.onePair((Object)result.p1, (Object)query.get(index - 1));
        }
        if (index + 1 < query.size()) {
            result = Pair.onePair((Object)query.get(index + 1), (Object)result.p2);
        }
        return result;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit unfloatmem = (BasedataEdit)this.getControl(STARTPERIOD);
        unfloatmem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public long getModelId() {
        if (this.getPageCache().get(CURRENT_MODEL) != null) {
            return LongUtil.toLong((Object)this.getPageCache().get(CURRENT_MODEL));
        }
        String style = (String)this.getFormCustomParam("style");
        QFilter qFilter = "new".equals(style) ? new QFilter("group", "=", (Object)this.getFormCustomParam("group", 0L)) : new QFilter("id", "=", (Object)this.getFormCustomParam("pkId", 0L));
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"model.id", (QFilter[])qFilter.toArray());
        long modelId = 0L;
        if (object != null) {
            modelId = object.getLong("model.id");
            this.getPageCache().put(CURRENT_MODEL, Long.toString(modelId));
        }
        return modelId;
    }

    private QFilter getPeriodQFilter() {
        List<Long> periodIds = this.getEffectStartPeriodIds();
        if (CollectionUtils.isEmpty(periodIds) || periodIds.size() == 1) {
            return new QFilter("1", "=", (Object)0);
        }
        return new QFilter("id", "in", periodIds);
    }

    private List<Long> getEffectStartPeriodIds() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (this.getModel().getValue("effectivedate") == null) {
            return ids;
        }
        LocalDateTime effectDate = TemplateStartPeriodUtil.dateToLocalDateTime((Date)((Date)this.getModel().getValue("effectivedate")));
        LocalDateTime expiringdate = this.getModel().getValue("expiringdate") == null ? null : TemplateStartPeriodUtil.dateToLocalDateTime((Date)((Date)this.getModel().getValue("expiringdate")));
        List objects = TemplateStartPeriodUtil.getPeriodForMRpt((long)this.getModelId());
        for (DynamicObject object : objects) {
            if (!TemplateStartPeriodUtil.isEffectStartPeriod((LocalDateTime)effectDate, (LocalDateTime)expiringdate, (DynamicObject)object)) continue;
            ids.add(object.getLong("id"));
        }
        return ids;
    }

    private boolean validateStartPeriod() {
        if (this.getModel().getValue(STARTPERIOD) instanceof DynamicObject) {
            List<Long> periodIds = this.getEffectStartPeriodIds();
            if (periodIds.contains(((DynamicObject)this.getModel().getValue(STARTPERIOD)).getLong("id"))) {
                if (periodIds.size() > 1) {
                    return true;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u751f\u6548\u65e5\u671f\u4e0d\u5b58\u5728\u591a\u4e2a\u671f\u95f4\uff0c\u751f\u6548\u8d77\u59cb\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"TplVersionEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u671f\u95f4\u4e0d\u5728\u6240\u9009\u751f\u6548\u65e5\u671f\u5185\uff0c\u751f\u6548\u8d77\u59cb\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"TplVersionEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String methodName = PlatUtil.getOpMethod();
        long modelId = this.getModelId();
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.PERIOD.getNumber());
        if ("click".equalsIgnoreCase(methodName) || "getLookupList".equalsIgnoreCase(methodName) || "showMore".equalsIgnoreCase(methodName)) {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(filter);
            qFilters.add(SingleMemberF7Util.getPermissionFilter(DimEntityNumEnum.PERIOD.getEntityNum(), dimId, modelId));
            qFilters.add(this.getPeriodQFilter());
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, (String)null));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (STARTPERIOD.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            this.getModel().setValue(STARTPERIOD, (Object)result);
        }
    }
}

