/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeMenuNode;

public class AbstractTreeMenuNode
extends TreeMenuNode
implements Comparable<AbstractTreeMenuNode>,
Serializable {
    private static final long serialVersionUID = -8458091176049949893L;
    protected int seq;
    protected boolean hidden = true;
    protected Map<String, Object> customParam;
    private String id;
    private String parentId;
    private String name;
    private int level;
    private List<TreeMenuNode> children;

    public AbstractTreeMenuNode(String id, String parentid, String name) {
        super(parentid, id, name);
        this.id = id;
        this.parentId = parentid;
        this.name = name;
        this.level = 0;
        this.customParam = new HashMap<String, Object>();
    }

    public void addCustomParam(String key, Object value) {
        this.customParam.put(key, value);
    }

    public Object getCustomParam(String key) {
        return this.customParam.get(key);
    }

    public String get_Id() {
        return this.id;
    }

    public String get_Parentid() {
        return this.parentId;
    }

    public String get_Text() {
        return this.name;
    }

    protected AbstractTreeMenuNode() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TreeMenuNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeMenuNode> arrayList) {
        this.children = arrayList;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        this.customParam = customParam;
    }

    public void sort() {
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList _children = Lists.newArrayList();
            this.children.forEach(c -> {
                AbstractTreeMenuNode temp = (AbstractTreeMenuNode)c;
                temp.sort();
                _children.add(temp);
            });
            Collections.sort(_children);
            this.children.clear();
            this.children.addAll(_children);
        }
    }

    @Override
    public int compareTo(AbstractTreeMenuNode o) {
        return Integer.compare(this.seq, o.seq);
    }

    public TreeMenuNode addChild(TreeMenuNode node) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (node != null) {
            this.getChildren().add(node);
        }
        return this;
    }

    public TreeMenuNode addChild(int i, TreeMenuNode node) {
        if (this.children == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (node != null) {
            if (i < this.children.size()) {
                this.children.add(i, node);
            } else {
                this.children.add(node);
            }
        }
        return this;
    }

    public TreeMenuNode addChildren(List<TreeMenuNode> nodes) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (nodes != null) {
            this.getChildren().addAll(nodes);
        }
        return this;
    }

    public TreeMenuNode getTreeNode(String id, int maxLevel) {
        if (this.id.equalsIgnoreCase(id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                TreeMenuNode node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public int getNodeLevel(String id, int startLevel) {
        if (this.id.equalsIgnoreCase(id)) {
            return startLevel;
        }
        if (this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                int currLevel = child.getNodeLevel(id, startLevel + 1);
                if (currLevel == -1) continue;
                return currLevel;
            }
        }
        return -1;
    }
}

