/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree.chk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ChkTreeBuilder
extends TreeBuilder {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";

    private static DynamicObjectCollection getOrgTreeListCollection(Long modelid, String fyNum, Long yearId, Long scenarioId, Long periodId, Long cslschemeId, IPageCache pageCache, Object ... params) {
        String yearNum = fyNum;
        String _periodId = periodId == 0L ? "" : "" + periodId;
        String modelId = modelid == 0L ? "" : "" + modelid;
        Pair schemePair = params != null && params.length > 0 ? (Pair)params[0] : null;
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)MODEL, (Object)modelId);
        param.set("period", (Object)_periodId);
        param.set("year", (Object)yearNum);
        param.set("scenario", (Object)scenarioId);
        param.setCslScheme(schemePair);
        DynamicObjectCollection doc = CslSchemeServiceHelper.getOrgDynamicObjectCollection((CslSchemeServiceHelper.QueryOrgParam)param);
        OrgServiceHelper.dealNoMergeOrgs((DynamicObjectCollection)doc, (Long)modelid, (Long)scenarioId, (Long)yearId, (Long)periodId, null);
        ChkTreeBuilder.delOrgMemberPerm(doc, modelid, pageCache);
        return doc;
    }

    private static void delOrgMemberPerm(DynamicObjectCollection doc, Object modelId, IPageCache pageCache) {
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(modelId)) {
            return;
        }
        QFilter filter = new QFilter(MODEL, "=", modelId);
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"dimension", (QFilter[])new QFilter[]{filter});
        if (dimension == null) {
            return;
        }
        long dimensionId = dimension.getLong("dimension");
        PermissionService permService = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
        PermPackageList perms = permService.getDimPermSet(Long.valueOf(dimensionId));
        pageCache.put(PermCacheKey.ORG_PERM_CACHE_KEY, SerializationUtils.toJsonString((Object)perms));
        Map relationMap = MemberPermHelper.BuildPCRelation((DynamicObjectCollection)doc);
        Iterator permIt = doc.iterator();
        while (permIt.hasNext()) {
            DynamicObject dd = (DynamicObject)permIt.next();
            boolean flag = MemberPermHelper.memberCanShow((Object)dd.getLong("id"), (PermPackageList)perms, (Map)relationMap);
            if (flag) continue;
            permIt.remove();
        }
    }

    private static DynamicObjectCollection getTempTreeListCollection(long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        if (modelId != 0L) {
            qfBuilder.add(MODEL, "=", (Object)modelId);
            qfBuilder.add(TemplateCatalogTypeEnum.getTemplateCalcog());
        }
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", qfBuilder.toArray(), "sequence");
        return doc;
    }

    public static OrgTreeNode getOrgTree(Long modelId, String fyNum, Long yearId, Long scenarioId, Long period, Long cslschemeId, String showType, IPageCache pageCache, Object ... params) {
        DynamicObjectCollection rootNodeList = ChkTreeBuilder.getOrgTreeListCollection(modelId, fyNum, yearId, scenarioId, period, cslschemeId, pageCache, params);
        OrgTreeNode root = new OrgTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ChkTreeBuilder_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        OrgTreeNode orgRoot = TreeBuilder.getOrgTree((DynamicObjectCollection)rootNodeList, (OrgTreeNode)root, (String)showType);
        OrgServiceHelper.dealNoMergeOrgs((DynamicObjectCollection)rootNodeList, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)period, (OrgTreeNode)orgRoot);
        return orgRoot;
    }

    public static TemplateTreeNode getTempTree(long modelId, String showType, boolean hasNoneTemp) {
        QFilter qf = new QFilter("templatetype", "not in", (Object)Lists.newArrayList((Object[])new String[]{TemplateTypeEnum.MSN.getType() + "", TemplateTypeEnum.OTHERWP.getType() + ""}));
        qf.and("status", "=", (Object)Character.valueOf('1'));
        return ChkTreeBuilder.getTempTree(modelId, showType, qf, hasNoneTemp);
    }

    public static TemplateTreeNode getTempTree(long modelId, String showType, QFilter qFilter, boolean hasNoneTemp) {
        ArrayListMultimap map;
        List noPermIds;
        DynamicObjectCollection rootNodeList = ChkTreeBuilder.getTempTreeListCollection(modelId);
        TemplateTreeNode root = new TemplateTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ChkTreeBuilder_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)modelId);
        qfBuilder.add(qFilter);
        boolean ifUserHasRootPermByModel = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
        if (!ifUserHasRootPermByModel && !CollectionUtils.isEmpty((Collection)(noPermIds = (map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)String.valueOf(RequestContext.getOrCreate().getCurrUserId()))).get((Object)"1")))) {
            qfBuilder.add("id", "not in", (Object)noPermIds);
        }
        root = TreeBuilder.getTemplateTreeNew((DynamicObjectCollection)rootNodeList, (TemplateTreeNode)root, () -> ((QFBuilder)qfBuilder).toArray(), (String)showType, null);
        if (hasNoneTemp) {
            TemplateTreeNode child = new TemplateTreeNode("1", ResManager.loadKDString((String)"\u4e0d\u533a\u5206\u6a21\u677f", (String)"ChkTreeBuilder_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "TemplateNone", false);
            child.setParent((ITreeNode)root);
            root.getChildren().add(0, child);
        }
        root.SetIsOpened(true);
        return root;
    }
}

