/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.formplugin.tree.dimension.AccountTreeNode;

public class AccountTreeBuilder {
    public static AccountTreeNode getAccountTreeNode(DynamicObjectCollection rootNodeList) {
        return AccountTreeBuilder.getAccountTreeRoot(rootNodeList);
    }

    private static AccountTreeNode getAccountTreeRoot(DynamicObjectCollection rootNodeList) {
        HashMap<String, List<DynamicObject>> nodeMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject node : rootNodeList) {
            String parentId = node.getString("parent");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)nodeMap.get(parentId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                nodeMap.put(parentId, list);
            }
            list.add(node);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (DynamicObject)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        return AccountTreeBuilder.createNode(rootNode, null, nodeMap);
    }

    private static AccountTreeNode createNode(DynamicObject map, AccountTreeNode parentNode, Map<String, List<DynamicObject>> nodeMap) {
        String id = map.getString("id");
        String name = map.getString("name");
        String number = map.getString("number");
        String storageType = map.getString("storagetype");
        String accounttype = map.getString("accounttype");
        AccountTreeNode curNode = new AccountTreeNode(id, name, number, storageType, accounttype);
        List<DynamicObject> list = nodeMap.get(id);
        curNode.SetIsOpened(true);
        String formatName = number + " " + name;
        if (parentNode != null) {
            curNode.setParent((ITreeNode)parentNode);
            parentNode.addChild((ITreeNode<Object>)curNode);
        }
        if (list != null) {
            for (DynamicObject dnm : list) {
                AccountTreeBuilder.createNode(dnm, curNode, nodeMap);
            }
            curNode.setName(formatName + "(" + curNode.getChildsize() + ")");
        } else {
            curNode.setName(formatName);
        }
        return curNode;
    }
}

