/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree.invest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.formplugin.tree.invest.InvDynRelationRatioTreeNode;

public class InvDynRelationRatioTreeBuilder {
    public static List<ITreeNode<DynamicObject>> bulidTreeWithOrder(DynamicObjectCollection doc) {
        ArrayList<ITreeNode<DynamicObject>> trees = new ArrayList<ITreeNode<DynamicObject>>(16);
        HashMap<String, List> childrenMap = new HashMap<String, List>(16);
        for (DynamicObject dynamicObject : doc) {
            InvDynRelationRatioTreeNode node = new InvDynRelationRatioTreeNode(dynamicObject.getString("id"), dynamicObject);
            if (dynamicObject.getInt("level") == 2) {
                trees.add((ITreeNode<DynamicObject>)node);
                continue;
            }
            childrenMap.computeIfAbsent(InvDynRelationRatioTreeBuilder.getKey(dynamicObject), k -> new ArrayList(16)).add(node);
        }
        trees.sort(Comparator.comparing(e -> ((DynamicObject)e.getData()).getString("year.number"), Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(e -> ((DynamicObject)e.getData()).getInt("period.expmonth"), Comparator.reverseOrder()).thenComparing(e -> ((DynamicObject)e.getData()).getInt("period.expday"), Comparator.reverseOrder()).thenComparing(e -> ((DynamicObject)e.getData()).getString("investeecompanynumber"), Comparator.nullsLast(String::compareTo)).thenComparing(e -> ((DynamicObject)e.getData()).getString("shareholdernumber"), Comparator.nullsLast(String::compareTo)).thenComparing(e -> ((DynamicObject)e.getData()).getString("invchangetypename"), Comparator.nullsLast(String::compareTo)));
        for (ITreeNode iTreeNode : trees) {
            List children = (List)childrenMap.get(InvDynRelationRatioTreeBuilder.getKey((DynamicObject)iTreeNode.getData()));
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            children.sort(Comparator.comparing(e -> ((DynamicObject)e.getData()).getDate("investdate"), Comparator.nullsLast(Comparator.reverseOrder())));
            for (InvDynRelationRatioTreeNode child : children) {
                child.setParent(iTreeNode);
                iTreeNode.addChild((ITreeNode)child);
            }
        }
        return trees;
    }

    private static String getKey(DynamicObject dyn) {
        return String.format("%s_%s_%s_%s_%s", dyn.getLong("year"), dyn.getLong("period"), dyn.getString("investeecompanynumber"), dyn.getString("shareholdernumber"), dyn.getLong("invchangetype.id"));
    }
}

