/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.tree.task.TaskCataLog;
import kd.fi.bcm.formplugin.tree.task.TaskParam;
import kd.fi.bcm.formplugin.tree.task.TaskTreeNode;

public class TaskTreeBulider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CACHE_KEY = "key_treebulider";
    private Map<String, TemplateModel> map;
    private Map<String, Boolean> isRange;

    public Map<String, TemplateModel> getMap() {
        return this.map;
    }

    public void setMap(Map<String, TemplateModel> map) {
        this.map = map;
    }

    public Map<String, Boolean> getIsRange() {
        return this.isRange;
    }

    public void setIsRange(Map<String, Boolean> isRange) {
        this.isRange = isRange;
    }

    public TaskTreeNode initTree(String userId, Boolean isoverdue, Boolean isdue, Boolean isundue, Boolean iscomplete, Boolean isMyTaskList, ApplicationTypeEnum app) {
        TaskTreeNode root = new TaskTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskTreeBulider_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        root.setNodetype(TaskTypeEnum.VIRTUAL);
        root.SetIsOpened(true);
        List catalogs = MyTaskServiceHelper.getTaskCataLogByUserAndApplication((String)userId, (ApplicationTypeEnum)app);
        List<DynamicObject> taskstatus0 = this.getTaskbyFilter(userId, isoverdue, isdue, isundue, iscomplete);
        Map<String, List<DynamicObject>> bycatalog = this.group(taskstatus0, "reporttask.taskcatalog.id");
        Map<String, TemplateModel> map = this.getMap();
        Map<String, Boolean> isRange = this.getIsRange();
        Map<Long, TaskCataLog> taskCataLogMap = this.getAllTaskcatalogMsg(catalogs);
        Set<Long> modelIds = this.getAllDistributeModel(taskCataLogMap);
        Map<Long, DynamicObjectCollection> idToOrgs = this.getAllModelHavePermOrg(modelIds);
        for (Long log : catalogs) {
            String catalogid = String.valueOf(log);
            TaskCataLog taskCataLog = this.getTaskcatalogMsg(catalogid);
            TaskTreeNode catalog = this.buildCatalogInfo(catalogid, root, taskCataLog, isMyTaskList);
            List<DynamicObject> listbycatalog = bycatalog.get(catalogid);
            String modelid = "";
            if (listbycatalog == null || listbycatalog.size() == 0) continue;
            modelid = listbycatalog.get(0).getString("model");
            TaskCataLog cataLog2 = taskCataLogMap.get(log);
            FilterOrgStructParam param = new FilterOrgStructParam(cataLog2.getModelId().longValue(), Long.parseLong(String.valueOf(cataLog2.getScenario().getId())), cataLog2.getYear().getNumber().toString(), Long.parseLong(String.valueOf(cataLog2.getPeriod().getId())));
            param.setFrom(FilterOrgStructParam.FROM_TASK);
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, listbycatalog);
            if (map == null) {
                map = new HashMap<String, TemplateModel>();
            }
            if (isRange == null) {
                isRange = new HashMap<String, Boolean>();
            }
            this.setMap(map);
            this.setIsRange(isRange);
            Map<String, DynamicObject> confmap = taskCataLog.getConfmap();
            this.filterOrg(listbycatalog, idToOrgs.get(Long.valueOf(modelid)), taskCataLogMap.get(log));
            HashSet<Object> tempids = new HashSet<Object>();
            HashSet<TemplateModel> tempmodels = new HashSet<TemplateModel>();
            List<TemplateModel> result = this.getAndCacheTemp(map, Long.parseLong(modelid), listbycatalog, tempids, tempmodels);
            HashSet<String> notintempids = new HashSet<String>();
            HashSet<String> notinstatusids = new HashSet<String>();
            String curnumber = (String)taskCataLog.getCurrency().getNumber();
            Object curId = taskCataLog.getCurrency().getId();
            this.getNoPermRecord(map, isRange, taskCataLog, listbycatalog, result, notintempids, notinstatusids, curId, curnumber, Long.parseLong(modelid));
            Iterator<DynamicObject> it = listbycatalog.iterator();
            while (it.hasNext()) {
                DynamicObject obj = it.next();
                if (!notintempids.contains(obj.getString("template")) && !notinstatusids.contains(obj.getString("id"))) continue;
                it.remove();
            }
            if (listbycatalog.size() == 0) continue;
            root.addChild((ITreeNode)catalog);
            Map<String, List<DynamicObject>> byorg = this.group(listbycatalog, "entity");
            Set<Map.Entry<String, List<DynamicObject>>> byorgset = byorg.entrySet();
            HashMap<String, DynamicObject> showMap = new HashMap<String, DynamicObject>(16);
            for (Map.Entry<String, List<DynamicObject>> entry : byorgset) {
                showMap.clear();
                List<DynamicObject> listbyorg = entry.getValue();
                if (listbyorg.size() == 0) continue;
                String orgid = entry.getKey();
                TaskTreeNode org = new TaskTreeNode(taskCataLog.getConfrootid() + "_" + orgid, listbyorg.get(0).getString("entity.name"), catalog);
                org.setOrgId(orgid);
                org.setModelId(modelid);
                org.setNodetype(TaskTypeEnum.ORG_DISPLAY);
                org.setOrgId(orgid);
                org.setCatalog(taskCataLog);
                ArrayList<DynamicObject> showlist = new ArrayList();
                for (DynamicObject obj : listbyorg) {
                    String reporttaskid = obj.getString("reporttask");
                    DynamicObject conf = confmap.get(reporttaskid);
                    if (Objects.isNull(conf)) continue;
                    showMap.put(reporttaskid, conf);
                    String pid = conf.getString("parent");
                    while (!"0".equals(pid)) {
                        conf = confmap.get(pid);
                        showMap.put(pid, conf);
                        pid = conf.getString("parent");
                    }
                }
                Collection valueCollection = showMap.values();
                showlist = new ArrayList(valueCollection);
                if (showMap.size() <= 0) continue;
                catalog.addChild((ITreeNode)org);
                Map<String, List<DynamicObject>> bytask = this.group(listbyorg, "reporttask");
                if (isMyTaskList.booleanValue()) {
                    this.buildOrgForMyTask(org, showlist, taskCataLog.getConfrootid(), orgid, modelid, bytask, taskCataLog, taskCataLog.getRootTaskid());
                    continue;
                }
                this.buildOrg(org, showlist, taskCataLog.getConfrootid(), orgid, modelid, bytask, taskCataLog);
            }
        }
        return root;
    }

    private void getNoPermRecord(Map<String, TemplateModel> map, Map<String, Boolean> isRange, TaskCataLog taskCataLog, List<DynamicObject> listbycatalog, List<TemplateModel> result, Set<String> notintempids, Set<String> notinstatusids, Object curId, String curnumber, long modelid) {
        for (TemplateModel temp : result) {
            boolean isin = true;
            HashMap<String, String> checkmap = new HashMap<String, String>();
            checkmap.put((String)taskCataLog.getYear().getNumber(), "bcm_fymembertree");
            checkmap.put((String)taskCataLog.getPeriod().getNumber(), "bcm_periodmembertree");
            checkmap.put((String)taskCataLog.getScenario().getNumber(), "bcm_scenemembertree");
            Set checkmapset = checkmap.entrySet();
            boolean isbreak = false;
            for (Map.Entry entry : checkmapset) {
                if (isRange.containsKey(String.valueOf(temp.getId()) + "," + (String)entry.getKey())) {
                    isin = isRange.get(String.valueOf(temp.getId()) + "," + (String)entry.getKey());
                } else {
                    isin = TemplateRangeService.isInnerRange((String)((String)entry.getValue()), (TemplateModel)temp, (Object)this.getIdByNumber((String)entry.getValue(), (String)entry.getKey(), modelid));
                    isRange.put(String.valueOf(temp.getId()) + "," + (String)entry.getKey(), isin);
                }
                if (isin) continue;
                notintempids.add(String.valueOf(temp.getId()));
                isbreak = true;
                break;
            }
            if (isbreak) break;
            if ("EC".equals(curnumber)) continue;
            if (isRange.containsKey(String.valueOf(temp.getId()) + "," + curnumber)) {
                isin = isRange.get(String.valueOf(temp.getId()) + "," + curnumber);
            } else {
                isin = TemplateRangeService.isInnerRange((String)"bcm_currencymembertree", (TemplateModel)temp, (Object)curId);
                isRange.put(String.valueOf(temp.getId()) + "," + curnumber, isin);
            }
            if (isin) continue;
            notintempids.add(String.valueOf(temp.getId()));
        }
        if ("EC".equals(curnumber)) {
            for (DynamicObject taskEntry : listbycatalog) {
                boolean iscurrencyin = true;
                curnumber = taskEntry.getString("currency.number");
                TemplateModel temp = map.get(taskEntry.getString("template"));
                if (temp == null) continue;
                if (isRange.containsKey(String.valueOf(temp.getId()) + "," + curnumber)) {
                    iscurrencyin = isRange.get(String.valueOf(temp.getId()) + "," + curnumber);
                } else {
                    iscurrencyin = TemplateRangeService.isInnerRange((String)"bcm_currencymembertree", (TemplateModel)temp, (Object)taskEntry.getLong("currency.id"));
                    isRange.put(String.valueOf(temp.getId()) + "," + curnumber, iscurrencyin);
                }
                if (iscurrencyin) continue;
                notinstatusids.add(taskEntry.getString("id"));
            }
        }
    }

    private Object getIdByNumber(String entity, String number, long modelid) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("model", "=", (Object)modelid)};
        DynamicObject at = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id", (QFilter[])filters);
        return at.getLong("id");
    }

    private List<TemplateModel> getAndCacheTemp(Map<String, TemplateModel> map, long modelId, List<DynamicObject> listbycatalog, Set<Object> tempids, Set<TemplateModel> tempmodels) {
        for (DynamicObject taskEntry : listbycatalog) {
            TemplateModel tem = map.get(taskEntry.getString("template"));
            if (tem != null) {
                tempmodels.add(tem);
                continue;
            }
            tempids.add(taskEntry.getLong("template"));
        }
        List result = TemplateRangeService.getTemplateModels(tempids, (long)modelId, (boolean)false, (boolean)true);
        result.addAll(tempmodels);
        for (TemplateModel temp : result) {
            map.put(String.valueOf(temp.getId()), temp);
        }
        return result;
    }

    private TaskTreeNode buildCatalogInfo(String catalogid, TaskTreeNode root, TaskCataLog taskCataLog, boolean isMyTaskList) {
        TaskTreeNode catalog = new TaskTreeNode(taskCataLog.getConfrootid(), taskCataLog.getName(), root);
        catalog.setTaskId(taskCataLog.getConfrootid());
        catalog.setCatalog(taskCataLog);
        catalog.setNodetype(TaskTypeEnum.ROOT);
        catalog.SetIsOpened(false);
        if (taskCataLog.isIsshowexplain()) {
            TaskTreeNode explain = new TaskTreeNode(taskCataLog.getConfrootid() + "_explain", ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"TaskTreeBulider_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), catalog);
            explain.setTaskId(taskCataLog.getConfrootdiscribeid());
            explain.setCatalog(taskCataLog);
            explain.setNodetype(TaskTypeEnum.EXPLAIN);
            explain.SetIsOpened(false);
            catalog.addChild((ITreeNode)explain);
        }
        if (!isMyTaskList) {
            DynamicObjectCollection taskconf = taskCataLog.getConf();
            String paramname = "";
            for (DynamicObject dynamicObject : taskconf) {
                if (!"1".equals(dynamicObject.getString("tasktype"))) continue;
                paramname = dynamicObject.getString("name");
                break;
            }
            TaskTreeNode param = new TaskTreeNode(taskCataLog.getConfrootid() + "_param", paramname, catalog);
            param.setTaskId(taskCataLog.getConfrootparamid());
            param.setCatalog(taskCataLog);
            param.setNodetype(TaskTypeEnum.PARAM);
            param.SetIsOpened(false);
            catalog.addChild((ITreeNode)param);
        }
        return catalog;
    }

    private void filterOrg(List<DynamicObject> taskstatus, DynamicObjectCollection orghaveperm, TaskCataLog cataLog) {
        HashSet<Long> permorgids = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        if (orghaveperm != null) {
            for (DynamicObject obj : orghaveperm) {
                permorgids.add(obj.getLong("id"));
                if (obj.getBoolean("isleaf")) continue;
                noLeafIds.add(obj.getLong("id"));
            }
        }
        Map nodeMap = TreeStructureServiceHelper.getAllNode((String)"bcm_entitymembertree", (Object)cataLog.getModelId());
        block1: for (Long noLeafId : noLeafIds) {
            IDNumberTreeNode node = (IDNumberTreeNode)nodeMap.get(noLeafId);
            if (node == null) continue;
            Set ids = TreeStructureServiceHelper.getIds((List)node.getAllChildren());
            for (Long id : permorgids) {
                if (!ids.contains(id)) continue;
                permorgids.remove(noLeafId);
                continue block1;
            }
        }
        if (taskstatus != null) {
            for (int i = taskstatus.size() - 1; i >= 0; --i) {
                if (permorgids.contains(taskstatus.get(i).getLong("entity"))) continue;
                taskstatus.remove(i);
            }
        }
    }

    private Map<Long, DynamicObjectCollection> getAllModelHavePermOrg(Set<Long> models) {
        HashMap<Long, DynamicObjectCollection> idToOrgs = new HashMap<Long, DynamicObjectCollection>(models.size());
        for (Long modelId : models) {
            DynamicObjectCollection orghaveperm = TemplateRangeService.getHavePermOrgSet_task((Object)modelId);
            idToOrgs.put(modelId, orghaveperm);
        }
        return idToOrgs;
    }

    private void buildOrg(TaskTreeNode root, List<DynamicObject> showlist, String id, String orgid, String modelId, Map<String, List<DynamicObject>> bytask, TaskCataLog taskCataLog) {
        for (DynamicObject obj : showlist) {
            if (!id.equals(obj.getString("parent"))) continue;
            TaskTreeNode node = new TaskTreeNode(orgid + "_" + obj.getString("id"), obj.getString("name"), root);
            node.setOrgId(orgid);
            node.setTaskId(obj.getString("id"));
            node.setCatalog(taskCataLog);
            node.setModelId(modelId);
            if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(obj.getString("tasktype"))) {
                node.setNodetype(TaskTypeEnum.REPORT);
                ReportPostmanByEntity pm = new ReportPostmanByEntity(orgid, taskCataLog.getScenario().getId(), taskCataLog.getYear().getId(), taskCataLog.getPeriod().getId(), taskCataLog.getCurrency().getId(), modelId);
                List<DynamicObject> list = bytask.get(obj.getString("id"));
                list.sort((t1, t2) -> t1.getString("tempnum").compareTo(t2.getString("tempnum")));
                for (DynamicObject tem : list) {
                    pm.addPair(tem.get("template"), null);
                }
                node.setData(pm);
            } else if (String.valueOf(TaskTypeEnum.LABEL.getValue()).equals(obj.getString("tasktype"))) {
                node.setNodetype(TaskTypeEnum.LABEL);
            }
            root.addChild((ITreeNode)node);
            this.buildOrg(node, showlist, obj.getString("id"), orgid, modelId, bytask, taskCataLog);
        }
    }

    private void buildOrgForMyTask(TaskTreeNode root, List<DynamicObject> showlist, String parentId, String orgid, String modelId, Map<String, List<DynamicObject>> bytask, TaskCataLog taskCataLog, Long rootTaskId) {
        for (DynamicObject obj : showlist) {
            if (!parentId.equals(obj.getString("parent"))) continue;
            TaskTreeNode node = new TaskTreeNode(orgid + "_" + obj.getString("id"), obj.getString("name"), root);
            node.setOrgId(orgid);
            node.setTaskId(obj.getString("id"));
            node.setCatalog(taskCataLog);
            node.setModelId(modelId);
            node.setRootid(rootTaskId);
            if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(obj.getString("tasktype")) || String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(obj.getString("tasktype"))) {
                List<DynamicObject> list = bytask.get(obj.getString("id"));
                int k = 0;
                for (DynamicObject tem : list) {
                    TaskTreeNode childNode = new TaskTreeNode(tem.getString("id"), tem.getString("tempName"), root);
                    childNode.setNodetype(TaskTypeEnum.REPORT_UNIT);
                    childNode.setOrgId(orgid);
                    childNode.setTaskId(obj.getString("id"));
                    childNode.setModelId(modelId);
                    childNode.setRootid(rootTaskId);
                    HashMap<String, Object> childObject = new HashMap<String, Object>(16);
                    childObject.put("remaintime", null);
                    childObject.put("financeyear", tem.getString("fyname"));
                    childObject.put("period", tem.getString("periodname"));
                    childObject.put("scenario", tem.getString("scenarioname"));
                    childObject.put("taskstatus", tem.getString("taskstatus"));
                    childObject.put("orgid", orgid);
                    childObject.put("taskname", tem.getString("tempName"));
                    childObject.put("tempnum", tem.getString("tempNum"));
                    childObject.put("id", tem.getLong("id"));
                    childObject.put("rootid", rootTaskId);
                    childObject.put("taskid", tem.getLong("reporttask"));
                    childObject.put("modifier", tem.getString("modifier"));
                    childObject.put("modifytime", tem.getDate("modifytime"));
                    childObject.put("reportstatus", tem.getString("reportstatus"));
                    childObject.put("tasktype", TaskTypeEnum.REPORT_UNIT.getValue());
                    childObject.put("memberid", tem.getLong("template"));
                    childObject.put("seq", k);
                    childObject.put("endtime", obj.getDate("endtime"));
                    childObject.put("warningbegintime", obj.getDate("warningbegintime"));
                    childNode.setDetailData(childObject);
                    ++k;
                    node.addChild((ITreeNode)childNode);
                }
            }
            TaskTypeEnum taskType = TaskTypeEnum.getTaskTypeByVal((int)obj.getInt("tasktype"));
            node.setNodetype(taskType);
            HashMap<String, Object> currentObject = new HashMap<String, Object>();
            currentObject.put("tasktype", obj.getInt("tasktype"));
            currentObject.put("orgid", orgid);
            currentObject.put("taskname", obj.getString("name"));
            currentObject.put("tempnum", "");
            currentObject.put("tempid", "");
            currentObject.put("seq", obj.getInt("kseq"));
            currentObject.put("memberid", obj.getLong("id"));
            currentObject.put("rootid", rootTaskId);
            currentObject.put("taskid", obj.getLong("id"));
            currentObject.put("id", node.getId());
            currentObject.put("endtime", obj.getDate("endtime"));
            currentObject.put("warningbegintime", obj.getDate("warningbegintime"));
            node.setDetailData(currentObject);
            root.addChild((ITreeNode)node);
            this.buildOrgForMyTask(node, showlist, obj.getString("id"), orgid, modelId, bytask, taskCataLog, rootTaskId);
        }
    }

    private Map<String, List<DynamicObject>> group(List<DynamicObject> oldlist, String groupBy) {
        LinkedHashMap<String, List<DynamicObject>> gop = new LinkedHashMap<String, List<DynamicObject>>(16);
        for (DynamicObject obj : oldlist) {
            String org = obj.getString(groupBy);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)gop.get(org);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
            }
            list.add(obj);
            gop.put(org, list);
        }
        return gop;
    }

    private List<DynamicObject> getTaskbyFilter(String userId, Boolean isoverdue, Boolean isdue, Boolean isundue, Boolean iscomplete) {
        if (!isoverdue.booleanValue() && !isdue.booleanValue() && !isundue.booleanValue() && iscomplete.booleanValue()) {
            return MyTaskServiceHelper.getDoneTaskNum((String)userId, (String[])new String[]{"3", "5"});
        }
        if ((isoverdue.booleanValue() || isdue.booleanValue() || isundue.booleanValue()) && !iscomplete.booleanValue()) {
            return MyTaskServiceHelper.getPendingTaskNum((String)userId, (String[])new String[]{"3", "5"});
        }
        return MyTaskServiceHelper.getALLTaskNum((String)userId, (String[])new String[]{"3", "5"});
    }

    public TaskCataLog getTaskcatalogMsg(String id) {
        TaskCataLog task = new TaskCataLog(id);
        QFilter qf = new QFilter("id", "=", (Object)ConvertUtil.convertStrToLong((String)id));
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObject dcs = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_taskcatalog", (String)"number,name", (QFilter[])qfs);
        if (dcs != null) {
            task.setName(dcs.getString("name"));
            task.setNumber(dcs.getString("number"));
        }
        QFilter qftask = new QFilter("taskcatalog", "=", (Object)ConvertUtil.convertStrToLong((String)id));
        QFilter qfnum = new QFilter("number", "=", (Object)"root");
        QFilter[] qfsTask = new QFilter[]{qftask, qfnum};
        DynamicObject rootTask = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_taskconfig", (String)"id", (QFilter[])qfsTask);
        if (dcs != null) {
            task.setRootTaskid(rootTask.getLong("id"));
        }
        qf = new QFilter("taskcatalog", "=", (Object)ConvertUtil.convertStrToLong((String)id));
        qfs = new QFilter[]{qf};
        dcs = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_taskexplain", (String)"text", (QFilter[])qfs);
        if (dcs != null) {
            task.setExplain(dcs.getString("text"));
        }
        qf = new QFilter("taskcatalog", "=", (Object)ConvertUtil.convertStrToLong((String)id));
        qfs = new QFilter[]{qf};
        dcs = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamAllSelector(), (QFilter[])qfs);
        if (dcs != null) {
            task.setYear(new TaskParam(dcs.get("year.id"), dcs.get("year.number"), dcs.get("year.name")));
            task.setPeriod(new TaskParam(dcs.get("period.id"), dcs.get("period.number"), dcs.get("period.name")));
            task.setScenario(new TaskParam(dcs.get("scenario.id"), dcs.get("scenario.number"), dcs.get("scenario.name")));
            task.setCurrency(new TaskParam(dcs.get("currency.id"), dcs.get("currency.number"), dcs.get("currency.name")));
        }
        DynamicObjectCollection dcss = this.getOrLoadTaskConfig(id);
        task.setConf(dcss);
        HashMap<String, DynamicObject> confmap = new HashMap<String, DynamicObject>();
        task.setIsshowexplain(false);
        for (DynamicObject dynamicObject : dcss) {
            confmap.put(dynamicObject.getString("id"), dynamicObject);
            if ("0".equals(dynamicObject.getString("tasktype"))) {
                task.setConfrootid(dynamicObject.getString("id"));
            }
            if ("1".equals(dynamicObject.getString("tasktype"))) {
                task.setConfrootparamid(dynamicObject.getString("id"));
            }
            if (!"2".equals(dynamicObject.getString("tasktype"))) continue;
            task.setIsshowexplain(true);
            task.setConfrootdiscribeid(dynamicObject.getString("id"));
        }
        task.setConfmap(confmap);
        return task;
    }

    public DynamicObjectCollection getOrLoadTaskConfig(String taskCatalogId) {
        return (DynamicObjectCollection)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("bcm_taskconfig_" + taskCatalogId), () -> {
            QFilter[] qfs = new QFilter[]{new QFilter("taskcatalog", "=", (Object)ConvertUtil.convertStrToLong((String)taskCatalogId))};
            return QueryServiceHelper.query((String)"bcm_taskconfig", (String)MyTaskServiceHelper.getTaskSelectFields(), (QFilter[])qfs);
        });
    }

    public DynamicObjectCollection getOrLoadTaskCatalogs(String entityName, String field, List<Long> catalogs) {
        return (DynamicObjectCollection)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(entityName + "_" + catalogs.toString()), () -> {
            QFilter[] qfs = new QFilter[]{new QFilter("taskcatalog", "in", (Object)catalogs)};
            return QueryServiceHelper.query((String)entityName, (String)field, (QFilter[])qfs);
        });
    }

    public void cache2page(IPageCache cache) {
        cache.put(CACHE_KEY, ObjectSerialUtil.toByteSerialized((Object)this));
    }

    public static TaskTreeBulider toTreeModel(IPageCache cache) {
        String serial = cache.get(CACHE_KEY);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (TaskTreeBulider)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return new TaskTreeBulider();
    }

    private Set<Long> getAllDistributeModel(Map<Long, TaskCataLog> taskCataLogMap) {
        HashSet<Long> modelIds = new HashSet<Long>(taskCataLogMap.size());
        for (TaskCataLog taskCataLog : taskCataLogMap.values()) {
            modelIds.add(taskCataLog.getModelId());
        }
        return modelIds;
    }

    public Map<Long, TaskCataLog> getAllTaskcatalogMsg(List<Long> catalogs) {
        QFilter qf = new QFilter("id", "in", catalogs);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection taskCatalogs = QueryServiceHelper.query((String)"bcm_taskcatalog", (String)"id,number,name,model.id", (QFilter[])qfs);
        QFilter qftask = new QFilter("taskcatalog", "in", catalogs);
        QFilter qfnum = new QFilter("number", "=", (Object)"root");
        QFilter[] qfsTask = new QFilter[]{qftask, qfnum};
        DynamicObjectCollection rootTasks = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id,taskcatalog.id", (QFilter[])qfsTask);
        DynamicObjectCollection taskExplains = this.getOrLoadTaskCatalogs("bcm_taskexplain", "text,taskcatalog.id", catalogs);
        DynamicObjectCollection taskParams = this.getOrLoadTaskCatalogs("bcm_taskparam", MyTaskServiceHelper.getTaskParamAllSelector(), catalogs);
        DynamicObjectCollection taskConfigs = this.getOrLoadTaskCatalogs("bcm_taskconfig", MyTaskServiceHelper.getTaskSelectFields(), catalogs);
        HashMap<Long, TaskCataLog> taskCataLogIdMap = new HashMap<Long, TaskCataLog>();
        for (DynamicObject taskCatalog : taskCatalogs) {
            if (taskCatalog == null) continue;
            TaskCataLog task = new TaskCataLog(taskCatalog.getString("id"));
            task.setName(taskCatalog.getString("name"));
            task.setNumber(taskCatalog.getString("number"));
            task.setModelId(taskCatalog.getLong("model.id"));
            for (DynamicObject rootTask : rootTasks) {
                if (rootTask == null || rootTask.getLong("taskcatalog.id") != taskCatalog.getLong("id")) continue;
                task.setRootTaskid(rootTask.getLong("id"));
            }
            for (DynamicObject taskExpalin : taskExplains) {
                if (taskExpalin == null || taskExpalin.getLong("taskcatalog.id") != taskCatalog.getLong("id")) continue;
                task.setExplain(taskExpalin.getString("text"));
            }
            for (DynamicObject taskParam : taskParams) {
                if (taskParam == null || taskParam.getLong("taskcatalog.id") != taskCatalog.getLong("id")) continue;
                task.setYear(new TaskParam(taskParam.get("year.id"), taskParam.get("year.number"), taskParam.get("year.name")));
                task.setPeriod(new TaskParam(taskParam.get("period.id"), taskParam.get("period.number"), taskParam.get("period.name")));
                task.setScenario(new TaskParam(taskParam.get("scenario.id"), taskParam.get("scenario.number"), taskParam.get("scenario.name")));
                task.setCurrency(new TaskParam(taskParam.get("currency.id"), taskParam.get("currency.number"), taskParam.get("currency.name")));
            }
            task.setIsshowexplain(false);
            DynamicObjectCollection dcs = new DynamicObjectCollection();
            HashMap<String, DynamicObject> confmap = new HashMap<String, DynamicObject>();
            for (DynamicObject taskConfig : taskConfigs) {
                if (taskConfig == null || taskConfig.getLong("taskcatalog.id") != taskCatalog.getLong("id")) continue;
                dcs.add((Object)taskConfig);
                confmap.put(taskConfig.getString("id"), taskConfig);
                if ("0".equals(taskConfig.getString("tasktype"))) {
                    task.setConfrootid(taskConfig.getString("id"));
                }
                if ("1".equals(taskConfig.getString("tasktype"))) {
                    task.setConfrootparamid(taskConfig.getString("id"));
                }
                if (!"2".equals(taskConfig.getString("tasktype"))) continue;
                task.setIsshowexplain(true);
                task.setConfrootdiscribeid(taskConfig.getString("id"));
            }
            task.setConfmap(confmap);
            task.setConf(dcs);
            taskCataLogIdMap.put(taskCatalog.getLong("id"), task);
        }
        return taskCataLogIdMap;
    }

    public static void addReportIdToPair(ReportPostmanByEntity pm) {
        QFilter sceneid = new QFilter("scene", "=", pm.getScenarioPK());
        QFilter periodid = new QFilter("period", "=", pm.getPeriodPK());
        QFilter fyearid = new QFilter("fyear", "=", pm.getYearPK());
        DynamicObject curr = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getCurrencyPK())});
        QFilter currencyid = new QFilter("currency", "=", DimensionUtil.getOrgCurrency(curr, Long.valueOf(pm.getEntityPK(null).toString()), Long.valueOf(pm.getYearPK().toString()), Long.valueOf(pm.getPeriodPK().toString())));
        QFilter entityid = new QFilter("entity", "=", (Object)LongUtil.toLong((Object)pm.getEntityPK(null)));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template", (QFilter[])new QFilter[]{sceneid, periodid, fyearid, currencyid, entityid});
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        if (docs != null) {
            for (DynamicObject rpt : docs) {
                for (Pair<Object, Object> pair : pm.getPairs()) {
                    if (!pair.p1.toString().equals(rpt.getString("template"))) continue;
                    pairs.add(Pair.onePair((Object)pair.p1, (Object)rpt.getString("id")));
                }
            }
        }
        List<Pair<Object, Object>> old = pm.getPairs();
        block2: for (int i = 0; i < old.size(); ++i) {
            Pair<Object, Object> op = old.get(i);
            for (Pair pair : pairs) {
                if (!op.p1.toString().equals(pair.p1.toString())) continue;
                old.remove(op);
                old.add(i, (Pair<Object, Object>)pair);
                continue block2;
            }
        }
    }
}

