/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.tree.task;

import kd.bos.entity.tree.TreeNode;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.tree.task.TaskCataLog;

public class TaskTreeNode
extends AbstractTreeNode<ReportPostmanByEntity> {
    private static final long serialVersionUID = 1L;
    private Object taskId;
    private Object orgId;
    private TaskTypeEnum nodetype;
    private Object modelId;
    private TaskCataLog catalog;

    public TaskTreeNode(String id, String name) {
        super(id, name);
    }

    public TaskTreeNode(String id, String name, TaskTreeNode parent) {
        super(id, name, (ITreeNode)parent);
    }

    public Object getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Object taskId) {
        this.taskId = taskId;
    }

    public Object getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Object orgId) {
        this.orgId = orgId;
    }

    public void setNodetype(TaskTypeEnum nodetype) {
        this.nodetype = nodetype;
    }

    public TaskTypeEnum getNodetype() {
        return this.nodetype;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelId(Object modelId) {
        this.modelId = modelId;
    }

    public TaskCataLog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(TaskCataLog catalog) {
        this.catalog = catalog;
        this.setRootid(catalog.getRootTaskid());
    }

    public TreeNode toTreeNode() {
        TreeNode virtualRoot = this.clone(this);
        return virtualRoot;
    }

    private TreeNode clone(TaskTreeNode node) {
        TreeNode newNode = new TreeNode();
        if (node.getNodetype() != null) {
            newNode.setType(String.valueOf(node.getNodetype().getValue()));
        }
        if (node.getParent() != null) {
            newNode.setParentid(node.getParent().getId());
        }
        newNode.setText(node.getName());
        if (TaskTypeEnum.REPORT_UNIT.getValue() != node.getNodetype().getValue()) {
            node.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        }
        newNode.setId(node.getId());
        if (TaskTypeEnum.ROOT.getValue() == node.getNodetype().getValue()) {
            node.getDetailData().put("taskname", node.getName());
            node.getDetailData().put("memberid", node.getRootid());
            node.getDetailData().put("taskid", node.getRootid());
            node.getDetailData().put("tasktype", node.getNodetype().getValue());
        } else if (TaskTypeEnum.ORG_DISPLAY.getValue() == node.getNodetype().getValue()) {
            node.getDetailData().put("tasktype", node.getNodetype().getValue());
            node.getDetailData().put("orgid", Long.valueOf(node.getOrgId().toString()));
            node.getDetailData().put("taskname", node.getName());
            node.getDetailData().put("memberid", Long.valueOf(node.getOrgId().toString()));
            node.getDetailData().put("rootid", node.getRootid());
            node.getDetailData().put("taskid", Long.valueOf(node.getOrgId().toString()));
        } else if (TaskTypeEnum.PARAM.getValue() == node.getNodetype().getValue() || TaskTypeEnum.EXPLAIN.getValue() == node.getNodetype().getValue()) {
            node.getDetailData().put("taskname", node.getName());
            node.getDetailData().put("memberid", Long.valueOf(node.getTaskId().toString()));
            node.getDetailData().put("taskid", Long.valueOf(node.getTaskId().toString()));
            node.getDetailData().put("id", node.getId());
            node.getDetailData().put("tasktype", node.getNodetype().getValue());
            node.getDetailData().put("rootid", node.getRootid());
        }
        newNode.setData((Object)node.getDetailData());
        if (node.getChildren().size() > 0) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                TaskTreeNode child = (TaskTreeNode)((Object)node.getChildren().get(i));
                TreeNode newChild = this.clone(child);
                newNode.addChild(newChild);
            }
        }
        return newNode;
    }
}

