/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AdjustCatalogUtil {
    public static void setAdjustCatalogFilter(BasedataEdit basedataEdit, Object modelId) {
        basedataEdit.addBeforeF7SelectListener(event -> {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.setFormId("bcm_adjustcatalogf7");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"AdjTemCalogPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.getTreeFilterParameter().getQFilters().add(AdjustCatalogUtil.getAdjustCatalogFilter(LongUtil.toLong((Object)modelId)));
            formShowParameter.getListFilterParameter().getQFilters().add(AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(LongUtil.toLong((Object)modelId)));
            formShowParameter.getListFilterParameter().setOrderBy("level");
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)LongUtil.toLong((Object)modelId));
        });
    }

    public static DynamicObject getAdjustCatalogDyn(Long modelId, String catalogNum) {
        QFilter filterWithPerm = AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(modelId);
        filterWithPerm.and(new QFilter("number", "=", (Object)catalogNum));
        return (DynamicObject)ThreadCache.get((Object)("PaperTemplateAdjustCatalogCache-" + catalogNum + modelId), () -> QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"id,longnumber", (QFilter[])new QFilter[]{filterWithPerm}));
    }

    public static QFilter getAdjustCatalogFilter(Long modelId) {
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter2 = new QFilter("catalogtype", "=", (Object)(TemplateCatalogTypeEnum.ADJCATALOG.getType() + "")).or("parent.id", "=", (Object)0);
        return qFilter1.and(qFilter2);
    }

    public static QFilter getAdjustCatalogFilterWithPerm(Long modelId) {
        ArrayListMultimap catalogPerm;
        ArrayList noPermCatalog;
        QFilter qFilter = AdjustCatalogUtil.getAdjustCatalogFilter(modelId);
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)(modelId + ""));
        if (!adminUserBol && !(noPermCatalog = new ArrayList((catalogPerm = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_templatecatalog", (String)(modelId + ""), (String)String.valueOf(RequestContext.get().getCurrUserId()))).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()))).isEmpty()) {
            qFilter.and("id", "not in", noPermCatalog);
        }
        return qFilter;
    }
}

