/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.report.cache.NoPluginCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class AnalysisMemberUtil {
    public static String analyMember(long modelId, Cell cell, SpreadManager spreadManager, Map<String, String> cellInfo) {
        StringBuilder sb = new StringBuilder();
        DataTypeEnum totaltype = CellDataTypeUtil.getCellDataType((long)modelId, (Cell)cell, (IPageCache)new NoPluginCache(), (SpreadManager)spreadManager);
        sb.append(ResManager.loadKDString((String)"\u5355\u5143\u683c\u7c7b\u578b:", (String)"AnalysisMemberUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(totaltype.getName()).append("\n");
        sb.append("-------------------").append("\n");
        AnalysisMemberUtil.getDetailMsg(modelId, cellInfo, sb);
        sb.append("-------------------").append("\n");
        sb.append(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u578b:", (String)"AnalysisMemberUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(totaltype.getName()).append("\n");
        AnalysisMemberUtil.getPermDetailMsg(modelId, cellInfo, sb);
        return sb.toString();
    }

    private static void getPermDetailMsg(long modelId, Map<String, String> cellInfo, StringBuilder sb) {
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (Map.Entry<String, String> entry : cellInfo.entrySet()) {
            String dim = entry.getKey();
            String mem = entry.getValue();
            PermPackageList dimPermSet = permService.getDimPermSet(MemberReader.getDimensionIdByNum((long)modelId, (String)dim));
            PermEnum permEnum = dimPermSet.getPermEnum(MemberReader.findMemberByNumber((String)modelNum, (String)dim, (String)mem).getId().longValue(), RequestContext.get().getCurrUserId());
            sb.append(dim).append("|").append(mem).append(":").append(permEnum.getName()).append("\n");
        }
    }

    public static void getDetailMsg(long modelId, Map<String, String> cellInfo, StringBuilder sb) {
        String modelnumber = MemberReader.findModelNumberById((Object)modelId);
        sb.append(ResManager.loadKDString((String)"\u5404\u6210\u5458\u6570\u636e\u7c7b\u578b:", (String)"AnalysisMemberUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        ArrayList<Long> ids = new ArrayList<Long>(cellInfo.size());
        HashMap<Long, IDNumberTreeNode> nodes = new HashMap<Long, IDNumberTreeNode>(cellInfo.size());
        for (Map.Entry<String, String> mem : cellInfo.entrySet()) {
            sb.append(mem.getKey()).append("|").append(mem.getValue()).append(":");
            try {
                DataTypeEnum memtype = CellDataTypeUtil.getDimensionDataType((long)modelId, (String)mem.getKey(), (String)mem.getValue(), new HashMap());
                sb.append(memtype.getName());
            }
            catch (Exception exception) {
                sb.append(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u7c7b\u578b", (String)"AnalysisMemberUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            sb.append("\n");
        }
        sb.append("-------------------").append("\n");
        sb.append(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u7684\u6210\u5458:", (String)"AnalysisMemberUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        for (Map.Entry<String, String> mem : cellInfo.entrySet()) {
            IDNumberTreeNode memNode = MemberReader.findMemberByNumber((String)modelnumber, (String)mem.getKey(), (String)mem.getValue());
            ids.add(memNode.getId());
            nodes.put(memNode.getId(), memNode);
            if (StorageTypeEnum.DYNAMIC == memNode.getStorageType()) {
                sb.append(mem.getKey()).append("|").append(mem.getValue()).append("\n");
                continue;
            }
            if (!DimTypesEnum.PROCESS.getNumber().equals(mem.getKey()) || !"EIRpt".equals(mem.getValue()) && !"ERAdj".equals(mem.getValue()) && !"ERpt".equals(mem.getValue())) continue;
            sb.append(mem.getKey()).append("|").append(mem.getValue()).append(ResManager.loadKDString((String)"\u9690\u5f0f\u52a8\u6001\u8ba1\u7b97", (String)"AnalysisMemberUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        }
        DynamicObjectCollection cc = QueryServiceHelper.query((String)"bcm_aggshieldruledis", (String)"member,rule.rule", (QFilter[])new QFilter[]{new QFilter("member", "in", ids)});
        if (cc != null && !cc.isEmpty()) {
            sb.append("-------------------").append("\n");
            sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5c4f\u853d\u89c4\u5219\u7684\u6210\u5458:", (String)"AnalysisMemberUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
            for (DynamicObject obj : cc) {
                sb.append(((IDNumberTreeNode)nodes.get(obj.getLong("member"))).getNumber()).append(":").append(obj.getString("rule.rule"));
                sb.append("\n");
            }
        }
    }
}

