/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.util.ConvertSchemeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.SerialSpliter;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ConvertFormulaEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.IDimMember;

public class CvtFormulaUtil {
    private static final String DIM_CACHE_KEY = "diminfo";
    private static final String convert2scenarioid = "convert2scenarioid";

    public static Pair<String, String> getAccountAndCTNumber(TemplateModel template) {
        List viewDims = template.getViewPointDimensionEntries();
        List pageDims = template.getPageDimensionEntries();
        String account = null;
        String changetype = null;
        for (ViewPointDimensionEntry dim : viewDims) {
            if (dim.getDimension().getNumber().equals("Account")) {
                account = dim.getMember().getNumber();
            }
            if (!dim.getDimension().getNumber().equals("ChangeType")) continue;
            changetype = dim.getMember().getNumber();
        }
        for (ViewPointDimensionEntry dim : pageDims) {
            if (dim.getDimension().getNumber().equals("Account")) {
                account = ((Member)dim.getMembers().get(0)).getNumber();
            }
            if (!dim.getDimension().getNumber().equals("ChangeType")) continue;
            changetype = ((Member)dim.getMembers().get(0)).getNumber();
        }
        return Pair.onePair(account, changetype);
    }

    public static Map<String, Map<String, Map<String, Object>>> getDimInfo(TemplateModel template, IPageCache pageCache) {
        Map result;
        if (pageCache.get(DIM_CACHE_KEY) == null) {
            long modelid = template.getModelId();
            HashMap<String, List<String>> dimNumAndFiels = new HashMap<String, List<String>>();
            if (!template.getAreaRangeEntries().isEmpty()) {
                List row = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries();
                for (RowDimensionEntry entry : row) {
                    if (entry.getDimension().getNumber().equals(DimTypesEnum.ACCOUNT.getNumber()) || entry.getDimension().getNumber().equals(DimTypesEnum.CHANGETYPE.getNumber())) continue;
                    dimNumAndFiels.put(entry.getDimension().getNumber(), Collections.singletonList("number"));
                }
                List col = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries();
                for (ColDimensionEntry entry : col) {
                    if (entry.getDimension().getNumber().equals(DimTypesEnum.ACCOUNT.getNumber()) || entry.getDimension().getNumber().equals(DimTypesEnum.CHANGETYPE.getNumber())) continue;
                    dimNumAndFiels.put(entry.getDimension().getNumber(), Collections.singletonList("number"));
                }
            }
            dimNumAndFiels.put(DimTypesEnum.ACCOUNT.getNumber(), Arrays.asList("number", "accounttype", "exchange"));
            if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)modelid))) {
                dimNumAndFiels.put(DimTypesEnum.CHANGETYPE.getNumber(), Arrays.asList("number", "changeway"));
            }
            result = QueryDimensionServiceHelper.getDimMemberInfoMap((long)modelid, dimNumAndFiels, (boolean)false);
            pageCache.put(DIM_CACHE_KEY, ObjectSerialUtil.toByteSerialized((Object)result));
        } else {
            result = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(DIM_CACHE_KEY));
        }
        return result;
    }

    public static BaseConvertFormula getBaseCvtFormula(TemplateModel template, IPageCache pageCache) {
        long scenarioId = Long.parseLong(pageCache.get(convert2scenarioid));
        return ConvertSchemeServiceHelper.getBaseConvertFormula((long)template.getModelId(), (long)scenarioId);
    }

    public static String displayFormula(Cell cell, Map<String, Map<String, Map<String, Object>>> dimInfo, Pair<String, String> dimValue, BaseConvertFormula baseFormula, TemplateModel template) {
        List members = cell.getMemberFromUserObject();
        if (members.isEmpty()) {
            return null;
        }
        if (!CvtFormulaUtil.checkAllIsLeaf(members, dimInfo)) {
            return null;
        }
        AccountAndChangeTypeInfo aCTInfo = CvtFormulaUtil.getAccAndCTInfo(dimInfo, dimValue, members);
        return CvtFormulaUtil.getFinalFormula(aCTInfo, baseFormula, template);
    }

    public static String displayFormula4Float(Cell cell, Map<String, Map<String, Map<String, Object>>> dimInfo, Pair<String, String> dimValue, BaseConvertFormula baseFormula, PositionInfo posInfo, TemplateModel template, Sheet effectiveSheet) {
        int[] startXY = ExcelUtils.pos2XY((String)posInfo.getAreaRange().split(":")[0]);
        ArrayList<IDimMember> dimMembers = new ArrayList<IDimMember>();
        for (BasePointInfo bp : posInfo.getBasePoints()) {
            String[] dynaRange = bp.getDynaRange().split(":");
            int[] fromXY = ExcelUtils.pos2XY((String)dynaRange[0]);
            boolean isFirst = false;
            if (bp.isDirectHoriz()) {
                if (cell.getCol() == fromXY[0]) {
                    isFirst = true;
                }
            } else if (cell.getRow() == fromXY[1]) {
                isFirst = true;
            }
            if (!isFirst) continue;
            List lines = bp.getBasePointInnerLineInfo();
            for (BasePointInnerLineInfo info : lines) {
                if (info.isFloated()) continue;
                IDimMember member = ((DynaMembScopeInfo)info.getDynaMembScopes().get(0)).getMember();
                dimMembers.add(member);
            }
            List members = bp.isDirectHoriz() ? effectiveSheet.getCell(cell.getRow(), startXY[0]).getMemberFromUserObject() : effectiveSheet.getCell(startXY[1], cell.getCol()).getMemberFromUserObject();
            dimMembers.addAll(members);
        }
        AccountAndChangeTypeInfo aCTInfo = CvtFormulaUtil.getAccAndCTInfo(dimInfo, dimValue, dimMembers);
        return CvtFormulaUtil.getFinalFormula(aCTInfo, baseFormula, template);
    }

    private static AccountAndChangeTypeInfo getAccAndCTInfo(Map<String, Map<String, Map<String, Object>>> dimInfo, Pair<String, String> dimValue, Object dimMembers) {
        String accountType = null;
        String exchange = null;
        if (dimValue.p1 != null) {
            accountType = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(dimValue.p1).get("accounttype");
            exchange = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(dimValue.p1).get("exchange");
        } else if (dimMembers.getClass().isAssignableFrom(ArrayList.class)) {
            for (IDimMember member : (List)dimMembers) {
                if (!member.getDimension().getNumber().equals(DimTypesEnum.ACCOUNT.getNumber())) continue;
                accountType = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(member.getNumber()).get("accounttype");
                exchange = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(member.getNumber()).get("exchange");
            }
        } else {
            for (IDimMember member : ((SerialSpliter)dimMembers).getPairs()) {
                if (!((String)member.p1).equals(DimTypesEnum.ACCOUNT.getNumber())) continue;
                accountType = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(member.p2).get("accounttype");
                exchange = (String)dimInfo.get(DimTypesEnum.ACCOUNT.getNumber()).get(member.p2).get("exchange");
            }
        }
        String changeWay = null;
        String changeTypeMember = null;
        if (dimValue.p2 != null) {
            changeWay = (String)((Map)dimInfo.get(DimTypesEnum.CHANGETYPE.getNumber()).getOrDefault(dimValue.p2, new HashMap())).get("changeway");
            changeTypeMember = (String)dimValue.p2;
        } else if (dimMembers.getClass().isAssignableFrom(ArrayList.class)) {
            for (IDimMember member : (List)dimMembers) {
                if (!member.getDimension().getNumber().equals(DimTypesEnum.CHANGETYPE.getNumber())) continue;
                changeWay = (String)dimInfo.get(DimTypesEnum.CHANGETYPE.getNumber()).get(member.getNumber()).get("changeway");
                changeTypeMember = member.getNumber();
            }
        } else {
            for (Pair member : ((SerialSpliter)dimMembers).getPairs()) {
                if (!((String)member.p1).equals(DimTypesEnum.CHANGETYPE.getNumber())) continue;
                changeWay = (String)dimInfo.get(DimTypesEnum.CHANGETYPE.getNumber()).get(member.p2).get("changeway");
                changeTypeMember = (String)member.p2;
            }
        }
        return new AccountAndChangeTypeInfo(accountType, exchange, changeWay, changeTypeMember);
    }

    private static String getFinalFormula(AccountAndChangeTypeInfo aCTInfo, BaseConvertFormula baseFormula, TemplateModel template) {
        if (!ConvertServiceHelper.checkCanDisplayFormula((Long)template.getModelId(), (String)aCTInfo.getAccountType(), (String)aCTInfo.getChangeWay(), (String)aCTInfo.getChangeTypeMember(), (String)aCTInfo.getExchange())) {
            return null;
        }
        String formula = CvtFormulaUtil.getFormulaByAccType(aCTInfo.getAccountType(), aCTInfo.getChangeTypeMember(), baseFormula, true);
        if (formula == null) {
            return null;
        }
        formula = formula.substring(formula.indexOf(61) + 1, formula.indexOf(42));
        formula = formula.replaceAll(ResManager.loadKDString((String)"\u91d1\u989d", (String)"CvtFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570", (String)"CvtFormulaUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String cvtExchange = CvtFormulaUtil.getCvtExchange(aCTInfo.getExchange(), aCTInfo.getChangeWay(), template, true);
        if (!StringUtils.isEmpty((String)cvtExchange)) {
            formula = formula + "*";
            formula = formula + cvtExchange;
            return formula;
        }
        return null;
    }

    private static String getFinalFormula4Edit(AccountAndChangeTypeInfo aCTInfo, BaseConvertFormula baseFormula, TemplateModel template) {
        String factor = CvtFormulaUtil.getFormulaByAccType(aCTInfo.getAccountType(), aCTInfo.getChangeTypeMember(), baseFormula, false);
        String exchange = CvtFormulaUtil.getCvtExchange(aCTInfo.getExchange(), aCTInfo.getChangeWay(), template, false);
        return factor + exchange;
    }

    private static String getFormulaByAccType(String accountType, String changeTypeNumber, BaseConvertFormula baseFormula, boolean getChinese) {
        ConvertFormulaEnum formulaEnum = null;
        switch (AccountTypeEnum.getEnum((String)accountType)) {
            case ASSET: 
            case DEBT: 
            case UNFINNANCE: 
            case OTHERS: 
            case EXCHANGERATE: {
                formulaEnum = ConvertFormulaEnum.getConvertFormulaByIndex((int)baseFormula.getBalance());
                break;
            }
            case LOSS: 
            case CASHFLOW: {
                if ("CurrentPeriod".equals(changeTypeNumber)) {
                    formulaEnum = ConvertFormulaEnum.PROFITLOSS3;
                    break;
                }
                formulaEnum = ConvertFormulaEnum.getConvertFormulaByIndex((int)baseFormula.getProfitloss());
                break;
            }
            case RIGHTS: {
                formulaEnum = ConvertFormulaEnum.getConvertFormulaByIndex((int)baseFormula.getRights());
            }
        }
        if (formulaEnum != null) {
            if (getChinese) {
                return formulaEnum.getFormula();
            }
            return formulaEnum.getCvtFactor();
        }
        return null;
    }

    private static String getCvtExchange(String exchange, String changeWay, TemplateModel template, boolean getChinese) {
        ExchangeEnum exchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)exchange);
        if (exchangeEnum == null) {
            switch (ChangewayEnum.getChangewayEnumByIndex((String)changeWay)) {
                case End: 
                case THIS: 
                case CREATE: {
                    DynamicObject dot = QueryDimensionServiceHelper.getMemberMsgByNumber((long)template.getModelId(), (String)exchange, (String)"bcm_accountmembertree");
                    if (getChinese) {
                        return dot.getString("name");
                    }
                    return "CVT(\"exchange@" + dot.getString("number") + "\")";
                }
                case EARLYYEARADJUST: {
                    DynamicObject BOYdot = QueryDimensionServiceHelper.getMemberMsgByNumber((long)template.getModelId(), (String)("BOY" + exchange), (String)"bcm_accountmembertree");
                    if (getChinese) {
                        return BOYdot.getString("name");
                    }
                    return "CVT(\"exchange@" + BOYdot.getString("number") + "\")";
                }
            }
        } else {
            switch (exchangeEnum) {
                case TERMINAL: 
                case AVERAGE: 
                case UserdefinedRate: {
                    switch (ChangewayEnum.getChangewayEnumByIndex((String)changeWay)) {
                        case End: 
                        case THIS: 
                        case CREATE: {
                            if (getChinese) {
                                return ExchangeEnum.getExchangeEnumByIndex((String)exchange).getName();
                            }
                            return ExchangeEnum.getExchangeEnumByIndex((String)exchange).getCvtFactor();
                        }
                        case EARLYYEARADJUST: {
                            if (ExchangeEnum.getExchangeEnumByIndex((String)exchange) == ExchangeEnum.TERMINAL) {
                                if (getChinese) {
                                    return ResManager.loadKDString((String)"\u5e74\u521d\u6c47\u7387", (String)"CvtFormulaUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                                }
                                return "CVT(\"exchange@BOYRate\")";
                            }
                            if (getChinese) {
                                return ResManager.loadKDString((String)"\u5e74\u521d%s", (String)"CvtFormulaUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[]{ExchangeEnum.getExchangeEnumByIndex((String)exchange).getName()});
                            }
                            String[] temp = ExchangeEnum.getExchangeEnumByIndex((String)exchange).getCvtFactor().split("@");
                            return temp[0] + "@BOY" + temp[1];
                        }
                    }
                    break;
                }
                case ONE: {
                    return null;
                }
                case UserdefinedRate1: 
                case UserdefinedRate2: 
                case UserdefinedRate3: 
                case UserdefinedRate4: 
                case UserdefinedRate5: 
                case UserdefinedRate6: 
                case UserdefinedRate7: 
                case UserdefinedRate8: 
                case UserdefinedRate9: 
                case UserdefinedRate10: {
                    return exchangeEnum.getName();
                }
            }
        }
        return null;
    }

    public static boolean checkAllIsLeaf(List<IDimMember> members, Map<String, Map<String, Map<String, Object>>> dimInfo) {
        for (IDimMember member : members) {
            String dimNumber = member.getDimension().getNumber();
            String memNumber = member.getNumber();
            if (dimInfo.get(dimNumber).get(memNumber) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIsLeaf(IDimMember member, Map<String, Map<String, Map<String, Object>>> dimInfo) {
        String dimNumber = member.getDimension().getNumber();
        String memNumber = member.getNumber();
        return dimInfo.get(dimNumber).get(memNumber) != null;
    }

    static class AccountAndChangeTypeInfo {
        private String accountType;
        private String exchange;
        private String changeWay;
        private String changeTypeMember;

        AccountAndChangeTypeInfo(String accountType, String exchange, String changeWay, String changeTypeMember) {
            this.accountType = accountType;
            this.exchange = exchange;
            this.changeWay = changeWay;
            this.changeTypeMember = changeTypeMember;
        }

        String getAccountType() {
            return this.accountType;
        }

        String getExchange() {
            return this.exchange;
        }

        String getChangeTypeMember() {
            return this.changeTypeMember;
        }

        String getChangeWay() {
            return this.changeWay;
        }
    }
}

