/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import org.apache.commons.lang3.StringUtils;

public class DocumentUtils {
    public static final String ENTITYS = "entitys";
    public static final String SELECT_ENTITYS = "selectentitys";
    public static final String FROM_CELL = "1";
    public static final String FROM_REPORT = "2";
    public static final Map<String, String> NEED_CHECKDIM = new HashMap<String, String>(8);

    public static Collection<Long> getPermIds(Long modelId, DataTypeEnum ... permType) {
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_docmodel", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
        if (map.size() == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>(12);
        Map permMap = map.asMap();
        for (Map.Entry entry : permMap.entrySet()) {
            String index = (String)entry.getKey();
            DataTypeEnum permEnum = DataTypeEnum.getDataTypeEnumByIndex((String)index);
            if (!Arrays.asList(permType).contains(permEnum)) continue;
            list.addAll((Collection)entry.getValue());
        }
        return list;
    }

    public static StringBuffer getDimFilterBuffer(IDataModel dataModel) {
        StringBuffer dimFilterBuffer = new StringBuffer();
        if (dataModel.getValue("scenario") != null) {
            dimFilterBuffer.append(DimTypesEnum.SCENARIO.getNumber()).append("|").append(((DynamicObject)dataModel.getValue("scenario")).getString("number")).append(",");
        }
        if (dataModel.getValue("year") != null) {
            dimFilterBuffer.append(DimTypesEnum.YEAR.getNumber()).append("|").append(((DynamicObject)dataModel.getValue("year")).getString("number")).append(",");
        }
        if (dataModel.getValue("period") != null) {
            dimFilterBuffer.append(DimTypesEnum.PERIOD.getNumber()).append("|").append(((DynamicObject)dataModel.getValue("period")).getString("number")).append(",");
        }
        if (dataModel.getValue("entity") != null) {
            dimFilterBuffer.append(DimTypesEnum.ENTITY.getNumber()).append("|").append(((DynamicObject)dataModel.getValue("entity")).getString("number"));
        }
        return dimFilterBuffer;
    }

    public static boolean isMatchDimMems(DynamicObject e, Map<String, Object> pageDimMemMap, boolean flag) {
        HashMap<String, String> dimMemMap = new HashMap<String, String>(16);
        if (e.getDataEntityType().getProperties().containsKey((Object)"dims")) {
            String dims = e.getString("dims");
            if (kd.bos.util.StringUtils.isEmpty((String)dims)) {
                return true;
            }
            for (String dimMem : dims.split("\\,")) {
                String[] dimAndMem = dimMem.split("\\|");
                if (dimAndMem.length != 2) continue;
                dimMemMap.put(dimAndMem[0], dimAndMem[1]);
            }
        } else {
            String attachmenttype = e.getString("attachmenttype");
            if (FROM_CELL.equals(attachmenttype)) {
                String[] split;
                String dimensionstr = e.getString("dimensionstr");
                for (String s : split = dimensionstr.split(",")) {
                    String[] dimension = s.split("\\|");
                    if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.SCENARIO.getNumber())) {
                        dimMemMap.put(DimTypesEnum.SCENARIO.getNumber(), dimension[1]);
                        continue;
                    }
                    if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.YEAR.getNumber())) {
                        dimMemMap.put(DimTypesEnum.YEAR.getNumber(), dimension[1]);
                        continue;
                    }
                    if (dimension[0].equalsIgnoreCase(DimEntityNumEnum.PERIOD.getNumber())) {
                        dimMemMap.put(DimTypesEnum.PERIOD.getNumber(), dimension[1]);
                        continue;
                    }
                    if (!dimension[0].equalsIgnoreCase(DimEntityNumEnum.ENTITY.getNumber())) continue;
                    dimMemMap.put(DimTypesEnum.ENTITY.getNumber(), dimension[1]);
                }
            } else if (FROM_REPORT.equals(attachmenttype)) {
                dimMemMap.put(DimTypesEnum.ENTITY.getNumber(), e.getString("entity.number"));
                dimMemMap.put(DimTypesEnum.SCENARIO.getNumber(), e.getString("scene.number"));
                dimMemMap.put(DimTypesEnum.YEAR.getNumber(), e.getString("year.number"));
                dimMemMap.put(DimTypesEnum.PERIOD.getNumber(), e.getString("period.number"));
            } else {
                return false;
            }
        }
        return DocumentUtils.isMatchDimMems(dimMemMap, pageDimMemMap, flag);
    }

    public static boolean isMatchDimMems(Map<String, String> dimMemMap, Map<String, Object> pageDimMemMap, boolean flag) {
        if (dimMemMap.isEmpty() || pageDimMemMap.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Object> entry : pageDimMemMap.entrySet()) {
            String s;
            String dimNum = entry.getKey();
            if (!dimMemMap.containsKey(dimNum) || kd.bos.util.StringUtils.isEmpty((String)(s = dimMemMap.get(dimNum)))) continue;
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                Set selectOrgs = (Set)entry.getValue();
                if (!flag && (selectOrgs.isEmpty() || selectOrgs.contains(s))) continue;
                return false;
            }
            String memNum = (String)entry.getValue();
            if (!kd.bos.util.StringUtils.isNotEmpty((String)memNum) || memNum.equals(s)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> getPageDimMemMap(IPageCache pageCache, long modelId, IDataModel dataModel) {
        Set<String> selectOrgs;
        HashMap<String, Object> dimMemMap = new HashMap<String, Object>(16);
        if (dataModel.getValue("scenario") != null) {
            dimMemMap.put(DimTypesEnum.SCENARIO.getNumber(), ((DynamicObject)dataModel.getValue("scenario")).getString("number"));
        }
        if (dataModel.getValue("year") != null) {
            dimMemMap.put(DimTypesEnum.YEAR.getNumber(), ((DynamicObject)dataModel.getValue("year")).getString("number"));
        }
        if (dataModel.getValue("period") != null) {
            dimMemMap.put(DimTypesEnum.PERIOD.getNumber(), ((DynamicObject)dataModel.getValue("period")).getString("number"));
        }
        if (!(selectOrgs = DocumentUtils.getSelectOrgs(pageCache, modelId)).isEmpty()) {
            dimMemMap.put(DimTypesEnum.ENTITY.getNumber(), selectOrgs);
        }
        return dimMemMap;
    }

    public static Set<String> getSelectOrgs(IPageCache pageCache, long modelId) {
        HashSet<String> orgs = new HashSet<String>(16);
        if (pageCache.get(SELECT_ENTITYS) != null) {
            return (Set)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(SELECT_ENTITYS));
        }
        if (pageCache.get(ENTITYS) != null) {
            List membColl = (List)SerializationUtils.fromJsonString((String)pageCache.get(ENTITYS), List.class);
            membColl.forEach(result -> {
                boolean isCustom = false;
                String number = (String)result.get("number");
                if (result.get("pid") != null && kd.bos.util.StringUtils.isNotEmpty((String)((String)result.get("pid")))) {
                    isCustom = true;
                    String[] split = number.split(":");
                    if (split.length == 2) {
                        number = split[1];
                    }
                }
                new MembRangeItem("bcm_entitymembertree", Long.valueOf(Long.parseLong((String)result.get("id"))), number, Integer.parseInt((String)result.get("scope")), isCustom, (Object)modelId).matchItems(c -> orgs.add(c.getNumber()));
            });
            pageCache.put(SELECT_ENTITYS, ObjectSerialUtil.toByteSerialized(orgs));
        }
        return orgs;
    }

    public static String getCellAttachmentSource(String dimensionstr, long modelId) {
        if (StringUtils.isEmpty((CharSequence)dimensionstr) || !dimensionstr.contains(",") || !dimensionstr.contains("|")) {
            return dimensionstr;
        }
        String[] split = dimensionstr.split(",");
        List<String> dims = Arrays.asList(split);
        Map<String, String> number2shortNum = DocumentUtils.getNumber2shortNum(modelId);
        ArrayList transformDim2Num = new ArrayList(dims.size());
        dims.forEach(p -> {
            int first = p.indexOf("|");
            String dim = p.substring(0, first);
            String member = p.substring(first + 1);
            String shortNum = (String)number2shortNum.get(dim);
            if (shortNum != null) {
                if ("none".equals(member)) {
                    member = shortNum + "None";
                }
                transformDim2Num.add(String.join((CharSequence)".", shortNum, member));
            }
        });
        return String.join((CharSequence)",", transformDim2Num);
    }

    private static Map<String, String> getNumber2shortNum(long modelId) {
        return (Map)ThreadCache.get((Object)("getNumber2shortNum_" + modelId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            HashMap number2shortNum = new HashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"number,dseq,fieldmapped,shortnumber", (QFilter[])new QFilter[]{filter}, (String)"dseq").forEach(e -> {
                String number = e.getString("number");
                if (StringUtils.isNotEmpty((CharSequence)e.getString("fieldmapped"))) {
                    number = e.getString("fieldmapped");
                }
                number2shortNum.put(number, e.getString("shortnumber"));
            });
            return number2shortNum;
        });
    }

    public static HashMap<String, String> parseDocDimension(String dims) {
        HashMap<String, String> dimMem = new HashMap<String, String>();
        if (kd.bos.util.StringUtils.isNotEmpty((String)dims)) {
            String[] dim2mems;
            for (String dim2mem : dim2mems = dims.split(",")) {
                String[] dimAndMem = dim2mem.split("\\|");
                if (dimAndMem.length != 2) continue;
                dimMem.put(dimAndMem[0], dimAndMem[1]);
            }
        }
        return dimMem;
    }

    public static Set<Long> getNoPermTemplateIds(Long modelId) {
        HashSet<Long> noPermids = new HashSet<Long>(16);
        ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_templateentity", (String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
        noPermids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        return noPermids;
    }

    static {
        NEED_CHECKDIM.put(DimTypesEnum.ENTITY.getNumber(), "entity");
        NEED_CHECKDIM.put(DimTypesEnum.SCENARIO.getNumber(), "scene");
        NEED_CHECKDIM.put(DimTypesEnum.YEAR.getNumber(), "year");
        NEED_CHECKDIM.put(DimTypesEnum.PERIOD.getNumber(), "period");
    }
}

