/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class EffectiveYearPeriodUtil {
    private static final String applytypecol = "applytypecol";
    private static final String yearcol = "yearcol";
    private static final String periodcol = "periodcol";
    private static final String yearscopecol = "yearscopecol";
    private static final String entryentity = "entryentity";

    public static void loadEntitymember(IDataModel dataModel, IPageCache pageCache, Map<String, Set<Long>> effective) {
        if (effective == null || effective.size() == 0) {
            return;
        }
        dataModel.deleteEntryData(entryentity);
        TreeMap effectiveMap = new TreeMap();
        effective.entrySet().forEach(entry -> {
            HashSet set = new HashSet((Collection)entry.getValue());
            effectiveMap.put(entry.getKey(), set);
        });
        dataModel.batchCreateNewEntryRow(entryentity, effectiveMap.size());
        DynamicObjectCollection dys = dataModel.getEntryEntity(entryentity);
        int index = 0;
        HashMap<Integer, Set> cache = new HashMap<Integer, Set>(16);
        DynamicObjectType periodColType = ((DynamicObject)dys.get(0)).getDynamicObjectCollection(periodcol).getDynamicObjectType();
        HashSet yearIds = new HashSet();
        effectiveMap.keySet().forEach(k -> yearIds.add(k.split("@")[1]));
        Map years = new HashMap();
        yearIds.remove("null");
        if (yearIds.size() > 0) {
            years = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (String)"name, number", (QFilter[])new QFBuilder("id", "in", (Object)LongUtil.toLongList(yearIds)).toArray());
        }
        Collection<Object> periodDys = new HashSet();
        for (Map.Entry entry2 : effectiveMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)dys.get(index);
            String[] split = ((String)entry2.getKey()).split("@");
            dynamicObject.set(yearcol, split[1].equals("null") ? null : years.get(Long.valueOf(split[1])));
            dynamicObject.set(applytypecol, (Object)split[2]);
            dynamicObject.set(yearscopecol, (Object)split[3]);
            Set periodIds = (Set)entry2.getValue();
            if (periodIds.size() > 0) {
                periodDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)"id, name, number", (QFilter[])new QFBuilder("id", "in", (Object)periodIds).toArray(), (String)"number").values();
            }
            DynamicObjectCollection periods = new DynamicObjectCollection();
            for (DynamicObject dynamicObject2 : periodDys) {
                DynamicObject tmp = new DynamicObject(periodColType);
                tmp.set(0, (Object)dynamicObject2.getLong("id"));
                tmp.set(1, (Object)dynamicObject2);
                periods.add((Object)tmp);
            }
            dynamicObject.set(periodcol, (Object)(periods.size() == 0 ? null : periods));
            cache.put(index, periodIds);
            ++index;
            periodDys.clear();
        }
        pageCache.put("periodIds", ObjectSerialUtil.toByteSerialized(cache));
    }

    public static void loadEntitymember(IDataModel dataModel, IPageCache pageCache, long id, String entityName) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)"effective.seq, effective.effectiveyear, effective.effectiveperiod, effective.applytype, effective.yearscope");
        if (entity == null) {
            return;
        }
        DynamicObjectCollection doc = entity.getDynamicObjectCollection("effective");
        if (doc.isEmpty()) {
            return;
        }
        dataModel.deleteEntryData(entryentity);
        TreeMap<String, ArrayList<DynamicObject>> map = new TreeMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject dy : doc) {
            int group = dy.getInt("seq");
            long yearId = dy.get("effectiveyear") == null ? 0L : dy.getLong("effectiveyear.id");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(group + "@" + yearId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                map.put(group + "@" + yearId, list);
            }
            list.add(dy);
        }
        int size = map.size();
        dataModel.batchCreateNewEntryRow(entryentity, size);
        DynamicObjectCollection dys = dataModel.getEntryEntity(entryentity);
        int index = 0;
        HashMap cache = new HashMap(16);
        DynamicObjectType periodColType = ((DynamicObject)dys.get(0)).getDynamicObjectCollection(periodcol).getDynamicObjectType();
        for (List list : map.values()) {
            DynamicObject dynamicObject = (DynamicObject)dys.get(index);
            dynamicObject.set(applytypecol, (Object)((DynamicObject)list.get(0)).getString("applytype"));
            dynamicObject.set(yearscopecol, (Object)(StringUtils.isEmpty((String)((DynamicObject)list.get(0)).getString("yearscope")) ? YearScopeEnum.THISYEAR.getValue() : ((DynamicObject)list.get(0)).getString("yearscope")));
            dynamicObject.set(yearcol, (Object)((DynamicObject)list.get(0)).getDynamicObject("effectiveyear"));
            DynamicObjectCollection periods = new DynamicObjectCollection();
            HashSet periodIds = new HashSet();
            list.sort((o1, o2) -> {
                String o1PeriodNumber = ((DynamicObject)o1).getDynamicObject("effectiveperiod").getString("number");
                String o2PeriodNumber = ((DynamicObject)o2).getDynamicObject("effectiveperiod").getString("number");
                return Integer.compare(o1PeriodNumber.compareTo(o2PeriodNumber), 0);
            });
            list.forEach(l -> {
                long periodId = l.getDynamicObject("effectiveperiod") == null ? 0L : l.getDynamicObject("effectiveperiod").getLong("id");
                periodIds.add(periodId);
                DynamicObject tmp = new DynamicObject(periodColType);
                tmp.set(0, (Object)periodId);
                tmp.set(1, (Object)l.getDynamicObject("effectiveperiod"));
                periods.add((Object)tmp);
            });
            dynamicObject.set(periodcol, (Object)periods);
            cache.put(index, periodIds);
            ++index;
        }
        pageCache.put("periodIds", ObjectSerialUtil.toByteSerialized(cache));
    }

    public static Map<String, Set<Long>> saveEffectiveInfo(IDataModel dataModel) {
        DynamicObjectCollection docs = dataModel.getEntryEntity(entryentity);
        return EffectiveYearPeriodUtil.getEffectiveInfo(docs);
    }

    public static Map<String, Set<Long>> getEffectiveInfo(DynamicObjectCollection docs) {
        TreeMap<String, Set<Long>> effective = new TreeMap<String, Set<Long>>();
        ArrayList<Map<String, Object>> checkUp = new ArrayList<Map<String, Object>>(docs.size());
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObject sel = (DynamicObject)docs.get(i);
            String applytype = sel.getString(applytypecol);
            String yearscope = sel.getString(yearscopecol);
            String yearId = sel.getDynamicObject(yearcol) == null ? null : sel.getDynamicObject(yearcol).getString("id");
            String yearNum = sel.getDynamicObject(yearcol) == null ? null : sel.getDynamicObject(yearcol).getString("number");
            DynamicObjectCollection periodColDyn = sel.getDynamicObjectCollection(periodcol);
            if (yearId == null && periodColDyn.isEmpty() && "1".equals(applytype) && !"1".equals(yearscope)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9002\u7528\u8d22\u5e74\u548c\u671f\u95f4\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"EffectiveYearPeriodUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            HashSet<Long> periodIds = new HashSet<Long>();
            effective.put(i + "@" + yearId + "@" + applytype + "@" + yearscope, periodIds);
            Map<String, Object> temp = EffectiveYearPeriodUtil.getRowMap(yearscope, yearNum, periodColDyn, periodIds);
            for (Map map : checkUp) {
                String sourceType = temp.get("type").toString();
                String targetType = map.get("type").toString();
                String sourceYear = temp.get("year").toString();
                String targetYear = map.get("year").toString();
                Set sourcePeriod = (Set)temp.get("period");
                Set targetPeriod = (Set)map.get("period");
                if (!"ALL".equals(sourceType) && !"ALL".equals(targetType) && !EffectiveYearPeriodUtil.sourceIsInTarget(sourceType, targetType, sourceYear, targetYear) || !sourcePeriod.removeAll(targetPeriod) && !sourcePeriod.contains("ALL") && !targetPeriod.contains("ALL")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EffectiveYearPeriodUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            checkUp.add(temp);
        }
        return effective;
    }

    private static boolean sourceIsInTarget(String sourceType, String targetType, String sourceYear, String targetYear) {
        if (sourceYear.equals(targetYear)) {
            return true;
        }
        if (sourceYear.compareTo(targetYear) > 0) {
            return ">=".equals(targetType) || "<=".equals(sourceType);
        }
        return "<=".equals(targetType) || ">=".equals(sourceType);
    }

    private static Map<String, Object> getRowMap(String yearscope, String yearNum, DynamicObjectCollection periods, Set<Long> periodIds) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String type = "ALL";
        HashSet<String> period = new HashSet<String>(Collections.singletonList("ALL"));
        switch (yearscope) {
            case "2": {
                type = "=";
                break;
            }
            case "3": {
                type = "<=";
                break;
            }
            case "4": {
                type = ">=";
                break;
            }
        }
        if (!periods.isEmpty()) {
            period.clear();
            for (DynamicObject temp : periods) {
                Long periodId = (Long)temp.get(0);
                if (periodId != 0L) {
                    periodIds.add(periodId);
                } else {
                    if (temp.get(1) != null) {
                        periodId = ((DynamicObject)temp.get(1)).getLong("id");
                    }
                    periodIds.add(temp.get(1) == null ? null : periodId);
                }
                if (temp.getDynamicObject("fbasedataid") != null) {
                    period.add(temp.getDynamicObject("fbasedataid").getString("id"));
                    continue;
                }
                if (periodId == null || periodId == 0L) continue;
                period.add(String.valueOf(periodId));
            }
        }
        map.put("type", type);
        map.put("year", yearNum == null ? "" : yearNum);
        map.put("period", period);
        return map;
    }

    public static void saveEffectiveInfo(DynamicObject dy, Map<String, Set<Long>> effectiveMap) {
        if (effectiveMap != null) {
            DynamicObjectCollection effectives = dy.getDynamicObjectCollection("effective");
            effectives.clear();
            DynamicObjectType effectiveType = effectives.getDynamicObjectType();
            TreeMap<String, Set> tmp = new TreeMap<String, Set>();
            effectiveMap.entrySet().forEach(entry -> {
                HashSet set = new HashSet((Collection)entry.getValue());
                tmp.put((String)entry.getKey(), set);
            });
            tmp.forEach((yearId, periodIds) -> {
                String[] split = yearId.split("@");
                if (periodIds.isEmpty()) {
                    DynamicObject effective = new DynamicObject(effectiveType);
                    effective.set("seq", (Object)split[0]);
                    effective.set("effectiveyear", split[1].equals("null") ? null : split[1]);
                    effective.set("effectiveperiod", null);
                    effective.set("applytype", (Object)split[2]);
                    effective.set("yearscope", (Object)split[3]);
                    effectives.add((Object)effective);
                }
                periodIds.forEach(periodId -> {
                    DynamicObject effective = new DynamicObject(effectiveType);
                    effective.set("seq", (Object)split[0]);
                    effective.set("effectiveyear", (Object)split[1]);
                    effective.set("effectiveperiod", periodId);
                    effective.set("applytype", (Object)split[2]);
                    effective.set("yearscope", (Object)split[3]);
                    effectives.add((Object)effective);
                });
            });
        }
    }

    public static void beforeF7Select(BeforeF7SelectEvent arg0, long modelId, String key, IDataModel dataModel, IPageCache pageCache) {
        Map map;
        Set periodIds;
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("isleaf", "=", (Object)true);
        filter.and("storagetype", "!=", (Object)StorageTypeEnum.LABEL.getOIndex());
        if (yearcol.equals(key)) {
            filter.and("number", "<>", (Object)"CurrentYear");
            filter.and("number", "<>", (Object)"LastYear");
        } else if (periodcol.equals(key)) {
            if (pageCache.get("SCENARIO_ID") != null) {
                Long scenarioid = Long.parseLong(pageCache.get("SCENARIO_ID"));
                HashSet sceneperiodNums = new HashSet(16);
                DimensionServiceHelper.getScenePeriod((long)modelId, (long)scenarioid).forEach(dyn -> sceneperiodNums.add(dyn.getDynamicObject("fbasedataid").getString("number")));
                filter.and("number", "in", sceneperiodNums);
            }
            filter.and("number", "<>", (Object)"CurrentPeriod");
            filter.and("number", "<>", (Object)"LastPeriod");
            filter.and("number", "<>", (Object)"LastPeriodX");
        }
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), null));
        String periodIdsStr = pageCache.get("periodIds");
        if (periodIdsStr != null && periodcol.equals(key) && (periodIds = (Set)(map = (Map)ObjectSerialUtil.deSerializedBytes((String)periodIdsStr)).get(dataModel.getEntryCurrentRowIndex(entryentity))) != null) {
            showParameter.setSelectedRows(periodIds.toArray());
        }
    }

    public static String buildPeriodTxt(IDataModel dataModel, long modelid) {
        DynamicObjectCollection docs = dataModel.getEntryEntity(entryentity);
        Collection periodDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)"id, name, number", (QFilter[])new QFBuilder("model", "in", (Object)modelid).toArray(), (String)"number").values();
        HashMap periodmap = new HashMap();
        periodDys.forEach(period -> periodmap.put(period.getLong("id"), period));
        StringBuilder periodTxt = new StringBuilder();
        for (DynamicObject sel : docs) {
            periodTxt.append(sel.getString(applytypecol).equals("1") ? ResManager.loadKDString((String)"\u9002\u7528", (String)"EffectiveYearPeriodUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f8b\u5916", (String)"EffectiveYearPeriodUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            periodTxt.append(sel.getDynamicObject(yearcol) == null ? "" : sel.getDynamicObject(yearcol).getString("name"));
            periodTxt.append(YearScopeEnum.getEnumByType((String)sel.getString(yearscopecol)).getName());
            if (sel.getDynamicObjectCollection(periodcol).isEmpty()) {
                periodTxt.append(ResManager.loadKDString((String)"\u6240\u6709\u671f\u95f4", (String)"EffectiveYearPeriodUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                sel.getDynamicObjectCollection(periodcol).forEach(p -> {
                    Long periodId = (Long)p.get(0);
                    if (periodId != 0L) {
                        periodTxt.append(((DynamicObject)periodmap.get(p.get(0))).getString("name"));
                    } else if (p.get(1) != null) {
                        periodTxt.append(((DynamicObject)p.get(1)).getString("name"));
                    } else {
                        periodTxt.append(ResManager.loadKDString((String)"\u6240\u6709\u671f\u95f4", (String)"EffectiveYearPeriodUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                });
            }
            periodTxt.append(';');
        }
        return periodTxt.toString();
    }
}

