/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormUserConfig;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.userconfig.GridConfigDAO;

public class EntryGridUtils {
    public static List<GridConfigurationRow> getFieldApInfo(IFormView formView, String entryId) {
        Objects.requireNonNull(entryId);
        Objects.requireNonNull(formView);
        String id = MetadataDao.getIdByNumber((String)formView.getEntityId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String entryApId = null;
        for (ControlAp ctlAp : formMeta.getItems()) {
            if (!(ctlAp instanceof EntryAp) || !Objects.equals(entryId, ctlAp.getKey())) continue;
            entryApId = ctlAp.getId();
            break;
        }
        return EntryGridUtils.buildGridConfiguration(formView, formMeta.getItems(), entryApId);
    }

    private static List<GridConfigurationRow> buildGridConfiguration(IFormView formView, List<ControlAp<?>> items, String entryApId) {
        ArrayList<GridConfigurationRow> currentFields = new ArrayList<GridConfigurationRow>(items.size());
        for (ControlAp<?> ctlAp : items) {
            int statusVal;
            if (!(ctlAp instanceof EntryFieldAp) && !(ctlAp instanceof EntryFieldGroupAp) && !(ctlAp instanceof EntryFieldContainerAp) && !(ctlAp instanceof OperationColumnAp) || !Objects.equals(entryApId, ctlAp.getParentId()) || ctlAp.isHidden() || !ctlAp.getVisible().contains("init")) continue;
            int visibleValue = ctlAp.getVisibleValue();
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            int n = statusVal = formView instanceof BillView ? ((BillShowParameter)formShowParameter).getBillStatus().getValue() : formShowParameter.getStatus().getValue();
            if (statusVal == 0 && (visibleValue & 1) != 1 || statusVal == 1 && (visibleValue & 2) != 2 || statusVal == 2 && (visibleValue & 4) != 4 || statusVal == 4 && (visibleValue & 0x10) != 16 || statusVal == 5 && (visibleValue & 0x20) != 32) continue;
            LocaleString name = ctlAp.getName();
            String textAlign = ctlAp.getTextAlign();
            String key = ctlAp.getKey();
            int width = 0;
            if (ctlAp.getWidth() != null) {
                for (Map.Entry entry : ctlAp.getWidth().entrySet()) {
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue())) || ((String)entry.getValue()).contains("%")) continue;
                    width = Integer.parseInt(((String)entry.getValue()).replace("px", "").split("\\.")[0]);
                    break;
                }
            }
            GridConfigurationRow bean = new GridConfigurationRow(name, width, textAlign, key);
            if (ctlAp instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp fieldGroupAp = (EntryFieldGroupAp)ctlAp;
                bean.setChildren(EntryGridUtils.buildGridConfiguration(formView, fieldGroupAp.getItems(), ctlAp.getId()));
            }
            currentFields.add(bean);
        }
        return currentFields;
    }

    public static void updateView(IFormView formView, String entityId, List<GridConfigurationRow> beans) {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.saveGridConfig(formView.getFormShowParameter().getFormId(), entityId, beans);
        formView.updateView(entityId);
    }

    public static void changeCols(IFormView formView, String entityId, Consumer<List<GridConfigurationRow>> consumer) {
        List<GridConfigurationRow> beans = EntryGridUtils.getFieldApInfo(formView, entityId);
        consumer.accept(beans);
        EntryGridUtils.updateView(formView, entityId, beans);
    }

    public static UserConfig getUserConfig(IFormView formView, String configKey) {
        FormUserConfig service = (FormUserConfig)formView.getService(IFormUserConfig.class);
        UserConfig gridConfig = service.loadUserConfig(configKey);
        return gridConfig;
    }

    public static <T> List<T> getSetting(IFormView formView, String configKey, Class<T> settingType) {
        UserConfig gridConfig = EntryGridUtils.getUserConfig(formView, configKey);
        if (StringUtils.isEmpty((CharSequence)gridConfig.getSetting())) {
            return Collections.emptyList();
        }
        return SerializationUtils.fromJsonStringToList((String)gridConfig.getSetting(), settingType);
    }

    public static List<GridConfigurationRow> getSetting(IFormView formView, String entryId) {
        return EntryGridUtils.getSetting(formView, GridConfigDAO.buildUserConfigKey((String)formView.getEntityId(), (String)entryId), GridConfigurationRow.class);
    }

    public static <T> void updateSetting(IFormView formView, String configKey, Class<T> settingType, Consumer<List<T>> consumer) {
        UserConfig gridConfig = EntryGridUtils.getUserConfig(formView, configKey);
        if (StringUtils.isEmpty((CharSequence)gridConfig.getSetting())) {
            return;
        }
        List fieldApInfo = SerializationUtils.fromJsonStringToList((String)gridConfig.getSetting(), settingType);
        consumer.accept(fieldApInfo);
        gridConfig.setSetting(SerializationUtils.toJsonString((Object)fieldApInfo));
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)configKey, (String)gridConfig.getSetting());
    }

    public static void createDefaultSetting(IFormView formView, String entryId, Consumer<List<GridConfigurationRow>> consumer) {
        String configKey = GridConfigDAO.buildUserConfigKey((String)formView.getEntityId(), (String)entryId);
        UserConfig gridConfig = EntryGridUtils.getUserConfig(formView, configKey);
        if (StringUtils.isEmpty((CharSequence)gridConfig.getSetting())) {
            List<GridConfigurationRow> fieldApInfo = EntryGridUtils.getFieldApInfo(formView, entryId);
            consumer.accept(fieldApInfo);
            gridConfig.setSetting(SerializationUtils.toJsonString(fieldApInfo));
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)configKey, (String)gridConfig.getSetting());
        }
    }

    public static List<Map> getSettingByBillList(IFormView formView, String entryId) {
        List<Map> setting = EntryGridUtils.getSetting(formView, EntryGridUtils.buildUserConfigKeyByBillListNew((BillList)formView.getControl(entryId)), Map.class);
        if (null == setting || setting.isEmpty()) {
            setting = EntryGridUtils.getSetting(formView, EntryGridUtils.buildUserConfigKeyByBillList((BillList)formView.getControl(entryId)), Map.class);
        }
        return setting;
    }

    public static String buildUserConfigKeyByBillList(BillList billList) {
        return String.format("%s.%s.%s", billList.getView().getEntityId(), billList.getEntityId(), billList.getKey());
    }

    public static String buildUserConfigKeyByBillListNew(BillList billList) {
        return billList.getEntityId();
    }
}

