/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.enums.EnumValueDBCache;
import org.apache.commons.collections.CollectionUtils;

public class EnumUtils {
    public static List<Object> getPreTemplateOfEnum(String preEntityNameImp) {
        QFilter qFilter = new QFilter("number", "=", (Object)preEntityNameImp);
        return QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
    }

    public static void buildIsLeafAndLnumberAllEnumValue(long modelId, long enumItemId) {
        if (modelId == 0L || enumItemId == 0L) {
            return;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("enumitemid", "=", (Object)enumItemId);
        DynamicObject[] enumValues = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)"id, number, parent, isleaf, longnumber, level", (QFilter[])qf.toArray());
        if (enumValues == null || enumValues.length == 0) {
            return;
        }
        List<DynamicObject> enumValuesSorted = Arrays.stream(enumValues).sorted(Comparator.comparing(x -> x.getLong("level"))).collect(Collectors.toList());
        Set pIds = Arrays.stream(enumValues).filter(x -> x.get("parent") != null).map(y -> y.getDynamicObject("parent").getLong("id")).collect(Collectors.toSet());
        HashMap<Long, String> id2Longnumbers = new HashMap<Long, String>(128);
        for (DynamicObject enumValue : enumValuesSorted) {
            long id = enumValue.getLong("id");
            if (pIds.contains(id)) {
                enumValue.set("isleaf", (Object)"0");
            } else {
                enumValue.set("isleaf", (Object)"1");
            }
            DynamicObject parent = enumValue.getDynamicObject("parent");
            String number = enumValue.getString("number");
            String longnumber = "";
            if (parent == null) {
                enumValue.set("longnumber", (Object)number);
                longnumber = number;
            } else {
                long pId = parent.getLong("id");
                longnumber = (String)id2Longnumbers.get(pId) + '!' + number;
                enumValue.set("longnumber", (Object)longnumber);
            }
            id2Longnumbers.put(id, longnumber);
        }
        SaveServiceHelper.save((DynamicObject[])enumValuesSorted.toArray(new DynamicObject[0]));
    }

    public static int getAndIncreDseqOfEnum(long parentId) {
        LinkedHashSet<Integer> enumDseqs = EnumValueDBCache.getpId2Dseqs().get(parentId);
        if (CollectionUtils.isEmpty(enumDseqs)) {
            return new AtomicInteger(1).get();
        }
        List dseqs = enumDseqs.stream().sorted().collect(Collectors.toList());
        AtomicInteger ato = new AtomicInteger((Integer)dseqs.get(dseqs.size() - 1));
        return ato.getAndIncrement();
    }
}

