/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.fi.bcm.common.util.DynamicEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FormUtils {
    public static void customDynamicEnum(List<String[]> keysAndValues, ComboEdit edit) {
        ArrayList items = new ArrayList(keysAndValues.size());
        keysAndValues.forEach(new DynamicEnum(items));
        edit.setComboItems(items);
    }

    public static void setBillFormId4FormBill(BillList billlist, String billFormId) {
        Map<String, Object> meta = FormUtils.getListMetadata(billFormId);
        if (meta != null && meta.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)meta.get(BillList.class.getSimpleName());
            BillList list = (BillList)ControlTypes.fromJsonString((String)strBillList);
            billlist.setPageRow(list.getPageRow());
            billlist.setEntityId(list.getEntityId());
            billlist.getItems().clear();
            billlist.getItems().addAll(list.getItems());
        } else {
            billlist.setBillFormId(billFormId);
        }
    }

    private static Map<String, Object> getListMetadata(String billFormId) {
        return FormMetadataCache.getListMeta((String)billFormId);
    }

    public static void closePage(IFormView view, String pageId) {
        ArrayList tabListClose = new ArrayList();
        IFormView formView = view.getView(pageId);
        if (formView == null) {
            return;
        }
        formView.close();
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", pageId);
        tabListClose.add(arg);
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    public static void clickCheckBillListSelect(IFormView view, String billListId, String noRowTip, Consumer<ListSelectedRowCollection> yesOpt) {
        FormUtils.clickCheckBillListSelect(null, view, billListId, noRowTip, "", "", yesOpt);
    }

    public static void clickCheckBillListSelect(IFormPlugin formPlugin, IFormView view, String billListId, String noRowTip, String noSelectTip, String confirmFlag, Consumer<ListSelectedRowCollection> yesOpt) {
        BillList billList = (BillList)view.getControl(billListId);
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectRows)) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{noSelectTip, confirmFlag}) || Objects.isNull(formPlugin) || CollectionUtils.isEmpty((Collection)billList.getCurrentListAllRowCollection())) {
                view.showTipNotification(noRowTip);
            } else {
                view.showConfirm(noSelectTip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(confirmFlag, formPlugin));
            }
        } else {
            yesOpt.accept(selectRows);
        }
    }

    public static IFormView findHomePage(IFormView parentView) {
        while (parentView != null && !FormUtils.isHomePage(parentView)) {
            parentView = parentView.getParentView();
        }
        return parentView;
    }

    private static boolean isHomePage(IFormView parentView) {
        return "bcm_apphome".equals(parentView.getEntityId()) || "report_apphome_new".equals(parentView.getEntityId());
    }
}

