/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class GrantPermUtil {
    public static Set<Long> getPermClass(Long modelId) {
        Long currUserId = RequestContext.get().getCurrUserId();
        Set groupIds = UserDistributeServiceHelper.queryAllGroupByUserId((long)currUserId);
        groupIds.add(currUserId);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("users", "in", (Object)groupIds);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_class_grant", (String)"permclass.id", (QFilter[])qfBuilder.toArray());
        return dys.stream().map(dy -> dy.getLong("permclass.id")).collect(Collectors.toSet());
    }

    public static boolean memberCanShow(Long modelId, String entityName, Set<String> grantPermIds, Long memberId, Map<Long, List<Long>> relationMap) {
        IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memberId);
        if (Objects.equals(member, IDNumberTreeNode.NotFoundTreeNode)) {
            return false;
        }
        if (grantPermIds.contains(member.getNumber())) {
            return true;
        }
        if (relationMap.get(memberId) != null) {
            for (long id : relationMap.get(memberId)) {
                if (!GrantPermUtil.memberCanShow(modelId, entityName, grantPermIds, id, relationMap)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getGrantPerm(Long modelId, Long dimId, Boolean isCustomProp) {
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimId);
        if (Objects.isNull(dim)) {
            return Collections.emptySet();
        }
        String entityName = dim.getString("membermodel");
        DynamicObjectCollection dys = GrantPermUtil.hasGrantPermFromDb(modelId, entityName);
        if (isCustomProp.booleanValue()) {
            entityName = "bcm_definedpropertyvalue";
        }
        HashSet returnNumbers = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dy : dys) {
            IDNumberTreeNode memberById;
            if (!Objects.equals(dy.getBoolean("iscustomprop"), isCustomProp) || Objects.equals(memberById = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)dy.getLong("member.id")), IDNumberTreeNode.NotFoundTreeNode)) continue;
            if (dy.getBoolean("includesub")) {
                new MembRangeItem(entityName, memberById.getId(), memberById.getNumber(), RangeEnum.VALUE_50.getValue(), isCustomProp.booleanValue(), (Object)modelId).matchItems(c -> returnNumbers.add(c.number));
                continue;
            }
            returnNumbers.add(memberById.getNumber());
        }
        return returnNumbers;
    }

    public static boolean hasGrantPerm(Long modelId, Long dimId, Long memberId, RangeEnum rangeEnum, Boolean isCustomProp) {
        IDNumberTreeNode member;
        String entityName;
        if (PermissionServiceImpl.getInstance((Long)modelId).isAdmin()) {
            return true;
        }
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimId);
        if (Objects.isNull(dim)) {
            return false;
        }
        String findEntityName = entityName = dim.getString("membermodel");
        if (isCustomProp.booleanValue()) {
            findEntityName = "bcm_definedpropertyvalue";
        }
        if (Objects.equals(member = MemberReader.findMemberById((long)modelId, (String)findEntityName, (Long)memberId), IDNumberTreeNode.NotFoundTreeNode)) {
            return false;
        }
        if (member.isShare()) {
            memberId = member.getCopyfromId();
        }
        DynamicObjectCollection dys = GrantPermUtil.hasGrantPermFromDb(modelId, entityName);
        HashSet curMemberNumbers = Sets.newHashSetWithExpectedSize((int)16);
        new MembRangeItem(entityName, memberId, member.getNumber(), rangeEnum.getValue(), isCustomProp.booleanValue(), (Object)modelId).matchItems(c -> curMemberNumbers.add(c.number));
        Set<String> hasGrantPermNumbers = GrantPermUtil.getHasGrantPermNumbers(modelId, findEntityName, dys, isCustomProp);
        return hasGrantPermNumbers.containsAll(curMemberNumbers);
    }

    private static Set<String> getHasGrantPermNumbers(Long modelId, String entityName, DynamicObjectCollection dys, Boolean isCustomProp) {
        HashSet hasGrantPermNumbers = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dy : dys) {
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)dy.getLong("member.id"));
            if (Objects.equals(memberById, IDNumberTreeNode.NotFoundTreeNode)) continue;
            if (dy.getBoolean("includesub")) {
                new MembRangeItem(entityName, memberById.getId(), memberById.getNumber(), RangeEnum.VALUE_50.getValue(), isCustomProp.booleanValue(), (Object)modelId).matchItems(c -> hasGrantPermNumbers.add(c.number));
                continue;
            }
            hasGrantPermNumbers.add(memberById.getNumber());
        }
        return hasGrantPermNumbers;
    }

    private static DynamicObjectCollection hasGrantPermFromDb(Long modelId, String entityName) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("GrantPermUtil#hasGrantPermFromDb#" + modelId + '#' + entityName), () -> {
            long currUserId = RequestContext.get().getCurrUserId();
            Set groupIds = UserDistributeServiceHelper.queryAllGroupByUserId((long)currUserId);
            groupIds.add(currUserId);
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("membertype", "=", (Object)entityName);
            qfBuilder.add("users", "in", (Object)groupIds);
            return QueryServiceHelper.query((String)"bcm_member_grant", (String)"member.id,includesub,iscustomprop", (QFilter[])qfBuilder.toArray());
        });
    }
}

