/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.util.TemplateExtDataAreaUtil;
import kd.fi.bcm.formplugin.template.util.TemplateSeqUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import org.apache.commons.collections.CollectionUtils;

public class MarkSpecialCell {
    public static final String OLDSPREAD = "oldspread";

    public static void markSpecialCells(Object pif, boolean mark, IFormView view, String spreadkey) {
        List baseinfo = null;
        PositionInfo positionInfo = null;
        if (pif instanceof PositionInfo) {
            positionInfo = (PositionInfo)pif;
            if (positionInfo.getExtendInfo() == null) {
                baseinfo = positionInfo.getBasePoints();
            }
        } else if (pif instanceof BasePointInfo) {
            baseinfo = Collections.singletonList((BasePointInfo)pif);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u201cPositionInfo\u201d\u6216\u8005\u201cBasePointInfo\u201d\u7c7b\u578b\uff0c\u5982\u9700\u652f\u6301\u5176\u4ed6\u7c7b\u578b\u8bf7\u81ea\u884c\u6dfb\u52a0\u3002", (String)"MarkSpecialCell_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (positionInfo != null && baseinfo == null) {
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{TemplateExtDataAreaUtil.getRedMarkPointParms(new RangeModel(positionInfo.getAreaRange()), mark)});
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)baseinfo)) {
            ArrayList<Map<String, Object>> markRedPoints = new ArrayList<Map<String, Object>>(16);
            for (BasePointInfo base : baseinfo) {
                String range = base.getDynaRange();
                if (!StringUtils.isNotEmpty((String)range)) continue;
                markRedPoints.addAll(TemplateExtDataAreaUtil.getRedMarkPointParms(new RangeModel(range), mark));
            }
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{markRedPoints});
        }
    }

    public static void cacheOldFloat(IPageCache pageCache, SpreadManager spread) {
        pageCache.put(OLDSPREAD, ObjectSerialUtil.toByteSerialized((Object)spread));
    }

    public static void dealSpecialCells(long modelId, IFormView view, SpreadManager sm, String spreadkey, boolean isMark) {
        HashSet<PositionInfo> positionInfos = new HashSet<PositionInfo>(16);
        HashSet<PositionInfo> extPositionInfos = new HashSet<PositionInfo>(16);
        for (PositionInfo pif : sm.getAreaManager().getPostionInfoSet()) {
            MarkSpecialCell.markSpecialCells(pif, isMark, view, spreadkey);
            if (pif.getSequenceInfo() != null) {
                positionInfos.add(pif);
            }
            if (pif.getExtendInfo() == null || !pif.getExtendInfo().isColChange()) continue;
            extPositionInfos.add(pif);
        }
        MarkSpecialCell.markSeqAreaCells(positionInfos, isMark, view, spreadkey, sm);
        MarkSpecialCell.markExtDataAreaCells(extPositionInfos, isMark, view, spreadkey, sm, modelId, true);
    }

    public static void drawMarkPoint(IPageCache pageCache, IFormView view, SpreadManager newspread, String spreadkey, boolean isclean, boolean isFromTemplate) {
        String serial = pageCache.get(OLDSPREAD);
        HashSet<PositionInfo> positionInfos = new HashSet<PositionInfo>(16);
        HashSet<PositionInfo> extPositionInfos = new HashSet<PositionInfo>(16);
        String modelStr = pageCache.get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)serial)) {
            SpreadManager lastsm = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)serial);
            for (PositionInfo pif : lastsm.getAreaManager().getPostionInfoSet()) {
                MarkSpecialCell.markSpecialCells(pif, false, view, spreadkey);
                if (isFromTemplate && pif.getSequenceInfo() != null) {
                    positionInfos.add(pif);
                }
                if (pif.getExtendInfo() == null || !pif.getExtendInfo().isColChange()) continue;
                extPositionInfos.add(pif);
            }
            if (StringUtils.isNotEmpty((String)modelStr)) {
                MarkSpecialCell.markSeqAreaCells(positionInfos, false, view, spreadkey, newspread);
                MarkSpecialCell.markExtDataAreaCells(extPositionInfos, false, view, spreadkey, newspread, LongUtil.toLong((Object)modelStr), isFromTemplate);
            }
        }
        positionInfos.clear();
        extPositionInfos.clear();
        for (PositionInfo pif : newspread.getAreaManager().getPostionInfoSet()) {
            MarkSpecialCell.markSpecialCells(pif, true, view, spreadkey);
            if (isFromTemplate && pif.getSequenceInfo() != null) {
                positionInfos.add(pif);
            }
            if (pif.getExtendInfo() == null || !pif.getExtendInfo().isColChange()) continue;
            extPositionInfos.add(pif);
        }
        if (StringUtils.isNotEmpty((String)modelStr)) {
            MarkSpecialCell.markSeqAreaCells(positionInfos, true, view, spreadkey, newspread);
            MarkSpecialCell.markExtDataAreaCells(extPositionInfos, true, view, spreadkey, newspread, LongUtil.toLong((Object)modelStr), isFromTemplate);
        }
        if (isclean) {
            pageCache.remove(OLDSPREAD);
        }
    }

    public static void markSeqAreaCells(Set<PositionInfo> positionInfos, boolean mark, IFormView view, String spreadkey, SpreadManager newspread) {
        if (positionInfos != null && !positionInfos.isEmpty()) {
            SpreadEasyInvoker invoker = new SpreadEasyInvoker((IClientViewProxy)view.getService(IClientViewProxy.class), spreadkey);
            invoker.setBatch(true);
            TemplateSeqUtil.markSeqAreaCells(positionInfos, newspread, mark, invoker);
            invoker.startToInvoke();
        }
    }

    public static void markExtDataAreaCells(Set<PositionInfo> positionInfos, boolean mark, IFormView view, String spreadkey, SpreadManager newspread, long modelId, boolean isFromTemplate) {
        Tuple<List<Map<String, Object>>, List<Map<String, Object>>, List<Map<String, Object>>> tuple;
        if (positionInfos != null && !positionInfos.isEmpty() && (tuple = TemplateExtDataAreaUtil.markExtDataAreaCells(positionInfos, newspread, mark, modelId, isFromTemplate)) != null) {
            SpreadClientInvoker.invokeSetFormulaMethod((IClientViewProxy)view.getService(IClientViewProxy.class), spreadkey, tuple.p1);
            SpreadClientInvoker.invokeUpdataValueMethod((IClientViewProxy)view.getService(IClientViewProxy.class), spreadkey, tuple.p2);
            SpreadClientInvoker.invokeMethod((IClientViewProxy)view.getService(IClientViewProxy.class), "setCellTag", spreadkey, tuple.p3);
        }
    }

    public static void drawMarkPointForReport(IPageCache pageCache, IFormView view, SpreadManager newspread, String spreadkey) {
        MarkSpecialCell.drawMarkPoint(pageCache, view, newspread, spreadkey, true, false);
    }

    public static void drawMarkPoint(IPageCache pageCache, IFormView view, SpreadManager newspread, String spreadkey) {
        MarkSpecialCell.drawMarkPoint(pageCache, view, newspread, spreadkey, true, true);
    }
}

