/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import org.apache.commons.collections.CollectionUtils;

public class NewMyTemplateUtil {
    public static final String MYCELLFORMULAS = "myCellFormulas";
    public static final String MYCELLLOCKS = "myCellLocks";
    public static final String TEMPLATE = "template";

    public static void saveMyTemplateDyos(long modelId, long templateId, String orgNumber, SpreadManager sm, boolean isImportFormula) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bcm_templateentity", (String)"id,rptdata,data,rptspreadjson");
        NewMyTemplateUtil.saveMyTemplateDyo(modelId, template, orgNumber, sm, isImportFormula);
    }

    public static void saveMyTemplateDyo(long modelId, DynamicObject template, String orgNumber, SpreadManager sm, boolean isImportFormula) {
        long templateId = template.getLong("id");
        Map<String, Object> resultMap = NewMyTemplateUtil.getCellFormulasAndLocks(sm, template, orgNumber, modelId, isImportFormula);
        QFilter delFilter = new QFilter("model", "=", (Object)modelId);
        delFilter.and(TEMPLATE, "=", (Object)templateId);
        delFilter.and("orgnumber", "=", (Object)orgNumber);
        DynamicObject originTem = (DynamicObject)resultMap.get(TEMPLATE);
        Object[] myCellFormulas = (DynamicObject[])resultMap.get(MYCELLFORMULAS);
        Object[] myCellLocks = (DynamicObject[])resultMap.get(MYCELLLOCKS);
        try (TXHandle tx = TX.required();){
            try {
                BusinessDataWriter.update((IDataEntityType)originTem.getDataEntityType(), (Object[])new Object[]{originTem});
                if (!ArrayUtils.isEmpty((Object[])myCellFormulas)) {
                    BusinessDataWriter.delete((String)"bcm_cellformula", (QFilter[])delFilter.toArray());
                    BusinessDataWriter.save((IDataEntityType)myCellFormulas[0].getDataEntityType(), (Object[])myCellFormulas);
                }
                if (!ArrayUtils.isEmpty((Object[])myCellLocks) && !isImportFormula) {
                    BusinessDataWriter.delete((String)"bcm_mytemplate_celllock", (QFilter[])delFilter.toArray());
                    BusinessDataWriter.save((IDataEntityType)myCellLocks[0].getDataEntityType(), (Object[])myCellLocks);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.printError((Throwable)e));
            }
            if (!isImportFormula) {
                TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])new Object[]{templateId});
            }
        }
    }

    public static Map<String, Object> getCellFormulasAndLocks(SpreadManager sm, DynamicObject template, String orgNumber, long modelId, boolean isImportFormula) {
        SpreadManager originDataSpreadManage = JsonSerializerUtil.toSpreadManager((String)template.getString("data"));
        SpreadManager originRptSpreadManage = JsonSerializerUtil.toSpreadManager((String)template.getString("rptdata"));
        if (!isImportFormula) {
            TemplateModel tm = ModelDataProvider.getTemplateModel(template.getLong("id"));
            String rptspreadjson = template.getString("rptspreadjson");
            NewMyTemplateUtil.syncLockStatusToSm(tm, originDataSpreadManage, rptspreadjson);
            NewMyTemplateUtil.syncLockStatusToSm(tm, originRptSpreadManage, rptspreadjson);
        }
        return NewMyTemplateUtil.getCellFormulasAndLocks(sm, orgNumber, modelId, template, originDataSpreadManage, originRptSpreadManage);
    }

    private static void syncLockStatusToSm(TemplateModel tm, SpreadManager sm, String spreadjson) {
        if (tm.isSaveByDim() || AutoFloatUtil.isSyncLockStatus(sm.getBook().getSheet(0))) {
            return;
        }
        JSONObject dataJsonObj = (JSONObject)ThreadCache.get((Object)"syncLockStatusToSm_rptspreadjson", () -> {
            JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)spreadjson));
            return DataAndJsonTranslator.getDataTable((JSONObject)object, (String)tm.getName());
        });
        TemplateUtil.setTemplateLockedCellStatus(dataJsonObj, sm);
    }

    public static Map<String, Object> getCellFormulasAndLocks(SpreadManager sm, String orgNumber, long modelId, DynamicObject template, SpreadManager originDataSpreadManage, SpreadManager originRptSpreadManage) {
        Sheet originDataSheet = originDataSpreadManage.getBook().getSheet(0);
        Sheet originRptDataSheet = originRptSpreadManage.getBook().getSheet(0);
        Sheet myTemSheet = sm.getBook().getSheet(0);
        AtomicInteger cellId = new AtomicInteger();
        if (myTemSheet.getMaxCellId() != -1) {
            cellId.set(myTemSheet.getMaxCellId());
        }
        Pair obj = NewMyTemplateUtil.collectCellIdForMyTemplate(myTemSheet, cellId, originRptDataSheet, originDataSheet);
        originRptDataSheet.setMaxCellId(Integer.valueOf(cellId.get()));
        originDataSheet.setMaxCellId(Integer.valueOf(cellId.get()));
        myTemSheet.setMaxCellId(Integer.valueOf(cellId.get()));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        template.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)originDataSpreadManage));
        template.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)originRptSpreadManage));
        resultMap.put(TEMPLATE, template);
        long userId = RequestContext.get().getCurrUserId();
        long templateId = template.getLong("id");
        resultMap.put(MYCELLFORMULAS, NewMyTemplateUtil.createCellFormulaDyo(templateId, orgNumber, modelId, userId, (Map)obj.p1));
        resultMap.put(MYCELLLOCKS, NewMyTemplateUtil.createCellLockDyo(templateId, orgNumber, modelId, userId, (Map)obj.p2));
        return resultMap;
    }

    private static Pair collectCellIdForMyTemplate(Sheet myTemSheet, AtomicInteger cellId, Sheet originRptDataSheet, Sheet originDataSheet) {
        HashMap temCellAndFormula = new HashMap(16);
        HashMap temCellLock = new HashMap(16);
        originRptDataSheet.iteratorCells(cell -> {
            boolean lock = cell.getUserObject("locked") != null;
            boolean hasFormula = cell.hasFormula();
            if (hasFormula || lock) {
                Integer id = cell.getCellId();
                if (id == -1) {
                    return;
                }
                if (hasFormula) {
                    Pair pair = new Pair((Object)(cell.getRow() + "|" + cell.getCol()), (Object)cell.getFormula());
                    temCellAndFormula.put(id, pair);
                }
                if (lock) {
                    temCellLock.put(id, cell.isLock());
                }
            }
        });
        HashMap myTemCellAndFormula = new HashMap(16);
        HashMap myTemCellLock = new HashMap(16);
        myTemSheet.iteratorCells(cell -> {
            boolean isChangeLock;
            String curFormula = cell.getFormula() != null ? cell.getFormula() : "";
            Boolean curLock = cell.isLock();
            Integer orgTemCellId = cell.getCellId();
            String tempFormula = "";
            Boolean tempLock = false;
            if (orgTemCellId != -1) {
                if (temCellAndFormula.get(orgTemCellId) != null) {
                    tempFormula = (String)((Pair)temCellAndFormula.get((Object)orgTemCellId)).p2;
                }
                if (temCellLock.get(orgTemCellId) != null) {
                    tempLock = (Boolean)temCellLock.get(orgTemCellId);
                }
            } else {
                Cell rptCell = originRptDataSheet.getCell(cell.getRow(), cell.getCol());
                curFormula = rptCell.getFormula() != null ? rptCell.getFormula() : "";
                tempLock = rptCell.isLock();
            }
            boolean isChangeFormula = !curFormula.equalsIgnoreCase(tempFormula);
            boolean bl = isChangeLock = !curLock.equals(tempLock);
            if (orgTemCellId == -1 && (cell.hasFormula() || cell.isLock() || isChangeFormula || isChangeLock)) {
                cell.setCellId(Integer.valueOf(cellId.incrementAndGet()));
                Cell rptCell = originRptDataSheet.getCell(cell.getRow(), cell.getCol());
                rptCell.setCellId(Integer.valueOf(cellId.get()));
                originDataSheet.getCell(cell.getRow(), cell.getCol()).setCellId(Integer.valueOf(cellId.get()));
                orgTemCellId = cellId.get();
            }
            if (orgTemCellId != -1) {
                if (isChangeFormula) {
                    myTemCellAndFormula.put(orgTemCellId, new Pair((Object)(cell.getRow() + "|" + cell.getCol()), (Object)cell.getFormula()));
                }
                if (isChangeLock) {
                    myTemCellLock.put(orgTemCellId, curLock);
                }
            }
        });
        return Pair.onePair(myTemCellAndFormula, myTemCellLock);
    }

    public static DynamicObject[] createCellLockDyo(long templateId, String orgNumber, long modelId, long userId, Map<Integer, Boolean> myTemCellLock) {
        if (myTemCellLock.isEmpty()) {
            return new DynamicObject[0];
        }
        DynamicObject[] myCellLockDyos = new DynamicObject[myTemCellLock.size()];
        AtomicInteger index = new AtomicInteger(0);
        myTemCellLock.forEach((k, v) -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mytemplate_celllock");
            dynamicObject.set("cell", k);
            dynamicObject.set("lockstatus", v);
            dynamicObject.set("orgnumber", (Object)orgNumber);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set(TEMPLATE, (Object)templateId);
            dynamicObject.set("modifier", (Object)userId);
            myCellLockDyos[index.getAndIncrement()] = dynamicObject;
        });
        return myCellLockDyos;
    }

    public static DynamicObject[] createCellFormulaDyo(long templateId, String orgNumber, long modelId, long userId, Map<Integer, Pair<String, String>> temCellAndFormula) {
        if (temCellAndFormula.isEmpty()) {
            return new DynamicObject[0];
        }
        DynamicObject[] cellFormulas = new DynamicObject[temCellAndFormula.size()];
        AtomicInteger index = new AtomicInteger(0);
        temCellAndFormula.forEach((k, v) -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cellformula");
            dynamicObject.set("cell", k);
            dynamicObject.set("orgnumber", (Object)orgNumber);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set(TEMPLATE, (Object)templateId);
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("formula", ((Pair)temCellAndFormula.get((Object)k)).p2);
            dynamicObject.set("coordinate", ((Pair)temCellAndFormula.get((Object)k)).p1);
            cellFormulas[index.getAndIncrement()] = dynamicObject;
        });
        return cellFormulas;
    }

    public static boolean repairCellIdForSm(SpreadManager sm) {
        Sheet sheet = sm.getBook().getSheet(0);
        if (sheet.getMaxCellId() != -1) {
            return false;
        }
        AtomicInteger cellId = new AtomicInteger();
        sheet.iteratorCells(cell -> {
            if (cell.hasFormula() || cell.getUserObject("locked") != null) {
                cell.setCellId(Integer.valueOf(cellId.incrementAndGet()));
            }
        });
        sheet.setMaxCellId(Integer.valueOf(cellId.get()));
        return true;
    }

    public static boolean isExitChangeOrgTempCell(Set<Integer> cellIds, Set<Integer> locks, SpreadManager sm, long modelId, long templateId) {
        DynamicObjectCollection myTemCellFormulas = NewMyTemplateUtil.queryOrgTempCell(modelId, templateId, true);
        DynamicObjectCollection myTemCelllocks = NewMyTemplateUtil.queryOrgTempCell(modelId, templateId, false);
        myTemCellFormulas.addAll((Collection)myTemCelllocks);
        if (CollectionUtils.isNotEmpty((Collection)myTemCellFormulas)) {
            myTemCellFormulas.forEach(e -> {
                int cellId = e.getInt("cell");
                if (e.getDataEntityType().getProperties().containsKey((Object)"lockstatus")) {
                    locks.add(cellId);
                } else {
                    cellIds.add(cellId);
                }
            });
        }
        AtomicBoolean result = new AtomicBoolean(false);
        sm.getBook().getSheet(0).iteratorCellsByPredicateBreak(cell -> {
            if (cell.getCellId() != -1 && ((Boolean)cell.getUserObject("c_f", (Object)false)).booleanValue() && cellIds.contains(cell.getCellId())) {
                result.set(true);
                return true;
            }
            return false;
        });
        return result.get();
    }

    private static DynamicObjectCollection queryOrgTempCell(long modelId, long templateId, boolean isFormula) {
        String entityName = isFormula ? "bcm_cellformula" : "bcm_mytemplate_celllock";
        String selectFields = isFormula ? "formula, cell" : "lockstatus, cell";
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{NewMyTemplateUtil.getOrgTempCellQfilter(modelId, templateId, true)});
    }

    public static QFilter getOrgTempCellQfilter(long modelId, long templateId, boolean isOrgTemp) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(TEMPLATE, "=", (Object)templateId);
        qFilter.and("orgnumber", isOrgTemp ? "!=" : "=", (Object)" ");
        return qFilter;
    }

    public static void clearAllMytemplateRecords(long modelId, long templateId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(TEMPLATE, "=", (Object)templateId);
        QFilter orgQfilter = new QFilter("orgnumber", "!=", (Object)" ");
        DeleteServiceHelper.delete((String)"bcm_cellformula", (QFilter[])new QFilter[]{qFilter, orgQfilter});
        DeleteServiceHelper.delete((String)"bcm_mytemplate_celllock", (QFilter[])new QFilter[]{qFilter, orgQfilter});
        DeleteServiceHelper.delete((String)"bcm_orgrpttemplate", (QFilter[])qFilter.toArray());
    }

    public static void clearAllMytemplateRecords(long modelId, List<Object> templateIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(TEMPLATE, "in", templateIds);
        DeleteServiceHelper.delete((String)"bcm_cellformula", (QFilter[])qFilter.toArray());
        DeleteServiceHelper.delete((String)"bcm_mytemplate_celllock", (QFilter[])qFilter.toArray());
        DeleteServiceHelper.delete((String)"bcm_orgrpttemplate", (QFilter[])qFilter.toArray());
    }

    public static void getAllCellFormulasDy(SpreadManager sm, Set<Integer> changeFormulaCellIds, Set<Integer> changeLockCellIds) {
        Sheet sheet = sm.getBook().getSheet(0);
        AtomicInteger cellId = new AtomicInteger();
        if (sheet.getMaxCellId() == -1) {
            sheet.iteratorCells(cell -> {
                if (cell.hasFormula() || cell.getUserObject("locked") != null) {
                    cell.setCellId(Integer.valueOf(cellId.incrementAndGet()));
                    if (cell.hasFormula()) {
                        cell.getUserObject().remove((Object)"c_f");
                    }
                    if (cell.getUserObject("locked") != null) {
                        cell.getUserObject().remove((Object)"c_l");
                    }
                }
            });
        } else {
            cellId.set(sheet.getMaxCellId());
            sheet.iteratorCells(cell -> {
                Boolean isLockChange = (Boolean)cell.getUserObject("c_l", (Object)false);
                Boolean isFormulaChange = (Boolean)cell.getUserObject("c_f", (Object)false);
                if (isLockChange.booleanValue() || isFormulaChange.booleanValue() || cell.hasFormula() || cell.getUserObject("locked") != null) {
                    Integer templateCellId = cell.getCellId();
                    if (templateCellId == -1) {
                        cell.setCellId(Integer.valueOf(cellId.incrementAndGet()));
                        templateCellId = cellId.get();
                    }
                    if ((isLockChange.booleanValue() || cell.getUserObject("locked") != null) && isLockChange.booleanValue()) {
                        changeLockCellIds.add(templateCellId);
                        cell.getUserObject().remove((Object)"c_l");
                    }
                    if ((isFormulaChange.booleanValue() || cell.hasFormula()) && isFormulaChange.booleanValue()) {
                        changeFormulaCellIds.add(templateCellId);
                        cell.getUserObject().remove((Object)"c_f");
                    }
                }
            });
        }
        sheet.setMaxCellId(Integer.valueOf(cellId.get()));
    }

    public static void saveTemplateCellRecords(long modelId, TemplateModel template, Set<Integer> deleteCellIds, Set<Integer> delCellLockIds, boolean isRestore) {
        QFilter delFilter = NewMyTemplateUtil.getOrgTempCellQfilter(modelId, template.getId(), false);
        BusinessDataWriter.delete((String)"bcm_cellformula", (QFilter[])delFilter.toArray());
        BusinessDataWriter.delete((String)"bcm_mytemplate_celllock", (QFilter[])delFilter.toArray());
        if (isRestore) {
            QFilter idQf;
            QFilter qFilter = NewMyTemplateUtil.getOrgTempCellQfilter(modelId, template.getId(), true);
            if (!deleteCellIds.isEmpty()) {
                idQf = new QFilter("cell", "in", deleteCellIds);
                BusinessDataWriter.delete((String)"bcm_cellformula", (QFilter[])new QFilter[]{qFilter, idQf});
            }
            if (!delCellLockIds.isEmpty()) {
                idQf = new QFilter("cell", "in", delCellLockIds);
                BusinessDataWriter.delete((String)"bcm_mytemplate_celllock", (QFilter[])new QFilter[]{qFilter, idQf});
            }
        }
        if (template.get("isChange") != null && ((Boolean)template.get("isChange")).booleanValue() && ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isSupportNewMytemplate")) {
            NewMyTemplateUtil.clearAllMytemplateRecords(modelId, template.getId());
            template.put("isChange", (Object)false);
        }
    }

    public static void clearSpecialCellMark(SpreadManager sm) {
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            cell.removeUserObject("c_l");
            cell.removeUserObject("c_f");
        });
    }
}

