/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.scheme.SimpleIDNumberTreeNode;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class ObjectConvertUtils {
    public static IDimension toIDimension(kd.fi.bcm.business.template.model.Dimension d) {
        Dimension dimension = new Dimension(d.getName(), d.getNumber(), d.getShortNumber());
        return dimension;
    }

    public static IDimMember toDimMember(Member m, IDimension dim) {
        DimMember member = new DimMember(m.getName(), m.getNumber(), null, dim);
        return member;
    }

    public static IDimMember toDimMember(IDNumberTreeNode m, IDimension dim) {
        return (IDimMember)ThreadCache.get((Object)(dim.getNumber() + "->" + m.getNumber()), () -> new DimMember(m.getName(), m.getNumber(), null, dim));
    }

    public static IDimMember toDimMember(SimpleIDNumberTreeNode m, IDimension dim) {
        return (IDimMember)ThreadCache.get((Object)(dim.getNumber() + "->" + m.getNumber()), () -> new DimMember(m.getName(), m.getNumber(), null, dim));
    }

    public static IDimension toIDimension(DynamicObject dimDyna) {
        String name = dimDyna.getDynamicObjectType().getProperties().containsKey((Object)"dimension.name") ? dimDyna.getString("dimension.name") : dimDyna.getString("name");
        String number = dimDyna.getDynamicObjectType().getProperties().containsKey((Object)"dimension.number") ? dimDyna.getString("dimension.number") : dimDyna.getString("number");
        Dimension dimension = new Dimension(name, number, null);
        return dimension;
    }

    public static IDimension toIDimension(SimpleIDNumberTreeNode member) {
        String number = member.getDimNum();
        Map map = MemberReader.getDimNumberMapNameById((long)member.getModelId());
        Dimension dimension = new Dimension((String)map.get(number), number, null);
        return dimension;
    }

    public static IDimMember toDimMember(DynamicObject m, IDimension dim) {
        return new DimMember(m.getString("name"), m.getString("number"), m.getDataEntityType().getProperties().containsKey((Object)"simplename") ? m.getString("simplename") : null, dim);
    }

    public static Member toMember(DynamicObject m) {
        Member mr = new Member();
        mr.setId(m.getLong("id"));
        mr.setName(m.getString("name"));
        mr.setNumber(m.getString("number"));
        return mr;
    }

    public static Member toMember(IDNumberTreeNode m) {
        Member mr = new Member();
        mr.setId(m.getId().longValue());
        mr.setName(m.getName());
        mr.setNumber(m.getNumber());
        return mr;
    }

    public static IDimMember toDimMember(String memNum, long modelId, IDimension dimension) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimension.getNumber(), (String)memNum);
        if (memNum.split(":").length == 2) {
            memNum = memNum.split(":")[1];
        }
        String simpleName = (String)MemberReader.getMemberNumber2SimpleNameMap((long)modelId, (String)dimension.getNumber()).get(memNum);
        return new DimMember(node.getName(), node.getNumber(), simpleName, dimension);
    }
}

