/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.PageParamModel;

public class OpenMenuPageUtil {
    public static void showFormViewByParam(PageParamModel pageModel) {
        IFormView thisView = pageModel.getThisView();
        String markId = OpenMenuPageUtil.getMarkIdByFormApp(pageModel.getEntityId(), pageModel.getThisView());
        IFormView mainPageView = thisView.getMainView();
        FormShowParameter param = pageModel.getParam();
        param.setFormId(pageModel.getEntityId());
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.NewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        if (mainPageView == null) {
            thisView.showForm(param);
        } else {
            String menuPageID = markId + mainPageView.getPageId();
            if (mainPageView.getView(menuPageID) != null) {
                IFormView childFormView = mainPageView.getView(menuPageID);
                childFormView.activate();
                thisView.sendFormAction(childFormView);
            } else {
                param.setPageId(menuPageID);
                IFormView appPageView = thisView.getView(pageModel.getAppPageId());
                appPageView.showForm(param);
                thisView.sendFormAction(appPageView);
            }
        }
    }

    public static void showFormViewByParam(PageParamModel pageModel, boolean refreshPage) {
        IFormView thisView = pageModel.getThisView();
        String markId = OpenMenuPageUtil.getMarkIdByFormApp(pageModel.getEntityId(), pageModel.getThisView());
        IFormView mainPageView = thisView.getMainView();
        FormShowParameter param = pageModel.getParam();
        param.setFormId(pageModel.getEntityId());
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.NewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        if (mainPageView == null) {
            thisView.showForm(param);
        } else {
            String menuPageID = markId + mainPageView.getPageId();
            if (mainPageView.getView(menuPageID) != null) {
                IFormView childFormView = mainPageView.getView(menuPageID);
                if (refreshPage) {
                    IDataModel dataModel = childFormView.getModel();
                    OpenMenuPageUtil.addCustomParamter(childFormView, param);
                    dataModel.beginInit();
                    dataModel.createNewData();
                    childFormView.updateView();
                }
                childFormView.activate();
                thisView.sendFormAction(childFormView);
            } else {
                param.setPageId(menuPageID);
                IFormView appPageView = thisView.getView(pageModel.getAppPageId());
                appPageView.showForm(param);
                thisView.sendFormAction(appPageView);
            }
        }
    }

    public static String getMarkIdByFormApp(String entityId, IFormView thisView) {
        QFilter filter = new QFilter("number", "=", (Object)entityId);
        String formId = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{filter}).getString("id");
        String appNumber = ModelUtil.queryApp(thisView).getAppnum();
        filter = new QFilter("number", "=", (Object)appNumber);
        String appId = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{filter}).getString("id");
        AppMetadata am = AppMetaServiceHelper.loadAppMetadataById((String)appId);
        for (AppMenuElement aa : am.getAppMenus()) {
            if (aa == null || aa.getFormId() == null || !aa.getFormId().equals(formId)) continue;
            return aa.getId();
        }
        return "";
    }

    private static void addCustomParamter(IFormView childFormView, FormShowParameter param) {
        Map customParams = param.getCustomParams();
        for (Map.Entry customParam : customParams.entrySet()) {
            childFormView.getFormShowParameter().setCustomParam((String)customParam.getKey(), customParam.getValue());
        }
    }
}

