/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import org.apache.commons.collections4.CollectionUtils;

public class OrgUtils {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(OrgUtils.class);
    public static final String ID = "id";
    public static final String ORG_FUZZY_SEARCH_FLAG = "org_fuzzySearch_flag";

    private OrgUtils() {
    }

    public static DynamicObjectCollection dealNoMergeOrgList(DynamicObjectCollection doc, IDataModel pageModel) {
        Long modelId = OrgUtils.getF7Id(pageModel, "model");
        Long scenarioId = OrgUtils.getF7Id(pageModel, "scenario");
        Long yearId = OrgUtils.getF7Id(pageModel, "year");
        Long periodId = OrgUtils.getF7Id(pageModel, "period");
        return OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)doc, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
    }

    public static void dealNoMergeOrgs(DynamicObjectCollection doc, IDataModel pageModel, OrgTreeNode root) {
        Long modelId = OrgUtils.getF7Id(pageModel, "model");
        Long yearId = OrgUtils.getF7Id(pageModel, "year");
        Long scenarioId = OrgUtils.getF7Id(pageModel, "scenario");
        Long periodId = OrgUtils.getF7Id(pageModel, "period");
        OrgServiceHelper.dealNoMergeOrgs((DynamicObjectCollection)doc, (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId, (OrgTreeNode)root);
    }

    public static Long getF7Id(IDataModel pageModel, String f7Number) {
        Long f7SelectId = null;
        try {
            DynamicObject dy = (DynamicObject)pageModel.getValue(f7Number);
            if (dy == null) {
                return null;
            }
            f7SelectId = dy.getLong(ID);
        }
        catch (KDException e) {
            log.error("error", (Throwable)e);
        }
        return f7SelectId == null || f7SelectId == 0L ? null : f7SelectId;
    }

    public static void resetBasedataFuzzySearchQFilter2Org(BeforeF7SelectEvent arg0, long modelId) {
        String value;
        String[] vals;
        QFilter searchFilter;
        BasedataEditSingleMemberF7 f7;
        Map<String, Object> customData;
        if (arg0.getSource() instanceof BasedataEditSingleMemberF7 && "bcm_entitymembertree".equals(((BasedataEditSingleMemberF7)((Object)arg0.getSource())).getEntity()) && (customData = (f7 = (BasedataEditSingleMemberF7)((Object)arg0.getSource())).getCustomData()) != null && customData.containsKey(ORG_FUZZY_SEARCH_FLAG) && customData.get("yearNum") != null && customData.get("periodId") != null && (searchFilter = f7.getSearchFilter()) != null && searchFilter.isCP("ftlike") && (vals = (value = (String)searchFilter.getValue()).split("#")).length == 2) {
            String keys = Arrays.stream(vals[0].split(",")).filter(e -> !e.equals("name")).collect(Collectors.joining(","));
            searchFilter.__setValue((Object)(keys + "#" + vals[1]));
            DynamicObject modelDo = EntityVersioningUtil.getModelFilter((Object)modelId);
            DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter((Object)customData.get("periodId"));
            Date lastDate = EntityVersioningUtil.getFilterDay((boolean)false, (DynamicObject)modelDo, (String)((String)customData.get("yearNum")), (DynamicObject)periodDo);
            QFilter qf = new QFilter("namechangerds.namerds", "like", (Object)("%" + vals[1] + "%"));
            QFilter less = new QFilter("namechangerds.nameeffdate", "<=", (Object)lastDate).and(new QFilter("namechangerds.nameexpdate", ">=", (Object)lastDate).or("namechangerds.nameexpdate", "is null", null));
            searchFilter.or(qf).and(less).or(new QFilter("name", "like", (Object)("%" + vals[1] + "%")).or("number", "like", (Object)("%" + vals[1] + "%")).and("isexchangerate", "=", (Object)Character.valueOf('1')));
        }
    }

    public static List<Object> resetBasedataFuzzySearchResult2Org(long modelId, Map<String, Object> customData, List<Object> queryData) {
        if (CollectionUtils.isNotEmpty(queryData) && customData != null && customData.containsKey(ORG_FUZZY_SEARCH_FLAG) && customData.get("yearNum") != null && customData.get("periodId") != null) {
            List collect = queryData.stream().map(e -> (List)e).map(e -> {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
                dy.set(ID, e.get(0));
                dy.set("number", e.get(1));
                dy.set("name", e.get(2));
                return dy;
            }).collect(Collectors.toList());
            FilterOrgStructParam param = new FilterOrgStructParam(modelId, ((Long)customData.get("scenarioId")).longValue(), customData.get("yearNum").toString(), LongUtil.toLong((Object)customData.get("periodId")).longValue());
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, collect);
            queryData = collect.stream().map(e -> Arrays.asList(e.getString(ID), e.getString("number"), e.getString("name"))).collect(Collectors.toList());
        }
        return queryData;
    }

    public static Collection<DynamicObject> changeOrgName2Dy(long modelId, long fyId, long periodId, Collection<DynamicObject> orgs, String entityKey, boolean isClone) {
        String keyid = StringUtils.isNotEmpty((CharSequence)entityKey) ? entityKey + ".id" : ID;
        String keyName = StringUtils.isNotEmpty((CharSequence)entityKey) ? entityKey + ".name" : "name";
        List<Object> orgIds = orgs.stream().map(e -> e.getLong(keyid)).collect(Collectors.toList());
        Map<Long, String> id2NumMap = OrgUtils.getOrgChangeName2Map(modelId, fyId, periodId, orgIds);
        if (id2NumMap.isEmpty()) {
            return orgs;
        }
        CloneUtils cloneUtils = new CloneUtils(true, false);
        return orgs.stream().map(e -> {
            String name = (String)id2NumMap.get(e.getLong(keyid));
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                DynamicObject clone = isClone ? (DynamicObject)cloneUtils.clone((IDataEntityBase)e) : e;
                clone.set(keyName, (Object)name);
            }
            return e;
        }).collect(Collectors.toList());
    }

    public static Map<Long, String> getOrgChangeName2Map(long modelId, long fyId, long periodId, Collection<Object> orgIds) {
        HashMap<Long, String> id2NumMap = new HashMap<Long, String>(orgIds.size());
        if (fyId == 0L || periodId == 0L) {
            return id2NumMap;
        }
        OrgUtils.getOrgChangeName(modelId, fyId, periodId, orgIds, (id, number) -> id2NumMap.put((Long)id, (String)number));
        return id2NumMap;
    }

    public static void getOrgChangeName(long modelId, long fyId, long periodId, Collection<Object> orgIds, BiConsumer<Long, String> consumer) {
        QFilter qf = new QFilter(ID, "in", orgIds);
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter((Object)modelId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter((Object)periodId);
        Date lastDate = EntityVersioningUtil.getFilterDay((boolean)false, (DynamicObject)modelDo, (String)MemberReader.findFyMemberById((Long)modelId, (Long)fyId).getNumber(), (DynamicObject)periodDo);
        QFilter firstQf = new QFilter("namechangerds.nameeffdate", "<=", (Object)lastDate);
        firstQf.and("namechangerds.nameexpdate", "is null", null);
        QFilter lastQf = new QFilter("namechangerds.nameexpdate", ">=", (Object)lastDate);
        firstQf.or(lastQf);
        qf.and(firstQf);
        QueryServiceHelper.queryDataSet((String)"orgchangeName", (String)"bcm_entitymembertree", (String)"id,namechangerds.namerds as name", (QFilter[])qf.toArray(), null, (int)-1).forEachRemaining(e -> consumer.accept(e.getLong(ID), e.getString("name")));
    }
}

