/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.report.ReportMultiExportTask;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.helpers.RowShifter;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIUtil {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportMultiExportTask.class);
    public static final String PROPROTION = "%";

    public static void copyCellStyle(XSSFCellStyle fromStyle, XSSFCellStyle toStyle) {
        toStyle.cloneStyleFrom((CellStyle)fromStyle);
    }

    public static void copyCellStyle(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFCellStyle fromStyle, HSSFCellStyle toStyle) {
        POIUtil.transform(xwb, hwb, fromStyle, toStyle);
    }

    public static void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        styleNew.setAlignment(styleOld.getAlignment());
        styleNew.setBorderBottom(styleOld.getBorderBottom());
        styleNew.setBorderLeft(styleOld.getBorderLeft());
        styleNew.setBorderRight(styleOld.getBorderRight());
        styleNew.setBorderTop(styleOld.getBorderTop());
        styleNew.setDataFormat(POIUtil.transform(workbookOld, workbookNew, styleOld.getDataFormat()));
        styleNew.setFillPattern(styleOld.getFillPattern());
        styleNew.setFont(POIUtil.transform(workbookNew, styleOld.getFont()));
        styleNew.setHidden(styleOld.getHidden());
        styleNew.setIndention(styleOld.getIndention());
        styleNew.setLocked(styleOld.getLocked());
        styleNew.setVerticalAlignment(styleOld.getVerticalAlignment());
        styleNew.setWrapText(styleOld.getWrapText());
        POIUtil.dealCellColor(workbookNew, styleOld, styleNew);
    }

    public static void dealCellColor(HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        POIUtil.dealBorderColor(workbookNew, styleOld, styleNew);
        POIUtil.dealFillBgdColor(workbookNew, styleOld, styleNew);
        POIUtil.dealFillFgdColor(workbookNew, styleOld, styleNew);
        POIUtil.dealCellFontColor(workbookNew, styleOld, styleNew);
    }

    public static void dealBorderColor(HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        short colorIndex;
        byte[] rgb;
        String black = "FF000000";
        if (styleOld.getBottomBorderXSSFColor() != null && !black.equalsIgnoreCase(styleOld.getBottomBorderXSSFColor().getARGBHex())) {
            rgb = styleOld.getBottomBorderXSSFColor().getRGB();
            colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setBottomBorderColor(colorIndex);
        }
        if (styleOld.getTopBorderXSSFColor() != null && !black.equalsIgnoreCase(styleOld.getTopBorderXSSFColor().getARGBHex())) {
            rgb = styleOld.getTopBorderXSSFColor().getRGB();
            colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setTopBorderColor(colorIndex);
        }
        if (styleOld.getLeftBorderXSSFColor() != null && !black.equalsIgnoreCase(styleOld.getLeftBorderXSSFColor().getARGBHex())) {
            rgb = styleOld.getLeftBorderXSSFColor().getRGB();
            colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setLeftBorderColor(colorIndex);
        }
        if (styleOld.getRightBorderXSSFColor() != null && !black.equalsIgnoreCase(styleOld.getRightBorderXSSFColor().getARGBHex())) {
            rgb = styleOld.getRightBorderXSSFColor().getRGB();
            colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setRightBorderColor(colorIndex);
        }
    }

    public static void dealFillBgdColor(HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        if (styleOld.getFillBackgroundColorColor() != null) {
            byte[] rgb = styleOld.getFillForegroundColorColor().getRGB();
            short colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setFillBackgroundColor(colorIndex);
        }
    }

    public static void dealFillFgdColor(HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        if (styleOld.getFillForegroundXSSFColor() != null) {
            byte[] rgb = styleOld.getFillForegroundColorColor().getRGB();
            short colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
            styleNew.setFillForegroundColor(colorIndex);
        }
    }

    public static void dealCellFontColor(HSSFWorkbook workbookNew, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        if (styleOld.getFont() == null || styleNew.getFont((Workbook)workbookNew) == null) {
            return;
        }
        XSSFFont fontOld = styleOld.getFont();
        HSSFFont fontNew = styleNew.getFont((Workbook)workbookNew);
        byte[] rgb = fontOld.getXSSFColor().getRGB();
        short colorIndex = POIUtil.getColorIndex(workbookNew, rgb);
        fontNew.setColor(colorIndex);
    }

    private static short getColorIndex(HSSFWorkbook workbookNew, byte[] rgb) {
        String rgbKey = Arrays.toString(rgb);
        Map<String, Short> colorIndexMap = new HashMap();
        if (ThreadCache.exists((Object)"colorIndexMap")) {
            colorIndexMap = (Map)ThreadCache.get((Object)"colorIndexMap");
        } else {
            ThreadCache.put((Object)"colorIndexMap", colorIndexMap);
        }
        if (colorIndexMap.get(rgbKey) != null) {
            return (Short)colorIndexMap.get(rgbKey);
        }
        HSSFPalette customPalette = workbookNew.getCustomPalette();
        short colorIndex = 10;
        if (ThreadCache.exists((Object)"colorIndex")) {
            colorIndex = (short)((Short)ThreadCache.get((Object)"colorIndex") + 1);
            ThreadCache.put((Object)"colorIndex", (Object)colorIndex);
        } else {
            ThreadCache.put((Object)"colorIndex", (Object)colorIndex);
        }
        customPalette.setColorAtIndex(colorIndex, rgb[0], rgb[1], rgb[2]);
        colorIndexMap.put(rgbKey, colorIndex);
        return colorIndex;
    }

    public static short transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, short index) {
        XSSFDataFormat formatOld = workbookOld.createDataFormat();
        HSSFDataFormat formatNew = workbookNew.createDataFormat();
        return formatNew.getFormat(formatOld.getFormat(index));
    }

    public static HSSFFont transform(HSSFWorkbook workbookNew, XSSFFont fontOld) {
        HSSFFont fontNew = workbookNew.createFont();
        fontNew.setBold(fontOld.getBold());
        fontNew.setCharSet(fontOld.getCharSet());
        fontNew.setFontName(fontOld.getFontName());
        fontNew.setFontHeight(fontOld.getFontHeight());
        fontNew.setItalic(fontOld.getItalic());
        fontNew.setStrikeout(fontOld.getStrikeout());
        fontNew.setTypeOffset(fontOld.getTypeOffset());
        fontNew.setUnderline(fontOld.getUnderline());
        return fontNew;
    }

    public static void mergeSheetAllRegion(XSSFSheet fromSheet, XSSFSheet toSheet) {
        int num = fromSheet.getNumMergedRegions();
        CellRangeAddress cellR = null;
        for (int i = 0; i < num; ++i) {
            cellR = fromSheet.getMergedRegion(i);
            if (cellR.getNumberOfCells() < 2) continue;
            toSheet.addMergedRegionUnsafe(cellR);
        }
    }

    public static void mergeSheetAllRegion(XSSFSheet fromSheet, HSSFSheet toSheet) {
        int num = fromSheet.getNumMergedRegions();
        CellRangeAddress cellR = null;
        for (int i = 0; i < num; ++i) {
            cellR = fromSheet.getMergedRegion(i);
            if (cellR.getNumberOfCells() < 2) continue;
            toSheet.addMergedRegionUnsafe(cellR);
        }
    }

    public static boolean validateRowShiftParameters(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        try {
            RowShifter.validateShiftParameters((int)firstShiftColumnIndex, (int)lastShiftColumnIndex, (int)step);
        }
        catch (IllegalArgumentException e) {
            log.error((Throwable)e);
            return false;
        }
        return true;
    }

    public static String getCellStyleKey(XSSFCell cell) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        String dataFormatStr = cellStyle.getDataFormatString();
        XSSFColor backgroundColorColor = cellStyle.getFillBackgroundColorColor();
        String backgroundColorColorKey = backgroundColorColor != null ? backgroundColorColor.getARGBHex() : "";
        XSSFColor fillForegroundColor = cellStyle.getFillForegroundColorColor();
        String fillForegroundColorKey = fillForegroundColor != null ? fillForegroundColor.getARGBHex() : "";
        FillPatternType fillPattern = cellStyle.getFillPattern();
        String fillcode = fillPattern == null ? "" : "" + fillPattern.getCode();
        short alignment = cellStyle.getAlignment().getCode();
        short topcode = cellStyle.getBorderTop().getCode();
        short bottomcode = cellStyle.getBorderBottom().getCode();
        short leftcode = cellStyle.getBorderLeft().getCode();
        short rightcode = cellStyle.getBorderRight().getCode();
        short indention = cellStyle.getIndention();
        String topBorderColor = cellStyle.getTopBorderXSSFColor() == null ? "" : cellStyle.getTopBorderXSSFColor().getARGBHex();
        String bottomBorderColor = cellStyle.getBottomBorderXSSFColor() == null ? "" : cellStyle.getBottomBorderXSSFColor().getARGBHex();
        String leftBorderColor = cellStyle.getLeftBorderXSSFColor() == null ? "" : cellStyle.getLeftBorderXSSFColor().getARGBHex();
        String rightBorderColor = cellStyle.getRightBorderXSSFColor() == null ? "" : cellStyle.getRightBorderXSSFColor().getARGBHex();
        String borderKey = "t" + topcode + topBorderColor + "b" + bottomcode + bottomBorderColor + "l" + leftcode + leftBorderColor + "r" + rightcode + rightBorderColor;
        XSSFFont font = cellStyle.getFont();
        if (font != null) {
            String fontName = font.getFontName();
            short fontHeightInPoints = font.getFontHeightInPoints();
            short fontHeight = font.getFontHeight();
            boolean bold = font.getBold();
            String color = font.getXSSFColor().getARGBHex();
            return fontName + fontHeightInPoints + bold + fontHeight + color + fillForegroundColorKey + backgroundColorColorKey + fillcode + alignment + borderKey + dataFormatStr + indention;
        }
        return fillForegroundColorKey + backgroundColorColorKey + fillcode + alignment + borderKey + dataFormatStr + indention;
    }

    public static void copyCellByIndex(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell, Map<Object, Short> styles) {
        CellType cType;
        XSSFCellStyle newstyle;
        String issmall = (String)ThreadCache.get((Object)"issmall", () -> ConfigServiceHelper.getStringParamNoModel((String)"issmall"));
        if (!"1".equals(issmall)) {
            String key = POIUtil.getCellStyleKey(fromCell);
            newstyle = wb.getCellStyleAt((int)styles.getOrDefault(key, (short)Short.MIN_VALUE).shortValue());
            if (newstyle == null) {
                newstyle = wb.createCellStyle();
                POIUtil.copyCellStyle(fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        } else {
            newstyle = wb.getCellStyleAt((int)styles.getOrDefault(fromCell.getCellStyle().getIndex(), (short)Short.MIN_VALUE).shortValue());
            if (newstyle == null) {
                newstyle = wb.createCellStyle();
                POIUtil.copyCellStyle(fromCell.getCellStyle(), newstyle);
                styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
            }
        }
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        if ((cType = fromCell.getCellType()) == CellType.FORMULA && toCell.getCellType() != CellType.FORMULA) {
            try {
                toCell.setCellFormula(fromCell.toString());
            }
            catch (Exception e) {
                try {
                    toCell.setCellValue(fromCell.toString());
                }
                catch (Exception e1) {
                    log.error(fromCell.getRowIndex() + "@" + fromCell.getColumnIndex() + ":dealWorkBook:" + e1);
                }
            }
        } else {
            toCell.setCellType(cType);
        }
        switch (cType) {
            case STRING: {
                toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                toCell.setCellValue(fromCell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                try {
                    toCell.setCellValue(fromCell.getCellFormula());
                }
                catch (Exception e) {
                    log.error(fromCell.getRowIndex() + "@" + fromCell.getColumnIndex() + ":dealWorkBook:" + e);
                }
                break;
            }
            case BOOLEAN: {
                toCell.setCellValue(fromCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                toCell.setCellValue((double)fromCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                toCell.setBlank();
                break;
            }
            default: {
                toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
            }
        }
    }

    public static void copyCellByIndex(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFCell fromCell, HSSFCell toCell, Map<Object, Short> styles) {
        String issmall = (String)ThreadCache.get((Object)"issmall", () -> ConfigServiceHelper.getStringParamNoModel((String)"issmall"));
        HSSFCellStyle newstyle = null;
        if (!"1".equals(issmall)) {
            String key = POIUtil.getCellStyleKey(fromCell);
            if (styles.get(key) != null) {
                newstyle = hwb.getCellStyleAt((int)styles.get(key).shortValue());
            }
            if (newstyle == null) {
                newstyle = hwb.createCellStyle();
                POIUtil.copyCellStyle(xwb, hwb, fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        } else {
            if (styles.get(fromCell.getCellStyle().getIndex()) != null) {
                newstyle = hwb.getCellStyleAt((int)styles.get(fromCell.getCellStyle().getIndex()).shortValue());
            }
            if (newstyle == null) {
                newstyle = hwb.createCellStyle();
                POIUtil.copyCellStyle(xwb, hwb, fromCell.getCellStyle(), newstyle);
                styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
            }
        }
        toCell.setCellStyle(newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        POIUtil.copyCellValue(fromCell, toCell);
    }

    public static void copyCell(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell, Map<Object, Short> styles, boolean isCopyValue) {
        XSSFCellStyle newstyle;
        String issmall = (String)ThreadCache.get((Object)"issmall", () -> ConfigServiceHelper.getStringParamNoModel((String)"issmall"));
        if (!"1".equals(issmall)) {
            String key = POIUtil.getCellStyleKey(fromCell);
            newstyle = wb.getCellStyleAt((int)styles.getOrDefault(key, (short)Short.MIN_VALUE).shortValue());
            if (newstyle == null) {
                newstyle = wb.createCellStyle();
                POIUtil.copyCellStyle(fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        } else {
            XSSFColor backgroundColorColor = fromCell.getCellStyle().getFillBackgroundColorColor();
            String key = fromCell.getCellStyle().getCoreXf().toString() + fromCell.getCellStyle().getStyleXf().toString() + (backgroundColorColor != null ? backgroundColorColor.getARGBHex() : "");
            Short idx = styles.get(key);
            newstyle = wb.getCellStyleAt(idx == null ? Short.MIN_VALUE : (int)idx.shortValue());
            if (newstyle == null) {
                newstyle = wb.createCellStyle();
                POIUtil.copyCellStyle(fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        }
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        if (isCopyValue) {
            CellType cType = fromCell.getCellType();
            if (cType == CellType.FORMULA && toCell.getCellType() != CellType.FORMULA) {
                try {
                    toCell.setCellFormula(fromCell.getCellFormula());
                }
                catch (Exception e) {
                    try {
                        toCell.setCellValue(fromCell.getCellFormula());
                    }
                    catch (Exception e1) {
                        log.error(fromCell.getRowIndex() + "@" + fromCell.getColumnIndex() + ":dealWorkBook:" + e1);
                    }
                }
            } else {
                toCell.setCellType(cType);
            }
            switch (cType) {
                case STRING: {
                    toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
                    break;
                }
                case NUMERIC: {
                    toCell.setCellValue(fromCell.getNumericCellValue());
                    break;
                }
                case FORMULA: {
                    break;
                }
                case BOOLEAN: {
                    toCell.setCellValue(fromCell.getBooleanCellValue());
                    break;
                }
                case ERROR: {
                    toCell.setCellValue((double)fromCell.getErrorCellValue());
                    break;
                }
                case BLANK: {
                    toCell.setBlank();
                    break;
                }
                default: {
                    toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
                }
            }
        }
    }

    public static void copyCell(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFCell fromCell, HSSFCell toCell, Map<Object, Short> styles, boolean isCopyValue) {
        String issmall = (String)ThreadCache.get((Object)"issmall", () -> ConfigServiceHelper.getStringParamNoModel((String)"issmall"));
        HSSFCellStyle newstyle = null;
        if (!"1".equals(issmall)) {
            String key = POIUtil.getCellStyleKey(fromCell);
            Short value = styles.get(key);
            if (value != null) {
                newstyle = hwb.getCellStyleAt((int)value.shortValue());
            }
            if (newstyle == null) {
                newstyle = hwb.createCellStyle();
                POIUtil.copyCellStyle(xwb, hwb, fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        } else {
            XSSFColor backgroundColorColor = fromCell.getCellStyle().getFillBackgroundColorColor();
            String key = fromCell.getCellStyle().getCoreXf().toString() + fromCell.getCellStyle().getStyleXf().toString() + (backgroundColorColor != null ? backgroundColorColor.getARGBHex() : "");
            Short idx = styles.get(key);
            if (idx != null) {
                newstyle = hwb.getCellStyleAt((int)idx.shortValue());
            }
            if (newstyle == null) {
                newstyle = hwb.createCellStyle();
                POIUtil.copyCellStyle(xwb, hwb, fromCell.getCellStyle(), newstyle);
                styles.put(key, newstyle.getIndex());
            }
        }
        toCell.setCellStyle(newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        if (isCopyValue) {
            POIUtil.copyCellValue(fromCell, toCell);
        }
    }

    private static void copyCellValue(XSSFCell fromCell, HSSFCell toCell) {
        CellType cType = fromCell.getCellType();
        if (cType == CellType.FORMULA && toCell.getCellType() != CellType.FORMULA) {
            try {
                toCell.setCellFormula(fromCell.getCellFormula());
            }
            catch (Exception e) {
                try {
                    toCell.setCellValue(fromCell.getCellFormula());
                }
                catch (Exception e1) {
                    log.error(fromCell.getRowIndex() + "@" + fromCell.getColumnIndex() + ":dealWorkBook:" + e1);
                }
            }
        } else {
            toCell.setCellType(cType);
        }
        switch (cType) {
            case STRING: {
                toCell.setCellValue((RichTextString)new HSSFRichTextString(fromCell.getRichStringCellValue().getString()));
                break;
            }
            case NUMERIC: {
                toCell.setCellValue(fromCell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                break;
            }
            case BOOLEAN: {
                toCell.setCellValue(fromCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                toCell.setCellValue((double)fromCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                toCell.setBlank();
                break;
            }
            default: {
                toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
            }
        }
    }

    public static void copyCell(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell, Map<Object, Short> styles) {
        POIUtil.copyCell(wb, fromCell, toCell, styles, true);
    }

    public static void copyCell(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFCell fromCell, HSSFCell toCell, Map<Object, Short> styles) {
        POIUtil.copyCell(xwb, hwb, fromCell, toCell, styles, true);
    }

    public static void copyCellWithoutValue(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell, Map<Object, Short> styles) {
        XSSFCellStyle newstyle = wb.getCellStyleAt((int)styles.getOrDefault(fromCell.getCellStyle().getIndex(), (short)Short.MIN_VALUE).shortValue());
        if (newstyle == null) {
            newstyle = wb.createCellStyle();
            POIUtil.copyCellStyle(fromCell.getCellStyle(), newstyle);
            styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
        }
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
    }

    public static Pair<String, String> getCellDataFontAddr(String srcFormat) {
        if (srcFormat.startsWith("0") && srcFormat.endsWith(PROPROTION)) {
            return Pair.onePair((Object)"", (Object)PROPROTION);
        }
        if (srcFormat.startsWith("#") || srcFormat.startsWith("0")) {
            return Pair.onePair((Object)"", (Object)"_ ");
        }
        if (srcFormat.startsWith("\u00a5") || srcFormat.endsWith("$")) {
            return Pair.onePair((Object)"", (Object)"");
        }
        if (srcFormat.endsWith("E+00")) {
            return Pair.onePair((Object)"", (Object)"E+00");
        }
        return Pair.onePair((Object)"", (Object)"");
    }

    public static boolean isNeedUnitChange(Object formatter) {
        String result;
        return formatter != null && (StringUtils.isNumeric((String)(result = (String)formatter)) || result.startsWith("_(") && result.endsWith("* \"-\"??_);_(@_)") && result.contains("#,##0") || result.startsWith("\u00a5#,##0") || result.startsWith("$#,##0") || result.startsWith("#,##0") || result.equals("0_);(0)") || result.equals("0_);[Red](0)") || result.equals("0;[Red]0"));
    }

    public static int getDataFormatStringScale(String fmt) {
        try {
            String[] fs = fmt.split("\\.");
            if (fs.length <= 1) {
                return 0;
            }
            int scale = 0;
            for (char c : fs[1].toCharArray()) {
                if ('0' != c) continue;
                ++scale;
            }
            return scale;
        }
        catch (Exception e) {
            log.debug(e.toString());
            return 2;
        }
    }

    public static String dealforceValueFont(String fmt, String newscaleStr) {
        String cyFormat;
        Pair<String, String> addr = POIUtil.getCellDataFontAddr(fmt);
        String[] fs = fmt.split("\\.");
        String prex = fs.length > 0 ? fs[0] : fmt;
        String newformat = prex + newscaleStr + (String)addr.p2;
        if (fmt.startsWith("\u00a5") || fmt.endsWith("$")) {
            newformat = cyFormat = "\u00a5" + newformat.substring(1) + ";\u00a5-" + newformat.substring(1);
        }
        if (fmt.startsWith("General")) {
            newformat = cyFormat = "0" + newscaleStr;
        }
        return newformat;
    }

    public static void copyRow(XSSFWorkbook wb, XSSFRow oldRow, XSSFRow toRow, int maxCol, Map<Object, Short> styles) {
        if (oldRow == null) {
            log.warn("copy sourcerow is null");
            return;
        }
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            Object next = cellIt.next();
            if (next == null) continue;
            XSSFCell tmpCell = (XSSFCell)next;
            if (tmpCell.getColumnIndex() > maxCol) {
                return;
            }
            if (tmpCell.getCellStyle() != null) {
                if (tmpCell.getCellType() == CellType.BLANK && tmpCell.getCellStyle().getFont() == null) {
                    continue;
                }
            } else {
                log.info("dd");
            }
            XSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            POIUtil.copyCell(wb, tmpCell, newCell, styles);
        }
    }

    public static void copyRow(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFRow oldRow, HSSFRow toRow, int maxCol, Map<Object, Short> styles) {
        if (oldRow == null) {
            log.warn("copy sourcerow is null");
            return;
        }
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            Object next = cellIt.next();
            if (next == null) continue;
            XSSFCell tmpCell = (XSSFCell)next;
            if (tmpCell.getColumnIndex() > maxCol) {
                return;
            }
            if (tmpCell.getCellStyle() != null) {
                if (tmpCell.getCellType() == CellType.BLANK && tmpCell.getCellStyle().getFont() == null) {
                    continue;
                }
            } else {
                log.info("dd");
            }
            HSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            POIUtil.copyCell(xwb, hwb, tmpCell, newCell, styles);
        }
    }

    public static void copyRowByIndex(XSSFWorkbook wb, XSSFRow oldRow, XSSFRow toRow, int maxCol, Map<Object, Short> styles) {
        if (oldRow == null) {
            log.warn("copy sourcerow is null");
            return;
        }
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            XSSFCell tmpCell = (XSSFCell)cellIt.next();
            if (tmpCell.getColumnIndex() > maxCol) {
                return;
            }
            if (tmpCell.getCellType() == CellType.BLANK && tmpCell.getCellStyle().getFont() == null) continue;
            XSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            POIUtil.copyCellByIndex(wb, tmpCell, newCell, styles);
        }
    }

    public static void copyRowByIndex(XSSFWorkbook xwb, HSSFWorkbook hwb, XSSFRow oldRow, HSSFRow toRow, int maxCol, Map<Object, Short> styles) {
        if (oldRow == null) {
            log.warn("copy sourcerow is null");
            return;
        }
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            XSSFCell tmpCell = (XSSFCell)cellIt.next();
            if (tmpCell.getColumnIndex() > maxCol) {
                return;
            }
            if (tmpCell.getCellType() == CellType.BLANK && tmpCell.getCellStyle().getFont() == null) continue;
            HSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            POIUtil.copyCellByIndex(xwb, hwb, tmpCell, newCell, styles);
        }
    }

    public static void copySheet(XSSFWorkbook wb, XSSFSheet fromSheet, XSSFSheet toSheet, SheetInfo sheetInfo, Map<Object, Short> stylesByWB) {
        XSSFRow oldRow;
        Object next;
        POIUtil.mergeSheetAllRegion(fromSheet, toSheet);
        int firstRowNum = fromSheet.getFirstRowNum();
        if (firstRowNum >= 0) {
            for (int i = 0; i <= fromSheet.getRow(firstRowNum).getLastCellNum(); ++i) {
                toSheet.setColumnWidth(i, fromSheet.getColumnWidth(i));
            }
        }
        log.info("reportSize:" + sheetInfo.getMaxRow() + "*" + sheetInfo.getMaxCol());
        Map<Object, Short> styles = stylesByWB == null ? new HashMap<Object, Short>(16) : stylesByWB;
        if (fromSheet.getPaneInformation() != null) {
            toSheet.createFreezePane((int)fromSheet.getPaneInformation().getVerticalSplitLeftColumn(), (int)fromSheet.getPaneInformation().getHorizontalSplitTopRow());
        }
        Iterator rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            next = rowIt.next();
            if (next == null) continue;
            oldRow = (XSSFRow)next;
            toSheet.createRow(oldRow.getRowNum());
        }
        rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            next = rowIt.next();
            if (next == null) continue;
            oldRow = (XSSFRow)next;
            if (oldRow.getRowNum() > sheetInfo.getMaxRow()) {
                return;
            }
            XSSFRow newRow = toSheet.getRow(oldRow.getRowNum());
            if (newRow == null) continue;
            if (stylesByWB == null) {
                POIUtil.copyRowByIndex(wb, oldRow, newRow, sheetInfo.getMaxCol(), styles);
                continue;
            }
            try {
                POIUtil.copyRow(wb, oldRow, newRow, sheetInfo.getMaxCol(), styles);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return;
            }
        }
    }

    public static void copySheet(HSSFWorkbook hwb, XSSFWorkbook xwb, XSSFSheet fromSheet, HSSFSheet toSheet, SheetInfo sheetInfo, Map<Object, Short> stylesByWB) {
        XSSFRow oldRow;
        Object next;
        POIUtil.mergeSheetAllRegion(fromSheet, toSheet);
        int firstRowNum = fromSheet.getFirstRowNum();
        if (firstRowNum >= 0) {
            for (int i = 0; i <= fromSheet.getRow(firstRowNum).getLastCellNum(); ++i) {
                toSheet.setColumnWidth(i, fromSheet.getColumnWidth(i));
            }
        }
        log.info("reportSize:" + sheetInfo.getMaxRow() + "*" + sheetInfo.getMaxCol());
        Map<Object, Short> styles = stylesByWB == null ? new HashMap<Object, Short>(16) : stylesByWB;
        if (fromSheet.getPaneInformation() != null) {
            toSheet.createFreezePane((int)fromSheet.getPaneInformation().getVerticalSplitLeftColumn(), (int)fromSheet.getPaneInformation().getHorizontalSplitTopRow());
        }
        Iterator rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            next = rowIt.next();
            if (next == null) continue;
            oldRow = (XSSFRow)next;
            toSheet.createRow(oldRow.getRowNum());
        }
        rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            next = rowIt.next();
            if (next == null) continue;
            oldRow = (XSSFRow)next;
            if (oldRow.getRowNum() > sheetInfo.getMaxRow()) {
                return;
            }
            HSSFRow newRow = toSheet.getRow(oldRow.getRowNum());
            if (newRow == null) continue;
            if (stylesByWB == null) {
                POIUtil.copyRowByIndex(xwb, hwb, oldRow, newRow, sheetInfo.getMaxCol(), styles);
                continue;
            }
            try {
                POIUtil.copyRow(xwb, hwb, oldRow, newRow, sheetInfo.getMaxCol(), styles);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return;
            }
        }
    }
}

