/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtils {
    public static final String INPUT_REGEX = "^\\[[\\s\\S]+\\]$";
    public static final String NEW_INPUT_REGEX = "[A-Za-z0-9]+@[A-Za-z0-9\\\\._$]+";
    public static final String FORMAT_REGEX = "[\u4e00-\\u9fa5\\w\\-.]+![\u4e00-\\u9fa5\\w\\-.]+";
    public static final String SPLIT_FLAG = "!";
    public static final String NEW_SPLIT_FLAG = "@";
    public static final String SPLIT_FLAG_END = ";";
    public static final String NEW_SPLIT_FLAG_END = ",";
    private static final String[] _EMPTY_STR_ARRAY = new String[0];

    public static boolean isMatches(String input) {
        return RegexUtils.isMatches(INPUT_REGEX, input);
    }

    public static boolean isMatches(String regex, String input) {
        return Pattern.matches(regex, input);
    }

    public static String[] resolveInput(String input) {
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            if (input.indexOf(33) > -1 && RegexUtils.isMatches(input)) {
                return input.substring(1, input.length() - 1).split(SPLIT_FLAG_END);
            }
            if (!RegexUtils.regexMatch(input, NEW_INPUT_REGEX).isEmpty()) {
                return input.split(NEW_SPLIT_FLAG_END);
            }
        }
        return _EMPTY_STR_ARRAY;
    }

    public static List<String> regexMatch(String source, String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile(pattern).matcher(source);
        while (matcher.find()) {
            result.add(matcher.group().trim());
        }
        return result;
    }

    public static boolean isOnlyNumberAndString(String input) {
        return Pattern.matches("^[A-Za-z0-9]+$", input);
    }
}

