/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.formplugin.report.context.ReportListContext;

public class ReportListUtil {
    public static final String ITEM_STAGEOP = "stageop";

    public static TreeNode getTree(List<Map<String, String>> rootNodeList, String showType, boolean isAllOpen) {
        if (rootNodeList.isEmpty()) {
            return new TreeNode();
        }
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> map : rootNodeList) {
            String parentId = map.get("parentid");
            ArrayList<Map<String, String>> list = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (list == null) {
                list = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, list);
            }
            list.add(map);
        }
        Map rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (Map)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return new TreeNode();
        }
        TreeNode treeNode = ReportListUtil.createNode(rootNode, null, nodeMap, showType, isAllOpen);
        return treeNode;
    }

    private static TreeNode createNode(Map<String, String> map, TreeNode parentNode, Map<String, List<Map<String, String>>> nodeMap, String showType, boolean isOpen) {
        String id = map.get("id");
        String name = map.get("name");
        String currencyName = map.get("currencyName");
        String number = map.get("number");
        String parentId = map.get("parentid");
        String formatName = ReportListUtil.formatDisplayName(showType, name, number, currencyName);
        TreeNode curNode = new TreeNode();
        curNode.setId(id);
        curNode.setData((Object)map.get("number"));
        curNode.setText(formatName);
        List<Map<String, String>> list = nodeMap.get(id);
        curNode.setIsOpened(isOpen);
        if (parentNode != null) {
            curNode.setParentid(parentId);
            parentNode.addChild(curNode);
        }
        if (list != null) {
            for (Map<String, String> dnm : list) {
                ReportListUtil.createNode(dnm, curNode, nodeMap, showType, isOpen);
            }
            curNode.setText(curNode.getText() + "(" + curNode.getChildren().size() + ")");
        }
        return curNode;
    }

    private static String formatDisplayName(String showType, String name, String number, String currencyName) {
        String formatName = name;
        switch (showType = StringUtils.isEmpty((String)showType) ? "2" : showType) {
            case "2": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? name + " " + currencyName : name;
                break;
            }
            case "3": {
                formatName = number + " " + name;
                break;
            }
            case "4": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? number + " " + name + " " + currencyName : name;
            }
        }
        return formatName;
    }

    public static List<Map<String, String>> getTreeList(DynamicObjectCollection colls) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (colls.size() != 0) {
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject row = (DynamicObject)colls.get(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.getString("id"));
                map.put("name", row.getString("name"));
                map.put("number", row.getString("number"));
                map.put("currencyName", row.getString("currency.name"));
                Object parent = row.get("parent");
                if (parent == null) {
                    map.put("parentid", "0");
                } else if (parent instanceof DynamicObject) {
                    map.put("parentid", row.getString("parent.id"));
                } else {
                    map.put("parentid", row.getString("parent"));
                }
                map.put("isleaf", row.getString("isleaf"));
                map.put("orgcode", row.getString("orgcode"));
                list.add(map);
            }
        }
        return list;
    }

    public static DynamicObjectCollection getCollection(String entityName, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.query((String)ReportListUtil.class.getName(), (String)entityName, (String)"id,name,number,parent,isleaf", (QFilter[])filters, (String)orderBys);
    }

    public static DynamicObjectCollection getOrgCollectionForShare(String entityName, String otherSelectFields, QFilter[] filters, String orderBys) {
        String selectFields = "id,name,number,parent,isleaf,storagetype,member.id,share,level,dseq,copyfrom,longnumber";
        if (StringUtils.isNotEmpty((String)otherSelectFields)) {
            selectFields = selectFields + "," + otherSelectFields;
        }
        return QueryServiceHelper.query((String)ReportListUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public static TreeNode getTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObjectCollection templateColls, List<TreeNode> templateNodeList, String rootid, TreeNode root) {
        if (templateNodeList.size() != 0) {
            root.setChildren(templateNodeList);
        }
        if (templatecatalogList.size() == 0) {
            return new TreeNode();
        }
        Iterator<Map<String, String>> iter = templatecatalogList.iterator();
        String fieldId = "";
        String fieldName = "";
        String parentid = "";
        while (iter.hasNext()) {
            Map<String, String> map = iter.next();
            fieldId = map.get("id");
            fieldName = map.get("name");
            parentid = map.get("parentid");
            if (!parentid.equals(rootid)) continue;
            if (templateColls != null && templateColls.size() > 0) {
                templateNodeList = new ArrayList<TreeNode>();
                for (DynamicObject templateObject : templateColls) {
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    String versionnumber = templateObject.getDynamicObjectType().getProperty("versionnumber") == null ? "" : String.format("V%.1f", Float.valueOf(templateObject.getBigDecimal("versionnumber").floatValue()));
                    templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString() + "   " + versionnumber);
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = ReportListUtil.getTemplateTree(templatecatalogList, templateColls, templateNodeList, fieldId, entry);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            if (entry.getChildren() != null) {
                children.add(entry);
            }
            entry.setIsOpened(true);
        }
        return root;
    }

    public static TreeNode getTemplateTree(DynamicObjectCollection templatecatalogColls, DynamicObjectCollection templateColls, List<TreeNode> templateNodeList, String rootid, TreeNode root) {
        if (templateNodeList.size() != 0) {
            root.setChildren(templateNodeList);
        }
        if (templatecatalogColls.size() == 0) {
            return new TreeNode();
        }
        for (DynamicObject templatecatalog : templatecatalogColls) {
            String fieldId = templatecatalog.getString("id");
            String fieldName = (String)templatecatalog.get("name");
            String parentid = templatecatalog.getString("parent");
            if (!parentid.equals(rootid)) continue;
            if (templateColls != null && templateColls.size() > 0) {
                templateNodeList = new ArrayList<TreeNode>();
                for (DynamicObject templateObject : templateColls) {
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    templateNode.setText(templateObject.get("name").toString());
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)templatecatalog.getString("number"));
            entry = ReportListUtil.getTemplateTree(templatecatalogColls, templateColls, templateNodeList, fieldId, entry);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            children.add(entry);
            entry.setIsOpened(true);
        }
        return root;
    }

    @SDKMark
    public static QFilter fromJsonArrayToQFilter(JSONArray jsonArray) {
        QFilter filter = null;
        if (jsonArray == null) {
            return null;
        }
        for (Object o : jsonArray) {
            if (filter == null) {
                filter = new QFilter(((JSONObject)o).getString("property"), ((JSONObject)o).getString("cp"), ((JSONObject)o).get((Object)"value"));
                continue;
            }
            filter.and(new QFilter(((JSONObject)o).getString("property"), ((JSONObject)o).getString("cp"), ((JSONObject)o).get((Object)"value")));
        }
        return filter;
    }

    public static FormShowParameter getSelectStepFormParam(ReportListContext context, StageOpTypeEnum opEnum, boolean isForce) {
        Long modelId = context.modelId;
        Long sceneId = context.scenceId;
        Long yearId = context.yearId;
        Long periodId = context.periodId;
        boolean isShowStage = false;
        if (modelId != null && sceneId != null && yearId != null && periodId != null) {
            Pair dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L && !((List)dataLockPlanInfo.p2).isEmpty()) {
                isShowStage = true;
            }
        }
        FormShowParameter param = new FormShowParameter();
        param.setCaption(opEnum.getText());
        param.setFormId("bcm_selectflowstep");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("modelId", (Object)modelId);
        param.setCustomParam("sceneId", (Object)sceneId);
        param.setCustomParam("yearId", (Object)yearId);
        param.setCustomParam("periodId", (Object)periodId);
        param.setCustomParam("isShowStage", (Object)isShowStage);
        param.setCustomParam("stageaction", (Object)opEnum.getCode());
        StyleCss css = new StyleCss();
        css.setWidth("520");
        if (opEnum == StageOpTypeEnum.APPR) {
            css.setHeight(isShowStage ? "655" : "455");
        } else {
            css.setHeight(isShowStage ? "595" : "395");
        }
        if (isForce) {
            param.setCustomParam("forcecommit", (Object)true);
        }
        param.getOpenStyle().setInlineStyleCss(css);
        return param;
    }
}

