/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.function.Predicate;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;

public class SearchUtil {
    public static final String ResultList = "resultlist";
    public static final String Focus = "focus";

    public static List<TreeNode> seekChildrenIf(TreeNode root, Predicate<TreeNode> p) {
        Recorder r = new Recorder(new ArrayList());
        if (p.test(root)) {
            ((List)r.getRecord()).add(root);
        }
        if (root.getChildren() != null) {
            SearchUtil.cycleSeekNodes(root, p, (Recorder<List<TreeNode>>)r);
        }
        return (List)r.getRecord();
    }

    private static void cycleSeekNodes(TreeNode node, Predicate<TreeNode> p, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            if (p.test((TreeNode)t)) {
                ((List)r.getRecord()).add(t);
            }
            if (t.getChildren() != null) {
                SearchUtil.cycleSeekNodes(t, p, r);
            }
        });
    }

    public static List<TreeNode> getNodeList(TreeNode root) {
        Recorder r = new Recorder(new ArrayList());
        ((List)r.getRecord()).add(root);
        if (root.getChildren() != null) {
            SearchUtil.addChildren2List(root, (Recorder<List<TreeNode>>)r);
        }
        return (List)r.getRecord();
    }

    private static void addChildren2List(TreeNode node, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            ((List)r.getRecord()).add(node);
            if (t.getChildren() != null) {
                SearchUtil.addChildren2List(t, r);
            }
        });
    }

    public static Queue<TreeNode> getQueue(TreeNode root) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        LinkedList<TreeNode> result = new LinkedList<TreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            result.add(node);
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                queue.add(child);
            }
        }
        return result;
    }

    public static void expand(String parentid, TreeView treeView, TreeNode root) {
        block0: while (!parentid.equals(root.getId()) && !parentid.equals("")) {
            treeView.expand(parentid);
            List<TreeNode> nodes = SearchUtil.getNodeList(root);
            for (TreeNode node : nodes) {
                if (!node.getId().equals(parentid)) continue;
                parentid = node.getParentid();
                continue block0;
            }
        }
        treeView.expand(root.getId());
    }

    private static void selectNode(List<TreeNode> nodes, TreeView tree, TreeNode root) {
        TreeNode fnode = nodes.get(0);
        tree.treeNodeClick(fnode.getParentid(), fnode.getId());
        tree.checkNode(fnode);
        SearchUtil.expand(fnode.getParentid(), tree, root);
        tree.focusNode(fnode);
    }

    public static TreeNode searchMember(String text, boolean setcolor, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName) {
        return SearchUtil.searchMember(text, view, pageCache, treeView, treeCacheName);
    }

    public static TreeNode searchMember(String text, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName) {
        String tree = pageCache.get(treeCacheName);
        if (tree == null) {
            view.showTipNotification(MessageConstant.getNO_DATA());
            return null;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)tree, TreeNode.class);
        List<TreeNode> nodes = SearchUtil.seekChildrenIf(root, p -> p.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        if (!nodes.isEmpty()) {
            SearchUtil.selectNode(nodes, treeView, root);
            pageCache.put(ResultList, SerializationUtils.serializeToBase64(nodes));
            pageCache.put(Focus, "0");
            return nodes.get(0);
        }
        view.showTipNotification(MessageConstant.getNO_DATA());
        return null;
    }

    public static void searchMember(String text, boolean setcolor, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName, String resultList, String focus) {
        SearchUtil.searchMember(text, view, pageCache, treeView, treeCacheName, resultList, focus);
    }

    public static void searchMember(String text, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName, String resultList, String focus) {
        String treeCache = pageCache.getBigObject(treeCacheName);
        if (treeCache == null) {
            view.showTipNotification(MessageConstant.getNO_DATA());
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List<TreeNode> nodes = SearchUtil.seekChildrenIf(root, p -> p.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        if (!nodes.isEmpty()) {
            SearchUtil.selectNode(nodes, treeView, root);
            pageCache.put(resultList, SerializationUtils.serializeToBase64(nodes));
            pageCache.put(focus, "0");
        } else {
            view.showTipNotification(MessageConstant.getNO_DATA());
        }
    }

    public static Pair<String, String> getLeftOrRight(IPageCache pageCache, IFormView view, String key, TreeView treeView, String[] btns, String treeCacheName) {
        TreeNode beforeFocusNode;
        String rowcache = pageCache.get(ResultList);
        if (rowcache == null) {
            view.showTipNotification(MessageConstant.getNO_DATA());
            return null;
        }
        List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
        int rowCount = Integer.parseInt(pageCache.get(Focus));
        if (btns[0].equals(key)) {
            if (0 == rowCount) {
                view.showTipNotification(MessageConstant.getSELECT_FIRST());
                return null;
            }
            beforeFocusNode = (TreeNode)rowList.get(rowCount);
            --rowCount;
        } else {
            if (rowList.size() - 1 == rowCount) {
                view.showTipNotification(MessageConstant.getSELECT_LAST());
                return null;
            }
            beforeFocusNode = (TreeNode)rowList.get(rowCount);
            ++rowCount;
        }
        pageCache.put(Focus, String.valueOf(rowCount));
        TreeNode focusNode = (TreeNode)rowList.get(rowCount);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(treeCacheName), TreeNode.class);
        treeView.checkNode(focusNode);
        treeView.focusNode(focusNode);
        treeView.uncheckNode(beforeFocusNode.getId());
        treeView.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        SearchUtil.expand(focusNode.getParentid(), treeView, root);
        return new Pair((Object)beforeFocusNode.getId(), (Object)focusNode.getId());
    }

    public static List<TreeNode> getList(String text, TreeNode root) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        Queue<TreeNode> queue = SearchUtil.getQueue(root);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            if (!node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

