/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.model.BCMOperationResult;

public class ShowOperationMsgUtil {
    public static void showOperationMsg(List<Long> successIds, List<String> TabName, String showmsg, IFormView fromview) {
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(successIds.size() + TabName.size());
        if (!TabName.isEmpty()) {
            for (String ss : TabName) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(ss + showmsg);
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
            }
        }
        for (Long l : successIds) {
            operationResult.addSuccessPkId((Object)l);
        }
        ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", fromview, "");
    }

    public static void showOperationMsg(List<Long> successIds, List<String> TabName, List<String> makingTabName, IFormView fromview, String taskmessage, Map<String, Integer> taskSum) {
        OperateErrorInfo operateErrorInfo;
        OperationResult operationResult = new OperationResult();
        if (successIds != null) {
            operationResult.setBillCount(successIds.size());
            for (Long l : successIds) {
                operationResult.addSuccessPkId((Object)l);
            }
        }
        if (StringUtils.isNotEmpty((String)taskmessage)) {
            OperateErrorInfo operateErrorInfo2 = new OperateErrorInfo();
            operateErrorInfo2.setMessage(taskmessage);
            operateErrorInfo2.setErrorLevel(ErrorLevel.Error.name());
            operationResult.addErrorInfo(operateErrorInfo2);
        }
        if (TabName != null && !TabName.isEmpty()) {
            for (String ss : TabName) {
                operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u62a5\u8868\u672a\u7f16\u5236\uff0c\u5df2\u81ea\u52a8\u751f\u6210\u62a5\u8868\u5e76\u6267\u884c\u5bf9\u5e94\u64cd\u4f5c\u3002", (String)"ShowOperationMsgUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ss));
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
            }
        }
        if (makingTabName != null && !makingTabName.isEmpty()) {
            for (String ss : makingTabName) {
                operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u62a5\u8868\u7f16\u5236\u4e2d\uff0c\u5df2\u81ea\u52a8\u4fee\u6539\u62a5\u8868\u72b6\u6001\u5e76\u6267\u884c\u5bf9\u5e94\u64cd\u4f5c\u3002", (String)"ShowOperationMsgUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ss));
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
            }
        }
        ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", fromview, String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20,\u5931\u8d25%3$s\u5f20\u3002", (String)"ShowOperationMsgUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), taskSum.get("successtask") + taskSum.get("failtask"), taskSum.get("successtask"), taskSum.get("failtask")));
    }

    public static void showOperationMsg(OperationResult operationResult, List<Long> successIds, List<String> TabName, List<String> checkFailTabName, String errmsg, String showmsg, IFormView fromview) {
        OperateErrorInfo operateErrorInfo;
        operationResult.setBillCount(successIds.size() + TabName.size() + checkFailTabName.size());
        int error = 0;
        if (!TabName.isEmpty()) {
            for (String ss : TabName) {
                operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(ss + showmsg);
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
                ++error;
            }
        }
        if (!checkFailTabName.isEmpty()) {
            for (String ss : checkFailTabName) {
                operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(ss + errmsg);
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
                ++error;
            }
        }
        for (Long l : successIds) {
            operationResult.addSuccessPkId((Object)l);
        }
        ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", fromview, "", error, 5);
    }

    public static void showOperationResultMulti(List<String> infoList, String operateName, IFormView thisView, String message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCaption(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b8c\u6210", (String)"ShowOperationMsgUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operateName));
        parameters.setFormId("bcm_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c", (String)"ShowOperationMsgUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        HashMap pkNumbers = new HashMap(16);
        parameters.setCustomParam("pkNumbers", pkNumbers);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        parameters.setCustomParam("title", (Object)message);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int infoSize = infoList == null ? 0 : infoList.size();
        for (int i = 0; i < infoSize; ++i) {
            buf.append(infoList.get(i)).append("<br/>");
        }
        buf.append("</div>");
        parameters.setCustomParam("errorMsg", (Object)buf.toString().trim());
        thisView.showForm(parameters);
    }

    public static void showOperationResultMulti(OperationResult operationResult, IFormView thisView) {
        ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", thisView, null);
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView thisView, String message) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCaption(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ShowOperationMsgUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameters.setFormId("bcm_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)(StringUtils.isNotEmpty((String)operateName) ? operateName : ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c", (String)"ShowOperationMsgUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        HashMap<Object, Object> pkNumbers = ShowOperationMsgUtil.getPkNumbers(operationResult);
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = (IPageCache)thisView.getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty((String)message)) {
            buf.append(message);
        } else {
            int errorSize = operationResult.getBillCount() - operationResult.getSuccessPkIds().size();
            errorSize = errorSize < 0 ? 0 : errorSize;
            buf = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ShowOperationMsgUtil_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), operationResult.getBillCount() - errorSize, errorSize));
        }
        parameters.setCustomParam("title", (Object)buf.toString());
        buf.setLength(0);
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        thisView.showForm(parameters);
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView thisView, String message, int error, int hasMore) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCaption(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ShowOperationMsgUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameters.setFormId("bcm_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)(StringUtils.isNotEmpty((String)operateName) ? operateName : ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c", (String)"ShowOperationMsgUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        HashMap<Object, Object> pkNumbers = ShowOperationMsgUtil.getPkNumbers(operationResult);
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = (IPageCache)thisView.getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty((String)message)) {
            buf.append(message);
        } else {
            int errorSize = operationResult.getSuccessPkIds().size() == operationResult.getBillCount() ? 0 : error;
            buf = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ShowOperationMsgUtil_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), operationResult.getBillCount() - errorSize, errorSize));
        }
        parameters.setCustomParam("title", (Object)buf.toString());
        if (hasMore == 0) {
            parameters.setCustomParam("formTitle", (Object)ResManager.loadKDString((String)"\u72b6\u6001\u91cd\u7f6e\u5904\u7406\u7ed3\u679c", (String)"ShowOperationMsgUtil_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        buf.setLength(0);
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < hasMore && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > hasMore ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        thisView.showForm(parameters);
    }

    private static HashMap<Object, Object> getPkNumbers(OperationResult operationResult) {
        if (operationResult == null) {
            return null;
        }
        HashMap<Object, Object> pkNumbers = new HashMap<Object, Object>();
        if (!operationResult.getSuccessPkIds().isEmpty()) {
            for (Object pkId : operationResult.getSuccessPkIds()) {
                Map successMsgMap;
                String str = String.valueOf(pkId);
                if (operationResult instanceof BCMOperationResult && (successMsgMap = ((BCMOperationResult)operationResult).getSuccessMsgMap()) != null && StringUtils.isNotEmpty((String)((String)successMsgMap.get(str)))) {
                    str = (String)successMsgMap.get(str);
                }
                pkNumbers.put(pkId, str);
            }
        }
        return pkNumbers;
    }
}

