/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.report.BasedataEditSingleMemberF74NoLeaf;
import kd.fi.bcm.formplugin.adjust.report.BasedataEditSingleMemberF74Root;
import kd.fi.bcm.formplugin.adjust.report.BasedataEditSingleMemberF7Custom;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.database.LTreeRListEdit;
import kd.fi.bcm.formplugin.exchangeRate.BasedataEditSingleMemberF7Ext;
import kd.fi.bcm.formplugin.invest.sheet.BaseDataEditSingleMemberF7ExtDim;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class SingleMemberF7Util {
    public static final String NOT_PERM_FILTER = "isNotPermFilterF7";

    public static void cacheSingleMemberF7ByModelId(IFormView view, IDataModel dataModel, long modelId, long dimId, List<String> f7Keys, ISingleMemberF7Handle handle) {
        Field field = SingleMemberF7Util.getClassField(view.getClass(), "cacheControls");
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            try {
                Map ctrls = (Map)field.get(view);
                BeforeF7SelectListener beforeF7SelectListener = handle::beforeSingleMemberF7Select;
                for (String f7Key : f7Keys) {
                    ctrls.put(f7Key, SingleMemberF7Util.createBasedataEditSingleMemberF7(view, dataModel, modelId, dimId, f7Key, beforeF7SelectListener, false));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void cacheSingleMemberF7ByModelId(IFormView view, IDataModel dataModel, long modelId, List<Long> dimIds, List<String> f7Keys, ISingleMemberF7Handle handle) {
        Field field = SingleMemberF7Util.getClassField(view.getClass(), "cacheControls");
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            try {
                Map ctrls = (Map)field.get(view);
                BeforeF7SelectListener beforeF7SelectListener = handle::beforeSingleMemberF7Select;
                for (int i = 0; i < dimIds.size(); ++i) {
                    String key = f7Keys.get(i);
                    BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(view, dataModel, modelId, dimIds.get(i), key, beforeF7SelectListener, false);
                    if (DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(key)) {
                        f7.addBasedataFuzzySearchListener(event -> {
                            QFilter[] qFilters = new QFilter("model", "=", (Object)modelId).and("isenable", "=", (Object)"1").toArray();
                            Set cslchemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"number", (QFilter[])qFilters).stream().map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
                            List queryData = event.getQueryData();
                            if (!CollectionUtil.isEmpty((Collection)queryData)) {
                                queryData.removeIf(data -> !cslchemes.contains(MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong(((List)data).get(0))).getProperty("cslscheme")));
                            }
                        });
                    }
                    ctrls.put(key, f7);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] fields;
        Field field = null;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            field = f;
            break;
        }
        if (field == null && clazz != Object.class) {
            field = SingleMemberF7Util.getClassField(clazz.getSuperclass(), fieldName);
        }
        return field;
    }

    public static BasedataEditSingleMemberF7 getBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, String dimNumber, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type) {
        IDataEntityType parentProperty;
        BasedataEditSingleMemberF7 bdEdit = DimTypesEnum.INTERCOMPANY.getNumber().equalsIgnoreCase(dimNumber) || !DimTypesEnum.include((String)dimNumber) && BCMTreeUtils.getMaxCount((long)0L) > 0 ? new LTreeRListEdit() : SingleMemberF7Util.getBdEdit(type);
        bdEdit.setKey(f7Key);
        bdEdit.setFieldKey(f7Key);
        bdEdit.setF7Name(f7Key);
        bdEdit.setView(view);
        bdEdit.setModel(iDataModel);
        bdEdit.setOnlyReturnId(isOnlyReturnId);
        bdEdit.setDisplayProp("name");
        bdEdit.setDimNumber(dimNumber);
        bdEdit.setType(type);
        if (bdEdit.getProperty() != null && (parentProperty = bdEdit.getProperty().getParent()) instanceof EntryType) {
            bdEdit.setEntryKey(parentProperty.getName());
        }
        if (modelId != null) {
            bdEdit.setModelId(modelId);
        }
        if (beforeF7SelectListener != null) {
            bdEdit.addBeforeF7SelectListener(beforeF7SelectListener);
        }
        return bdEdit;
    }

    public static QFilter getPermissionFilter(String entityName, long dimensionId, long modelId) {
        return PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(Long.valueOf(dimensionId), entityName, "id");
    }

    public static Boolean cacheModelPrem(IPageCache iPageCache, Long modelId, ApplicationTypeEnum application) {
        Boolean isModelPerm = Boolean.FALSE;
        if (MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application).contains(modelId)) {
            isModelPerm = Boolean.TRUE;
        }
        iPageCache.put("modelPrem", String.valueOf(isModelPerm));
        return isModelPerm;
    }

    @Deprecated
    public static Map<Long, Integer> getAndCacheDimPrem(IPageCache iPageCache, String f7Key, String entityName, long dimensionId, Object modelId) {
        Map permissionMap = MemberPermHelper.getMemberPermission((String)entityName, (long)dimensionId, (Object)modelId);
        iPageCache.put(f7Key + "Prem", ObjectSerialUtil.toByteSerialized((Object)permissionMap));
        return permissionMap;
    }

    public static PermPackageList getAndCacheDimPremNew(IPageCache iPageCache, String f7Key, long dimensionId, Object modelId) {
        PermissionService permService = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
        PermPackageList permPackageList = permService.getDimPermSet(Long.valueOf(dimensionId));
        iPageCache.put(f7Key + "PremNew", ObjectSerialUtil.toByteSerialized((Object)permPackageList));
        return permPackageList;
    }

    public static void cacheDimPrem(IPageCache iPageCache, Object modelId, List<String> numbers) {
        DynamicObject[] dims;
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter numberFilter = new QFilter("number", "in", UserSelectUtil.getStandardDimKeys(numbers));
        for (DynamicObject dim : dims = (DynamicObject[])QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,dseq,memberform", (QFilter[])new QFilter[]{modelFilter, numberFilter}).toArray((Object[])new DynamicObject[0])) {
            SingleMemberF7Util.getAndCacheDimPremNew(iPageCache, dim.getString("number").toLowerCase(Locale.ENGLISH), dim.getLong("id"), modelId);
        }
    }

    public static Boolean isSureReturn(IPageCache iPageCache, String f7Key, DynamicObject newValue, Boolean isOnlyLeaf) {
        if ("true".equals(iPageCache.get("modelPrem")) || newValue == null || SystemVarsEnum.isDimVars((String)newValue.getString("id"))) {
            return true;
        }
        if (newValue.getDynamicObjectType().getProperties().get((Object)"model") == null) {
            newValue = BusinessDataServiceHelper.loadSingleFromCache((Object)newValue.getPkValue(), (String)newValue.getDynamicObjectType().getName());
        }
        Long modelId = newValue.getDynamicObject("model").getLong("id");
        String prem = iPageCache.get(f7Key + "PremNew");
        PermPackageList permPackageList = null;
        if (StringUtils.isEmpty((CharSequence)prem)) {
            Long dimensionId = newValue.getLong("dimension.id");
            if (dimensionId == null || dimensionId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"F7\u672a\u8fd4\u56de\u7ef4\u5ea6id\u3002", (String)"SingleMemberF7Util_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            permPackageList = SingleMemberF7Util.getAndCacheDimPremNew(iPageCache, f7Key, dimensionId, modelId);
        } else {
            permPackageList = (PermPackageList)ObjectSerialUtil.deSerializedBytes((String)prem);
        }
        PermEnum permission = permPackageList.getPermEnum(newValue.getLong("id"));
        if (permission == null) {
            return false;
        }
        if (PermEnum.NOPERM != permission && (!isOnlyLeaf.booleanValue() || newValue.getBoolean("isleaf"))) {
            return true;
        }
        return false;
    }

    public static BasedataEditSingleMemberF7 createBaseDataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type, boolean isExtDimension) {
        DynamicObject dimObj = MemberReader.getDimensionDynById((long)dimId);
        if (dimObj == null) {
            throw new KDBizException("not found dimension:{dimId:" + dimId + ";modelId:" + modelId + ";f7Key:" + f7Key + "}");
        }
        String memberModel = isExtDimension ? "bcm_structofextend" : dimObj.getString("membermodel");
        String dimNumber = dimObj.getString("number");
        BasedataEditSingleMemberF7 bdEdit = DimTypesEnum.INTERCOMPANY.getNumber().equalsIgnoreCase(dimNumber) || "bcm_userdefinedmembertree".equals(memberModel) && BCMTreeUtils.getMaxCount((long)0L) > 0 ? new LTreeRListEdit() : SingleMemberF7Util.getBdEdit(type);
        if (StringUtils.isEmpty((CharSequence)bdEdit.getF7title())) {
            bdEdit.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"BCMBaseFunction_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        bdEdit.setKey(f7Key);
        bdEdit.setFieldKey(f7Key);
        bdEdit.setModelId(modelId);
        bdEdit.setDimId(dimId);
        bdEdit.setF7Name(f7Key);
        bdEdit.setF7Value(dimObj.getInt("dseq"));
        bdEdit.setEntity(memberModel);
        bdEdit.setView(view);
        bdEdit.setOnlyReturnId(isOnlyReturnId);
        bdEdit.setModel(iDataModel);
        bdEdit.setDisplayProp("name");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if ("bcm_entitymembertree".equals(memberModel)) {
            filter.and(new QFilter("isexchangerate", "=", (Object)"0"));
        }
        switch (type) {
            case LEAF: {
                filter.and(new QFilter("isleaf", "=", (Object)true));
                break;
            }
            case NOLEAF: {
                filter.and(new QFilter("isleaf", "=", (Object)false));
                break;
            }
        }
        QFilter permissonFilter = view.getFormShowParameter().getCustomParam(NOT_PERM_FILTER) == null ? SingleMemberF7Util.getPermissionFilter(memberModel, dimId, modelId) : null;
        filter.and(permissonFilter);
        bdEdit.setQFilter(filter);
        if (beforeF7SelectListener != null) {
            bdEdit.addBeforeF7SelectListener(beforeF7SelectListener);
        }
        return bdEdit;
    }

    public static BasedataEditSingleMemberF7 createBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type) {
        return SingleMemberF7Util.createBaseDataEditSingleMemberF7(view, iDataModel, modelId, dimId, f7Key, beforeF7SelectListener, isOnlyReturnId, type, false);
    }

    public static BasedataEditSingleMemberF7 createBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type, Map<String, Object> customParam) {
        BasedataEditSingleMemberF7 baseDataEditSingleMemberF7 = SingleMemberF7Util.createBaseDataEditSingleMemberF7(view, iDataModel, modelId, dimId, f7Key, beforeF7SelectListener, isOnlyReturnId, type, false);
        baseDataEditSingleMemberF7.setCustomData(customParam);
        return baseDataEditSingleMemberF7;
    }

    public static BasedataEditSingleMemberF7 createBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId) {
        return SingleMemberF7Util.createBasedataEditSingleMemberF7(view, iDataModel, modelId, dimId, f7Key, beforeF7SelectListener, isOnlyReturnId, SingleF7TypeEnum.COMMON);
    }

    public static BasedataEditSingleMemberF7 getBdEdit(SingleF7TypeEnum type) {
        switch (type) {
            case LEAF: {
                return new BasedataEditSingleMemberF7Ext();
            }
            case NOLEAF: {
                return new BasedataEditSingleMemberF74NoLeaf();
            }
            case ROOT: {
                return new BasedataEditSingleMemberF74Root();
            }
            case CUSTOM: {
                return new BasedataEditSingleMemberF7Custom();
            }
            case EXT_DIM: {
                return new BaseDataEditSingleMemberF7ExtDim();
            }
            case DM: {
                throw new KDBizException("FIDM F7 Haved Remove!");
            }
        }
        return new BasedataEditSingleMemberF7();
    }

    public static interface ISingleMemberF7Handle {
        public void beforeSingleMemberF7Select(BeforeF7SelectEvent var1);
    }
}

