/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.util.NewMyTemplateUtil;

public class TemplateDeleteUtil {
    private static final String TEMPLATE = "template";
    private static final String MODEL = "model";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    public static void deleteTemplates(Long modelId, List<Object> templateIds, List<String> successNums, OperationResult operationResult) {
        try (TXHandle tx = TX.required();){
            try {
                QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
                QFilter filter2 = new QFilter("id", "in", (Object)templateIds.toArray());
                QFilter[] filters = new QFilter[]{filter1, filter2};
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,group", (QFilter[])filters);
                TemplateDeleteUtil.deleteDataCollectOrder(modelId, templateIds);
                TemplateDeleteUtil.deleteBizRuleByTemplate(templateIds);
                NewMyTemplateUtil.clearAllMytemplateRecords((long)modelId, templateIds);
                TemplateDeleteUtil.deleteDistributionAboutTemplate(modelId, templateIds);
                TemplateDeleteUtil.deleteUserDefCvtFormulaByTemplate(modelId, templateIds);
                TemplateDeleteUtil.deleteChkReportByTemplate(modelId, templateIds, dynamicObjectCollection);
                TemplateDeleteUtil.deletePageSelectByTemplate(templateIds);
                TemplateDeleteUtil.deleteExtendModelRef(modelId, templateIds);
                TemplateDeleteUtil.deleteTemplateDisCt(modelId, templateIds);
                TemplateDeleteUtil.deleteTemplate(templateIds);
                TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])templateIds.toArray());
                TemplateDeleteUtil.deleteAdjustLinkTemplateData(modelId, templateIds);
                TemplateDeleteUtil.deleteTemplateRptDataSet("bcm_reportdata_custseting", new QFilter[]{new QFilter("template.id", "in", templateIds)});
                TemplateDeleteUtil.deleteTemplateBeginPeriods("bcm_beginperioddims", new QFilter[]{new QFilter("template.id", "in", templateIds)});
                DeleteServiceHelper.delete((String)"bcm_temp_startperiod", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId).and(TEMPLATE, "in", templateIds)});
                TemplateDeleteUtil.deleteAttachFiles(modelId, templateIds);
                AutoFloatUtil.clearTemplateAlternateFloatCache(modelId, templateIds.toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25:%s\u3002", (String)"TemplateListPlugin_58", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[]{e.getMessage()}));
                operationResult.addErrorInfo(operateErrorInfo);
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
    }

    private static void deleteAttachFiles(Long modelId, List<Object> templateIds) {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.add(TEMPLATE, "in", templateIds);
        qfBuilder.add("attachmenttype", "=", (Object)"2");
        List ids = QueryServiceHelper.query((String)"bcm_chknoteinfo", (String)"id", (QFilter[])qfBuilder.toArray()).stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((String)"bcm_chknoteinfo", (QFilter[])new QFilter("id", "in", ids).toArray());
            DeleteServiceHelper.delete((String)"bcm_chkattachment", (QFilter[])new QFilter("noteinfo", "in", ids).toArray());
        }
    }

    private static void deleteAdjustLinkTemplateData(Long modelId, List<Object> templateIds) {
        String sql = String.format("update t_bcm_linkageentry set ftemplateid = 0 where ftemplateid in (%s)", String.join((CharSequence)",", (CharSequence[])templateIds.stream().map(Object::toString).distinct().toArray(String[]::new)));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
        SaveServiceHelper.clearDataEntityCache((String)"bcm_linkagemapping");
    }

    private static void deleteTemplateRptDataSet(String formReportdata, QFilter[] in) {
        DeleteServiceHelper.delete((String)formReportdata, (QFilter[])in);
    }

    private static void deleteTemplateBeginPeriods(String formReportdata, QFilter[] in) {
        DeleteServiceHelper.delete((String)formReportdata, (QFilter[])in);
    }

    private static void deleteTemplateDisCt(Long modelId, List<Object> templateIds) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and(TEMPLATE, "in", templateIds);
        DeleteServiceHelper.delete((String)"bcm_tempdiscycletable", (QFilter[])qFilter.toArray());
    }

    private static void deleteExtendModelRef(Long modelId, List<Object> templateIds) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and(TEMPLATE, "in", templateIds);
        DeleteServiceHelper.delete((String)"bcm_extmodelref", (QFilter[])qFilter.toArray());
    }

    private static void deleteChkReportSettingByTemplate(Long modelId, List<Object> templateIds, DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<Long> idList = new ArrayList<Long>(12);
        ArrayList<String> numberList = new ArrayList<String>(12);
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
        for (DynamicObject object : dynamicObjectCollection) {
            String number = object.getString("number");
            QFilter filter2 = new QFilter("rformulatemp", "like", (Object)("%\"@TMP." + number + "\"%")).or(new QFilter("lformulatemp", "like", (Object)("%\"@TMP." + number + "\"%")));
            QFilter[] filters = new QFilter[]{filter1, filter2};
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,number", (QFilter[])filters);
            for (DynamicObject id : ids) {
                idList.add(id.getLong("id"));
            }
            numberList.add(number);
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_chkformulasetting"), (Object[])idList.toArray());
        QFilter filter2 = new QFilter("chkformula", "in", (Object)idList.toArray());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])filters);
        QFilter filter3 = new QFilter("number", "in", (Object)numberList.toArray());
        QFilter filter4 = new QFilter("versionnumber", "=", (Object)1.0);
        QFilter[] filter = new QFilter[]{filter1, filter3, filter4};
        DynamicObjectCollection templateIdList = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])filter);
        templateIdList.forEach(dy -> templateIds.add(dy.getLong("id")));
        SQLBuilder4RDB sql = new SQLBuilder4RDB();
        sql.append("DELETE FROM t_bcm_chkformulaentry where fbasedataid in (").append(Joiner.on((String)",").join(templateIds)).append(")");
        DBRoute BCM_DB_Router = DBRoute.of((String)"bcm");
        DB.execute((DBRoute)BCM_DB_Router, (String)sql.toString());
    }

    private static void deletePageSelectByTemplate(List<Object> templateIds) {
        QFilter filter = new QFilter(TEMPLATE, "in", (Object)ConvertUtil.convertObjsToLongs(templateIds));
        BusinessDataWriter.delete((String)"bcm_pageselect", (QFilter[])new QFilter[]{filter});
    }

    private static void deleteChkReportByTemplate(Long modelId, List<Object> templateIds, DynamicObjectCollection dynamicObjectCollection) {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
        HashSet<Long> groupList = new HashSet<Long>(12);
        for (DynamicObject object : dynamicObjectCollection) {
            groupList.add(object.getLong("group"));
        }
        QFilter filter2 = new QFilter("group", "in", (Object)groupList.toArray());
        DynamicObjectCollection templateCollection = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,versionnumber,group,number,effectivedate,expiringdate", (QFilter[])new QFilter[]{filter1, filter2});
        for (DynamicObject template : templateCollection) {
            if (templateIds.contains(template.get("id"))) continue;
            groupList.remove(template.getLong("group"));
        }
        QFilter filter3 = new QFilter("multitemplate.fbasedataid.group", "in", (Object)groupList.toArray());
        QFilter[] filter = new QFilter[]{filter1, filter3};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate,multitemplate.fbasedataid,multitemplate.pkid", (QFilter[])filter);
        HashSet ids = new HashSet(doc.size());
        HashSet pkIds = new HashSet(doc.size());
        HashSet needDeleteChkFormulaSettingId = new HashSet(doc.size());
        HashMap chkFormulaSettingMap = new HashMap(doc.size());
        doc.forEach(dy -> {
            Long id = dy.getLong("id");
            ids.add(id);
            pkIds.add(dy.getLong("multitemplate.pkid"));
            List<Long> idList = new ArrayList<Long>(12);
            if (chkFormulaSettingMap.containsKey(id)) {
                idList = (List)chkFormulaSettingMap.get(id);
                idList.add(dy.getLong("multitemplate.fbasedataid"));
                chkFormulaSettingMap.put(dy.getLong("id"), idList);
            } else {
                idList.add(dy.getLong("multitemplate.fbasedataid"));
                chkFormulaSettingMap.put(dy.getLong("id"), idList);
            }
        });
        if (!ids.isEmpty()) {
            QFilter filter4 = new QFilter("id", "in", (Object)ids.toArray());
            QFilter[] filters = new QFilter[]{filter1, filter4};
            DynamicObject[] docC = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate.fbasedataid,multitemplate.pkid", (QFilter[])filters);
            needDeleteChkFormulaSettingId.addAll(ids);
            docC.forEach(dy -> {
                Long id = dy.getLong("id");
                Long baseDataId = dy.getLong("multitemplate.fbasedataid");
                List baseDataIdList = (List)chkFormulaSettingMap.get(id);
                if (!baseDataIdList.contains(baseDataId)) {
                    needDeleteChkFormulaSettingId.remove(id);
                }
            });
        }
        if (!pkIds.isEmpty()) {
            SQLBuilder4RDB sql = new SQLBuilder4RDB();
            sql.append("DELETE FROM t_bcm_chkformulaentry where fpkid in (").append(Joiner.on((String)",").join(pkIds)).append(")");
            DBRoute BCM_DB_Router = DBRoute.of((String)"bcm");
            DB.execute((DBRoute)BCM_DB_Router, (String)sql.toString());
        }
        if (!needDeleteChkFormulaSettingId.isEmpty()) {
            DynamicObject[] dos;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("id", "in", needDeleteChkFormulaSettingId);
            for (DynamicObject dy2 : dos = BusinessDataServiceHelper.load((String)"bcm_chkformulasetting", (String)"status,modifier", (QFilter[])qfBuilder.toArray())) {
                dy2.set("status", (Object)CHKFormulaStatusEnum.disable.getIndex());
                dy2.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            }
            SaveServiceHelper.save((DynamicObject[])dos);
            QFilter filter5 = new QFilter("chkformula", "in", (Object)needDeleteChkFormulaSettingId.toArray());
            QFilter[] qf = new QFilter[]{filter1, filter5};
            DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])qf);
        }
    }

    private static void deleteDataCollectOrder(Long modelId, List<Object> templateIds) {
        QFilter filter = new QFilter(TEMPLATE, "in", (Object)ConvertUtil.convertObjsToLongs(templateIds));
        filter.and(new QFilter(MODEL, "=", (Object)modelId));
        BusinessDataWriter.delete((String)"bcm_datacollectorder", (QFilter[])new QFilter[]{filter});
    }

    private static void deleteBizRuleByTemplate(List<Object> templateIds) {
        QFilter filter = new QFilter(TEMPLATE, "in", (Object)ConvertUtil.convertObjsToLongs(templateIds));
        BusinessDataWriter.delete((String)"bcm_brallocateentity", (QFilter[])new QFilter[]{filter});
    }

    private static void deleteTemplate(List<Object> templateIds) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"), (Object[])templateIds.toArray());
    }

    private static void deleteDistributionAboutTemplate(Long modelId, List<Object> templateIds) {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
        QFilter filter2 = new QFilter(TEMPLATE, "in", (Object)templateIds.toArray());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        ArrayList<String> recordIds = new ArrayList<String>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_distributionentity", (String)"id", (QFilter[])filters);
        if (collection != null && !collection.isEmpty()) {
            for (DynamicObject obj : collection) {
                recordIds.add(obj.get("id").toString());
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_distributionentity"), (Object[])recordIds.toArray());
    }

    private static void deleteUserDefCvtFormulaByTemplate(Long modelId, List<Object> templateIds) {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
        QFilter filter2 = new QFilter(TEMPLATE, "in", (Object)templateIds.toArray());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DeleteServiceHelper.delete((String)"bcm_userdefcvtformula", (QFilter[])filters);
    }
}

