/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.template.DefaultDimAreaEnum;
import kd.fi.bcm.common.enums.template.DefaultDimSettingEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import org.apache.commons.collections.CollectionUtils;

public class TemplateDimSettingUtil {
    private static String ALL = "allPoint";
    private static final String FILTER_DIMENSION_SIGN = "fd";
    private static String VIEWPANEL_SIGN = "viewpanel";
    private static String PAGEPANEL_SIGN = "pagepanel";
    private static String ISEDIT = "edit";
    private static String RANKPANEL_SIGN = "rankpanel";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, TemplateDimSettingUtil.class);

    public static List<Map<String, String>> getPointEntry(AbstractTemplateBasePlugin page, TemplateModel tem, boolean isWorkPaper) {
        if (page.getPageCache().get(ALL) == null) {
            ArrayList allPoint = new ArrayList();
            int maxSeq = QueryDimensionServiceHelper.getMaxDseq((String)String.valueOf(tem.getModelId()));
            ApplicationTypeEnum app = ModelUtil.queryApp(page.getView());
            DefaultDimAreaEnum pageenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"page", (String)app.appnum, (boolean)isWorkPaper);
            DefaultDimAreaEnum rankenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"rank", (String)app.appnum, (boolean)isWorkPaper);
            List<String> pagenumbers = Arrays.asList(pageenum.getNumbers());
            List<String> ranknumbers = Arrays.asList(rankenum.getNumbers());
            for (int i = 1; i <= maxSeq; ++i) {
                DynamicObject obj = QueryDimensionServiceHelper.getDimByDseq((int)i, (String)String.valueOf(tem.getModelId()));
                if (obj == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)tem.getModelId())) continue;
                map.put("name", obj.getString("name"));
                map.put("entity", obj.getString("membermodel"));
                map.put("seq", Integer.toString(i));
                map.put("number", obj.getString("number"));
                String number = obj.getString("number");
                if (pagenumbers.contains(number)) {
                    map.put("sign", TemplateDimSettingUtil.buildSign(obj.getString("membermodel"), obj.getString("number"), PAGEPANEL_SIGN));
                    map.put("panel", PAGEPANEL_SIGN);
                } else if (ranknumbers.contains(number)) {
                    map.put("sign", TemplateDimSettingUtil.buildSign(obj.getString("membermodel"), obj.getString("number"), RANKPANEL_SIGN));
                    map.put("panel", RANKPANEL_SIGN);
                } else {
                    map.put("sign", TemplateDimSettingUtil.buildSign(obj.getString("membermodel"), obj.getString("number"), VIEWPANEL_SIGN));
                    map.put("panel", VIEWPANEL_SIGN);
                }
                allPoint.add(map);
            }
            page.getPageCache().put(ALL, SerializationUtils.toJsonString(allPoint));
        }
        List ap = (List)SerializationUtils.fromJsonString((String)page.getPageCache().get(ALL), List.class);
        return ap;
    }

    private static String buildSign(String entity, String number, String sign) {
        return (entity + "!" + number + "!" + sign).toLowerCase(Locale.ENGLISH);
    }

    public static void setDefaultValue(AbstractTemplateBasePlugin page, TemplateModel tem, IFormView formView, boolean isWorkPaper) {
        List<Map<String, String>> list = TemplateDimSettingUtil.getPointEntry(page, tem, isWorkPaper);
        for (Map<String, String> map : list) {
            DefaultDimSettingEnum dimSetting = DefaultDimSettingEnum.getDefaultDimSettingEnumByEntity((String)map.get("entity"), (String)page.getBizAppId());
            if (VIEWPANEL_SIGN.equals(map.get("panel"))) {
                if (dimSetting != null) {
                    DynamicObject memberMsgByNumber;
                    String id = null;
                    String number = dimSetting.getNumber();
                    if (isWorkPaper && dimSetting == DefaultDimSettingEnum.BCM_CURRENCY) {
                        number = "EC";
                    }
                    if (Objects.isNull(memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)dimSetting.getEntity()))) {
                        if (map.get("number").equals("Scenario") && Objects.isNull(memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)DefaultDimSettingEnum.RPT_SCENARIO.getNumber(), (String)dimSetting.getEntity()))) {
                            memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)"Actual", (String)dimSetting.getEntity());
                            id = memberMsgByNumber.getString("id");
                        }
                    } else {
                        id = memberMsgByNumber.getString("id");
                    }
                    if (StringUtils.isNotEmpty((String)id)) {
                        page.getPageCache().put(map.get("sign"), id);
                        continue;
                    }
                    formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TemplateDimSettingUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimSetting.getNumber()));
                    continue;
                }
                try {
                    long id;
                    if (isWorkPaper && map.get("entity").equals("bcm_processmembertree")) {
                        DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)"BPNone", (String)"bcm_processmembertree");
                        id = member.getLong("id");
                    } else {
                        long dimid = Long.parseLong(QueryDimensionServiceHelper.getDimIdByNumber((String)map.get("number"), (String)String.valueOf(tem.getModelId())));
                        id = QueryDimensionServiceHelper.getDefautDimMemId((long)dimid, (String)map.get("entity"));
                    }
                    page.getPageCache().put(map.get("sign"), String.valueOf(id));
                }
                catch (Exception e) {
                    formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u7684\u9ed8\u8ba4\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"TemplateDimSettingUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), map.get("number")));
                }
                continue;
            }
            if (!PAGEPANEL_SIGN.equals(map.get("panel"))) continue;
            if (dimSetting != null) {
                String number = dimSetting.getNumber();
                if ("bcm_scenemembertree".equals(map.get("entity"))) {
                    number = DimensionServiceHelper.getDefaultScenarioNumber((long)tem.getModelId(), (long)0L);
                }
                if (tem.isSaveByDim()) {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), number, dimSetting.getRange(), page, tem);
                } else {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), DimEntityNumEnum.getNumberByEntieyNum((String)map.get("entity")), RangeEnum.VALUE_40.getValue(), page, tem);
                    try {
                        List scenes;
                        if (tem != null && tem.get("scenes") != null && StringUtils.isNotEmpty((String)tem.get("scenes").toString()) && !CollectionUtils.isEmpty((Collection)(scenes = (List)SerializationUtils.fromJsonString((String)((String)tem.get("scenes")), List.class)))) {
                            page.getPageCache().put("bcm_scenemembertree!scenario!pagepanel", (String)tem.get("scenes"));
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            }
            if ("bcm_rulemembertree".equals(map.get("entity"))) {
                if (QueryServiceHelper.exists((String)map.get("entity"), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)tem.getModelId()), new QFilter("number", "=", (Object)"PRCGAAP")})) {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "PRCGAAP", RangeEnum.VALUE_10.getValue(), page, tem);
                } else {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), DimTypesEnum.MULTIGAAP.getNumber(), RangeEnum.VALUE_40.getValue(), page, tem);
                }
            }
            if ("bcm_processmembertree".equals(map.get("entity"))) {
                TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "Process", RangeEnum.VALUE_50.getValue(), page, tem);
            }
            if (!"bcm_audittrialmembertree".equals(map.get("entity"))) continue;
            TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "AuditTrail", RangeEnum.VALUE_50.getValue(), page, tem);
        }
    }

    public static void initDefaultValue(String sign, String entity, String number, int scope, AbstractTemplateBasePlugin page, TemplateModel tem) {
        DynamicObject obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        if (obj == null && "MRpt".equals(number)) {
            number = "Scenario";
            obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        }
        if (obj == null && "M_YearTotal".equals(number)) {
            number = "Period";
            obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        }
        if (obj != null) {
            long id = obj.getLong("id");
            ArrayList li = new ArrayList();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", String.valueOf(id));
            m.put("scope", String.valueOf(scope));
            m.put("number", obj.getString("number"));
            m.put("name", obj.getString("name"));
            li.add(m);
            page.getPageCache().put(sign, SerializationUtils.toJsonString(li));
        }
    }

    public static boolean fillBack2TemplateModel(AbstractTemplateBasePlugin pageview, TemplateModel tem, boolean isWorkPaper) {
        TemplateModel template = tem;
        ArrayList<Map<String, String>> view = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> page = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> rank = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> filterDim = new ArrayList<Map<String, String>>(16);
        for (Map<String, String> map : TemplateDimSettingUtil.getPointEntry(pageview, tem, isWorkPaper)) {
            String sign = map.get("sign");
            String panel = map.get("panel");
            if (VIEWPANEL_SIGN.equals(panel)) {
                if (pageview.getPageCache().get(sign) == null) {
                    pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9690\u85cf\u7ef4\u6210\u5458\u3002", (String)"TemplateDimSettingUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                String memberId = pageview.getPageCache().get(sign);
                map.put("viewmemb_Id", memberId);
                view.add(map);
                continue;
            }
            if (PAGEPANEL_SIGN.equals(panel)) {
                String[] split = sign.split("!");
                if (split.length == 4 && FILTER_DIMENSION_SIGN.equals(split[3])) {
                    if (pageview.getPageCache().get(sign) == null || ((List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(sign), List.class)).isEmpty()) {
                        pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u9762\u677f\u4e2d\u7684\u8054\u52a8\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"TemplateDimSettingUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    filterDim.add(map);
                    continue;
                }
                if (!"bcm_entitymembertree".equals(map.get("entity")) && (pageview.getPageCache().get(sign) == null || ((List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(sign), List.class)).isEmpty())) {
                    pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"TemplateDimSettingUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                page.add(map);
                continue;
            }
            if (!RANKPANEL_SIGN.equals(panel)) continue;
            rank.add(map);
        }
        if (rank.size() < 2 && MemberReader.isExistAuditTrailDimension((long)template.getModelId())) {
            pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5217\u7ef4\u81f3\u5c11\u4fdd\u75592\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateDimSettingUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!QueryDimensionServiceHelper.checkIcEnt((long)tem.getModelId()) && QueryDimensionServiceHelper.isExitDimension((long)tem.getModelId(), (String)DimTypesEnum.INTERCOMPANY.getNumber())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("entity", "bcm_icmembertree");
            map.put("number", DimTypesEnum.INTERCOMPANY.getNumber());
            map.put("seq", QueryDimensionServiceHelper.getMsgByNumber((long)tem.getModelId(), (String)DimTypesEnum.INTERCOMPANY.getNumber()).getString("dseq"));
            String selectFields = "id";
            QFilter fmodelid = new QFilter("model", "=", (Object)tem.getModelId());
            QFilter fmodelid2 = new QFilter("number", "=", (Object)"ICNone");
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)selectFields, (QFilter[])filters);
            String memberId = String.valueOf(member.get("id"));
            map.put("viewmemb_Id", memberId);
            view.add(map);
        }
        TemplateDimSettingUtil.handleViewEntryFilltoTemplateModel2(template, view, pageview);
        TemplateDimSettingUtil.handlePageEntryFilltoTemplateModel(template, page, pageview);
        TemplateDimSettingUtil.handleRankEntryFilltoCache(template, rank, pageview);
        TemplateDimSettingUtil.handFilterDimEntryToTemplateModel(template, filterDim, pageview);
        IPageCache pageCache = (IPageCache)pageview.getView().getParentView().getService(IPageCache.class);
        pageCache.put(ISEDIT, "1");
        return true;
    }

    private static DynamicObject getDimDynamicObjectByNumber(long modelId, String dimNumber) {
        DynamicObject temp = null;
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ThreadCache.get((Object)("getDimDynamicObject_" + modelId), () -> QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,membermodel,dseq", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}));
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (!dynamicObject.getString("number").equals(dimNumber)) continue;
            temp = dynamicObject;
            break;
        }
        return temp;
    }

    private static void handFilterDimEntryToTemplateModel(TemplateModel model, List<Map<String, String>> filterDim, AbstractTemplateBasePlugin pageview) {
        model.clearFilterDimensionEntry();
        DynamicObject temp = null;
        Dimension dim = null;
        List membColl = null;
        for (Map<String, String> entry : filterDim) {
            String entityName = entry.get("entity");
            temp = TemplateDimSettingUtil.getDimDynamicObjectByNumber(model.getModelId(), entry.get("number"));
            if (temp == null) {
                return;
            }
            dim = TemplateDimSettingUtil.convertDynaObj2Dimension(temp);
            dim.setDataEntityNumber(entityName);
            membColl = (List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(entry.get("sign")), List.class);
            if (membColl.isEmpty()) continue;
            FilterDimensionEntry tfDimEntry = new FilterDimensionEntry(model);
            tfDimEntry.setDimension(dim);
            tfDimEntry.setSeq(Integer.parseInt(entry.get("seq")));
            tfDimEntry.getMembers().clear();
            CustomProperty cp = null;
            for (Map tempMemb : membColl) {
                FilterDimMember filterDimMember = new FilterDimMember();
                filterDimMember.setDimension(dim);
                filterDimMember.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                String number = (String)tempMemb.get("number");
                String name = (String)tempMemb.get("name");
                if (tempMemb.get("pid") != null && StringUtils.isNotEmpty((String)((String)tempMemb.get("pid")))) {
                    filterDimMember.setCustom(true);
                    String[] numbers = number.split(":");
                    String[] names = name.split(":");
                    MembProperty membpro = new MembProperty();
                    membpro.setId(Long.parseLong((String)tempMemb.get("id")));
                    filterDimMember.setId(Long.parseLong((String)tempMemb.get("id")));
                    membpro.setNumber(numbers[1]);
                    membpro.setName(names[1]);
                    cp = new CustomProperty();
                    cp.setId(Long.parseLong((String)tempMemb.get("pid")));
                    cp.setNumber(numbers[0]);
                    cp.setName(names[0]);
                    membpro.setCustomProperty(cp);
                    membpro.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                    filterDimMember.setMembProperty(membpro);
                } else {
                    filterDimMember.setCustom(false);
                    filterDimMember.setNumber(number);
                    filterDimMember.setName(name);
                    filterDimMember.setId(LongUtil.toLong(tempMemb.get("id")).longValue());
                    filterDimMember.setDataEntityNumber(entityName);
                }
                tfDimEntry.getMembers().add(filterDimMember);
            }
            model.addTemplateFilterDimensionEntry(tfDimEntry);
        }
    }

    private static void handleRankEntryFilltoCache(TemplateModel template, List<Map<String, String>> rank, AbstractTemplateBasePlugin pageview) {
        template.clearRank();
        IPageCache pageCache = (IPageCache)pageview.getView().getParentView().getService(IPageCache.class);
        pageCache.put("rank", SerializationUtils.toJsonString(rank));
        pageview.getPageCache().put("rank", SerializationUtils.toJsonString(rank));
        ArrayList rankList = new ArrayList(16);
        rank.forEach(s -> rankList.add(s.get("number")));
        template.setRank(rankList);
    }

    public static void handleViewEntryFilltoTemplateModel2(TemplateModel model, List<Map<String, String>> entries, AbstractTemplateBasePlugin pageview) {
        model.getViewPointDimensionEntries().clear();
        DynamicObject temp = null;
        for (Map<String, String> entry : entries) {
            ViewPointDimensionEntry viewentry = new ViewPointDimensionEntry(model);
            viewentry.setSeq(Integer.parseInt(entry.get("seq")));
            temp = TemplateDimSettingUtil.getDimDynamicObjectByNumber(model.getModelId(), entry.get("number"));
            if (temp == null) {
                return;
            }
            Dimension dim = TemplateDimSettingUtil.convertDynaObj2Dimension(temp);
            viewentry.setDimension(dim);
            temp = TemplateDimSettingUtil.loadMemberObject(dim.getMemberEntityNumber(), entry.get("viewmemb_Id"));
            Member member = TemplateDimSettingUtil.convertDynaObj2Member(temp);
            member.setDimension(dim);
            dim.setDataEntityNumber(temp.getDataEntityType().getName());
            viewentry.setMember(member);
            model.getViewPointDimensionEntries().add(viewentry);
        }
    }

    public static void handlePageEntryFilltoTemplateModel(TemplateModel model, List<Map<String, String>> entries, AbstractTemplateBasePlugin pageview) {
        model.getPageDimensionEntries().clear();
        model.getPagePropEntries().clear();
        Dimension dim = null;
        DynamicObject temp = null;
        List membColl = null;
        for (Map<String, String> entry : entries) {
            PageDimensionEntry pageentry;
            temp = TemplateDimSettingUtil.getDimDynamicObjectByNumber(model.getModelId(), entry.get("number"));
            if (temp == null) {
                return;
            }
            dim = TemplateDimSettingUtil.convertDynaObj2Dimension(temp);
            dim.setDataEntityNumber(temp.get("membermodel").toString());
            if (pageview.getPageCache().get(entry.get("sign")) == null) {
                pageentry = new PageDimensionEntry(model);
                pageentry.setDimension(dim);
                pageentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageentry.getMembers().clear();
                model.getPageDimensionEntries().add(pageentry);
                continue;
            }
            membColl = (List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(entry.get("sign")), List.class);
            if (membColl.size() == 0) {
                pageentry = new PageDimensionEntry(model);
                pageentry.setDimension(dim);
                pageentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageentry.getMembers().clear();
                model.getPageDimensionEntries().add(pageentry);
                continue;
            }
            if (((Map)membColl.get(0)).get("pid") != null && StringUtils.isNotEmpty((String)((String)((Map)membColl.get(0)).get("pid")))) {
                PageDimPropEntry pageproentry = new PageDimPropEntry(model);
                pageproentry.setDimension(dim);
                pageproentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageproentry.getAllMembProperties().clear();
                pageproentry.getCustomProperties().clear();
                CustomProperty cp = null;
                for (Map tempMemb : membColl) {
                    String[] numbers = ((String)tempMemb.get("number")).split(":");
                    String[] names = ((String)tempMemb.get("name")).split(":");
                    MembProperty membpro = new MembProperty();
                    membpro.setId(Long.parseLong((String)tempMemb.get("id")));
                    membpro.setNumber(numbers[1]);
                    membpro.setName(names[1]);
                    cp = new CustomProperty();
                    cp.setId(Long.parseLong((String)tempMemb.get("pid")));
                    cp.setNumber(numbers[0]);
                    cp.setName(names[0]);
                    membpro.setCustomProperty(cp);
                    membpro.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                    pageproentry.getAllMembProperties().add(membpro);
                    pageproentry.addCustomProperty(cp);
                }
                model.getPagePropEntries().add(pageproentry);
                continue;
            }
            pageentry = new PageDimensionEntry(model);
            pageentry.setDimension(dim);
            pageentry.setSeq(Integer.parseInt(entry.get("seq")));
            pageentry.getMembers().clear();
            for (Map tempMemb : membColl) {
                Member member = TemplateDimSettingUtil.convertDynaObj2Member(TemplateDimSettingUtil.loadMemberObject(dim.getMemberEntityNumber(), tempMemb.get("id")));
                member.setDimension(dim);
                member.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                pageentry.getMembers().add(member);
            }
            model.getPageDimensionEntries().add(pageentry);
        }
    }

    private static DynamicObject getDimByDseq(int seq, Map<String, DynamicObject> sysdimension) {
        if (!sysdimension.isEmpty()) {
            for (DynamicObject dynamicObject : sysdimension.values()) {
                if (dynamicObject.getInt("dseq") != seq) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    public static void fillBack2TemplateModelForImport(TemplateModel newTemplateModel, ApplicationTypeEnum app, String appID) {
        long modelId = newTemplateModel.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        DefaultDimAreaEnum pageenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"page", (String)app.appnum, (boolean)false);
        DefaultDimAreaEnum rankenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"rank", (String)app.appnum, (boolean)false);
        List<String> pagenumbers = Arrays.asList(pageenum.getNumbers());
        List<String> ranknumbers = Arrays.asList(rankenum.getNumbers());
        ArrayList viewDimNumber = new ArrayList(16);
        newTemplateModel.getPagePropEntries().clear();
        newTemplateModel.getPageDimensionEntries().clear();
        newTemplateModel.getViewPointDimensionEntries().clear();
        Map number2Id = (Map)MemberReader.getModelDimIDAndNumberMap((long)modelId).p2;
        number2Id.keySet().forEach(dimNum -> {
            if (!(DimEntityNumEnum.EXTENDS.getNumber().equals(dimNum) || ranknumbers.contains(dimNum) || pagenumbers.contains(dimNum))) {
                viewDimNumber.add(dimNum);
            }
        });
        number2Id.forEach((number, id) -> {
            if (DimEntityNumEnum.EXTENDS.getNumber().equals(number)) {
                return;
            }
            DynamicObject obj = MemberReader.getDimensionDynById((long)id);
            if (obj != null) {
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)modelId)) {
                    return;
                }
                String dimNumber = obj.getString("number");
                String entity = obj.getString("membermodel");
                DefaultDimSettingEnum dimSetting = DefaultDimSettingEnum.getDefaultDimSettingEnumByEntity((String)entity, (String)appID);
                if (pagenumbers.contains(dimNumber)) {
                    if (dimSetting != null) {
                        TemplateDimSettingUtil.addPageDim(newTemplateModel, obj, dimSetting.getNumber(), dimSetting.getRange(), modelNumber);
                    }
                    if ("bcm_rulemembertree".equals(entity)) {
                        if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)"PRCGAAP")})) {
                            TemplateDimSettingUtil.addPageDim(newTemplateModel, obj, "PRCGAAP", RangeEnum.VALUE_10.getValue(), modelNumber);
                        } else {
                            TemplateDimSettingUtil.addPageDim(newTemplateModel, obj, DimTypesEnum.MULTIGAAP.getNumber(), RangeEnum.VALUE_40.getValue(), modelNumber);
                        }
                    }
                    if ("bcm_processmembertree".equals(entity)) {
                        TemplateDimSettingUtil.addPageDim(newTemplateModel, obj, "Process", RangeEnum.VALUE_50.getValue(), modelNumber);
                    }
                    if ("bcm_audittrialmembertree".equals(entity)) {
                        TemplateDimSettingUtil.addPageDim(newTemplateModel, obj, "AuditTrail", RangeEnum.VALUE_50.getValue(), modelNumber);
                    }
                } else if (viewDimNumber.contains(dimNumber)) {
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber)) {
                        TemplateDimSettingUtil.addViewDim(newTemplateModel, obj, "ICNone", modelNumber);
                    }
                    if (entity.equals("bcm_userdefinedmembertree")) {
                        TemplateDimSettingUtil.addViewDim(newTemplateModel, obj, obj.getString("shortnumber") + "None", modelNumber);
                    }
                }
            }
        });
    }

    private static void addViewDim(TemplateModel newTemplateModel, DynamicObject obj, String number, String modelNumber) {
        String dimNumber = obj.getString("number");
        String entity = obj.getString("membermodel");
        Dimension dim = TemplateDimSettingUtil.convertDynaObj2Dimension(obj);
        ViewPointDimensionEntry viewentry = new ViewPointDimensionEntry(newTemplateModel);
        viewentry.setSeq(newTemplateModel.getViewPointDimensionEntries().size() + 1);
        viewentry.setDimension(dim);
        IDNumberTreeNode treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)number);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            Member member = TemplateDimSettingUtil.convertMemberTree2Member(treeNode, entity);
            member.setDimension(dim);
            viewentry.setMember(member);
            newTemplateModel.getViewPointDimensionEntries().add(viewentry);
        }
    }

    private static void addPageDim(TemplateModel newTemplateModel, DynamicObject obj, String number, int scope, String modelNumber) {
        String dimNumber = obj.getString("number");
        String entity = obj.getString("membermodel");
        Dimension dim = TemplateDimSettingUtil.convertDynaObj2Dimension(obj);
        PageDimensionEntry pageentry = new PageDimensionEntry(newTemplateModel);
        pageentry.setDimension(dim);
        pageentry.setSeq(newTemplateModel.getPageDimensionEntries().size() + 1);
        IDNumberTreeNode treeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)number);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            Member member = TemplateDimSettingUtil.convertMemberTree2Member(treeNode, entity);
            member.setDimension(dim);
            member.setScope(scope);
            pageentry.getMembers().add(member);
            newTemplateModel.getPageDimensionEntries().add(pageentry);
        }
    }

    public static Dimension getDimensionByNumber(String number, long modelId) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("model", "=", (Object)modelId);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,membermodel,dseq", (QFilter[])new QFilter[]{filter});
        return TemplateDimSettingUtil.convertDynaObj2Dimension(object);
    }

    public static Member getMemberByNumber(String number, String entityNumber, long modelId) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("model", "=", (Object)modelId);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        return TemplateDimSettingUtil.convertDynaObj2Member(object);
    }

    public static Dimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        Dimension dim = new Dimension();
        dim.setId(dynaObj.getLong("id"));
        dim.setNumber(dynaObj.getString("number"));
        dim.setName(dynaObj.getString("name"));
        dim.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        dim.setMemberEntityNumber(dynaObj.getString("membermodel"));
        if (dynaObj.getDataEntityType().getProperties().containsKey((Object)"fieldmapped")) {
            dim.setFieldmapped(dynaObj.getString("fieldmapped"));
        }
        return dim;
    }

    public static DynamicObject loadMemberObject(String entityNum, Object pk) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)pk), (String)entityNum);
    }

    public static Member convertDynaObj2Member(DynamicObject dynaObj) {
        Member member = new Member();
        member.setId(dynaObj.getLong("id"));
        member.setNumber(dynaObj.getString("number"));
        member.setName(dynaObj.getString("name"));
        member.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        return member;
    }

    public static Member convertMemberTree2Member(IDNumberTreeNode idNumberTreeNode, String entityNumber) {
        Member member = new Member();
        member.setId(idNumberTreeNode.getId().longValue());
        member.setNumber(idNumberTreeNode.getNumber());
        member.setName(idNumberTreeNode.getName());
        member.setDataEntityNumber(entityNumber);
        return member;
    }

    public static boolean checkDimension(AbstractTemplateBasePlugin pageview, TemplateModel template) {
        boolean is = true;
        ArrayList dimIds = new ArrayList();
        template.getViewPointDimensionEntries().forEach(v -> dimIds.add(v.getDimension().getId()));
        template.getPageDimensionEntries().forEach(p -> dimIds.add(p.getDimension().getId()));
        template.getPagePropEntries().forEach(p -> dimIds.add(p.getDimension().getId()));
        if (template.getAreaRangeEntries().size() != 0 && ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().size() != 0) {
            ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().forEach(c -> dimIds.add(c.getDimension().getId()));
            ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().forEach(c -> dimIds.add(c.getDimension().getId()));
        } else {
            if (pageview.getPageCache().get("rank") == null) {
                return true;
            }
            List list = (List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get("rank"), List.class);
            list.forEach(p -> dimIds.add(Long.valueOf(QueryDimensionServiceHelper.getDimIdByNumber((String)((String)p.get("number")), (String)String.valueOf(template.getModelId())))));
        }
        List realdimIds = QueryDimensionServiceHelper.getdimensionIds((String)String.valueOf(template.getModelId()));
        dimIds.retainAll(realdimIds);
        if (dimIds.size() != realdimIds.size()) {
            is = false;
        }
        return is;
    }
}

