/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateCatalog;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PositionTypeEnum;
import kd.fi.bcm.common.enums.TemplateSyncFormulaStatusEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateEntryFormulaCheck;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.RegexUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateUtil {
    public static Pair<AreaRangeEntry, List<String>> getCommonAreaRangeEntry(TemplateModel templateModel) {
        if (templateModel.isSaveByDim()) {
            for (AreaRangeEntry a : templateModel.getAreaRangeEntries()) {
                List rowDimEntries = a.getRowDimEntries();
                if (rowDimEntries == null || rowDimEntries.isEmpty()) continue;
                HashSet crossDimensions = new HashSet(16);
                rowDimEntries.forEach(rowDimensionEntry -> crossDimensions.add(rowDimensionEntry.getDimension().getNumber()));
                if (templateModel.getTemplateType() != null && TemplateTypeEnum.getWPTypes().contains(templateModel.getTemplateType().toString())) {
                    List colDimEntriesExt = a.getColDimEntriesExt();
                    if (colDimEntriesExt == null || colDimEntriesExt.isEmpty()) continue;
                    ColDimensionEntryExt colDimEntryExt = colDimEntriesExt.stream().filter(colDimensionEntryExt -> StringUtils.isEmpty((CharSequence)colDimensionEntryExt.getFormula())).findFirst().get();
                    if (colDimEntryExt != null && colDimEntryExt.getDimMembers() != null) {
                        colDimEntryExt.getDimMembers().forEach(pair -> crossDimensions.add(((Dimension)pair.p1).getNumber()));
                    }
                    return Pair.onePair((Object)a, crossDimensions.stream().collect(Collectors.toList()));
                }
                List colDimEntries = a.getColDimEntries();
                if (colDimEntries == null || colDimEntries.isEmpty()) continue;
                colDimEntries.forEach(colDimensionEntry -> crossDimensions.add(colDimensionEntry.getDimension().getNumber()));
                return Pair.onePair((Object)a, crossDimensions.stream().collect(Collectors.toList()));
            }
        }
        return null;
    }

    public static void updateReportStatus(TemplateModel.TplStatus status, Map<Long, DynamicObject> templateStatus, OperationResult operationResult, boolean isWorkPaper, Long modelId) {
        if (!templateStatus.isEmpty()) {
            List templateModelList;
            boolean isCheckEffectiveDate;
            ArrayList primaryKeyValues = new ArrayList(templateStatus.size());
            String templateType = isWorkPaper ? ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f", (String)"TemplateVerification_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868", (String)"TemplateVerification_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            templateStatus.forEach((k, v) -> {
                if (status.getStatuValue().equals(v.getString("status"))) {
                    String title = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684%2$s\u6a21\u677f\u5df2\u7ecf%3$s\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TemplateListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), v.getString("number"), templateType, status == TemplateModel.TplStatus.ENABLE ? ResManager.loadKDString((String)"\u542f\u7528", (String)"TemplateListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"TemplateListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    TemplateUtil.addOperateErrorInfo(title, operationResult);
                } else {
                    primaryKeyValues.add(k);
                }
            });
            ArrayList dos = new ArrayList(16);
            boolean bl = isCheckEffectiveDate = TemplateModel.TplStatus.ENABLE == status && !isWorkPaper;
            if (isCheckEffectiveDate && !(templateModelList = kd.fi.bcm.business.util.TemplateUtil.batchGetTemplateModel(primaryKeyValues, (Long)modelId, (boolean)false)).isEmpty()) {
                primaryKeyValues.removeAll(TemplateExtendModelRefUtil.batchCheckBeforeSave(templateModelList, operationResult, modelId));
            }
            if (!primaryKeyValues.isEmpty()) {
                templateStatus.forEach((k, p) -> {
                    if (primaryKeyValues.contains(k)) {
                        if (isCheckEffectiveDate && p.get("effectivedate") == null) {
                            BigDecimal versionNumber = (BigDecimal)p.get("versionnumber");
                            String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
                            String title = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u62a5\u8868\u6a21\u677f\u56e0\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u5728\u7248\u672c\u5316\u4e2d\u7ef4\u62a4\u751f\u6548\u65e5\u671f\u3002", (String)"TemplateListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format("%s-%s-%s", p.get("number"), p.get("name"), version));
                            TemplateUtil.addOperateErrorInfo(title, operationResult);
                        } else {
                            operationResult.addSuccessPkId((Object)p.getLong("id"));
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
                            dynamicObject.set("id", (Object)p.getLong("id"));
                            dynamicObject.set("status", (Object)status.getStatuValue());
                            dos.add(dynamicObject);
                        }
                    }
                });
            }
            if (!dos.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])dos.toArray(new DynamicObject[dos.size()]));
            }
        }
    }

    public static void addOperateErrorInfo(String message, OperationResult operationResult) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(message);
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        operationResult.addErrorInfo(operateErrorInfo);
    }

    public static Map<Long, DynamicObject> getTemplateStatus(Object[] primaryKeyValues) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        Map<Long, DynamicObject> result = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,versionnumber,status,effectivedate", (QFilter[])qfBuilder.toArray()).stream().collect(Collectors.toMap(tem -> tem.getLong("id"), Function.identity()));
        return result;
    }

    public static boolean isCtrl(IFormView view, String ctrlName) {
        boolean re = false;
        if (ctrlName == null) {
            return re;
        }
        re = ctrlName.startsWith("bcm_");
        return re;
    }

    public static Object[] updateSyncFormulasStatus(List<Object> ids, Long modelId, TemplateSyncFormulaStatusEnum recordEnum) {
        if (ids != null && !ids.isEmpty()) {
            DeleteServiceHelper.delete((String)"bcm_sync_formulas_report", (QFilter[])new QFilter("model", "=", (Object)modelId).and("template", "in", ids).toArray());
            long currUserId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Date now = TimeServiceHelper.now();
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(ids.size());
            for (Object id : ids) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_sync_formulas_report");
                dynamicObject.set("model", (Object)modelId);
                dynamicObject.set("template", (Object)LongUtil.toLong((Object)id));
                dynamicObject.set("status", (Object)Character.valueOf(recordEnum.index));
                if (recordEnum == TemplateSyncFormulaStatusEnum.INEXECUTION) {
                    dynamicObject.set("creator", (Object)currUserId);
                    dynamicObject.set("createtime", (Object)now);
                }
                dynamicObject.set("reportdetails", (Object)"");
                dynamicObjects.add(dynamicObject);
            }
            return SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
        return null;
    }

    public static void setTemplateLockedCellStatus(JSONObject dataTable, SpreadManager sm) {
        if (dataTable == null) {
            return;
        }
        Sheet sheet = sm.getBook().getSheet(0);
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        dataTable.forEach((row, v) -> {
            if (v instanceof JSONObject) {
                JSONObject cols = (JSONObject)v;
                cols.forEach((col, o) -> {
                    if (!(o instanceof JSONObject)) {
                        return;
                    }
                    JSONObject cell = (JSONObject)o;
                    if (!(cell.get((Object)"style") instanceof JSONObject)) {
                        return;
                    }
                    JSONObject style = (JSONObject)cell.get((Object)"style");
                    Boolean locked = false;
                    if (style.get((Object)"locked") instanceof Boolean) {
                        locked = (Boolean)style.get((Object)"locked");
                    }
                    Cell c = null;
                    if (locked.booleanValue() || Integer.parseInt(row) <= maxRowCount - 1 && Integer.parseInt(col) <= maxColumnCount - 1) {
                        c = sheet.getCell(Integer.parseInt(row), Integer.parseInt(col), locked.booleanValue());
                    }
                    if (c != null && !Boolean.valueOf(c.isLock()).equals(locked)) {
                        c.setLock(locked.booleanValue());
                        c.setUserObject("c_l", (Object)true);
                    }
                });
            }
        });
        AutoFloatUtil.setSyncLockStatus(sheet, true);
    }

    public static List<PositionInfo> getOverlapPositions(String tarArea, SpreadManager sm) {
        ArrayList<PositionInfo> result = new ArrayList<PositionInfo>();
        block0: for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = e.getAreaRange();
            if (e.getExtendInfo() != null) {
                String[] split = areaRange.split(":");
                Point point = ExcelUtils.pos2Point((String)split[0]);
                if (point.y - 1 >= 0) {
                    areaRange = ExcelUtils.xy2Pos((int)point.x, (int)(point.y - 1)) + ":" + split[1];
                }
            }
            if (ExcelUtils.isOverlap((String)areaRange, (String)tarArea)) {
                result.add(e);
                continue;
            }
            List basePoints = e.getBasePoints();
            if (basePoints == null || basePoints.isEmpty()) continue;
            for (BasePointInfo basePoint : basePoints) {
                if (!ExcelUtils.isOverlap((String)basePoint.getDynaRange(), (String)tarArea)) continue;
                result.add(e);
                continue block0;
            }
        }
        return result;
    }

    public static PositionInfo getOverlapPosition(int r, int c, SpreadManager sm) {
        return TemplateUtil.getOverlapPosition(ExcelUtils.xy2Pos((int)c, (int)r), false, sm);
    }

    public static PositionInfo getOverlapPosition(String tarArea, boolean isIncludeExt, SpreadManager sm) {
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            String areaRange = e.getAreaRange();
            if (isIncludeExt && e.getExtendInfo() != null) {
                String[] split = areaRange.split(":");
                Point point = ExcelUtils.pos2Point((String)split[0]);
                if (point.y - 1 >= 0) {
                    areaRange = ExcelUtils.xy2Pos((int)point.x, (int)(point.y - 1)) + ":" + split[1];
                }
            }
            if (!ExcelUtils.isOverlap((String)areaRange, (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    public static PositionInfo getExtPosByExtHeader(int row, int col, SpreadManager sm) {
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            RangeModel rangeModel;
            int headRow;
            if (e.getExtendInfo() == null || (headRow = (rangeModel = new RangeModel(e.getAreaRange())).getY_start() - 1) < 0 || row != headRow || rangeModel.getX_end() < col || rangeModel.getX_start() > col) continue;
            return e;
        }
        return null;
    }

    public static String getListEntryOrderBy(boolean isTemplate) {
        return kd.fi.bcm.business.util.TemplateUtil.getListEntryOrderBy((boolean)isTemplate);
    }

    public static LinkedHashMap<Long, List<DynamicObject>> groupTemplate(List<DynamicObject> templates, boolean isEntityTab) {
        LinkedHashMap<Long, List<DynamicObject>> map = new LinkedHashMap<Long, List<DynamicObject>>(16);
        templates.forEach(e -> {
            Long key = isEntityTab ? e.getLong("entity.id") : e.getLong("template.id");
            if (map.get(key) == null) {
                map.put(key, new ArrayList(16));
            }
            ((List)map.get(key)).add(e);
        });
        if (!isEntityTab && !map.isEmpty()) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())}, (String)TemplateUtil.getListEntryOrderBy(true));
            LinkedHashMap<Long, List<DynamicObject>> linkedHashMap = new LinkedHashMap<Long, List<DynamicObject>>(map.size());
            if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                dynamicObjects.forEach(dyo -> {
                    List cfr_ignored_0 = (List)linkedHashMap.put(dyo.getLong("id"), (List<DynamicObject>)map.get(dyo.getLong("id")));
                });
            }
            return linkedHashMap;
        }
        return map;
    }

    public static IDimMember getIDimMember(String dimNum, String memName, String memNum, long modelId, String entityNum, boolean isCurrent) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Map dimDyoMap = MemberReader.getDimDyoByModelId((long)modelId);
        if (dimDyoMap == null || dimDyoMap.isEmpty()) {
            return null;
        }
        DynamicObject dimDyo = (DynamicObject)dimDyoMap.get(dimNum);
        if (dimDyo != null) {
            Map<String, String> number2NameMap;
            IDNumberTreeNode node = IDNumberTreeNode.NotFoundTreeNode;
            if (isCurrent) {
                node = BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)LongUtil.toLong((Object)SystemVarsEnum.CURRENT.getId()));
            } else if (StringUtils.isNotEmpty((CharSequence)memNum)) {
                node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)memNum);
            }
            IDimension dim = ObjectConvertUtils.toIDimension(dimDyo);
            IDimMember member = null;
            boolean isOrg = "bcm_entitymembertree".equals(entityNum);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                member = TemplateUtil.getMember(dim, node, isOrg, isCurrent);
            } else if (StringUtils.isNotEmpty((CharSequence)memName) && !isCurrent && (number2NameMap = TemplateUtil.getMemberNumber2NameMap(dimNum, modelNum)).containsValue(memName)) {
                for (Map.Entry<String, String> entry : number2NameMap.entrySet()) {
                    if (!memName.equals(entry.getValue()) || !StringUtils.isNotEmpty((CharSequence)entry.getKey())) continue;
                    member = TemplateUtil.getMember(dim, BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)entry.getKey()), isOrg, isCurrent);
                    break;
                }
            }
            return member;
        }
        return null;
    }

    public static boolean updateCellDimMember(String dimNum, String memName, String memNum, long modelId, String entityNum, Cell cell, boolean isCurrent) {
        boolean isValidate = false;
        IDimMember member = TemplateUtil.getIDimMember(dimNum, memName, memNum, modelId, entityNum, isCurrent);
        if (member != null) {
            isValidate = true;
            cell.addDim2UserObject(member);
        }
        if (!isValidate) {
            cell.clearMembersOfUserObject();
        }
        return isValidate;
    }

    private static Map<String, String> getMemberNumber2NameMap(String dimNum, String modelNum) {
        return (Map)ThreadCache.get((Object)("TemplateUtil_getMemberNumber2NameMap" + modelNum), () -> {
            Collection allNodeByDimNum = MemberReader.getAllNodeByDimNum((String)dimNum, (String)modelNum);
            HashMap<String, String> map = new HashMap<String, String>(16);
            if (CollectionUtils.isNotEmpty((Collection)allNodeByDimNum)) {
                map = new HashMap(allNodeByDimNum.size());
                for (IDNumberTreeNode node : allNodeByDimNum) {
                    map.put(node.getNumber(), node.getName());
                }
            }
            return map;
        });
    }

    private static IDimMember getMember(IDimension dim, IDNumberTreeNode node, boolean isOrg, boolean isCurrent) {
        IDimMember member = null;
        if (!Objects.isNull(node) && node != IDNumberTreeNode.NotFoundTreeNode) {
            boolean flag = false;
            if (isCurrent) {
                flag = true;
            } else if (isOrg) {
                if (StringUtils.isNotEmpty((CharSequence)node.getCurrency())) {
                    flag = true;
                }
            } else if (!node.isShare()) {
                flag = true;
            }
            if (flag) {
                member = ObjectConvertUtils.toDimMember(node, dim);
                if (!Objects.isNull(node.getParent()) && IDNumberTreeNode.NotFoundTreeNode != node.getParent()) {
                    member.setPar_SonNum(node.getParent().getNumber() + "_" + node.getNumber());
                }
            }
        }
        return member;
    }

    private static String updateNewCellDimMems(List<Tuple<String, String, String>> rowColDimList, String modelNum, Map<String, DynamicObject> dimDyoMap, Cell cell, String[] membArrs, List<String> filterDimList) {
        boolean isValidate = true;
        HashMap shortNumMap = new HashMap(16);
        dimDyoMap.forEach((k, v) -> shortNumMap.put(k, v.getString("shortnumber")));
        Collection values = shortNumMap.values();
        HashMap<String, String> cellMap = new HashMap<String, String>(16);
        for (String m : membArrs) {
            String[] tmp = m.split("@");
            if (tmp.length != 2) {
                isValidate = false;
                break;
            }
            if (!values.contains(tmp[0])) {
                isValidate = false;
                break;
            }
            cellMap.put(tmp[0], m);
        }
        if (isValidate) {
            for (Tuple tuple : rowColDimList) {
                String dimNum = (String)tuple.p2;
                String shortNum = (String)shortNumMap.get(dimNum);
                boolean isOrg = DimTypesEnum.ENTITY.getNumber().equals(dimNum);
                String temp = (String)cellMap.get(shortNum);
                if (StringUtils.isEmpty((CharSequence)temp)) {
                    isValidate = false;
                    break;
                }
                String[] tmp = temp.split("@");
                if (StringUtils.isEmpty((CharSequence)tmp[1])) {
                    isValidate = false;
                    break;
                }
                boolean isCurrent = SystemVarsEnum.CURRENT.getNumber().equals(tmp[1]);
                if (isCurrent && !filterDimList.contains(dimNum)) {
                    isValidate = false;
                    break;
                }
                IDNumberTreeNode treeNode = isCurrent ? BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)LongUtil.toLong((Object)SystemVarsEnum.CURRENT.getId())) : BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)tmp[1]);
                if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                    DynamicObject dimDyo = dimDyoMap.get(dimNum);
                    IDimension dim = ObjectConvertUtils.toIDimension(dimDyo);
                    cell.addDim2UserObject(TemplateUtil.getMember(dim, treeNode, isOrg, isCurrent));
                    continue;
                }
                isValidate = false;
                break;
            }
        }
        if (!isValidate) {
            cell.clearMembersOfUserObject();
        }
        return isValidate ? cell.displayDimMsg() : null;
    }

    public static Map<String, Object> updateCellDimMems(TemplateModel tm, SpreadManager sm, Cell cell) {
        List<Tuple<String, String, String>> rowColDimList;
        int rowColDimSize;
        cell.clearMembersOfUserObject();
        String input = cell.getValue() == null ? "" : cell.getValue().toString();
        String value = null;
        if (StringUtils.isNotEmpty((CharSequence)input) && (rowColDimSize = (rowColDimList = new TemplateEntryFormulaCheck(tm, sm).getEnterRowOrColDims(cell)).size()) != 0) {
            List<String> filterDimList = tm.getFilterDimensionEntries().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList());
            String[] membArrs = RegexUtils.resolveInput(input);
            long modelId = tm.getModelId();
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            if (membArrs.length != 0) {
                TemplateUtil.filterEffectRowColDims(rowColDimList, membArrs);
                if (CollectionUtils.isNotEmpty(rowColDimList)) {
                    Map dimDyoMap = MemberReader.getDimDyoByModelId((long)modelId);
                    if (input.contains("@")) {
                        value = TemplateUtil.updateNewCellDimMems(rowColDimList, modelNum, dimDyoMap, cell, membArrs, filterDimList);
                    } else {
                        boolean isValidate = true;
                        HashMap numMapName = new HashMap(16);
                        dimDyoMap.forEach((k, v) -> numMapName.put(k, v.getString("name")));
                        Collection allDimNames = numMapName.values();
                        HashMap<String, String> cellMap = new HashMap<String, String>(16);
                        for (String m : membArrs) {
                            String[] tmp = m.split("!");
                            if (StringUtils.isEmpty((CharSequence)tmp[0]) || !allDimNames.contains(tmp[0])) {
                                isValidate = false;
                                break;
                            }
                            cellMap.put(tmp[0], m);
                        }
                        if (isValidate) {
                            String[] tmp = new String[membArrs.length];
                            int index = 0;
                            for (Tuple<String, String, String> tuple : rowColDimList) {
                                boolean isCurrent;
                                String entity = (String)tuple.p1;
                                String dimNum = (String)tuple.p2;
                                String dimName = (String)numMapName.get(dimNum);
                                if (cellMap.get(dimName) == null) {
                                    isValidate = false;
                                    break;
                                }
                                String combine = (String)cellMap.get(dimName);
                                tmp[index++] = combine;
                                String[] prop = combine.split("!");
                                if (prop.length != 2) {
                                    isValidate = false;
                                    break;
                                }
                                String[] membArr = prop[1].split("\\|");
                                if (membArr.length != 2) {
                                    isValidate = false;
                                    break;
                                }
                                boolean bl = isCurrent = SystemVarsEnum.CURRENT.getNumber().equals(membArr[1]) && SystemVarsEnum.CURRENT.getName().equals(membArr[0]);
                                if (isCurrent && !filterDimList.contains(dimNum)) {
                                    isValidate = false;
                                    break;
                                }
                                isValidate = TemplateUtil.updateCellDimMember(dimNum, membArr[0], membArr[1], modelId, entity, cell, isCurrent);
                                if (isValidate) continue;
                                break;
                            }
                        }
                        if (isValidate) {
                            value = cell.displayDimMsg();
                        } else {
                            cell.clearMembersOfUserObject();
                        }
                    }
                }
            } else if (rowColDimSize == 1 && !RegexUtils.isMatches(input)) {
                boolean isCurrent;
                boolean bl = isCurrent = SystemVarsEnum.CURRENT.getNumber().equals(input) || SystemVarsEnum.CURRENT.getName().equals(input);
                if ((!isCurrent || filterDimList.contains(rowColDimList.get(0))) && TemplateUtil.updateCellDimMember((String)rowColDimList.get((int)0).p2, input, input, modelId, (String)rowColDimList.get((int)0).p1, cell, isCurrent)) {
                    value = cell.displayDimMsg();
                }
            }
        }
        cell.setValue(null);
        return SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), value);
    }

    public static void filterEffectRowColDims(List<Tuple<String, String, String>> rowColDimList, String[] membArrs) {
        if (membArrs.length == rowColDimList.size()) {
            return;
        }
        ArrayList rowDims = new ArrayList(16);
        ArrayList colDims = new ArrayList(16);
        rowColDimList.forEach(e -> {
            if (PositionTypeEnum.ONCOL.getName().equals(e.p3)) {
                colDims.add(e);
            } else {
                rowDims.add(e);
            }
        });
        if (membArrs.length == rowDims.size()) {
            rowColDimList.removeAll(colDims);
        } else if (membArrs.length == colDims.size()) {
            rowColDimList.removeAll(rowDims);
        } else {
            rowColDimList.clear();
        }
    }

    public static boolean isChangeForTemplate(TemplateModel newTem, TemplateModel oldTem) {
        if (newTem.isSaveByDim() && oldTem.isSaveByDim()) {
            List newViews = newTem.getViewPointDimensionEntries();
            List oldViews = oldTem.getViewPointDimensionEntries();
            if (newViews.size() != oldViews.size()) {
                return true;
            }
            int i = 0;
            int index = 0;
            if (!newViews.isEmpty() && !oldViews.isEmpty()) {
                for (ViewPointDimensionEntry view : newViews) {
                    Object entry;
                    if (StringUtils.equals((CharSequence)(entry = (ViewPointDimensionEntry)oldViews.get(i++)).getDimension().getNumber(), (CharSequence)view.getDimension().getNumber()) && StringUtils.equals((CharSequence)entry.getMember().getNumber(), (CharSequence)view.getMember().getNumber())) continue;
                    return true;
                }
            }
            List newTemPagePropEntries = newTem.getPagePropEntries();
            List oldTemPagePropEntries = oldTem.getPagePropEntries();
            if (newTemPagePropEntries.size() != oldTemPagePropEntries.size()) {
                return true;
            }
            if (!newTemPagePropEntries.isEmpty() && !oldTemPagePropEntries.isEmpty()) {
                i = 0;
                for (PageDimPropEntry pro : newTemPagePropEntries) {
                    PageDimPropEntry oldPro = (PageDimPropEntry)oldTemPagePropEntries.get(i++);
                    if (!StringUtils.equals((CharSequence)pro.getDimension().getNumber(), (CharSequence)oldPro.getDimension().getNumber())) {
                        return true;
                    }
                    List newMembProperties = pro.getAllMembProperties();
                    List oldMembProperties = oldPro.getAllMembProperties();
                    if (newMembProperties.size() != oldMembProperties.size()) {
                        return true;
                    }
                    if (oldMembProperties.isEmpty() || newMembProperties.isEmpty()) continue;
                    index = 0;
                    for (MembProperty membProperty : newMembProperties) {
                        MembProperty oldMembProperty = (MembProperty)oldMembProperties.get(index++);
                        if (StringUtils.equals((CharSequence)membProperty.getNumber(), (CharSequence)oldMembProperty.getNumber()) && StringUtils.equals((CharSequence)membProperty.getCustomProperty().getNumber(), (CharSequence)oldMembProperty.getCustomProperty().getNumber()) && membProperty.getScope() == oldMembProperty.getScope()) continue;
                        return true;
                    }
                }
            }
            List newPageDimEntries = newTem.getPageDimensionEntries();
            List oldPageDimEntries = oldTem.getPageDimensionEntries();
            if (newPageDimEntries.size() != oldPageDimEntries.size()) {
                return true;
            }
            if (!newPageDimEntries.isEmpty() && !oldPageDimEntries.isEmpty()) {
                i = 0;
                for (PageDimensionEntry newPageDimEntry : newPageDimEntries) {
                    PageDimensionEntry oldPageDimEntry = (PageDimensionEntry)oldPageDimEntries.get(i++);
                    if (!StringUtils.equals((CharSequence)newPageDimEntry.getDimension().getNumber(), (CharSequence)oldPageDimEntry.getDimension().getNumber())) {
                        return true;
                    }
                    List members = newPageDimEntry.getMembers();
                    List oldMembers = oldPageDimEntry.getMembers();
                    if (members.size() != oldMembers.size()) {
                        return true;
                    }
                    if (members.isEmpty() || oldMembers.isEmpty()) continue;
                    index = 0;
                    for (Member member : members) {
                        Member oldMem = (Member)oldMembers.get(index++);
                        if (StringUtils.equals((CharSequence)member.getNumber(), (CharSequence)oldMem.getNumber()) && oldMem.getScope() == member.getScope()) continue;
                        return true;
                    }
                }
            }
            List newFilterDims = newTem.getFilterDimensionEntries();
            List oldFilterDims = oldTem.getFilterDimensionEntries();
            if (newFilterDims.size() != oldFilterDims.size()) {
                return true;
            }
            if (!newFilterDims.isEmpty() && !oldFilterDims.isEmpty()) {
                i = 0;
                for (FilterDimensionEntry newFilterDim : newFilterDims) {
                    FilterDimensionEntry oldFilterDim = (FilterDimensionEntry)oldFilterDims.get(i++);
                    if (!StringUtils.equals((CharSequence)newFilterDim.getDimension().getNumber(), (CharSequence)oldFilterDim.getDimension().getNumber())) {
                        return true;
                    }
                    List newMems = newFilterDim.getMembers();
                    List oldMems = oldFilterDim.getMembers();
                    if (newMems.size() != oldMems.size()) {
                        return true;
                    }
                    if (newMems.isEmpty() || oldMems.isEmpty()) continue;
                    index = 0;
                    for (FilterDimMember fdm : newMems) {
                        FilterDimMember oldFdm = (FilterDimMember)oldMems.get(index++);
                        if (fdm.isCustom() != oldFdm.isCustom() || fdm.getScope() != oldFdm.getScope()) {
                            return true;
                        }
                        if (!(fdm.isCustom() ? !StringUtils.equals((CharSequence)fdm.getMembProperty().getNumber(), (CharSequence)oldFdm.getMembProperty().getNumber()) && !StringUtils.equals((CharSequence)fdm.getMembProperty().getCustomProperty().getNumber(), (CharSequence)oldFdm.getMembProperty().getCustomProperty().getNumber()) : !StringUtils.equals((CharSequence)fdm.getNumber(), (CharSequence)oldFdm.getNumber()))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean dealTemplateCatalog(TemplateModel tm, boolean isSave) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)tm.getModelId());
        qf.and("group", "=", (Object)tm.getGroup());
        boolean isMaxVersion = true;
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,templatecatalog,templatecatalog.id,templatecatalog.name,versionnumber", (QFilter[])qf.toArray(), (String)"versionnumber desc");
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            DynamicObject object = (DynamicObject)objects.get(0);
            boolean bl = isMaxVersion = object.getLong("id") == tm.getId();
            if (isSave) {
                if (isMaxVersion) {
                    ArrayList ids = new ArrayList(objects.size());
                    ArrayList dyos = new ArrayList(objects.size());
                    long catalogId = tm.getTemplateCatalog().getId();
                    objects.forEach(e -> {
                        long id = e.getLong("id");
                        if (id != tm.getId() && e.getLong("templatecatalog.id") != catalogId) {
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
                            dynamicObject.set("id", (Object)id);
                            dynamicObject.set("templatecatalog", (Object)catalogId);
                            ids.add(id);
                            dyos.add(dynamicObject);
                        }
                    });
                    if (CollectionUtils.isNotEmpty(ids)) {
                        OperateOption op = OperateOption.create();
                        op.setVariableValue("updateModifyDate", "false");
                        SaveServiceHelper.update((DynamicObject[])dyos.toArray(new DynamicObject[dyos.size()]), (OperateOption)op);
                        TemplateServiceHelper.removeTemplateModelCacheByIds((Object)tm.getModelId(), (Object[])ids.toArray());
                    }
                } else {
                    TemplateCatalog catalog = new TemplateCatalog();
                    catalog.setId(object.getLong("templatecatalog.id"));
                    catalog.setName(object.getString("templatecatalog.name"));
                    tm.setTemplateCatalog(catalog);
                }
            }
        }
        return isMaxVersion;
    }

    public static String getMemberMessage(long modelId, Cell cell) {
        List memberFromUserObject = cell.getMemberFromUserObject();
        if (CollectionUtils.isNotEmpty((Collection)memberFromUserObject)) {
            Map dimDyoMap = MemberReader.getDimDyoByModelId((long)modelId);
            ArrayList members = new ArrayList(16);
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            memberFromUserObject.forEach(iDimMember -> {
                String dimNumber = iDimMember.getDimension().getNumber();
                if (dimDyoMap.containsKey(dimNumber)) {
                    DynamicObject dimDyo = (DynamicObject)dimDyoMap.get(dimNumber);
                    IDimension iDimension = ObjectConvertUtils.toIDimension(dimDyo);
                    String memberNumber = iDimMember.getNumber();
                    if (SystemVarsEnum.CURRENT.getNumber().equals(memberNumber)) {
                        DimMember memberDim = new DimMember(SystemVarsEnum.CURRENT.getName(), SystemVarsEnum.CURRENT.getNumber(), "", iDimension);
                        members.add(memberDim);
                    } else {
                        IDNumberTreeNode member = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNumber, (String)memberNumber);
                        if (!IDNumberTreeNode.NotFoundTreeNode.equals(member)) {
                            IDimMember memberDim = ObjectConvertUtils.toDimMember(member, iDimension);
                            members.add(memberDim);
                        }
                    }
                }
            });
            if (!members.isEmpty()) {
                return Cell.formatDimMsg(members);
            }
        }
        return null;
    }

    public static Map<Long, String> generateNumbersForTemplate(long modelId, Collection<DynamicObject> tempObjs) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(tempObjs)) {
            return result;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter templatetypeFilter = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        List exitNumbers = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number", (QFilter[])new QFilter[]{modelFilter, templatetypeFilter}).stream().map(c -> c.getString("number")).collect(Collectors.toList());
        tempObjs.forEach(e -> {
            String curNum = e.getString("number");
            String number = "";
            if (50 >= curNum.length() && StringUtils.isNotEmpty((CharSequence)(number = TemplateUtil.generateIncrementNumber(curNum + "copy", exitNumbers, new AtomicInteger(1))))) {
                exitNumbers.add(number);
            }
            result.put(e.getLong("id"), number);
        });
        return result;
    }

    public static String generateIncrementNumber(String number, List<String> exitNumbers, AtomicInteger index) {
        if (50 <= number.length() || index.get() > 999) {
            return "";
        }
        String result = number;
        if (exitNumbers.contains(result)) {
            String suffix = "";
            if (index.get() < 10) {
                suffix = "00";
            } else if (index.get() < 100) {
                suffix = "0";
            } else if (index.get() < 1000) {
                suffix = "";
            }
            result = number + suffix + index.get();
            if (50 < result.length()) {
                return "";
            }
            if (exitNumbers.contains(result)) {
                result = TemplateUtil.generateIncrementNumber(number, exitNumbers, new AtomicInteger(index.incrementAndGet()));
            }
        }
        return result;
    }
}

