/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.SearchHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.invest.InvrelationSearchSetPlugin;
import org.apache.commons.collections.CollectionUtils;

public class TreeEntryEntityUtil {
    public static final String treeentryentity = "treeentryentity";
    public static final String NAME = "name";
    public static List<String> noIntroduceInvType = InvrelationSearchSetPlugin.noIntroduceInvType;

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf) {
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(model, memberColls, propertyList, checkIsLeaf, 0L);
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf, Long parentid) {
        model.getDataEntity(true);
        DynamicObject root = null;
        ArrayList<Long> allMembIds = new ArrayList<Long>();
        if (memberColls != null && memberColls.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
            String parentKey = "parent";
            if (!(((DynamicObject)memberColls.get(memberColls.size() - 1)).get("parent") instanceof Long)) {
                parentKey = "parent.id";
            }
            for (DynamicObject memb : memberColls) {
                if (root == null && memb.getLong(parentKey) == parentid.longValue()) {
                    root = memb;
                }
                allMembIds.add(memb.getLong("id"));
            }
            HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
            if (root != null) {
                Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getSeqComparator();
                for (int i = 0; i < memberColls.size(); ++i) {
                    TreeSet treeSet;
                    DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                    long parent = memberObject.getLong(parentKey);
                    if (parent == parentid) continue;
                    if (!allMembIds.contains(parent)) {
                        parent = root.getLong("id");
                    }
                    if ((treeSet = (TreeSet)searchChild.get(parent)) != null) {
                        treeSet.add(memberObject);
                        continue;
                    }
                    TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                    children.add(memberObject);
                    searchChild.put(parent, children);
                }
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = root.getString("dpname" + i);
                            String dppaname = root.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", root.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", root.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set("drcrdirect1", (Object)"");
                        continue;
                    }
                    if ("memberid".equals(property)) {
                        rowObj.set(property, (Object)root.getLong("id"));
                        continue;
                    }
                    rowObj.set(property, root.get(property));
                }
                rowObj.set("id", (Object)root.getLong("id"));
                rowObj.set("pid", (Object)0);
                if (checkIsLeaf && !root.getBoolean("isleaf") && searchChild.size() > 1) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                TreeEntryEntityUtil.expandNextLevel(model, propertyList, 0, root, searchChild, checkIsLeaf);
            }
        }
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf, Long parentid, Long modelId) {
        model.getDataEntity(true);
        DynamicObject root = null;
        ArrayList<Long> allMembIds = new ArrayList<Long>();
        if (memberColls != null && memberColls.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
            String parentKey = "parent";
            if (!(((DynamicObject)memberColls.get(memberColls.size() - 1)).get("parent") instanceof Long)) {
                parentKey = "parent.id";
            }
            for (DynamicObject memb : memberColls) {
                if (root == null && memb.getLong(parentKey) == parentid.longValue()) {
                    root = memb;
                }
                allMembIds.add(memb.getLong("id"));
            }
            HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
            if (root != null) {
                Map invChangetypeModel = InvestServiceHelper.getInvChangetypeModel((Long)modelId);
                List dcs = invChangetypeModel.values().stream().filter(x -> !TreeEntryEntityUtil.isContainsNumber(x.number()) && (x.GetIsdefault() || !"0".equals(x.change()))).collect(Collectors.toList());
                Map<String, String> result = dcs.stream().collect(Collectors.toMap(x -> x.number(), y -> y.name(), (v1, v2) -> v1));
                result.put("BD000", ResManager.loadKDString((String)"\u7981\u7528", (String)"OpItemEnum_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getSeqComparator();
                for (int i = 0; i < memberColls.size(); ++i) {
                    TreeSet treeSet;
                    DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                    long parent = memberObject.getLong(parentKey);
                    memberObject.set("bizchangetype", (Object)result.get(memberObject.getString("bizchangetype")));
                    if (parent == parentid) continue;
                    if (!allMembIds.contains(parent)) {
                        parent = root.getLong("id");
                    }
                    if ((treeSet = (TreeSet)searchChild.get(parent)) != null) {
                        treeSet.add(memberObject);
                        continue;
                    }
                    TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                    children.add(memberObject);
                    searchChild.put(parent, children);
                }
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = root.getString("dpname" + i);
                            String dppaname = root.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", root.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", root.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set("drcrdirect1", (Object)"");
                        continue;
                    }
                    if ("memberid".equals(property)) {
                        rowObj.set(property, (Object)root.getLong("id"));
                        continue;
                    }
                    rowObj.set(property, root.get(property));
                }
                rowObj.set("id", (Object)root.getLong("id"));
                rowObj.set("pid", (Object)0);
                if (checkIsLeaf && !root.getBoolean("isleaf") && searchChild.size() > 1) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                TreeEntryEntityUtil.expandNextLevel(model, propertyList, 0, root, searchChild, checkIsLeaf);
            }
        }
    }

    public static void fillTreeEntryEntityUserSeqDm(IDataModel model, DynamicObjectCollection allMember, Set<Long> memberIds, List<String> propertyList, List<String> dynamicObjecPpropertyList, Boolean noRoot) {
        LinkedHashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new LinkedHashMap<Long, TreeMap<Integer, DynamicObject>>(16);
        LinkedHashMultimap relationMap = LinkedHashMultimap.create();
        for (Object member : allMember) {
            Long parent = member.getLong("parent");
            relationMap.put((Object)parent, (Object)member.getLong("id"));
        }
        DynamicObjectCollection allMemberCopy = new DynamicObjectCollection();
        allMemberCopy.addAll((Collection)allMember);
        for (DynamicObject member : allMemberCopy) {
            if (TreeEntryEntityUtil.memberCanShow(member.getLong("id"), memberIds, (SetMultimap<Long, Long>)relationMap, null)) continue;
            allMember.remove((Object)member);
        }
        relationMap.clear();
        for (DynamicObject memberObject : allMember) {
            Long parent = memberObject.getLong("parent");
            int dseq = memberObject.getInt("dseq");
            if (searchChild.containsKey(parent)) {
                dseq = TreeEntryEntityUtil.getNewSeq(dseq, (TreeMap)searchChild.get(parent));
                ((TreeMap)searchChild.get(parent)).put(dseq, memberObject);
            } else {
                TreeMap<Integer, DynamicObject> treeMap = new TreeMap<Integer, DynamicObject>();
                treeMap.put(dseq, memberObject);
                searchChild.put(parent, treeMap);
            }
            relationMap.put((Object)parent, (Object)memberObject.getLong("id"));
        }
        Set<Long> rootIdSets = TreeEntryEntityUtil.getAllRootIds((SetMultimap<Long, Long>)relationMap);
        ArrayList rootIds = new ArrayList(16);
        int realRows = 0;
        for (Long l : rootIdSets) {
            realRows += TreeEntryEntityUtil.countRows(searchChild, l, 0, TreeEntryEntityUtil.getMaxCount(0L));
        }
        for (Map.Entry entry : searchChild.entrySet()) {
            if (!rootIdSets.contains(entry.getKey())) continue;
            rootIds.add(entry.getKey());
        }
        int n = realRows = noRoot != false ? --realRows : realRows;
        if (realRows > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, realRows);
            int row = 0;
            if (noRoot.booleanValue() && rootIds.size() > 1) {
                for (Long rootId : rootIds) {
                    if (rootId == 0L) continue;
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                }
            } else {
                for (Long rootId : rootIds) {
                    if (noRoot.booleanValue()) {
                        row = TreeEntryEntityUtil.expandNextLevelNoRoot(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                        continue;
                    }
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                }
            }
        }
        model.endInit();
    }

    public static int getMaxCount(long modelId) {
        int maxCount = 0;
        try {
            if (modelId == 0L) {
                modelId = LongUtil.toLong((Object)ThreadCache.get((Object)"getModelId"));
            }
            if (modelId != 0L) {
                return Integer.parseInt(ConfigServiceHelper.getStringParam((Long)modelId, (String)"dimMaxCount"));
            }
        }
        catch (Exception ex) {
            maxCount = 0;
        }
        return maxCount;
    }

    private static boolean memberCanShow(Long memberId, Set<Long> memberIds, SetMultimap<Long, Long> relationMap, Map<Long, Integer> permMap) {
        if (memberIds.contains(memberId)) {
            if (permMap != null && permMap.get(memberId) != null && permMap.get(memberId).intValue() != PermEnum.NOPERM.getValue()) {
                return true;
            }
            if (permMap == null || permMap.get(memberId) == null) {
                return true;
            }
            if (relationMap.get((Object)memberId) != null) {
                Iterator iterator = relationMap.get((Object)memberId).iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (!TreeEntryEntityUtil.memberCanShow(id, memberIds, relationMap, permMap)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void fillTreeEntryEntityUserSeqDm(IDataModel model, DynamicObjectCollection allMember, Set<Long> memberIds, Map<Long, Integer> permission, List<String> propertyList, List<String> dynamicObjecPpropertyList, Boolean noRoot) {
        LinkedHashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new LinkedHashMap<Long, TreeMap<Integer, DynamicObject>>(16);
        LinkedHashMultimap relationMap = LinkedHashMultimap.create();
        for (Object member : allMember) {
            Long parent = member.getLong("parent");
            relationMap.put((Object)parent, (Object)member.getLong("id"));
        }
        DynamicObjectCollection allMemberCopy = new DynamicObjectCollection();
        allMemberCopy.addAll((Collection)allMember);
        for (DynamicObject member : allMemberCopy) {
            if (TreeEntryEntityUtil.memberCanShow(member.getLong("id"), memberIds, (SetMultimap<Long, Long>)relationMap, permission)) continue;
            allMember.remove((Object)member);
        }
        for (DynamicObject memberObject : allMember) {
            Long parent = memberObject.getLong("parent");
            int dseq = memberObject.getInt("dseq");
            if (searchChild.containsKey(parent)) {
                dseq = TreeEntryEntityUtil.getNewSeq(dseq, (TreeMap)searchChild.get(parent));
                ((TreeMap)searchChild.get(parent)).put(dseq, memberObject);
                continue;
            }
            TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
            children.put(dseq, memberObject);
            searchChild.put(parent, children);
        }
        TreeEntryEntityUtil.filterPermission(permission, allMember);
        if (permission.size() > 0) {
            int rows = permission.size() - (noRoot != false ? 1 : 0);
            if (rows <= 0) {
                return;
            }
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, rows);
            Set<Long> rootIds = TreeEntryEntityUtil.getAllRootIds((SetMultimap<Long, Long>)relationMap);
            int row = 0;
            if (noRoot.booleanValue() && rootIds.size() > 1) {
                for (Long rootId : rootIds) {
                    if (rootId == 0L) continue;
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                }
            } else {
                for (Long rootId : rootIds) {
                    if (noRoot.booleanValue()) {
                        row = TreeEntryEntityUtil.expandNextLevelNoRoot(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                        continue;
                    }
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchChild, dynamicObjecPpropertyList);
                }
            }
            model.endInit();
        }
    }

    public static void fillMultiRootProperties(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList) {
        model.getDataEntity(true);
        ArrayList<DynamicObject> roots = new ArrayList<DynamicObject>();
        if (memberColls != null && memberColls.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
            for (DynamicObject memb : memberColls) {
                if (memb.getLong("parent") != 0L) continue;
                roots.add(memb);
            }
            HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
            if (roots.size() > 0) {
                Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getSeqComparator();
                for (int i = 0; i < memberColls.size(); ++i) {
                    DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                    long parent = memberObject.getLong("parent");
                    if (parent == 0L) continue;
                    TreeSet treeSet = (TreeSet)searchChild.get(parent);
                    if (treeSet != null) {
                        treeSet.add(memberObject);
                        continue;
                    }
                    TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                    children.add(memberObject);
                    searchChild.put(parent, children);
                }
                int index = 0;
                for (DynamicObject root : roots) {
                    DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, index);
                    for (int k = 0; k < propertyList.size(); ++k) {
                        String property = propertyList.get(k);
                        rowObj.set(property, root.get(property));
                    }
                    rowObj.set("id", (Object)root.getLong("id"));
                    rowObj.set("pid", (Object)0);
                    if (searchChild.get(root.getLong("id")) == null) continue;
                    index = 1 + TreeEntryEntityUtil.expandNextLevel(model, propertyList, index, root, searchChild, false);
                }
            }
        }
    }

    public static void updateMemberSeq(DynamicObjectCollection members) {
        Map searchChild = SearchHelper.fillParentMapChild((DynamicObjectCollection)members);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        for (TreeSet treeSet : searchChild.values()) {
            ArrayList<Long> seqs = new ArrayList<Long>(16);
            long dseqMax = ((DynamicObject)treeSet.last()).getLong("dseq");
            for (DynamicObject dy : treeSet) {
                long dseq = dy.getLong("dseq");
                if (seqs.contains(dseq)) {
                    dy.set("dseq", (Object)(++dseqMax));
                    dynamicObjects.add(dy);
                    continue;
                }
                seqs.add(dseq);
            }
        }
        if (dynamicObjects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
    }

    public static Comparator<DynamicObject> getSeqComparator() {
        Comparator comparator = (o1, o2) -> {
            int seq = o1.getInt("dseq") - o2.getInt("dseq");
            if (seq == 0) {
                Long id1 = o1.getLong("id");
                Long id2 = o2.getLong("id");
                return id1.compareTo(id2);
            }
            return seq;
        };
        return comparator;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, DynamicObject parent, Map<Long, TreeSet<DynamicObject>> searchChild, boolean checkIsLeaf) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            for (DynamicObject child : childrenMap) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = child.getString("dpname" + i);
                            String dppaname = child.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", child.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", child.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set("drcrdirect1", child.get("drcrdirect"));
                        continue;
                    }
                    if ("memberid".equals(property)) {
                        rowObj.set(property, (Object)child.getLong("id"));
                        continue;
                    }
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                if (checkIsLeaf && !child.getBoolean("isleaf")) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child, searchChild, checkIsLeaf);
            }
        }
        return row;
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, List<Map<String, Object>> memberColls, List<String> propertyList) {
        Map<String, Object> root = null;
        LinkedHashMap<Long, TreeMap<Integer, Map<String, Object>>> searchChild = new LinkedHashMap<Long, TreeMap<Integer, Map<String, Object>>>(16);
        if (memberColls != null && memberColls.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
            for (Map<String, Object> dd : memberColls) {
                Object data = dd.get("parent");
                long parent = data instanceof Integer ? (long)((Integer)data).intValue() : (Long)data;
                int dseq = Integer.parseInt((String)dd.get("kseq"));
                if (parent == 0L) {
                    root = dd;
                    continue;
                }
                if (searchChild.containsKey(parent)) {
                    TreeMap treeMap = (TreeMap)searchChild.get(parent);
                    if (treeMap.containsKey(dseq)) {
                        ++dseq;
                    }
                    treeMap.put(dseq, dd);
                    continue;
                }
                TreeMap<Integer, Map<String, Object>> children = new TreeMap<Integer, Map<String, Object>>();
                children.put(dseq, dd);
                searchChild.put(parent, children);
            }
        }
        DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
        for (int k = 0; k < propertyList.size(); ++k) {
            String property = propertyList.get(k);
            if (root == null) continue;
            rowObj.set(property, root.get(property));
        }
        rowObj.set("pid", (Object)0);
        if (root != null) {
            TreeEntryEntityUtil.expandNextLevel(model, propertyList, 0, root, searchChild);
        }
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, Map<String, Object> parent, Map<Long, TreeMap<Integer, Map<String, Object>>> searchChild) {
        if (searchChild.containsKey(parent.get("id"))) {
            TreeMap<Integer, Map<String, Object>> childrenMap = searchChild.get(parent.get("id"));
            Collection<Map<String, Object>> children = childrenMap.values();
            for (Map<String, Object> child : children) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("pid", parent.get("id"));
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child, searchChild);
            }
        }
        return row;
    }

    public static void fillTreeEntryEntity4Virture(IFormView view, IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, List<String> dynamicObjecPpropertyList, int insertIdx) {
        int insertFrom = insertIdx == -1 ? 0 : insertIdx;
        int insertSize = memberColls.size();
        if (insertSize == 0) {
            return;
        }
        model.getDataEntity(true);
        model.beginInit();
        if (insertFrom == 0) {
            model.batchCreateNewEntryRow(treeentryentity, insertSize);
        } else {
            model.batchInsertEntryRow(treeentryentity, insertFrom, insertSize);
        }
        model.endInit();
        DataEntityPropertyCollection props = null;
        int row = insertFrom == 0 ? 0 : insertIdx + 1;
        EntryProp entryProp = (EntryProp)model.getProperty(treeentryentity);
        DynamicObjectType dt = entryProp.getDynamicCollectionItemPropertyType();
        DynamicProperty isgroupnodeProp = dt.getProperty("isgroupnode");
        for (DynamicObject child : memberColls) {
            DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, row++);
            if (props == null) {
                props = rowObj.getDataEntityType().getProperties();
            }
            rowObj.set("id", (Object)child.getLong("id"));
            rowObj.set("pid", (Object)child.getLong("parent"));
            for (int k = 0; k < propertyList.size(); ++k) {
                String property = propertyList.get(k);
                if ("storagetype".equals(property)) {
                    rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)StorageTypeEnum.getStorageTypeEnumByIndex((String)child.getString(dynamicObjecPpropertyList.get(k))).getName());
                    continue;
                }
                if ("dimension".equals(property) && props.get((Object)property) instanceof BasedataProp) {
                    int idx = k;
                    DynamicObject dimension = (DynamicObject)ThreadCache.get((Object)"dimesnion-dy", () -> {
                        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_dimension");
                        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)entityType, null);
                        dynaObj.set("id", child.get((String)dynamicObjecPpropertyList.get(idx)));
                        return dynaObj;
                    });
                    rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)dimension);
                    continue;
                }
                if ("isleaf".equals(property)) {
                    rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)((Boolean)child.get(dynamicObjecPpropertyList.get(k)) != false ? 1 : 0));
                    if (((Boolean)child.get(dynamicObjecPpropertyList.get(k))).booleanValue()) continue;
                    isgroupnodeProp.setValueFast((Object)rowObj, (Object)true);
                    continue;
                }
                rowObj.set((IDataEntityProperty)props.get((Object)property), child.get(dynamicObjecPpropertyList.get(k)));
            }
        }
    }

    private static int getNewSeq(int dseq, TreeMap<Integer, DynamicObject> map) {
        while (map.keySet().contains(dseq)) {
            ++dseq;
        }
        return dseq;
    }

    private static int countRows(Map<Long, TreeMap<Integer, DynamicObject>> searchChild, long rootId, int rows, int maxCount) {
        TreeMap<Integer, DynamicObject> children = searchChild.get(rootId);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            for (DynamicObject child : children.values()) {
                if (maxCount > 0 && ++i > maxCount) {
                    return rows;
                }
                ++rows;
                rows = TreeEntryEntityUtil.countRows(searchChild, child.getLong("id"), rows, maxCount);
            }
        }
        return rows;
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection members, List<String> propertyList, List<String> dPropertyList, boolean noRoot) {
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(model, members, propertyList, dPropertyList, noRoot, null);
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection members, List<String> propertyList, List<String> dPropertyList, boolean noRoot, PairList<String, String> mergeList) {
        LinkedHashMap<Long, TreeMap<Integer, DynamicObject>> searchRelation = new LinkedHashMap<Long, TreeMap<Integer, DynamicObject>>(128);
        HashSet<Long> noMerges = new HashSet<Long>(16);
        for (DynamicObject member : members) {
            long id = member.getLong("id");
            long parent = member.getLong("parent");
            if (mergeList != null && id != ((DynamicObject)members.get(0)).getLong("id") && (mergeList.contains(Pair.onePair((Object)member.getString("parent.number"), (Object)member.getString("number"))) || noMerges.contains(parent))) {
                noMerges.add(id);
                continue;
            }
            int seq = member.getInt("dseq");
            if (searchRelation.containsKey(parent)) {
                seq = TreeEntryEntityUtil.getNewSeq(seq, (TreeMap)searchRelation.get(parent));
                ((TreeMap)searchRelation.get(parent)).put(seq, member);
                continue;
            }
            TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
            children.put(seq, member);
            searchRelation.put(parent, children);
        }
        if (members.size() > 0) {
            if (noRoot && members.size() == 1) {
                return;
            }
            model.beginInit();
            Set<Long> rootIds = TreeEntryEntityUtil.getAllRoots(searchRelation);
            int row = 0;
            int realRows = 0;
            for (Long rootId : rootIds) {
                realRows += TreeEntryEntityUtil.countRows(searchRelation, rootId, 0, BCMTreeUtils.getMaxCount((long)0L));
            }
            realRows = noRoot ? --realRows : realRows;
            model.batchCreateNewEntryRow(treeentryentity, realRows);
            if (noRoot && rootIds.size() > 1) {
                for (Long rootId : rootIds) {
                    if (rootId == 0L) continue;
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchRelation, dPropertyList);
                }
            } else {
                for (Long rootId : rootIds) {
                    if (noRoot) {
                        row = TreeEntryEntityUtil.expandNextLevelNoRoot(model, propertyList, row, rootId, searchRelation, dPropertyList);
                        continue;
                    }
                    row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, rootId, searchRelation, dPropertyList);
                }
            }
            model.endInit();
        }
    }

    private static Set<Long> getAllRootIds(SetMultimap<Long, Long> relationMap) {
        LinkedHashSet<Long> set = new LinkedHashSet<Long>(16);
        relationMap.keySet().forEach(key -> {
            Collection values = relationMap.values();
            if (!values.contains(key)) {
                set.add((Long)key);
            }
        });
        return set;
    }

    private static Set<Long> getAllRoots(Map<Long, TreeMap<Integer, DynamicObject>> searchRelation) {
        LinkedHashSet<Long> roots = new LinkedHashSet<Long>(16);
        HashSet ids = new HashSet(16);
        searchRelation.values().forEach(r -> ids.addAll(r.values().stream().map(m -> m.getLong("id")).collect(Collectors.toSet())));
        searchRelation.keySet().forEach(key -> {
            if (!ids.contains(key)) {
                roots.add((Long)key);
            }
        });
        return roots;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, Long parentid, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, List<String> dynamicObjecPpropertyList) {
        if (searchChild.containsKey(parentid)) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parentid);
            Collection<DynamicObject> children = childrenMap.values();
            DataEntityPropertyCollection props = null;
            long maxCount = BCMTreeUtils.getMaxCount((long)0L);
            int index = 0;
            for (DynamicObject child : children) {
                if (maxCount > 0L && (long)(++index) > maxCount) {
                    return row;
                }
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, row++);
                if (child == null || rowObj == null) continue;
                if (props == null) {
                    props = rowObj.getDataEntityType().getProperties();
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parentid);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("storagetype".equals(property)) {
                        rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)StorageTypeEnum.getStorageTypeEnumByIndex((String)child.getString(dynamicObjecPpropertyList.get(k))).getName());
                        continue;
                    }
                    if ("dimension".equals(property) && props.get((Object)property) instanceof BasedataProp) {
                        int idx = k;
                        DynamicObject dimension = (DynamicObject)ThreadCache.get((Object)"dimesnion-dy", () -> {
                            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_dimension");
                            DynamicObject dynaObj = new DynamicObject((DynamicObjectType)entityType, null);
                            dynaObj.set("id", child.get((String)dynamicObjecPpropertyList.get(idx)));
                            return dynaObj;
                        });
                        rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)dimension);
                        continue;
                    }
                    if ("isleaf".equals(property)) {
                        rowObj.set((IDataEntityProperty)props.get((Object)property), (Object)((Boolean)child.get(dynamicObjecPpropertyList.get(k)) != false ? 1 : 0));
                        continue;
                    }
                    rowObj.set((IDataEntityProperty)props.get((Object)property), child.get(dynamicObjecPpropertyList.get(k)));
                }
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child.getLong("id"), searchChild, dynamicObjecPpropertyList);
            }
        }
        return row;
    }

    private static int expandNextLevelNoRoot(IDataModel model, List<String> propertyList, int row, Long parentid, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, List<String> dynamicObjecPpropertyList) {
        if (searchChild.containsKey(parentid)) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parentid);
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child.getLong("id"), searchChild, dynamicObjecPpropertyList);
            }
        }
        return row;
    }

    public static int[] createTreeEntry(IFormView view, DynamicObjectCollection memberColls, List<String> propertyList, String level, boolean updateView) {
        DynamicObject root = null;
        for (DynamicObject obj : memberColls) {
            if (!level.equals(obj.getString("level"))) continue;
            root = obj;
            break;
        }
        if (root == null) {
            throw new KDBizException("root is null");
        }
        MainEntityType maintype = view.getModel().getDataEntityType();
        EntryType entityType = (EntryType)maintype.getAllEntities().get(treeentryentity);
        DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
        for (String property : propertyList) {
            if ("showdproperty".equals(property)) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= 10; ++i) {
                    String dpname = root.getString("dpname" + i);
                    String dppaname = root.getString("dppaname" + i);
                    if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                    sb.append(dppaname).append(':').append(dpname).append(';');
                }
                rowObj.set(property, (Object)sb.toString());
                continue;
            }
            rowObj.set(property, root.get(property));
        }
        rowObj.set("id", (Object)root.getLong("id"));
        rowObj.set("pid", (Object)0);
        view.getModel().beginInit();
        Long ecdataid = rowObj.getLong("ecdataid");
        Long pcdataid = rowObj.getLong("pcdataid");
        view.getModel().createNewEntryRow(treeentryentity, 0, rowObj);
        view.getModel().setValue("ecdataid", (Object)ecdataid, 0);
        view.getModel().setValue("pcdataid", (Object)pcdataid, 0);
        view.getModel().endInit();
        memberColls.remove((Object)root);
        return TreeEntryEntityUtil.insertTreeEntry(view, memberColls, propertyList, 0, root.getLong("id"), false, updateView);
    }

    public static int[] createTreeEntryFp(IFormView view, DynamicObjectCollection memberColls, List<String> propertyList, String level, boolean updateView) {
        DynamicObject root = null;
        for (DynamicObject obj : memberColls) {
            if (!level.equals(obj.getString("level"))) continue;
            root = obj;
            break;
        }
        if (root == null) {
            throw new KDBizException("root is null");
        }
        MainEntityType maintype = view.getModel().getDataEntityType();
        EntryType entityType = (EntryType)maintype.getAllEntities().get(treeentryentity);
        DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
        for (String property : propertyList) {
            rowObj.set(property, root.get(property));
        }
        rowObj.set("id", (Object)root.getLong("id"));
        rowObj.set("pid", (Object)0);
        view.getModel().beginInit();
        view.getModel().createNewEntryRow(treeentryentity, 0, rowObj);
        view.getModel().endInit();
        memberColls.remove((Object)root);
        return TreeEntryEntityUtil.insertTreeEntry(view, memberColls, propertyList, 0, root.getLong("id"), false, updateView);
    }

    public static int[] focus(IDataModel model, int row) {
        if (row == -1) {
            return new int[0];
        }
        ArrayList<Integer> pids = new ArrayList<Integer>();
        DynamicObjectCollection objs = model.getEntryEntity(treeentryentity);
        ArrayList<String> ids = new ArrayList<String>(10);
        for (int i = 0; i < objs.size(); ++i) {
            ids.add(((DynamicObject)objs.get(i)).getString("id"));
        }
        DynamicObject oo = (DynamicObject)objs.get(row);
        String pid = oo.getString("pid");
        while (StringUtils.isNotEmpty((String)pid)) {
            int i = -1;
            if (ids.contains(pid)) {
                i = ids.indexOf(pid);
                pids.add(i);
            }
            if (i != -1) {
                pid = ((DynamicObject)objs.get(i)).getString("pid");
                continue;
            }
            pid = "";
        }
        Collections.sort(pids);
        int[] exids = new int[pids.size()];
        for (int i = 0; i < exids.length; ++i) {
            exids[i] = (Integer)pids.get(i);
        }
        return exids;
    }

    public static int[] insertTreeEntry(IFormView view, DynamicObjectCollection memberColls, List<String> propertyList, int row, long pid, boolean isDel) {
        return TreeEntryEntityUtil.insertTreeEntry(view, memberColls, propertyList, row, pid, isDel, true);
    }

    public static void insertTreeEntryRows(IFormView view, DynamicObjectCollection memberColls, List<String> propertyList, int row, long pid, boolean isDel, boolean checkIsLeaf) {
        IDataModel model = view.getModel();
        if (memberColls.size() == 0) {
            return;
        }
        if (isDel && row != 0) {
            model.beginInit();
            model.deleteEntryRow(treeentryentity, row);
            model.endInit();
        }
        model.getDataEntity(true);
        model.beginInit();
        model.batchInsertEntryRow(treeentryentity, row, memberColls.size());
        model.endInit();
        Map rowObjs = SearchHelper.fillParentMapChild((DynamicObjectCollection)memberColls);
        DynamicObject pRow = model.getEntryRowEntity(treeentryentity, row);
        TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, pRow, rowObjs, checkIsLeaf);
    }

    public static int[] insertTreeEntry(IFormView view, DynamicObjectCollection memberColls, List<String> propertyList, int row, long pid, boolean isDel, boolean updateView) {
        IDataModel model = view.getModel();
        if (memberColls.size() == 0) {
            return null;
        }
        int index = row + 1;
        if (isDel && row != 0) {
            model.beginInit();
            model.deleteEntryRow(treeentryentity, index);
            model.endInit();
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)view.getControl(treeentryentity);
        Map<Integer, DynamicObject> returnMap = TreeEntryEntityUtil.doInsertTreeEntry(model, memberColls, propertyList, row);
        int[] list = new int[returnMap.size()];
        int i = 0;
        if (model.isInitialized()) {
            for (Map.Entry<Integer, DynamicObject> entry : returnMap.entrySet()) {
                list[i++] = entry.getKey();
            }
        } else {
            ClientViewProxy client = (ClientViewProxy)view.getService(IClientViewProxy.class);
            for (Map.Entry<Integer, DynamicObject> entry : returnMap.entrySet()) {
                if (updateView) {
                    BindingContext bindCtx = new BindingContext(entry.getValue().getDataEntityType(), entry.getValue(), entry.getKey().intValue());
                    List rowValues = treeEntry.getRowBindValue(bindCtx);
                    client.insertRow(treeentryentity, entry.getKey().intValue(), rowValues);
                }
                list[i++] = entry.getKey();
            }
        }
        return list;
    }

    private static Map<Integer, DynamicObject> doInsertTreeEntry(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, int row) {
        DynamicObjectCollection treeEntryRows = (DynamicObjectCollection)model.getDataEntity(true).get(treeentryentity);
        EntryProp entryProp = (EntryProp)model.getProperty(treeentryentity);
        DynamicObjectType dt = entryProp.getDynamicCollectionItemPropertyType();
        DynamicObject activeRow = (DynamicObject)treeEntryRows.get(row);
        activeRow.set("isGroupNode", (Object)true);
        Object pkVal = activeRow.getPkValue();
        DynamicObjectType objEntityType = ((DynamicObject)memberColls.get(0)).getDynamicObjectType();
        DataEntityPropertyCollection objAllProps = objEntityType.getProperties();
        HashMap<String, DynamicProperty> objnotShowdpProps = new HashMap<String, DynamicProperty>();
        ArrayList<DynamicProperty> treeEntryProperties = new ArrayList<DynamicProperty>(10);
        DynamicProperty isgroupnodeProp = dt.getProperty("isgroupnode");
        for (int k = 0; k < propertyList.size(); ++k) {
            String propertyName = propertyList.get(k);
            treeEntryProperties.add(dt.getProperty(propertyName));
            if ("showdproperty".equals(propertyName)) continue;
            objnotShowdpProps.put(propertyName, (DynamicProperty)objAllProps.get((Object)propertyName));
        }
        HashMap<String, DynamicProperty> objDPProps = new HashMap<String, DynamicProperty>(16);
        HashMap<String, DynamicProperty> objDPPAProps = new HashMap<String, DynamicProperty>(16);
        for (int i = 1; i <= 10; ++i) {
            String propName = "dpname" + i;
            String dppaname = "dppaname" + i;
            objDPProps.put(propName, (DynamicProperty)objAllProps.get((Object)propName));
            objDPPAProps.put(dppaname, (DynamicProperty)objAllProps.get((Object)dppaname));
        }
        HashMap<Integer, DynamicObject> returnMap = new HashMap<Integer, DynamicObject>();
        int curindex = treeEntryRows.size() - 1;
        for (DynamicObject obj : memberColls) {
            DynamicObject newInsertObj = new DynamicObject(dt);
            newInsertObj.beginInit();
            newInsertObj.set("pid", pkVal);
            ISimpleProperty entryIdProp = dt.getPrimaryKey();
            if (entryIdProp instanceof VarcharProp) {
                newInsertObj.getDataEntityType().getPrimaryKey().setValueFast((Object)newInsertObj, (Object)DB.genStringId((String)""));
            } else if (entryIdProp instanceof LongProp) {
                newInsertObj.getDataEntityType().getPrimaryKey().setValueFast((Object)newInsertObj, (Object)DB.genGlobalLongId());
            }
            DynamicProperty dpSeq = dt.getProperty("seq");
            dpSeq.setValueFast((Object)newInsertObj, (Object)(++curindex));
            treeEntryRows.add((Object)newInsertObj);
            for (DynamicProperty property : treeEntryProperties) {
                if ("showdproperty".equals(property.getName())) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i <= 10; ++i) {
                        String dpname = (String)((DynamicProperty)objDPProps.get("dpname" + i)).getValueFast((Object)obj);
                        String dppaname = (String)((DynamicProperty)objDPPAProps.get("dppaname" + i)).getValueFast((Object)obj);
                        if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                        sb.append(dppaname).append(':').append(dpname).append(';');
                    }
                    property.setValueFast((Object)newInsertObj, (Object)sb.toString());
                    continue;
                }
                if ("drcrdirect1".equals(property.getName())) {
                    property.setValueFast((Object)newInsertObj, (Object)obj.getString("drcrdirect"));
                    continue;
                }
                if ("memberid".equals(property.getName())) {
                    property.setValueFast((Object)newInsertObj, (Object)obj.getString("id"));
                    continue;
                }
                property.setValueFast((Object)newInsertObj, ((DynamicProperty)objnotShowdpProps.get(property.getName())).getValueFast((Object)obj));
            }
            if (!obj.getBoolean("isleaf")) {
                isgroupnodeProp.setValueFast((Object)newInsertObj, (Object)true);
            }
            newInsertObj.endInit();
            returnMap.put(curindex, newInsertObj);
        }
        return returnMap;
    }

    private static void filterPermission(Map<Long, Integer> permission, DynamicObjectCollection memberColls) {
        HashSet ids = new HashSet();
        memberColls.forEach(member -> ids.add(member.getLong("id")));
        permission.keySet().retainAll(ids);
    }

    public static boolean isContainsNumber(String number) {
        return noIntroduceInvType.contains(number);
    }

    public static void fillEnumValueEntity(IDataModel model, DynamicObjectCollection members) {
        model.getDataEntity(true);
        model.batchCreateNewEntryRow(treeentryentity, members.size() + 1);
        LinkedHashMap<Long, TreeSet<DynamicObject>> parentChild = new LinkedHashMap<Long, TreeSet<DynamicObject>>(16);
        Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getSeqComparator();
        TreeSet<DynamicObject> roots = new TreeSet<DynamicObject>(comparator);
        parentChild.put(-1L, roots);
        members.forEach(m -> {
            long parent = m.getLong("parent");
            if (parent == 0L) {
                roots.add((DynamicObject)m);
                m.set("parent", (Object)-1L);
            } else {
                TreeSet treeSet = (TreeSet)parentChild.get(parent);
                if (treeSet != null) {
                    treeSet.add(m);
                } else {
                    parentChild.computeIfAbsent(parent, k -> new TreeSet(comparator)).add(m);
                }
            }
        });
        DynamicObject root = model.getEntryRowEntity(treeentryentity, 0);
        root.set("id", (Object)-1L);
        TreeEntryEntityUtil.expandNextEnum(model, root, 0, parentChild);
        model.getEntryEntity(treeentryentity).remove(0);
    }

    public static int expandNextEnum(IDataModel model, DynamicObject parent, int row, Map<Long, TreeSet<DynamicObject>> parentChild) {
        if (parentChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> childrenMap = parentChild.get(parent.getLong("id"));
            for (DynamicObject child : childrenMap) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                rowObj.set("number", (Object)child.getString("number"));
                rowObj.set(NAME, (Object)child.getString(NAME));
                rowObj.set("parent", (Object)child.getString("pnumber"));
                rowObj.set("enumvalue", (Object)child.getString("enumvalue"));
                rowObj.set("datatypes", (Object)child.getString("datatype"));
                rowObj.set("isgroupnode", (Object)(!child.getBoolean("isleaf") ? 1 : 0));
                rowObj.set("dseq", (Object)child.getInt("dseq"));
                rowObj.set("entryid", (Object)child.getLong("id"));
                row = TreeEntryEntityUtil.expandNextEnum(model, child, row, parentChild);
            }
        }
        return row;
    }

    public static void cascaderSelection(IFormView view, String sign, RowClickEvent evt) {
        int clickRow = evt.getRow();
        if (clickRow == -1) {
            TreeEntryEntityUtil.cacheSelectRows(new ArrayList<Integer>(), view);
            return;
        }
        DynamicObjectCollection objects = view.getModel().getEntryEntity(sign);
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl(sign);
            List<Integer> selRows = TreeEntryEntityUtil.getSelectRows(view);
            ArrayList<Integer> curSelRows = new ArrayList<Integer>(16);
            for (int selectRow : treeEntryGrid.getSelectRows()) {
                curSelRows.add(selectRow);
            }
            boolean flag = false;
            if (selRows.isEmpty() && CollectionUtils.isNotEmpty(curSelRows)) {
                flag = true;
            } else {
                if (selRows.size() == curSelRows.size()) {
                    return;
                }
                if (selRows.size() > curSelRows.size()) {
                    selRows.removeAll(curSelRows);
                    if (!selRows.isEmpty()) {
                        clickRow = selRows.get(0);
                    }
                } else {
                    ArrayList rows = new ArrayList(curSelRows);
                    rows.removeAll(selRows);
                    if (!rows.isEmpty()) {
                        clickRow = (Integer)rows.get(0);
                    }
                    flag = true;
                }
            }
            DynamicObject currentRow = view.getModel().getEntryRowEntity(sign, clickRow);
            if (currentRow == null) {
                return;
            }
            int focusRowIndex = -1;
            if (clickRow == 0) {
                boolean isNotExit = selRows.contains(clickRow);
                curSelRows.clear();
                if (!isNotExit) {
                    for (int i = 0; i < objects.size(); ++i) {
                        curSelRows.add(i);
                    }
                    focusRowIndex = clickRow;
                }
            } else {
                HashMap<Long, List<Long>> parentToIdMap = new HashMap<Long, List<Long>>(16);
                HashMap<Long, Integer> idToRowMap = new HashMap<Long, Integer>(16);
                for (int i = 0; i < objects.size(); ++i) {
                    DynamicObject o = (DynamicObject)objects.get(i);
                    parentToIdMap.computeIfAbsent(o.getLong("pid"), k -> new ArrayList()).add(o.getLong("id"));
                    idToRowMap.put(o.getLong("id"), i);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)currentRow.getString("tabkey"))) {
                    TreeEntryEntityUtil.unCheckParentLevelByLeaf(objects, currentRow.getLong("pid"), clickRow, curSelRows, idToRowMap);
                } else {
                    focusRowIndex = TreeEntryEntityUtil.checkLeafByParent(currentRow.getLong("id"), clickRow, curSelRows, idToRowMap, parentToIdMap, flag);
                }
            }
            TreeEntryEntityUtil.updateSelectRows(view, treeEntryGrid, curSelRows, focusRowIndex);
        }
    }

    private static int checkLeafByParent(long cid, int clickRow, List<Integer> curSelRows, Map<Long, Integer> idToRowMap, Map<Long, List<Long>> parentToIdMap, boolean flag) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        idSet.add(cid);
        TemplatePermCrossUtil.appendSonCatalog(idSet, parentToIdMap);
        ArrayList rows = new ArrayList(16);
        idToRowMap.forEach((k, v) -> {
            if (idSet.contains(k)) {
                rows.add(v);
            }
        });
        int focusRowIndex = -1;
        if (!flag) {
            rows.forEach(curSelRows::remove);
        } else {
            curSelRows.addAll(rows);
            focusRowIndex = clickRow;
        }
        return focusRowIndex;
    }

    private static void unCheckParentLevelByLeaf(DynamicObjectCollection objects, long curPid, int clickRow, List<Integer> curSelRows, Map<Long, Integer> idToRowMap) {
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.add(curPid);
        for (int i = clickRow - 1; i >= 0; --i) {
            long id2;
            DynamicObject object = (DynamicObject)objects.get(i);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)object.getString("tabkey")) || !ids.contains(id2 = object.getLong("id"))) continue;
            ids.add(id2);
            ids.add(object.getLong("pid"));
        }
        ids.forEach(id -> curSelRows.remove(idToRowMap.get(id)));
    }

    private static void updateSelectRows(IFormView view, TreeEntryGrid treeEntryGrid, List<Integer> curSelRows, int focusRowIndex) {
        TreeEntryEntityUtil.cacheSelectRows(curSelRows, view);
        Collections.sort(curSelRows);
        int[] selects = Ints.toArray(curSelRows);
        if (CollectionUtils.isNotEmpty(curSelRows)) {
            Arrays.sort(selects);
        }
        treeEntryGrid.selectRows(selects, focusRowIndex);
    }

    private static List<Integer> getSelectRows(IFormView view) {
        if (view.getPageCache().get("select_rows") != null) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)view.getPageCache().get("select_rows"));
        }
        return new ArrayList<Integer>(16);
    }

    private static void cacheSelectRows(List<Integer> rows, IFormView view) {
        if (CollectionUtils.isNotEmpty(rows)) {
            view.getPageCache().put("select_rows", ObjectSerialUtil.toByteSerialized(rows));
        } else {
            view.getPageCache().remove("select_rows");
        }
    }
}

