/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;

public class UserSelectUtil {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(UserSelectUtil.class);
    public static final String model = "model";
    public static final String year = "year";
    public static final String period = "period";
    public static final String scene = "scenario";
    public static final String entity = "entity";
    public static final String currency = "currency";
    public static final String version = "version";
    public static final String cslScheme = "cslscheme";
    public static final String TEMPLATECATALOG = "templatecatalog";
    private static final Map<String, String> DimNum2UIKeyMap = new HashMap<String, String>();
    private static final Set<String> manaModelViews;

    public static final List<String> getStandardDimKeys(Collection<String> c) {
        ArrayList<String> keys = new ArrayList<String>();
        c.forEach(e -> keys.add(DimNum2UIKeyMap.get(e.toLowerCase(Locale.ENGLISH))));
        return keys;
    }

    public static String getDimensionByKey(String key) {
        return key + ".dimension";
    }

    public static String getF7SelectId(IFormView formView, String f7key) {
        String f7SelectId = null;
        try {
            DynamicObject dynamicObject = (DynamicObject)formView.getModel().getValue(f7key);
            if (dynamicObject == null) {
                return null;
            }
            f7SelectId = dynamicObject.getString("id");
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return f7SelectId == null || f7SelectId.equals("0") ? null : f7SelectId;
    }

    public static String getModelIdAfterCreateNewData(IFormView formView, String model, boolean byForm) {
        UserSelectModel userselect = UserSelectUtil.getUserSelectAfterCreateNewData(formView, model, byForm);
        if (scene.equals(model) && userselect != null) {
            return userselect.getScene();
        }
        if (userselect != null) {
            return userselect.getModel();
        }
        return UserSelectUtil.getF7SelectId(formView, model);
    }

    public static String getModelIdAfterCreateNewData(IFormView formView, String model) {
        return (String)ThreadCache.get((Object)(formView.getPageId() + model), () -> UserSelectUtil.getModelIdAfterCreateNewData(formView, model, false));
    }

    public static UserSelectModel getUserSelectAfterCreateNewData(IFormView formView, String model, boolean byForm) {
        UserSelectModel userSelect = GuidePageUtils.getUserSelectAfterCreateNewData(formView);
        if (userSelect != null) {
            return userSelect;
        }
        String modelId = "";
        userSelect = new UserSelectModel();
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        String formsign = formView.getFormShowParameter().getFormId();
        if (StringUtils.isEmpty((String)modelId) || modelId.equals("0")) {
            userSelect = byForm ? UserSelectServiceHelper.getUserSelectByForm((String)RequestContext.get().getUserId(), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)application, (String)formsign) : UserSelectServiceHelper.getUserSelect((String)RequestContext.get().getUserId(), (String)UserSelectServiceHelper.getDefaultFileds((String)formsign), (ApplicationTypeEnum)application);
            modelId = userSelect == null || userSelect.getModel() == null || userSelect.getModel().equals("0") ? "0" : userSelect.getModel();
        }
        Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        if (UserSelectUtil.checkConfigParam(formView)) {
            String entityId = !"bcm_report_workbenchback".equals(formView.getEntityId()) ? formView.getEntityId() : "bcm_report_list";
            Map app2permids = BcmFunPermissionHelper.getEffectiveByPermModel((String)entityId);
            Set haspermids = ApplicationTypeEnum.DI == application ? app2permids.getOrDefault(ApplicationTypeEnum.CM, Collections.emptySet()) : app2permids.getOrDefault(application, Collections.emptySet());
            Set perRoleids = BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)application, (String)entityId, (String)"47150e89000000ac");
            if (permIdSet == null) {
                permIdSet = Sets.newHashSet();
            }
            if (perRoleids == null) {
                perRoleids = Collections.emptySet();
            }
            permIdSet.addAll(perRoleids);
            permIdSet.addAll(haspermids);
            if (application == ApplicationTypeEnum.RPT) {
                boolean userParm = ModelUtil.getAllowPageList().stream().anyMatch(x -> x.equals(entityId));
                if (userParm) {
                    Set hascmpermModelids = BcmFunPermissionHelper.getEffectiveByPermModel((String)entityId, (ApplicationTypeEnum)ApplicationTypeEnum.CM);
                    Set perRoleModelids = BcmFunPermissionHelper.getRoleModel((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (ApplicationTypeEnum)ApplicationTypeEnum.CM, (String)entityId, (String)"47150e89000000ac");
                    permIdSet.addAll(hascmpermModelids);
                    permIdSet.addAll(perRoleModelids);
                } else {
                    permIdSet = haspermids;
                    if (!perRoleids.isEmpty()) {
                        QFilter filter = new QFilter("id", "in", perRoleids);
                        filter.and(new QFilter("reporttype", "in", (Object)Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()})));
                        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{filter});
                        if (docs.size() > 0) {
                            permIdSet.addAll(docs.stream().map(d -> d.getLong("id")).collect(Collectors.toList()));
                        }
                    }
                }
            }
        }
        if (permIdSet != null && permIdSet.size() > 0) {
            if (!permIdSet.contains(Long.valueOf(modelId))) {
                modelId = String.valueOf(permIdSet.iterator().next());
                if (userSelect == null) {
                    userSelect = new UserSelectModel();
                }
                userSelect.setModel(modelId);
            }
        } else {
            if (MemberPermHelper.isManager((ApplicationTypeEnum)application)) {
                return null;
            }
            switch (application) {
                case RPT: {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u5148\u521b\u5efa\u4f53\u7cfb\u3002", (String)"UserSelectUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            return null;
        }
        return userSelect;
    }

    private static boolean checkConfigParam(IFormView formView) {
        String entityId = formView.getEntityId();
        return !manaModelViews.contains(entityId) || !ConfigServiceHelper.getGlobalBoolParam((String)"isDimLmtAdmin");
    }

    public static UserSelectModel getDmUserSelectAfterCreateNewData(IFormView formView) {
        UserSelectModel userSelect = GuidePageUtils.getUserSelectAfterCreateNewData(formView);
        if (userSelect != null) {
            return userSelect;
        }
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        return UserSelectServiceHelper.getDmUserSelectByForm((String)RequestContext.get().getUserId(), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)application);
    }

    public static void saveUserSelectWhenModelChange(IFormView formView, String modelId) {
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        UserSelectUtil.savetUserSelectOnlyModel(modelId, application);
    }

    public static void saveUserSelectWhenModelChange(IFormView formView, String modelId, String scenarioId) {
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        UserSelectUtil.savetUserSelectOnlyModel(modelId, scenarioId, application);
    }

    public static DynamicObject getUserSelectDynamicObject(String selectFileds, ApplicationTypeEnum application) {
        return UserSelectServiceHelper.getUserSelectDynamicObject((String)RequestContext.get().getUserId(), (String)selectFileds, (ApplicationTypeEnum)application);
    }

    public static String buildOtherSelectFileds(List<String> fileds) {
        ArrayList<String> selectFileds = new ArrayList<String>();
        selectFileds.add("issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel");
        selectFileds.addAll(fileds);
        return String.join((CharSequence)",", selectFileds);
    }

    public static void savetUserSelectOnlyModel(String modelId, ApplicationTypeEnum application) {
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(modelId);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(true);
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }

    public static void savetDmUserSelectModel(String dmmodelId, ApplicationTypeEnum application) {
        if (dmmodelId == null || dmmodelId.equals("0")) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(dmmodelId);
        userSelectModel.setDmmodel(dmmodelId);
        userSelectModel.setModel(dmmodelId);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(true);
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }

    public static void savetUserSelectOnlyModel(String modelId, String scenarioId, ApplicationTypeEnum application) {
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(modelId);
        userSelectModel.setScene(scenarioId);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(false);
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }

    @SDKMark
    public static void savetUserSelect(UserSelectModel userSelectModel) {
        if (userSelectModel == null) {
            return;
        }
        String modelId = userSelectModel.getModel();
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }

    public static DynamicObject getUserSelectById(String modelid, String selectFileds, ApplicationTypeEnum application) {
        return UserSelectServiceHelper.getUserSelectDynamicObject((String)modelid, (String)RequestContext.get().getUserId(), (String)selectFileds, (ApplicationTypeEnum)application);
    }

    public static DynamicObject getUserSelectModel(String selectFileds, ApplicationTypeEnum application) {
        return UserSelectServiceHelper.getUserSelectDynamicObject((String)RequestContext.get().getUserId(), (String)selectFileds, (ApplicationTypeEnum)application);
    }

    public static Map<String, String> getUserSelectMapById(String modelid, String selectFileds, ApplicationTypeEnum application, List<String> dimKeys) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        DynamicObject userselect = UserSelectUtil.getUserSelectById(modelid, selectFileds, application);
        if (userselect != null) {
            for (String key : dimKeys) {
                map.put(key, userselect.getString(key));
            }
        }
        return map;
    }

    static {
        DimNum2UIKeyMap.put(year, PresetConstant.FY_DIM);
        DimNum2UIKeyMap.put(period, PresetConstant.PERIOD_DIM);
        DimNum2UIKeyMap.put(scene, PresetConstant.SCENE_DIM);
        DimNum2UIKeyMap.put(entity, PresetConstant.ENTITY_DIM);
        DimNum2UIKeyMap.put(currency, PresetConstant.CURRENCY_DIM);
        DimNum2UIKeyMap.put(version, DimTypesEnum.VERSION.getNumber());
        manaModelViews = Sets.newHashSet((Object[])new String[]{"bcm_dimensionmanager", "bcm_extendsmanager"});
    }
}

