/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.AnalyticsSolutionDataConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.WorkPaperEnum;
import kd.fi.bcm.common.enums.WorkPaperTypeEnum;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.TemplateDimSettingUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.formplugin.workingpaper.model.AbstractColumn;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.formplugin.workingpaper.model.Column4Cache;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections.CollectionUtils;

public class WorkPaperUtil {
    public static final String ORGDISPLAYFORWP = "orgdisplayforwp";

    public static List<Member> analyzRowEntryMember(RowDimensionEntry rowDimensionEntry, long modelid) {
        ArrayList<Member> result = new ArrayList<Member>();
        List list = rowDimensionEntry.getMembers();
        Dimension dimension = rowDimensionEntry.getDimension();
        String entityName = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimension.getNumber());
        String modelNumber = MemberReader.findModelNumberById((Object)modelid);
        for (Member member : list) {
            long memberId = member.getId();
            ArrayList<Member> singles = new ArrayList<Member>(16);
            if (memberId == 0L) {
                IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)dimension.getNumber(), (String)member.getNumber());
                if (IDNumberTreeNode.NotFoundTreeNode == memberByNumber) continue;
                memberId = memberByNumber.getId();
            }
            MembRangeItem item = new MembRangeItem(entityName, Long.valueOf(memberId), member.getNumber(), member.getScope(), false, (Object)modelid);
            item.matchItems(e -> {
                if (("bcm_fymembertree".equals(entityName) || "bcm_periodmembertree".equals(entityName)) && AnalyticsSolutionDataConstant.SPECIFIC_PE_OR_FY.contains(e.getNumber())) {
                    return;
                }
                IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelid, (String)entityName, (Long)((Long)e.getId()));
                Member memberDetail = new Member();
                memberDetail.setId(((Long)e.getId()).longValue());
                memberDetail.setNumber(e.getNumber());
                if ("bcm_accountmembertree".equals(entityName)) {
                    memberDetail.setLongNumber(numberTreeNode.getLongNumber());
                }
                memberDetail.setName(numberTreeNode.getName());
                memberDetail.setDataEntityNumber(entityName);
                memberDetail.setDimension(dimension);
                singles.add(memberDetail);
            });
            if (singles.isEmpty()) continue;
            if ("bcm_accountmembertree".equals(entityName)) {
                singles.sort(Comparator.comparing(Member::getLongNumber, Comparator.nullsFirst(Comparator.naturalOrder())));
            }
            result.addAll(singles);
        }
        return result;
    }

    public static WorkPaperTypeEnum getWorkPaperTypeEnum(Column4Cache column4Cache) {
        if (StringUtils.isEmpty((String)column4Cache.getFormula()) && column4Cache.isUseDefault()) {
            for (WorkPaperTypeEnum workPaperTypeEnum : WorkPaperTypeEnum.values()) {
                if (!workPaperTypeEnum.getProcessNum().equals(column4Cache.getProcess()) || !workPaperTypeEnum.getAuditTrailNum().equals(column4Cache.getAuditTrial()) || !workPaperTypeEnum.getCurrencyNum().equals(column4Cache.getCurrency()) || workPaperTypeEnum.isDisplayChild() != column4Cache.getDisplayChild().booleanValue()) continue;
                return workPaperTypeEnum;
            }
        }
        return null;
    }

    public static List<WorkPaperTypeEnum> filterPreWorkEnum(List<Column4Cache> column4Caches) {
        HashMap tupleMap = new HashMap(16);
        column4Caches.forEach(column4Cache -> {
            if (StringUtils.isEmpty((String)column4Cache.getFormula()) && column4Cache.isUseDefault()) {
                Boolean displayChild = column4Cache.getDisplayChild();
                ArrayList<Tuple> tuples = (ArrayList<Tuple>)tupleMap.get(displayChild);
                if (tuples == null) {
                    tuples = new ArrayList<Tuple>(16);
                    tupleMap.put(displayChild, tuples);
                }
                tuples.add(Tuple.create((Object)column4Cache.getProcess(), (Object)column4Cache.getAuditTrial(), (Object)column4Cache.getCurrency()));
            }
        });
        List elements = WorkPaperTypeEnum.getList((String)WorkPaperEnum.COMPLATE.getNumber());
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            WorkPaperTypeEnum workPaperTypeEnum = (WorkPaperTypeEnum)iterator.next();
            List tuples = (List)tupleMap.get(workPaperTypeEnum.isDisplayChild());
            if (tuples == null || tuples.isEmpty() || !tuples.contains(Tuple.create((Object)workPaperTypeEnum.getProcessNum(), (Object)workPaperTypeEnum.getAuditTrailNum(), (Object)workPaperTypeEnum.getCurrencyNum()))) continue;
            iterator.remove();
        }
        return elements;
    }

    public static void replaceFormulaNumber(StringBuilder sb, String formula, Map<String, String> numberMap) {
        int index = formula.indexOf("col_defined_");
        sb.append(formula.substring(0, index));
        String lastFormula = formula.substring(index);
        Pattern p = Pattern.compile("col_defined_[0-9]*");
        Matcher m = p.matcher(lastFormula);
        if (m.find()) {
            String cvt = m.group();
            if (numberMap.containsKey(cvt)) {
                sb.append(numberMap.get(cvt));
            } else {
                sb.append(cvt);
            }
            lastFormula = lastFormula.substring(cvt.length());
            if (lastFormula.contains("col_defined_")) {
                WorkPaperUtil.replaceFormulaNumber(sb, lastFormula, numberMap);
            } else {
                sb.append(lastFormula);
            }
        } else {
            sb.append(lastFormula);
        }
    }

    public static void setFormula(StringBuilder sb, String formula) {
        String preStr = formula.substring(0, formula.indexOf("@"));
        String lastStr = formula.substring(formula.indexOf("@") + 1);
        sb.append(preStr);
        if (lastStr.contains("@")) {
            lastStr = lastStr.substring(lastStr.indexOf("\")"));
            WorkPaperUtil.setFormula(sb, lastStr);
        } else if (lastStr.contains("(\"")) {
            sb.append(lastStr.substring(lastStr.indexOf("\")")));
        } else {
            sb.append("\")");
        }
    }

    public static Set<String> getPreHeadNname(Column4Cache sourceColumn) {
        HashSet<String> exitHeaderNames = new HashSet<String>(16);
        WorkPaperTypeEnum typeEnum = null;
        if (sourceColumn != null) {
            typeEnum = WorkPaperUtil.getWorkPaperTypeEnum(sourceColumn);
        }
        for (WorkPaperTypeEnum workPaperTypeEnum : WorkPaperUtil.filterPreWorkEnum(new ArrayList<Column4Cache>(16))) {
            if (typeEnum != null && typeEnum == workPaperTypeEnum) continue;
            exitHeaderNames.add(workPaperTypeEnum.getHeaderName());
        }
        return exitHeaderNames;
    }

    public static void saveUserSelect(long modelId, DimensionMemberDisplayTypeEnum displayTypeEnum, ApplicationTypeEnum application) {
        UserSelectModel userSelectModel = new UserSelectModel();
        HashMap<String, Integer> configObj = new HashMap<String, Integer>(2);
        configObj.put(ORGDISPLAYFORWP, displayTypeEnum.getIndex());
        userSelectModel.setConfig(configObj);
        userSelectModel.setModel(String.valueOf(modelId));
        userSelectModel.setOnlyModel(false);
        userSelectModel.setApplication(application);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        UserSelectUtil.savetUserSelect(userSelectModel);
    }

    public static DimensionMemberDisplayTypeEnum getOrgDisplayFromUserSelect(ApplicationTypeEnum application, long modelId) {
        JSONObject jsonObject;
        Object display;
        DynamicObject userSelect = UserSelectUtil.getUserSelectById(String.valueOf(modelId), "config", application);
        DimensionMemberDisplayTypeEnum displayTypeEnum = DimensionMemberDisplayTypeEnum.NUMBERANDNAME;
        if (userSelect == null) {
            return displayTypeEnum;
        }
        String configJsonStr = userSelect.getString("config");
        if (StringUtils.isNotEmpty((String)configJsonStr) && (display = (jsonObject = JSONObject.parseObject((String)configJsonStr)).get((Object)ORGDISPLAYFORWP)) != null) {
            try {
                displayTypeEnum = DimensionMemberDisplayTypeEnum.getEnumByIndex((int)Integer.parseInt(display.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return displayTypeEnum;
    }

    public static void updateOrgDisplay(IFormView view, DimensionMemberDisplayTypeEnum displayTypeEnum) {
        HashMap<String, String> language = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>(16);
        language.put(Lang.get().getLangTag().replace("-", "_"), displayTypeEnum.getText());
        parm.put("text", language);
        view.updateControlMetadata("btn_display", parm);
    }

    public static Map<Integer, Column> groupColumn(boolean isContainFormula, List<Column> columnList) {
        HashMap<Integer, Column> columnMap = new HashMap<Integer, Column>(16);
        if (CollectionUtils.isNotEmpty(columnList)) {
            int offset = 0;
            for (int i = 0; i < columnList.size(); ++i) {
                Column column = columnList.get(i);
                int curIndex = column.getColIndex() + offset;
                if (!isContainFormula && column.hasFormula()) continue;
                columnMap.put(curIndex, column);
                if (!column.getLoanShow().booleanValue()) continue;
                ++offset;
                columnMap.put(curIndex + 1, column);
            }
        }
        return columnMap;
    }

    public static RangeModel getDataRangeModel(List<AreaRangeEntry> areaRangeEntries) {
        RangeModel rangeModel = null;
        if (CollectionUtils.isEmpty(areaRangeEntries)) {
            return rangeModel;
        }
        for (AreaRangeEntry a : areaRangeEntries) {
            if (rangeModel != null) {
                RangeModel model = new RangeModel(a.getAreaRange());
                if (model.getY_end() <= rangeModel.getY_end()) continue;
                rangeModel.setY_end(model.getY_end());
                continue;
            }
            rangeModel = new RangeModel(a.getAreaRange());
        }
        return rangeModel;
    }

    public static String operationRowColCheck(AskExcuteInfo info, List<AreaRangeEntry> areaRangeEntries, SpreadManager sm) {
        RowColExcuteEnum method = info.getMethod();
        String message = null;
        if (method == RowColExcuteEnum.INSERTROW) {
            return message;
        }
        List<Column> columnList = WorkPaperUtil.getColumnList(sm);
        if (CollectionUtils.isEmpty(columnList) || CollectionUtils.isEmpty(areaRangeEntries)) {
            return message;
        }
        RangeModel rangeModel = WorkPaperUtil.getDataRangeModel(areaRangeEntries);
        if (rangeModel == null) {
            return message;
        }
        List<Integer> indexs = info.getOperationdata();
        HashSet<Integer> indexSet = new HashSet<Integer>(indexs);
        int rowDimSize = areaRangeEntries.get(0).getRowDimEntries().size();
        switch (method) {
            case DELETEROW: {
                Integer headerRow = rangeModel.getY_start() - 1;
                List rows = rangeModel.getRangeRowOrCols(true);
                boolean isAll = indexSet.containsAll(rows);
                boolean isContainHR = indexSet.contains(headerRow);
                if (isContainHR && !isAll) {
                    message = ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u5217\u5934\u6240\u5728\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WorkPaperTemplatePlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (isContainHR || !isAll) break;
                indexs.add(headerRow);
                indexs.sort(Collections.reverseOrder());
                info.setOperationdata(indexs);
                break;
            }
            case INSERTCOL: {
                int xstart = rangeModel.getX_start() - rowDimSize;
                rangeModel.setX_start(xstart);
                if (!indexs.stream().anyMatch(c -> c != xstart && rangeModel.isColInArea(c.intValue()))) break;
                message = ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u4e0d\u5141\u8bb8\u63d2\u5165\u5217\u3002", (String)"WorkPaperTemplatePlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case DELETECOL: {
                ArrayList<Integer> rowDimCols = new ArrayList<Integer>(16);
                for (int i = rangeModel.getX_start() - rowDimSize; i < rangeModel.getX_start(); ++i) {
                    rowDimCols.add(i);
                }
                List cols = rangeModel.getRangeRowOrCols(false);
                boolean isContainHC = indexSet.stream().anyMatch(rowDimCols::contains);
                boolean isAll = indexSet.containsAll(cols);
                boolean isAllHeader = indexSet.containsAll(rowDimCols);
                if (isContainHC) {
                    if (isAllHeader && isAll) break;
                    message = ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u884c\u5934\u6240\u5728\u7684\u5217\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WorkPaperTemplatePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (!isAll) break;
                indexs.addAll(rowDimCols);
                indexs.sort(Collections.reverseOrder());
                info.setOperationdata(indexs);
                break;
            }
        }
        return message;
    }

    public static boolean dealAddorDelColumn(AskExcuteInfo info, List<AreaRangeEntry> areaRangeEntries, List<Column> columnList, boolean isCheck) {
        if (CollectionUtils.isNotEmpty(areaRangeEntries) && CollectionUtils.isNotEmpty(columnList)) {
            AreaRangeEntry entry = areaRangeEntries.get(0);
            List rowDimEntries = entry.getRowDimEntries();
            Map<Integer, Column> columnMap = WorkPaperUtil.groupColumn(true, columnList);
            Column firstColumn = columnList.get(0);
            int rStart = firstColumn.getColIndex() - rowDimEntries.size();
            int rEnd = firstColumn.getColIndex() - 1;
            int cStart = firstColumn.getColIndex();
            int cEnd = cStart + columnMap.size() - 1;
            boolean isAddCol = EventConstant.ActionName.ADD_COL == info.getActionname();
            List<Integer> indexs = info.getOperationdata();
            for (Integer index : indexs) {
                if (index >= rStart && index <= rEnd) {
                    if (index == rStart && isAddCol) continue;
                    return false;
                }
                if (index < cStart || index > cEnd) continue;
                if (isAddCol) {
                    return false;
                }
                Column removeCol = columnMap.remove(index);
                if (removeCol == null) continue;
                if (removeCol.getLoanShow().booleanValue()) {
                    removeCol.setLoanShow(Boolean.valueOf(false));
                    continue;
                }
                columnList.remove(removeCol);
            }
            if (!columnList.stream().anyMatch(c -> !c.hasFormula())) {
                return false;
            }
        }
        return true;
    }

    public static List<Column> getColumnList(SpreadManager sm) {
        String s = WorkPaperUtil.getColumnListStr(sm);
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)s) ? (List)SerializationUtils.deSerializeFromBase64((String)s) : new ArrayList(16);
    }

    public static String getColumnListStr(SpreadManager sm) {
        return (String)sm.getBook().getSheet(0).getUserObject("column_list");
    }

    public static void saveColumnList(SpreadManager sm, List<Column> columnList) {
        if (CollectionUtils.isNotEmpty(columnList)) {
            sm.getBook().getSheet(0).putUserObject("column_list", (Object)SerializationUtils.serializeToBase64(columnList));
        } else {
            sm.getBook().getSheet(0).getUserObject().remove("column_list");
        }
    }

    public static void adjustHeaderColumn(AskExcuteInfo info, TemplateModel tm, SpreadManager sm) {
        if (tm == null) {
            return;
        }
        List areaRangeEntries = tm.getAreaRangeEntries();
        List<Column> headerList = WorkPaperUtil.getColumnList(sm);
        if (CollectionUtils.isEmpty((Collection)areaRangeEntries) || CollectionUtils.isEmpty(headerList)) {
            return;
        }
        String method = info.getMethod().getMethod();
        if ("deleteCol".equals(method) || "insertCol".equals(method)) {
            int startIndex = headerList.get(0).getColIndex();
            int offset = 0;
            if ("deleteCol".equals(method)) {
                WorkPaperUtil.dealAddorDelColumn(info, areaRangeEntries, headerList, false);
                for (Column column : headerList) {
                    column.setColIndex(startIndex + offset);
                    ++offset;
                }
            } else {
                info.getOperationdata().forEach(col -> headerList.forEach(column -> {
                    if (col < startIndex) {
                        column.setColIndex(column.getColIndex() + 1);
                    }
                }));
            }
            WorkPaperUtil.updateDefinedColAndFormula(headerList);
            WorkPaperUtil.syncSmColumnToAreaRangeEntry((AreaRangeEntry)areaRangeEntries.get(0), headerList, tm.getModelId());
            WorkPaperUtil.saveColumnList(sm, headerList);
        }
    }

    public static void updateDefinedColAndFormula(List<Column> headerList) {
        HashMap<String, String> numberMap = new HashMap<String, String>(16);
        String COL_DEFINED = "col_defined_";
        int offset = 0;
        for (Column column : headerList) {
            String number = column.getNumber();
            if (number.startsWith(COL_DEFINED)) {
                column.setNumber(COL_DEFINED + offset);
            }
            numberMap.put(number, column.getNumber());
            ++offset;
        }
        headerList.forEach(c -> {
            String oldFormula = c.getFormula();
            if (StringUtils.isNotEmpty((String)oldFormula) && oldFormula.contains(COL_DEFINED)) {
                StringBuilder sb = new StringBuilder();
                WorkPaperUtil.replaceFormulaNumber(sb, oldFormula, numberMap);
                String newFormula = sb.toString();
                if (sb.length() > 0 && newFormula.contains("@")) {
                    sb.setLength(0);
                    WorkPaperUtil.setFormula(sb, newFormula);
                    newFormula = sb.toString();
                }
                c.setFormula(newFormula);
            }
        });
    }

    public static void syncSmColumnToAreaRangeEntry(AreaRangeEntry entry, List<Column> columnList, long modelId) {
        if (CollectionUtils.isNotEmpty((Collection)entry.getColDimEntriesExt())) {
            entry.getColDimEntriesExt().clear();
        }
        columnList.forEach(c -> WorkPaperUtil.getColDimensionEntryExt(modelId, entry, (AbstractColumn)c, c.getColIndex()));
    }

    public static void syncSmColumnToTemplate(SpreadManager sm, TemplateModel tm) {
        List<Column> columnList = WorkPaperUtil.getColumnList(sm);
        List entries = tm.getAreaRangeEntries();
        if (CollectionUtils.isNotEmpty((Collection)entries) && CollectionUtils.isNotEmpty(columnList)) {
            WorkPaperUtil.syncSmColumnToAreaRangeEntry((AreaRangeEntry)entries.get(0), columnList, tm.getModelId());
        }
    }

    public static ColDimensionEntryExt getColDimensionEntryExt(long modelId, AreaRangeEntry entry, AbstractColumn column, int index) {
        ColDimensionEntryExt colDExt = new ColDimensionEntryExt(entry);
        colDExt.setFormula(column.getFormula());
        colDExt.setIndex(index);
        colDExt.setSeq(entry.getColDimEntriesExt().size());
        colDExt.setUseDefault(column.isUseDefault());
        colDExt.setHeader(column.getHeaderName());
        colDExt.setDisplayChild(column.getDisplayChild().booleanValue());
        colDExt.setLoanShow(column.getLoanShow().booleanValue());
        colDExt.setNumber(column.getNumber());
        if (column instanceof Column4Cache) {
            WorkPaperUtil.fillDimMembers(colDExt, modelId, DimTypesEnum.ENTITY.getNumber(), null);
            WorkPaperUtil.fillDimMembers(colDExt, modelId, DimTypesEnum.PROCESS.getNumber(), ((Column4Cache)column).getProcess());
            WorkPaperUtil.fillDimMembers(colDExt, modelId, DimTypesEnum.AUDITTRIAL.getNumber(), ((Column4Cache)column).getAuditTrial());
            WorkPaperUtil.fillDimMembers(colDExt, modelId, DimTypesEnum.CURRENCY.getNumber(), ((Column4Cache)column).getCurrency());
        } else if (column instanceof Column) {
            WorkPaperUtil.fillDimMembers((Pair<Dimension, Member>)((Column)column).getOrg(), colDExt, modelId);
            WorkPaperUtil.fillDimMembers((Pair<Dimension, Member>)((Column)column).getProcess(), colDExt, modelId);
            WorkPaperUtil.fillDimMembers((Pair<Dimension, Member>)((Column)column).getAuditTrial(), colDExt, modelId);
            WorkPaperUtil.fillDimMembers((Pair<Dimension, Member>)((Column)column).getCurrency(), colDExt, modelId);
        }
        entry.addColDimEntryExt(colDExt);
        return colDExt;
    }

    private static void fillDimMembers(Pair<Dimension, Member> pair, ColDimensionEntryExt colDExt, long modelId) {
        if (pair != null && pair.p1 != null) {
            WorkPaperUtil.fillDimMembers(colDExt, modelId, ((Dimension)pair.p1).getNumber(), pair.p2 == null ? null : ((Member)pair.p2).getNumber());
        }
    }

    public static void fillDimMembers(ColDimensionEntryExt colDExt, long modelId, String dimNum, String memNum) {
        Map dimDyoMap = MemberReader.getDimDyoByModelId((long)modelId);
        DynamicObject object = (DynamicObject)dimDyoMap.get(dimNum);
        if (object instanceof DynamicObject) {
            IDNumberTreeNode node;
            Dimension dimension = TemplateDimSettingUtil.convertDynaObj2Dimension(object);
            Member member = null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)memNum) && (node = BcmThreadCache.findMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)memNum)) != IDNumberTreeNode.NotFoundTreeNode) {
                member = ObjectConvertUtils.toMember(node);
                member.setDataEntityNumber(DimEntityNumEnum.getEntieyNumByNumber((String)dimNum));
            }
            colDExt.addDimMember(dimension, member);
        }
    }

    public static void setColHeaderName(IClientViewProxy view, String spreadKey, SpreadManager sm, TemplateModel tm) {
        List areaRangeEntries = tm.getAreaRangeEntries();
        List<Column> headerList = WorkPaperUtil.getColumnList(sm);
        if (CollectionUtils.isEmpty((Collection)areaRangeEntries) || CollectionUtils.isEmpty(headerList)) {
            return;
        }
        RangeModel rangeModel = new RangeModel(((AreaRangeEntry)areaRangeEntries.get(0)).getAreaRange());
        HashMap<Integer, String> headNameMap = new HashMap<Integer, String>(16);
        int startCol = rangeModel.getX_start();
        int offset = 0;
        for (Column column : headerList) {
            String name = column.getHeaderName();
            if (column.getLoanShow().booleanValue()) {
                headNameMap.put(startCol + offset, String.format(ResManager.loadKDString((String)"%s\u501f\u65b9", (String)"WorkPaperQueryUnit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
                name = String.format(ResManager.loadKDString((String)"%s\u8d37\u65b9", (String)"WorkPaperQueryUnit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), column.getHeaderName());
                ++offset;
            }
            headNameMap.put(startCol + offset, name);
            ++offset;
        }
        rangeModel.setY_start(rangeModel.getY_start() - 1);
        rangeModel.setY_end(rangeModel.getY_start());
        rangeModel.setY_end(rangeModel.getY_start());
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        sm.getBook().getSheet(0).iteratorRangeCells(rangeModel, true, cell -> {
            cell.setValue(headNameMap.get(cell.getCol()));
            invoker.updataValue(cell.getRow(), cell.getCol(), cell.getValue());
        });
        invoker.startToInvoke();
    }

    public static Map<String, String> getPageViewMember(SpreadManager sm) {
        LinkedHashMap<String, String> dim2Membs = new LinkedHashMap<String, String>(16);
        FilterView filterView = sm.getFilter();
        for (IDimMember member : filterView.getViewPointDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), TemplateUtil.getMemberNumber((IDimMember)member));
        }
        for (IDimMember member : filterView.getPageDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), TemplateUtil.getMemberNumber((IDimMember)member));
        }
        return dim2Membs;
    }
}

